/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/**
 * Extra tests for SMTP passwords (forgetPassword)
 */

Components.utils.import("resource://gre/modules/Services.jsm");

load("../../../resources/passwordStorage.js");

const kUser1 = "testsmtp";
const kUser2 = "testsmtpa";
const kProtocol = "smtp";
const kHostname = "localhost";
const kServerUrl = kProtocol + "://" + kHostname;

function run_test()
{
  // Prepare files for passwords (generated by a script in bug 925489).
  setupForPassword("signons-mailnews1.8-multiple.sqlite")

  // Set up the basic accounts and folders.
  localAccountUtils.loadLocalMailAccount();

  var smtpServer1 = getBasicSmtpServer();
  var smtpServer2 = getBasicSmtpServer();

  smtpServer1.authMethod = 3;
  smtpServer1.username = kUser1;
  smtpServer2.authMethod = 3;
  smtpServer2.username = kUser2;

  var i;
  var count = {};

  // Test - Check there are two logins to begin with.
  let logins = Services.logins.findLogins(count, kServerUrl, null, kServerUrl);

  do_check_eq(count.value, 2);

  // These will either be one way around or the other.
  if (logins[0].username == kUser1) {
    do_check_eq(logins[1].username, kUser2);
  } else {
    do_check_eq(logins[0].username, kUser2);
    do_check_eq(logins[1].username, kUser1);
  }

  // Test - Remove a login via the incoming server
  smtpServer1.forgetPassword();

  logins = Services.logins.findLogins(count, kServerUrl, null, kServerUrl);

  // should be one login left for kUser2
  do_check_eq(count.value, 1);
  do_check_eq(logins[0].username, kUser2);

  // Test - Remove the other login via the incoming server
  smtpServer2.forgetPassword();

  logins = Services.logins.findLogins(count, kServerUrl, null, kServerUrl);

  // should be one login left for kUser2
  do_check_eq(count.value, 0);
  do_check_eq(logins.length, 0);
}
