var detectList = [
  "chardet.universal_charset_detector",
  "chardet.ja_parallel_state_machine",
  "chardet.ko_parallel_state_machine",
  "chardet.zhtw_parallel_state_machine",
  "chardet.zhcn_parallel_state_machine",
  "chardet.zh_parallel_state_machine",
  "chardet.cjk_parallel_state_machine",
  "chardet.off",
  "chardet.ruprob",
  "chardet.ukprob",
];

var encoderList = [
  "ISO-8859-1",
  "windows-1252",
  "macintosh",
  "UTF-8",
  "us-ascii",
  "ISO-8859-2",
  "ISO-8859-3",
  "ISO-8859-4",
  "ISO-8859-5",
  "ISO-8859-6",
  "ISO-8859-6-I",
  "ISO-8859-6-E",
  "ISO-8859-7",
  "ISO-8859-8",
  "ISO-8859-8-I",
  "ISO-8859-8-E",
  "ISO-8859-9",
  "ISO-8859-10",
  "ISO-8859-13",
  "ISO-8859-14",
  "ISO-8859-15",
  "ISO-8859-16",
  "ISO-IR-111",
  "windows-1250",
  "windows-1251",
  "windows-1253",
  "windows-1254",
  "windows-1255",
  "windows-1256",
  "windows-1257",
  "windows-1258",
  "TIS-620",
  "windows-874",
  "ISO-8859-11",
  "KOI8-R",
  "KOI8-U",
  "x-mac-ce",
  "x-mac-greek",
  "x-mac-turkish",
  "x-mac-croatian",
  "x-mac-romanian",
  "x-mac-cyrillic",
  "x-mac-icelandic",
  "armscii-8",
  "x-viet-tcvn5712",
  "VISCII",
  "x-viet-vps",
  "UTF-7",
  "x-imap4-modified-utf7",
  "UTF-16",
  "UTF-16BE",
  "UTF-16LE",
  "T.61-8bit",
  "x-user-defined",
  "x-mac-arabic",
  "x-mac-devanagari",
  "x-mac-farsi",
  "x-mac-gurmukhi",
  "x-mac-gujarati",
  "x-mac-hebrew",

  "IBM850",
  "IBM852",
  "IBM855",
  "IBM857",
  "IBM862",
  "IBM864",
  "IBM866",
  "Shift_JIS",
  "ISO-2022-JP",
  "EUC-JP",
  "jis_0201",
  "x-euc-tw",
  "Big5",
  "Big5-HKSCS",
  "hkscs-1",
  "EUC-KR",
  "x-johab",
  "GB2312",
  "gbk",
  "HZ-GB-2312",
  "gb18030",
  "replacement",
];

var decoderList = [
  "ISO-8859-1",
  "windows-1252",
  "macintosh",
  "UTF-8",
  "us-ascii",
  "ISO-8859-2",
  "ISO-8859-3",
  "ISO-8859-4",
  "ISO-8859-5",
  "ISO-8859-6",
  "ISO-8859-6-I",
  "ISO-8859-6-E",
  "ISO-8859-7",
  "ISO-8859-8",
  "ISO-8859-8-I",
  "ISO-8859-8-E",
  "ISO-8859-9",
  "ISO-8859-10",
  "ISO-8859-13",
  "ISO-8859-14",
  "ISO-8859-15",
  "ISO-8859-16",
  "ISO-IR-111",
  "windows-1250",
  "windows-1251",
  "windows-1253",
  "windows-1254",
  "windows-1255",
  "windows-1256",
  "windows-1257",
  "windows-1258",
  "TIS-620",
  "windows-874",
  "ISO-8859-11",
  "KOI8-R",
  "KOI8-U",
  "x-mac-ce",
  "x-mac-greek",
  "x-mac-turkish",
  "x-mac-croatian",
  "x-mac-romanian",
  "x-mac-cyrillic",
  "x-mac-icelandic",
  "armscii-8",
  "x-viet-tcvn5712",
  "VISCII",
  "x-viet-vps",
  "UTF-7",
  "x-imap4-modified-utf7",
  "UTF-16",
  "UTF-16BE",
  "UTF-16LE",
  "T.61-8bit",
  "x-user-defined",
  "x-mac-arabic",
  "x-mac-devanagari",
  "x-mac-farsi",
  "x-mac-gurmukhi",
  "x-mac-gujarati",
  "x-mac-hebrew",
  "IBM850",
  "IBM852",
  "IBM855",
  "IBM857",
  "IBM862",
  "IBM864",
  "IBM866",
  "Shift_JIS",
  "ISO-2022-JP",
  "EUC-JP",
  "x-euc-tw",
  "Big5",
  "Big5-HKSCS",
  "EUC-KR",
  "x-johab",
  "GB2312",
  "gbk",
  "HZ-GB-2312",
  "gb18030",
  "ISO-2022-KR",
  "ISO-2022-CN",
  "replacement",
];

function verifyList(aEnumerator, aList)
{
  var count = 0;

  while (aEnumerator.hasMore()) {
    var result = aEnumerator.getNext();
    for (var i = 0; i < aList.length; i++) {
      if (result == aList[i]) {
        count++;
        break;
      }
    }
    if (i == aList.length) {
      do_throw("Unknown chardet: " + result);
    }
  }
  do_check_eq(count, aList.length);
}

function run_test()
{
  var cm = Components.classes["@mozilla.org/charset-converter-manager;1"]
           .getService(Components.interfaces.nsICharsetConverterManager);

  verifyList(cm.GetCharsetDetectorList(), detectList);
  verifyList(cm.getEncoderList(), encoderList);
  verifyList(cm.getDecoderList(), decoderList);
}
