(*
    Tux Commander - UTranslation_FR - French Localization constants
    Copyright (C) 2004 by Marie-Agnes Pauchet-Le Hericy <marie@kerplh.com>
                  2007 by Stanislas Zeller <skogkatt@orange.fr>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)
unit UTranslation_FR;

interface

implementation

uses ULocale;

const LANGfrF2Button_Caption = 'F2 - Renommer';
      LANGfrF3Button_Caption = 'F3 - Voir';
      LANGfrF4Button_Caption = 'F4 - Editer';
      LANGfrF5Button_Caption = 'F5 - Copier';
      LANGfrF6Button_Caption = 'F6 - Déplacer';
      LANGfrF7Button_Caption = 'F7 - Créer Rép.';
      LANGfrF8Button_Caption = 'F8 - Supprimer';

      LANGfrmnuFile_Caption = '_Fichier';
      LANGfrmnuMark_Caption = '_Sélection';
      LANGfrmnuCommands_Caption = '_Commandes';
      LANGfrmnuHelp_Caption = '_Aide';
      LANGfrmiExit_Caption = '_Quitter';
      LANGfrmiSelectGroup_Caption = 'Sélectionner le _Groupe...';
      LANGfrmiUnselectGroup_Caption = '_Désélectionner le groupe...';
      LANGfrmiSelectAll_Caption = '_Sélectionner Tout';
      LANGfrmiUnselectAll_Caption = 'Désélectionner _Tout';
      LANGfrmiInvertSelection_Caption = '_Inverser la sélection';
      LANGfrmiRefresh_Caption = '_Rafraîchir';
      LANGfrmiAbout_Caption = '_A propos...';

      LANGfrColumn1_Caption = 'Nom';
      LANGfrColumn2_Caption = 'Ext';
      LANGfrColumn3_Caption = 'Taille';
      LANGfrColumn4_Caption = 'Date';
      LANGfrColumn5_Caption = 'Attr';

      LANGfrExpandSelection = 'Etendre la sélection';
      LANGfrShrinkSelection = 'Réduire la sélection';
      LANGfrNoMatchesFound = 'Aucune correspondance trouvée';
      LANGfrNoFilesSelected = 'Pas de fichier selectionné!';
      LANGfrSelectedFilesDirectories = '%d fichier(s)/répertoire(s) sélectionné(s)';
      LANGfrDirectoryS = 'répertoire %s';
      LANGfrFileS = 'fichier %s';
      LANGfrDoYouReallyWantToDeleteTheS = 'Voulez-vous vraiment supprimer le %s ?';
      LANGfrDoYouReallyWantToDeleteTheSS = 'Voulez-vous vraiment supprimer %s ?'#10'%s';
      LANGfrCopyFiles = 'Copier les fichiers';
      LANGfrMoveRenameFiles = 'Déplacer/Renommer les fichiers';
      LANGfrCopyDFileDirectoriesTo = 'Copier %d les fichiers/répertoires vers';
      LANGfrMoveRenameDFileDirectoriesTo = 'Déplacer/Renommer %d fichier(s)/répertoire(s) vers';
      LANGfrCopySC = 'Copier :';
      LANGfrMoveRenameSC = 'Déplacer/Renommer :';

      LANGfrQuickFind = '  Recherche rapide ';

      LANGfrAboutString = 'Tux Commander'#10'Version %s'#10'date de fabrication : %s'#10#10'Copyright (c) 2008 Tomas Bzatek'#10'Adresse de courriel : tbzatek@users.sourceforge.net'#10'site internet: http://tuxcmd.sourceforge.net/';
      LANGfrAboutStringGnome = 'version %s'#10'date de fabrication : %s'#10'site internet : http ://tuxcmd.sourceforge.net/';
      LANGfrDiskStatFmt = '%s de %s de libre';
      LANGfrDiskStatVolNameFmt = '[%s] %s de %s de libre';
      LANGfrStatusLineFmt = '%s de %s dans %d de %d fichiers sélectionnés';
      LANGfrPanelStrings : array[boolean] of string = ('droite', 'gauche');

      LANGfrDIR = '<DIR>';
      LANGfrErrorGettingListingForSPanel = 'liste impossible à obtenir dans le volet de %s :'#10'    %s'#10#10'chemin = ''%s''';
      LANGfrErrorGettingListingForSPanelNoPath = 'liste impossible à obtenir dans le volet de %s :'#10'    %s';
      LANGfrErrorCreatingNewDirectorySInSPanel = 'Impossible de créer un nouveau répertoire dans le volet de ''%s'' %s :'#10'    %s';
      LANGfrErrorCreatingNewDirectorySInSPanelNoPath = 'Impossible de créer un nouveau répertoire dans le volet de %s :'#10'    %s';
      LANGfrTheFileDirectory = 'Le fichier/répertoire';
      LANGfrCouldNotBeDeleted = 'n''a pas pu être supprimé';
      LANGfrCouldNotBeDeletedS = 'n''a pas pu être supprimé :  %s';
      LANGfrUserCancelled = 'Annulation par l''utilisateur!';
      LANGfrTheDirectorySIsNotEmpty = 'Le répertoire %s n''est pas vide!';
      LANGfrCannotCopyFile = 'le fichier ne peut pas être copié';
      LANGfrCopyError = 'Erreur de copie';
      LANGfrMoveError = 'Erreur de déplacement';
      LANGfrOverwriteS = 'Ecraser : %s';
      LANGfrWithFileS = 'Avec fichier : %s';
      LANGfrOvewriteSBytesS = '%s octets, %s';
      LANGfrTheFile = 'Le Fichier';
      LANGfrCopy = 'Copier';
      LANGfrMove = 'Déplacer';
      LANGfrTheDirectory = 'Le répertoire';
      LANGfrTheSymbolicLink = 'Le lien symbolique';
      LANGfrCannotMoveFile = 'Le fichier ne peut être déplacé';
      LANGfrCouldNotBeCreated = 'ne peut pas être créé';
      LANGfrCouldNotBeCreatedS = 'ne peut pas être créé :  %s';
      LANGfrFromS = 'De : %s';
      LANGfrToS = 'A: %s';
      LANGfrCannotCopyFileToItself = 'Impossible de copier le fichier sur lui-même';
      LANGfrMemoryAllocationFailed = 'Echec d''allocation de mémoire :';
      LANGfrCannotOpenSourceFile = 'Le fichier source n''a pas pu être ouvert';
      LANGfrCannotOpenDestinationFile = 'Le fichier cible n''a pas pu être ouvert';
      LANGfrCannotCloseDestinationFile = 'Le fichier cible n''a pas pu être fermé';
      LANGfrCannotCloseSourceFile = 'Le fichier source n''a pas pu être ouvert';
      LANGfrCannotReadFromSourceFile = 'Le fichier source n''a pas pu être lu';
      LANGfrCannotWriteToDestinationFile = 'on ne peut pas écrire dans le fichier cible';

      LANGfrUnknownException = 'Exception Inconnue';
      LANGfrNoAccess = 'Pas d''accès';
      LANGfrUnknownError = 'Erreur inconnue';

      LANGfrCreateANewDirectory = 'Créer un nouveau répertoire';
      LANGfrEnterDirectoryName = 'Entrer le nom du _répertoire :';

      LANGfrOverwriteQuestion = 'Confirmation de suppression';
      LANGfrOverwriteButton_Caption = '_Ecrasement';
      LANGfrOverwriteAllButton_Caption = 'Tout _écraser';
      LANGfrSkipButton_Caption = '_Sauter';
      LANGfrOverwriteAllOlderButton_Caption = 'Ecraser tous les anciens';
      LANGfrSkipAllButton_Caption = 'Tout sauter';
      LANGfrRenameButton_Caption = '_Renommer';
      LANGfrAppendButton_Caption = 'A_jouter';
      LANGfrRename = 'Renommer';
      LANGfrRenameFile = 'Renommer le fichier ''%s'' en';
      LANGfrIgnoreButton_Caption = '_Ignorer';

      LANGfrProgress = 'Progression';
      LANGfrCancel = '_Annuler';
      LANGfrDelete = 'Supprimer :';

      LANGfrSpecifyFileType = '_Spécifier le type de fichier :';

      LANGfrRemoveDirectory = 'Supprimer le répertoire';
      LANGfrDoYouWantToDeleteItWithAllItsFilesAndSubdirectories = 'Voulez-vous le supprimer ainsi que tous ses fichiers et sous-répertoires?';
      LANGfrRetry = '_Réessayer';
      LANGfrDeleteButton_Caption = '_Supprimer';
      LANGfrAll = '_Tout';

      LANGfrCopyFilesSC = 'Copier les fichiers :';
      LANGfrAppendQuestion = 'Etes-vous sûr de vouloir ajouter le fichier ''%s'' à ''%s''?';
      LANGfrPreparingList = 'Préparation de la liste...'; 

      LANGfrYouMustSelectAValidFile = 'Vous devez sélectionner un fichier valide!';
      LANGfrmiVerifyChecksums = '_Vérifier les sommes de contrôle';
      LANGfrVerifyChecksumsCaption = 'Vérifier les sommes de contrôle';
      LANGfrCheckButtonCaptionCheck = '_Contrôler';
      LANGfrCheckButtonCaptionStop = '_Arrêter';
      LANGfrFileListTooltip = '[?] - Non contrôlé'#10'[OK] - Somme de contrôle OK'#10'[FAUX] - Somme de contrôle FAUX'#10'[N/A] - Fichier indisponible';
      LANGfrFilenameColumnCaption = 'nom de fichier';
      LANGfrTheFileSYouAreTryingToOpenIsQuiteBig = 'Le fichier ''%s'' que vous essayez d''ouvrir est assez gros (%s octets). Sa somme de contrôle est peut être invalide.'#10#10'Voulez-vous tout de même le charger?';
      LANGfrAnErrorOccuredWhileInitializingMemoryBlock = 'Une erreur est survenue à l''initialisation du bloc mémoire. Fermez des fichiers avant de réessayer.';
      LANGfrAnErrorOccuredWhileOpeningFileSS = 'Une erreur est survenue à l''ouverture du fichier ''%s'' :'#10'  %s';
      LANGfrAnErrorOccuredWhileReadingFileSS = 'Une erreur est survenue à la lecture du fichier ''%s'' :'#10'  %s';
      LANGfrChecksumNotChecked = '<span weight="bold">Statut :</span> Non contrôlé';
      LANGfrChecksumChecking = '<span weight="bold">Statut :</span> contrôle en cours...';
      LANGfrChecksumInterrupted = '<span weight="bold">Statut :</span> Interrompu';
      LANGfrChecksumDOK = '<span weight="bold">Statut :</span> %d%% OK';

      LANGfrmiCreateChecksumsCaption = '_Créer les sommes de contrôle...';
      LANGfrYouMustSelectAtLeastOneFileToCalculateChecksum = 'Vous devez sélectionner au moins un fichier pour pouvoir calculer la somme de contrôle!';
      LANGfrCreateChecksumsCaption = 'Créer les sommes de contrôle';
      LANGfrCCHKSUMPage1Text = 'Vous allez créer les sommes de contrôle pour'#10'les fichiers sélectionnés. Si vous n''avez pas sélectionné'#10'tous les fichiers souhaités, fermez cet assistant et'#10'sélectionnez d''autres fichiers';
      LANGfrCCHKSUMPage4Text = 'tout est prêt pour effectuer les sommes de contrôle pour vos'#10'fichiers sélectionnés. Ceci peut prendre quelques minutes.'#10'Cliquez sur suivant pour continuer.';
      LANGfrCCHKSUMPage6Text = 'Il y a eu des erreurs dans le calcul des sommes de contrôle :';
      LANGfrCCHKSUMPage7Text = 'La création de la somme de contrôle est terminée et'#10'vos fichiers sont prêts.'#10#10'Cliquer sur "Terminé" pour sortir.';
      LANGfrCCHKSUMPage1Title = '<span size="xx-large" weight="ultrabold">Préparer les fichiers pour le calcul des sommes de contrôle</span>';
      LANGfrCCHKSUMPage2Title = '<span size="xx-large" weight="ultrabold">Sélectionner le type de somme de contrôle</span>';
      LANGfrCCHKSUMPage3Title = '<span size="xx-large" weight="ultrabold">Choisir le nom de fichier</span>';
      LANGfrCCHKSUMPage4Title = '<span size="xx-large" weight="ultrabold">prêt à contrôler</span>';
      LANGfrCCHKSUMPage5Title = '<span size="xx-large" weight="ultrabold">En cours...</span>';
      LANGfrCCHKSUMPage6Title = '<span size="xx-large" weight="ultrabold">Erreur!</span>';
      LANGfrCCHKSUMPage7Title = '<span size="xx-large" weight="ultrabold">Terminé</span>';
      LANGfrCCHKSUMSFVFile = 'Fichier SFV ';
      LANGfrCCHKSUMMD5sumFile = 'Fichier MD5sum';
      LANGfrCCHKSUMFileName = '_Nom de fichier :';
      LANGfrCCHKSUMCreateSeparateChecksumFiles = 'Créer des fichiers séparés de sommes de contrôle';
      LANGfrCCHKSUMNowProcessingFileS = 'En cours : %s';
      LANGfrCCHKSUMFinishCaption = '_Terminé';
      LANGfrCCHKSUMAreYouSureYouWantToAbortTheProcessing = 'Etes-vous sûr de vouloir annuler le processus?';
      LANGfrCCHKSUMAnErrorOccuredWhileOpeningFileSS = 'Une erreur est survenue lors de l''ouverture du fichier ''%s'' : %s'#10;
      LANGfrCCHKSUMAnErrorOccuredWhileReadingFileSS = 'Une erreur est survenue lors de la lecture du fichier ''%s'' : %s'#10;
      LANGfrCCHKSUMAnErrorOccuredWhileWritingFileSS = 'Une erreur est survenue lors de l''écriture du fichier ''%s'' : %s'#10;

      LANGfrAnErrorOccuredWhileWritingFileSS = 'Une erreur est survenue lors de l''écriture du fichier ''%s'' :'#10'  %s';
      LANGfrTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt = 'Le fichier cible ''%s'' existe déjà. Voulez-vous l''écraser?';
      LANGfrTheTargetFileSCannotBeRemovedS = 'Le fichier cible ''%s''ne peut-être supprimé : %s';
      LANGfrMergeCaption = 'Fusionner';
      LANGfrPleaseInsertNextDiskOrGiveDifferentLocation = 'Veuillez insérer une nouvelle disquette ou préciser une autre destination :';
      LANGfrMergeOfSSucceeded = 'Fusion de ''%s'' réussie (Somme de contrôle CRC OK).';
      LANGfrWarningCreatedFileFailsCRCCheck = 'Attention : Le fichier créé ne répond pas au contrôle CRC !';
      LANGfrMergeOfSSucceeded_NoCRCFileAvailable = 'Fusion de ''%s'' réussie (pas de fichier CRC disponible).';
      LANGfrMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory = 'Fusionner ''%s'' et tous les fichiers avec noms d''ordre croissant dans le répertoire suivant:';
      LANGfrMergeSC = 'Fusionner :';
      LANGfrmiSplitFileCaption = '_Découper fichier...';
      LANGfrmiMergeFilesCaption = '_Fusionner fichiers...';

      LANGfrSplitTheFileSToDirectory = '_Découper le fichier ''%s'' dans le répertoire :';
      LANGfrSplitSC = 'Découper :';
      LANGfrSplitFile = 'Découper le fichier';
      LANGfrBytesPerFile = '_Octets par fichier :';
      LANGfrAutomatic = 'Automatique';
      LANGfrDeleteFilesOnTargetDisk = '_Supprimer les fichiers sur la cible (pour les supports amovibles)';
      LANGfrSplitCaption = 'Découper';
      LANGfrCannotOpenFileS = 'Le fichier ne peut être ouvert ''%s''';
      LANGfrCannotSplitTheFileToMoreThan999Parts = 'Le fichier ne peut être découpé en plus de 999 parties!';
      LANGfrThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem = 'Il y a des fichiers dans le répertoire cible :'#10'%s'#10'Voulez-vous les supprimer?';
      LANGfrThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem = 'Il y a  %d fichiers dans le répertoire cible. Voulez-vous les supprimer?';
      LANGfrAnErrorOccuredWhileOperationS = 'Une erreur est survenue pendant l''opération : %s';
      LANGfrSplitOfSSucceeded = 'Le découpage ''%s'' a réussi.';
      LANGfrSplitOfSFailed = 'Le découpage''%s'' a échoué!';

      LANGfrmnuShow_Caption = 'Mon_trer';
      LANGfrmiShowDotFiles_Caption = '_Montrer les fichiers .dot ';
      LANGfrTheFileYouAreTryingToOpenIsQuiteBig = 'Le fichier que vous essayez d''ouvrir est assez gros. Le charger dans une application externe  (par ex. gedit) peut ralentir le système.'#10'Voulez-vous continuer?';
      LANGfrCannotExecuteSPleaseCheckTheConfiguration = 'Exécution impossible ''%s''. Veuillez vérifier la configuration ou définir correctement le type de fichier associé.';
      LANGfrEdit = 'Editer';
      LANGfrEnterFilenameToEdit = '_Entrer le nom de fichier à éditer :';

      LANGfrmnuSettings_Caption = 'Co_nfiguration';
      LANGfrmiFileTypes_Caption = '_Types de fichiers...';
      LANGfrThereIsNoApplicationAssociatedWithS = 'Il n''y a pas d''application associée avec "%s".'#10#10'Vous pouvez configurer Tux Commander pour associer les applications avec les différents types de fichier. Voulez-vous associer une application avec ce type maintenant ?';
      LANGfrErrorExecutingCommand = 'Erreur en éxécutant la commande !';
      LANGfrEditFileTypesCaption = 'Editer les types de fichier';
      LANGfrTitleLabel_Caption = '<span size="x-large" weight="ultrabold">Configuration des types de fichier</span>';
      LANGfrExtensionsColumn = 'Extensions';
      LANGfrDescriptionColumn = 'Description';
      LANGfrFileTypesList = 'Liste des types de fichier';
      LANGfrActionName = 'Nom action';
      LANGfrCommand = 'Commande';
      LANGfrSetDefaultActionButton_Caption = '_Définir comme par défaut';
      LANGfrRunInTerminalCheckBox_Caption = 'Exécuter dans un terminal';
      LANGfrAutodetectCheckBox_Caption = 'Autodétecter _l''application GUI';
      LANGfrBrowseButton_Caption = 'N_aviguer...';
      LANGfrCommandLabel_Caption = 'Co_mmande :';
      LANGfrDescriptionLabel_Caption = 'D_escription :';
      LANGfrFNameExtLabel_Caption = 'Ajouter extension :';
      LANGfrNotebookPageExtensions = 'type de fichier';
      LANGfrNotebookPageActions = 'Actions';
      LANGfrDefault = ' (par defaut)';
      LANGfrCannotSaveFileTypeAssociationsBecauseOtherProcess = 'Les associations d''application avec les types de fichier ne peuvent être sauvagardées, parce que qu''une modification de ce fichier a entre temps été faite par un autre processus .';

      LANGfrDefaultColor = 'couleur par défaut';
      LANGfrIcon = '_Icône :';
      LANGfrBrowseForIcon = 'Rechercher une icône';
      LANGfrSelectFileTypeColor = 'Sélectionner la couleur du type de fichier';
      LANGfrColor = 'Cou_leur :';

      LANGfrmiChangePermissions_Caption = 'Changer les _autorisations...';
      LANGfrmiChangeOwner_Caption = 'Changer le _propriétaire/Groupe...';
      LANGfrmiCreateSymlink_Caption = 'Créer un _lien Symbolique...';
      LANGfrmiEditSymlink_Caption = '_Editer un lien Symbolique...';
      LANGfrChmodProgress = 'Changer les autorisations :';
      LANGfrChownProgress = 'Changer le propriétaire :';
      LANGfrYouMustSelectAValidSymbolicLink = 'Vous devez sélectionner un lien symbolique valide!';
      LANGfrPopupRunS = 'E_xecuter %s';
      LANGfrPopupOpenS = 'Ouvrir %s';
      LANGfrPopupGoUp = 'Remonter';
      LANGfrPopupOpenWithS = 'Ouvrir avec %s';
      LANGfrPopupDefault = ' (par défaut)';
      LANGfrPopupOpenWith = 'Ouvrir avec...';
      LANGfrPopupViewFile = 'Afficher le fichier';
      LANGfrPopupEditFile = 'Ed_iter le fichier';
      LANGfrPopupMakeSymlink = 'Créer un lien symbolique';
      LANGfrPopupRename = '_Renommer';
      LANGfrPopupDelete = '_Supprimer';
      LANGfrDialogChangePermissions = 'Changer les autorisations';
      LANGfrCouldNotBeChmoddedS = 'Ne peut pas changer les autorisations :  %s';
      LANGfrDialogChangeOwner = 'Changer le propriétaire';
      LANGfrCouldNotBeChownedS = 'Ne peut pas changer le propriétaire :  %s';
      LANGfrDialogMakeSymlink = 'Créer le lien symbolique';
      LANGfrDialogEditSymlink = 'Editer le lien symbolique';
      LANGfrFEditSymlink_Caption = 'Editer le lien symbolique';
      LANGfrFEditSymlink_SymbolicLinkFilename = 'Nom du lien symbolique :';
      LANGfrFEditSymlink_SymbolicLinkPointsTo = 'Le lien symbolique pointe vers :';

      LANGfrFChmod_Caption = 'Autorisations d''accès';
      LANGfrFChmod_PermissionFrame = 'Autorisations';
      LANGfrFChmod_FileFrame = 'Fichier';
      LANGfrFChmod_ApplyRecursivelyFor = 'Appliquer récursivement';
      LANGfrFChmod_miAllFiles = 'Tous les fichiers et répertoires';
      LANGfrFChmod_miDirectories = 'Répertoires seulement';
      LANGfrFChmod_OctalLabel = '_Octal :';
      LANGfrFChmod_SUID = 'SUID - Exécution sous l''identifiant du propriétaire';
      LANGfrFChmod_SGID = 'SGID - Exécution sous l''identifiant de groupe du propriétaire';
      LANGfrFChmod_Sticky = 'Sticky bit';
      LANGfrFChmod_RUSR = 'RUSR - Lecture par le propriétaire';
      LANGfrFChmod_WUSR = 'WUSR - Ecriture par le propriétaire';
      LANGfrFChmod_XUSR = 'XUSR - Exécution/recherche par le propriétaire';
      LANGfrFChmod_RGRP = 'RGRP - Lecture par le groupe';
      LANGfrFChmod_WGRP = 'WGRP - Ecriture par le groupe';
      LANGfrFChmod_XGRP = 'XGRP - Exécution/recherche par le groupe';
      LANGfrFChmod_ROTH = 'ROTH - Lecture par les autres';
      LANGfrFChmod_WOTH = 'WOTH - Ecriture par les autres';
      LANGfrFChmod_XOTH = 'XOTH - Exécution/recherche par les autres';
      LANGfrFChmod_TextLabel = '<span weight="ultrabold">Texte :</span>  %s';
      LANGfrFChmod_FileLabel = '<span weight="ultrabold">Fichier :</span> %s'#10'<span weight="ultrabold">Texte :</span> %s'#10 +
                               '<span weight="ultrabold">Octal :</span> %d'#10'<span weight="ultrabold">Propriétaire :</span> %s'#10 +
                               '<span weight="ultrabold">Groupe :</span> %s';

      LANGfrFChown_Caption = 'Changer le propriétaire/groupe';
      LANGfrFChown_OwnerFrame = 'Nom d''utilisateur';
      LANGfrFChown_GroupFrame = 'Nom de groupe';
      LANGfrFChown_FileFrame = 'Fichier';
      LANGfrFChown_ApplyRecursively = 'Appliquer récursivement';

      LANGfrFSymlink_Caption = 'Créer le lien symbolique';
      LANGfrFSymlink_ExistingFilename = 'Nom du fichier existant (vers lequel va pointer le lien symbolique) :';
      LANGfrFSymlink_SymlinkFilename = 'Nom du lien symbolique :';

      LANGfrmnuBookmarks_Caption = '_Marque-pages';
      LANGfrmiAddBookmark_Caption = 'Ajouter un marque-page';
      LANGfrmiEditBookmarks_Caption = 'Editer les marque-pages';
      LANGfrBookmarkPopupDelete_Caption = 'Supprimer';
      LANGfrmiPreferences_Caption = '_Préférences...';
      LANGfrTheCurrentDirectoryAlreadyExistsInTheBookmarksList = 'le répertoire courant existe déjà dans la liste des marque-pages';
      LANGfrSomeOtherInstanceChanged = 'une autre instance de Tux Commander a déjà modifié la configuration. Voulez-vous appliquer les nouveaux paramètres?'#10#10'Attention : si vous cliquez sur NON maintenant, la configuration sera écrasée pour cette instance'' sortie!';
      
      LANGfrPreferences_Caption = 'Préférences';
      LANGfrPreferences_TitleLabel_Caption = '<span size="x-large" weight="ultrabold"> Préférences de l''application</span>';
      LANGfrPreferences_GeneralPage = 'Général';
      LANGfrPreferences_FontsPage = 'Polices';
      LANGfrPreferences_ColorsPage = 'Couleurs';
      LANGfrPreferences_RowHeight = 'Hauteur de ligne :';
      LANGfrPreferences_NumHistoryItems = 'Eléments d''historique de la ligne de commande :';
      LANGfrPreferences_Default = 'par défaut';
      LANGfrPreferences_ClearReadonlyAttribute = 'Effacer l''attribut de lecture seule lors d''une copie à partir d''un CD-ROM';
      LANGfrPreferences_DisableMouseRenaming = 'Désactiver renommer avec la souris';
      LANGfrPreferences_ShowFiletypeIconsInList = 'Montrer les icônes de type de fichier';
      LANGfrPreferences_ExternalAppsLabel = '<span weight="ultrabold"> programmes externes</span>';
      LANGfrPreferences_Viewer = '_Visualiseur :';
      LANGfrPreferences_Editor = '_Editeur :';
      LANGfrPreferences_Terminal = '_Terminal :';
      LANGfrPreferences_ListFont = 'Liste de Polices :';
      LANGfrPreferences_Change = 'Changer...';
      LANGfrPreferences_UseDefaultFont = 'Utiliser _la fonte par défaut';
      LANGfrPreferences_Foreground = 'Avant-plan';
      LANGfrPreferences_Background = 'Arrière-plan';
      LANGfrPreferences_NormalItem = 'Elément Normal :';
      LANGfrPreferences_SetToDefaultToUseGTKThemeColors = 'Utiliser par défaut le thème GTK';
      LANGfrPreferences_Cursor = 'Curseur :';
      LANGfrPreferences_InactiveItem = 'Elément inactif :';
      LANGfrPreferences_SelectedItem = 'Elément sélectionné :';
      LANGfrPreferences_LinkItem = 'liens symboliques :';
      LANGfrPreferences_LinkItemHint = 'afficher par défaut les liens symboliques dans la couleur des éléments normaux';
      LANGfrPreferences_DotFileItem = 'Fichiers cachés :';
      LANGfrPreferences_DotFileItemHint = 'Afficher par défaut les fichiers cachés dans la couleur des éléments normaux';
      LANGfrPreferences_BrowseForApplication = 'Rechercher l''application';
      LANGfrPreferences_DefaultS = 'par défaut : %s';
      LANGfrPreferences_SelectFont = 'Sélectionner la fonte';

(***************  STRINGS ADDED TO v0.4.101  **********************************************************************************)
     LANGfrBookmarkButton_Tooltip = 'Afficher les marque-pages';
     LANGfrUpButton_Tooltip = 'Aller au répertoire parent';
     LANGfrRootButton_Tooltip = 'Aller au répertoire racine (/)';
     LANGfrHomeButton_Tooltip = 'Aller au répertoire home (/home/user)';
     LANGfrLeftEqualButton_Tooltip = 'Afficher le même répertoire dans le volet de droite';
     LANGfrRightEqualButton_Tooltip = 'Afficher le même répertoire dans le volet de gauche';
     LANGfrmiShowDirectorySizes_Caption = 'Afficher la taille des répertoires';
     LANGfrmiTargetSource_Caption = 'Cible = Source';
     LANGfrFileTypeDirectory = 'Répertoire';
     LANGfrFileTypeFile = 'Fichier';
     LANGfrFileTypeMetafile = 'Ceci est une méta-donnée générale';
     LANGfrPreferencesPanelsPage = 'Volets';
     LANGfrPreferencesApplicationsPage = 'Applications';
     LANGfrPreferencesExperimentalPage = 'Expérimental';
     LANGfrPreferencesSelectAllDirectoriesCheckBox_Caption = '"Sélectionner tout" inclut les répertoires';
     LANGfrPreferencesNewStyleAltOCheckBox_Caption = '_New style Alt+O';
     LANGfrPreferencesNewStyleAltOCheckBox_Tooltip = 'Rester dans le même répertoire si vous clonez ce répertoire dans le panel opposé en pressant Ctrl/Alt+O';
     LANGfrPreferencesShowFuncButtonsCheckBox_Caption = 'Afficher les boutons de touches de fonction';
     LANGfrPreferencesSizeFormatLabel_Caption = 'Format de taille:';
     LANGfrPreferencesmiSizeFormat1 = 'Système';
     LANGfrPreferencesmiSizeFormat6 = 'Groupé';
     LANGfrPreferencesAutodetectXApp = 'Autodétecter X app';
     LANGfrPreferencesAlwaysRunInTerminal = 'Toujours exécuter dans un terminal';
     LANGfrPreferencesNeverRunInTerminal = 'Ne jamais exécuter dans un terminal';
     LANGfrPreferencesCmdLineBehaviourLabel_Caption = 'Exécution à partir d''une ligne de commande:';
     LANGfrPreferencesFeatures = 'Fonctionnalités';
     LANGfrPreferencesDisableMouseRename_Tooltip = 'Vous pouvez utiliser Shift+F6 pour faire un renommage rapide';
     LANGfrPreferencesDisableFileTipsCheckBox_Caption = 'Désactiver les infobulles pour les fichiers';
     LANGfrPreferencesDisableFileTipsCheckBox_Tooltip = 'Ne pas afficher l''infobulle si le texte dans la colonne est tronqué';
     LANGfrPreferencesShow = 'Afficher';
     LANGfrPreferencesDirsInBoldCheckBox_Caption = 'Répertoires en gras';
     LANGfrPreferencesDisableDirectoryBracketsCheckBox_Caption = 'Supprimer les crochets pour les répertoires';
     LANGfrPreferencesOctalPermissionsCheckBox_Caption = 'Afficher les autorisations en octal';
     LANGfrPreferencesOctalPermissionsCheckBox_Tooltip = 'Afficher les autorisations des fichiers/répertoires sous forme de nombre au lieu d''un texte(-rw-rw-rw-)';
     LANGfrPreferencesMovement = 'Déplacement';
     LANGfrPreferencesLynxLikeMotionCheckBox_Caption = 'Déplacement style Lynx';
     LANGfrPreferencesInsertMovesDownCheckBox_Caption = 'Déplacement vers le bas après <Inser>';
     LANGfrPreferencesSpaceMovesDownCheckBox_Caption = 'Déplacement vers le bas après <Espace>';
     LANGfrPreferencesViewer = 'Visionneuse';
     LANGfrPreferencesCommandSC = 'Commande:';
     LANGfrPreferencesUseInternalViewer = 'Utiliser la visionneuse interne';
     LANGfrPreferencesEditor = 'Editeur';
     LANGfrPreferencesTerminal = 'Terminal';
     LANGfrPreferencesExperimentalFeatures = 'Fonctionnalités expérimentales';
     LANGfrPreferencesExperimentalWarningLabel_Caption = '<span weight="ultrabold">Attention :</span> Ces fonctionnalités sont en cours de développement et peuvent ne pas fonctionner correctement. Utilisez-les à vos risques et périls!';
     LANGfrPreferencesFocusRefreshCheckBox_Caption = 'Rafraîchit la fenêtre qui a le focus';
     LANGfrPreferencesFocusRefreshCheckBox_Tooltip = 'Le rafraîchissement du volet est très lent';
     LANGfrPreferencesWMCompatModeCheckBox_Caption = 'Mode de compatibilité _WM ';
     LANGfrPreferencesWMCompatModeCheckBox_Tooltip = 'A utiliser si vous avez des problèmes de gestionnaire de fenêtres (par exemple si IceWM ne maximise pas les fenêtres correctement)';
     LANGfrPreferencesCompatUseLibcSystemCheckBox_Caption = 'Utiliser libc _system() pour l''exécution de programmes';
     LANGfrPreferencesCompatUseLibcSystemCheckBox_Tooltip = 'A utiliser en cas de problèmes de gel ou de crash au lancement d''applications externes';

  (***************  STRINGS ADDED TO v0.5.70  **********************************************************************************)
      LANGfrmiSearchCaption2 = '_Chercher...';
      LANGfrmiNoMounterBarCaption = 'Cacher la barre de montage';
      LANGfrmiShowOneMounterBarCaption = 'Show _one mounter bar' ;
      LANGfrmiShowTwoMounterBarCaption = 'Show _two mounter bars' ;
      LANGfrmnuNetworkCaption = 'Rés_eau';
      LANGfrmiConnectionsCaption = '_Connections...';
      LANGfrmiOpenConnectionCaption = '_Ouvrir une connection...';
      LANGfrmiQuickConnectCaption = 'Connection _rapide...';
      LANGfrmnuPluginsCaption = 'Greff_ons';
      LANGfrmiTestPluginCaption = '_Tester un greffon';
      LANGfrmiMounterSettingsCaption = '_Paramètres de montage...';
      LANGfrmiColumnsCaption = 'P_aramètres des panels...';
      LANGfrmiSavePositionCaption = '_Sauver la position';
      LANGfrmiMountCaption = '_Monter';
      LANGfrmiUmountCaption = '_Démonter';
      LANGfrmiEjectCaption = '_Ejecter';
      LANGfrmiDuplicateTabCaption = 'Dupliquer l''onglet courant';
      LANGfrmiCloseTabCaption = 'Fermer l''onglet courant';
      LANGfrmiCloseAllTabsCaption = 'Fermer tous les onglets';
      LANGfrCannotDetermineDestinationEngine = 'Impossible de déterminer la destination. Vérifiez l''emplacement et réessayez.';
      LANGfrCannotLoadFile = 'Impossible de charger le fichier ''%s''. Vérifiez les permissions.';
      LANGfrMountPointDevice = 'Point de Montage: %s'#10'Périphérique: %s';
      LANGfrMountSC = 'Montage:';
      LANGfrNoPluginsFound = 'Aucuns greffons trouvés';
      LANGfrPluginAbout = 'A Propos...';
      LANGfrCouldntOpenURI = 'Impossible d''ouvrir l''URI spécifié. Please check the consistency of the resource identifier and the access permission.';
      LANGfrPluginAboutInside = 'Greffon: %s'#10#10'%s'#10'%s';
      LANGfrAreYouSureCloseAllTabs = 'Etes vous sur de vouloir fermer tous les onglets inactifs?';
      LANGfrCouldntOpenURIArchive = 'Impossible d''ouvrir l''archive. Please check consistency and access permissions.';
      LANGfrThereIsNoModuleAvailable = 'Il n''y a aucuns modules disponibles pouvant charger cette connection';
      LANGfrIgnoreError = 'Voulez-vous vraiment ignorer cette erreur? Le fichier source sera ensuite effacé!';
      LANGfrErrorMount = 'Erreur détectée pendant le montage du périphérique ''%s'':'#10#10;
      LANGfrErrorUmount = 'Erreur détectée pendant le démontage du périphérique ''%s'':'#10#10;
      LANGfrErrorEject = 'Erreur détectée pendant l''éjection du périphérique ''%s'':'#10#10;

      LANGfrMounterPrefs_Caption = 'Paramètres de montage';
      LANGfrMounterPrefs_TitleLabelCaption = 'Paramètres de Montage';
      LANGfrMounterPrefs_ListViewFrameCaption = 'Montage';
      LANGfrMounterPrefs_MountName = 'Nom de Montage';
      LANGfrMounterPrefs_MountPoint = 'Point de Montage';
      LANGfrMounterPrefs_Device = 'Périphérique';
      LANGfrMounterPrefs_MoveUpButtonTooltip = 'Vers le haut';
      LANGfrMounterPrefs_MoveDownButtonTooltip = 'Vers le bas';
      LANGfrMounterPrefs_UseFSTabDefaultsCheckBox = 'Utiliser le fichier _fstab par défaut';
      LANGfrMounterPrefs_UseFSTabDefaultsCheckBoxTooltip = 'En cochant cette case, la barre de montage sera configurée par défaut avec les entrées trouvées dans le fichier /etc/fstab (fichier de système de montage)';
      LANGfrMounterPrefs_ToggleModeCheckBox = 'Les boutons restent en position actif quan_d ils sont montés';
      LANGfrMounterPrefs_ToggleModeCheckBoxTooltip = 'Si activé, les boutons de la barre de montage resteront actifs si le périphérique est monté; Un autre click permettra de les démonter (éjecter dans ce cas)';
      LANGfrMounterPrefs_PropertiesFrameCaption = 'Propriétés';
      LANGfrMounterPrefs_DisplayTextLabelCaption = '_Texte Affiché:';
      LANGfrMounterPrefs_MountPointLabelCaption = '_Point de Montage:';
      LANGfrMounterPrefs_MountDeviceLabelCaption = 'Périphéri_que:';
      LANGfrMounterPrefs_DeviceTypeLabelCaption = 'T_ype:';
      LANGfrMounterPrefs_miLocalDiskCaption = 'Disque Dur';
      LANGfrMounterPrefs_miRemovableCaption = 'Removable';
      LANGfrMounterPrefs_miCDCaption = 'Lecteur CD/DVD';
      LANGfrMounterPrefs_miFloppyCaption = 'Lecteur de Disquette';
      LANGfrMounterPrefs_miNetworkCaption = 'Réseau';
      LANGfrMounterPrefs_MountCommandLabelCaption = '_Commande Montage:';
      LANGfrMounterPrefs_UmountCommandLabelCaption = 'C_ommande Démontage:';
      LANGfrMounterPrefs_MountCommandEntryTooltip = 'Syntaxe: utiliser %dev pour la substitution du périphérique et %dir pour le point de montage ou ne rien mettre pour le montage par défault'#10'Note: attention aux commandes, Tux Commander peut planter!' +
                                                     #10'Example: smbmount %dev %dir -o username=netuser,password=somepass';
      LANGfrMounterPrefs_UmountCommandEntryTooltip = 'Syntaxe: utiliser %dev pour la substitution du périphérique et %dir pour le point de montage ou ne rien mettre pour le montage par défault'#10'Example: smbumount $dir';
      LANGfrMounterPrefs_IconLabelCaption = '_Icone:';

      LANGfrConnMgr_Caption = 'Ouvrir une Nouvelle Connection';
      LANGfrConnMgr_ConnectButton = 'Co_nnecter';
      LANGfrConnMgr_OpenConnection = 'Ouvrir une Connection';
      LANGfrConnMgr_NameColumn = 'Nom';
      LANGfrConnMgr_URIColumn = 'URI';
      LANGfrConnMgr_AddConnectionButtonCaption = '_Ajouter';
      LANGfrConnMgr_AddConnectionButtonTooltip = 'Ajouter une nouvelle connection';
      LANGfrConnMgr_EditButtonCaption = '_Editer...';
      LANGfrConnMgr_EditButtonTooltip = 'Editer la connection sélectionnée';
      LANGfrConnMgr_RemoveButtonCaption = '_Supprimer';
      LANGfrConnMgr_RemoveButtonTooltip = 'Supprimer la connection sélectionnée';
      LANGfrConnMgr_DoYouWantDelete = 'Voulez vous vraiment supprimer cette connection ''%s''?';

      LANGfrConnProp_FTP = 'FTP';
      LANGfrConnProp_SFTP = 'SFTP (ssh subsystem)';
      LANGfrConnProp_SMB = 'Windows (SMB)';
      LANGfrConnProp_HTTP = 'WebDAV (HTTP)';
      LANGfrConnProp_HTTPS = 'Secure WebDAV (HTTPS)';
      LANGfrConnProp_Other = 'Autre <span style="italic">(à spécifier dans l''URI)</span>';
      LANGfrConnProp_Caption = 'Propriétés de la Connection';
      LANGfrConnProp_VFSModule = 'Module _VFS:';
      LANGfrConnProp_URI = '_URI:';
      LANGfrConnProp_URIEntryTooltip = 'Un URI valable doit contenir un préfixe de service et une adresse serveur';
      LANGfrConnProp_DetailedInformations = 'Informations détaillées';
      LANGfrConnProp_Name = '_Nom:';
      LANGfrConnProp_Server = 'Ser_veur[:port]:';
      LANGfrConnProp_Username = 'U_tilisateur:';
      LANGfrConnProp_UserNameEntryTooltip = 'Ne rien mettre pour les utilisateurs anonymes';
      LANGfrConnProp_Password = 'Mot de _Passe:';
      LANGfrConnProp_TargetDirectory = 'Répertoire _Cible:';
      LANGfrConnProp_ServiceType = '_Services:';
      LANGfrConnProp_MaskPassword = '_Masquer le mot de passe';
      LANGfrConnProp_MenuItemCaption = 'Défaut <span style="italic">(tous les modules appropriés)</span>';

      LANGfrConnLogin_Caption = 'Authentication requis';
      LANGfrConnLogin_Login = 'Login';
      LANGfrConnLogin_ExperimentalWarningLabelCaption = 'You must log in to access %s';
      LANGfrConnLogin_Username = '_Utilisateur:';
      LANGfrConnLogin_Password = 'Mot de _Passe:';
      LANGfrConnLogin_AnonymousCheckButton = '_Anonyme';

      LANGfrColumns_Caption = 'Paramètres des Panels';
      LANGfrColumns_Title = 'Paramètres des Panels';
      LANGfrColumns_MoveUpButtonTooltip = 'Vers le haut';
      LANGfrColumns_MoveDownButtonTooltip = 'Vers le bas';
      LANGfrColumns_TitlesLongName = 'Nom';
      LANGfrColumns_TitlesLongNameExt = 'Nom + Extension';
      LANGfrColumns_TitlesLongExt = 'Extension';
      LANGfrColumns_TitlesLongSize = 'Taille';
      LANGfrColumns_TitlesLongDateTime = 'Date + Heure';
      LANGfrColumns_TitlesLongDate = 'Date';
      LANGfrColumns_TitlesLongTime = 'Heure';
      LANGfrColumns_TitlesLongUser = 'Utilisateur';
      LANGfrColumns_TitlesLongGroup = 'Groupe';
      LANGfrColumns_TitlesLongAttr = 'Attributs';
      LANGfrColumns_TitlesShortName = 'Nom';
      LANGfrColumns_TitlesShortNameExt = 'Nom';
      LANGfrColumns_TitlesShortExt = 'Ext';
      LANGfrColumns_TitlesShortSize = 'Taille';
      LANGfrColumns_TitlesShortDateTime = 'Date';
      LANGfrColumns_TitlesShortDate = 'Date';
      LANGfrColumns_TitlesShortTime = 'Heure';
      LANGfrColumns_TitlesShortUser = 'Utilisateur';
      LANGfrColumns_TitlesShortGroup = 'Groupe';
      LANGfrColumns_TitlesShortAttr = 'Attr';

      LANGfrTestPlugin_Caption = 'Tester un Greffon VFS';
      LANGfrTestPlugin_Title = 'Tester un Greffon VFS';
      LANGfrTestPlugin_ExperimentalWarningLabelCaption = '<span weight="ultrabold">Avertissement:</span> Le sous-sytème VFS et ses greffons sont encore en développement et contiennent des bugs. utilisez cette fonction à votre propres risques!';
      LANGfrTestPlugin_Plugin = '_Greffon:';
      LANGfrTestPlugin_Command = 'Co_mmande:';
      LANGfrTestPlugin_Username = '_Utilisateur:';
      LANGfrTestPlugin_Password = 'Mot de _Passe:';
      LANGfrTestPlugin_AnonymousCheckButton = 'Login _Anonyme (n''appelle pas VFSLogin)';
      LANGfrTestPlugin_NoPluginsFound = 'Pas de greffons trouvés';

      LANGfrRemoteWait_Caption = 'Opération en cours';
      LANGfrRemoteWait_OperationInProgress = 'Opération en cours, veuillez patienter...';
      LANGfrRemoteWait_ItemsFound = 'Résultats: %d';

      LANGfrSearch_Bytes = 'Bytes';
      LANGfrSearch_kB = 'kB';
      LANGfrSearch_MB = 'MB';
      LANGfrSearch_days = 'jours';
      LANGfrSearch_weeks = 'semaines';
      LANGfrSearch_months = 'mois';
      LANGfrSearch_years = 'années';
      LANGfrSearch_Caption = 'Fichiers Trouvés';
      LANGfrSearch_General = 'General';
      LANGfrSearch_Advanced = 'Avancé';
      LANGfrSearch_SearchResults = '_Résultats:';
      LANGfrSearch_SearchFor = 'Chercher _pour:';
      LANGfrSearch_FileMaskEntryTooltip = 'Astuce: Utiliser un point-virgule (";") pour spécifier les fichiers multiples à trouver';
      LANGfrSearch_SearchIn = 'Chercher _dans:';
      LANGfrSearch_SearchArchivesCheckButton = 'Chercher _archives';
      LANGfrSearch_FindText = 'Trouver _texte:';
      LANGfrSearch_FindTextEntryTooltip = 'Une entrée vide permet de ne pas chercher un texte spécifique'#10'Veuillez noter que nous utilisons le codage UTF-8 dans l''interface graphique';
      LANGfrSearch_CaseSensitiveCheckButton = 'Cas_e sensitive';
      LANGfrSearch_StayCurrentFSCheckButton = 'Inclure d''autres systèmes de fichiers';
      LANGfrSearch_CaseSensitiveMatchCheckButton = 'Ca_se sensitive';
      LANGfrSearch_Size = 'Taille';
      LANGfrSearch_Date = 'Date';
      LANGfrSearch_BiggerThan = '_Plus grand que';
      LANGfrSearch_SmallerThan = 'P_lus petit que';
      LANGfrSearch_ModifiedBetweenRadioButton = '_Modifié entre';
      LANGfrSearch_NotModifiedAfterRadioButton = '_Non-modifié après';
      LANGfrSearch_ModifiedLastRadioButton = 'Modifié dans dernier';
      LANGfrSearch_ModifiedNotLastRadionButton =  'Non-modifié dans dernier';
      LANGfrSearch_ModifiedBetweenEntry1 = '"utilisez ce format de date:" c';
      LANGfrSearch_ViewButtonCaption = '_Voir';
      LANGfrSearch_NewSearchButtonCaption = '_Nouvelle';
      LANGfrSearch_GoToFileButtonCaption = '_Aller';
      LANGfrSearch_FeedToListboxButtonCaption = 'Ajou_ter';
      LANGfrSearch_StatusSC = 'Status:';
      LANGfrSearch_Ready = 'Prêt.';
      LANGfrSearch_PreparingToSearch = 'Recherche en préparation.';
      LANGfrSearch_SearchInProgress = 'Recherche en cours:';
      LANGfrSearch_UserCancelled = 'Annulation par l''utilisateur.';
      LANGfrSearch_SearchFinished = 'Recherche terminée';
      LANGfrSearch_FilesFound = '%d fichiers trouvés';
      LANGfrSearch_And = 'et';

  (***************  STRINGS ADDED TO v0.5.82  **********************************************************************************)
      LANGfrCloseOpenConnection = 'Vous essayez d''ouvrir une nouvelle connection sur une connection déjà existante. En continuant, la précédente connection sera fermée et remplacée par la nouvelle demandée.'#10#10'Souhaitez vous continuer?';
      LANGfrDuplicateTabWarning = 'Vous essayez d''ouvrir un nouvel onglet à partir d''un répertoire distant. Cependant, l''action n''est pas supportée. Le répertoire dans le nouvel onglet pointera ver un système de fichier local.';
      LANGfrDontShowAgain = '_Ne plus montrer ce message';
      LANGfrSwitchOtherPanelWarning = 'Vous essayez d''ouvrir un répertoire distant dans le panel opposé. Cependant, l''action n''est pas supportée. Le répertoire cible ne sera pas ouvert.';
      LANGfrOpenConnectionsWarning = 'Des connections actives sont ouvertes dans le panel. En fermant l''application, ces connections seront déconnectées.'#10#10'Souhaitez vous quitter?';
      LANGfrmiDisconnect_Caption = '_Déconnecter';
      LANGfrDisconnectButton_Tooltip = 'Déconnecter la connection active';
      LANGfrLeaveArchiveButton_Tooltip = 'Fermer l''archive courante';
      LANGfrOpenTerminalButton_Tooltip = 'Ouvrir un nouveau terminal dans le répertoire courant';
      LANGfrOpenTerminalButton_Caption = 'Te_rminal';
      LANGfrShowTextUIDsCheckBox_Caption = 'Voir Texte _UIDs';
      LANGfrShowTextUIDsCheckBox_Tooltip = 'Voir les informations textuelles d''Utilisateur et Groupe à la place des nombres (UID/GID)';

  (***************  STRINGS ADDED TO v0.5.100  **********************************************************************************)
      LANGfrmiNewTab_Caption = 'Nouvel On_glet';
      LANGfrFilePopupMenu_Properties = '_Propriétés';
      LANGfrCommandEntry_Tooltip = 'Use %s as file/directory placeholder';
      LANGfrmiFiles_Caption = 'Fichiers seulement';

  (***************  STRINGS ADDED TO v0.6.31  **********************************************************************************)
      LANGfrPasswordButton_Tooltip = 'Archive requires password.'#10'Click to set';
      LANGfrHandleRunFromArchive_Bytes = 'bytes';
      LANGfrHandleRunFromArchive_FileTypeDesc_Unknown = '(unknown)';
      LANGfrHandleRunFromArchive_NotAssociated = '(not associated)';
      LANGfrHandleRunFromArchive_SelfExecutable = '(self-executable)';
      LANGfrHandleRunFromArchive_CouldntCreateTemporaryDirectory = 'Couldn''t create temporary directory "%s": %s.'#10#10'Please check the temporary directory settings and try it again.';
      LANGfrFRunFromVFS_Caption = 'Packed file properties';
      LANGfrFRunFromVFS_TitleLabel = 'File Properties';
      LANGfrFRunFromVFS_FileNameLabel = 'File name:';
      LANGfrFRunFromVFS_FileTypeLabel = 'File type:';
      LANGfrFRunFromVFS_SizeLabel = 'Size:';
      LANGfrFRunFromVFS_PackedSizeLabel = 'Compressed size:';
      LANGfrFRunFromVFS_DateLabel = 'Modify date:';
      LANGfrFRunFromVFS_InfoLabel = 'Opening files directly from archives is not supported. By clicking the buttons below the file (all files respectively) will be extracted to a temporary location. Temporary files will be deleted when you close Tux Commander.';
      LANGfrFRunFromVFS_OpensWithLabel = 'Open with:';
      LANGfrFRunFromVFS_ExecuteButton = 'E_xtract and open';
      LANGfrFRunFromVFS_ExecuteAllButton = 'Extract _all and open';
      LANGfrFSetPassword_Caption = 'Set password';
      LANGfrFSetPassword_Label1_Caption = 'Password required';
      LANGfrFSetPassword_Label2_Caption = 'The archive is encrypted and requires password in order to extract the data';
      LANGfrFSetPassword_ShowPasswordCheckButton = 'Un_mask password';

  (***************  STRINGS ADDED TO v0.6.48  **********************************************************************************)
      LANGfrCopyFileNamesToClipboard = '_Copy file names to clipboard';
      LANGfrCopyFullPathNamesToClipboard = 'Copy _full path names to clipboard';
      LANGfrCopyPathToClipboard = '_Copy path to clipboard';
      LANGfrPreferences_DateFormatLabel_Caption = 'Date _format:';
      LANGfrPreferences_System = 'System';
      LANGfrPreferences_Custom = 'Custom...';
      LANGfrPreferences_CustomDateFormatEntry_Tooltip = 'Enter custom date format string.'#10'Please see "man strftime" for syntax reference.';
      LANGfrPreferences_TimeFormatLabel_Caption = '_Time format:';
      LANGfrPreferences_CustomTimeFormatEntry_Tooltip = 'Enter custom time format string.'#10'Please see "man strftime" for syntax reference.';
      LANGfrPreferences_DateTimeFormatLabel_Caption = 'Date/time _order:';
      LANGfrPreferences_QuickRenameSkipExtCheckBox = 'Select name part only on quick-rename';
      LANGfrPreferences_QuickRenameSkipExtCheckBox_Tooltip = 'Exclude filename extension from the selection when doing quick-rename';
      LANGfrPreferences_SortDirectoriesLikeFilesCheckBox = 'Sort directories lik_e files';
      LANGfrPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip = 'Check this to allow sorting directories along with files. Directories are always first in the list.'#10'Unchecked: directories are always sorted by name.';
      LANGfrPreferences_QuickSearchLabel_Caption = 'Quick search _keystroke:';
      LANGfrPreferences_QuickSearchOptionMenu_Tooltip = 'The Ctrl+S/Alt+S and "/" keystrokes are always active, regardless on this setting.';
      LANGfrPreferences_QuickSearch_Option1 = 'Ctrl+S/Alt+S and "/" only';
      LANGfrPreferences_QuickSearch_Option2 = 'Ctrl+Alt+letters';
      LANGfrPreferences_QuickSearch_Option3 = 'Alt+letters';
      LANGfrPreferences_QuickSearch_Option4 = 'letters directly';
      LANGfrPreferences_TempPathLabel_Caption = 'Temporary files';
      LANGfrPreferences_VFSTempPathLabel_Caption = '_VFS temp files:';
      LANGfrPreferences_VFSTempPathEntry_Tooltip = 'Location of temporary files used by VFS subsystem, e.g. when opening files directly from archives. All temporary files are cleaned on exit.';

  (***************  STRINGS ADDED TO v0.6.67  **********************************************************************************)
      LANGfrPreferences_RightClickSelectCheckBox = 'Right mouse button selection mode';
      LANGfrPreferences_RightClickSelectCheckBox_Tooltip = 'Use right mouse button to select, like mc.';
      LANGfrGtkMountOperation_ConnectAnonymously = 'Connect _anonymously';
      LANGfrGtkMountOperation_ConnectAsUser = 'Connect as u_ser:';
      LANGfrGtkMountOperation_Username = '_Username:';
      LANGfrGtkMountOperation_Domain = '_Domain:';
      LANGfrGtkMountOperation_Password = '_Password:';
      LANGfrGtkMountOperation_DoNotSavePassword = 'Do not save password';
      LANGfrGtkMountOperation_ForgetPasswordImmediately = 'Forget password _immediately';
      LANGfrGtkMountOperation_RememberPasswordUntilYouLogout = 'Remember password until you _logout';
      LANGfrGtkMountOperation_SavePasswordInConnectionManager = '_Save password in Connection Manager';
      LANGfrGtkMountOperation_RememberForever = 'Remember _forever';
      LANGfrFSymlink_RelativePath = '_Relative path';
      LANGfrFConnectionManager_DuplicateButton_Caption = 'D_uplicate...';
      LANGfrFConnectionManager_DuplicateButton_Tooltip = 'Duplicate selected connection';
      LANGfrFConnectionManager_DoNotSavePasswordsCheckBox_Label = '_Do not store passwords internally (but still use gnome-keyring)';
      LANGfrFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip = 'By checking this option on, Tux Commander will never save passwords into its connection list. Due to the GVFS nature, gnome-keyring will still be used to retrieve stored passwords from your desktop session.';
      LANGfrFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label = 'Do not synchronize passwords to gnome-_keyring';
      LANGfrFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip = 'Don''t tell gnome-keyring to save any passwords.';
      LANGfrFConnectionManager_DuplicateMenuItem_Caption = 'D_uplicate...';
      LANGfrFQuickConnect_Caption = 'Quick connect';
      LANGfrFQuickConnect_TitleLabel_Caption = 'Quick connect';
      LANGfrFQuickConnect_ConnectToURILabel_Caption = 'C_onnect to URI:';
      LANGfrLinkToS = 'Link to %s';
      LANGfrOpenDirectoryInBackgroundTab = 'Open directory in _background tab';
      LANGfrTheActiveConnectionHasNotBeenSaved = 'The active connection has not been saved. Do you want to save it to Connection Manager?'#10#10'%s';
      LANGfrTheArchiveIsEncryptedAndRequiresPassword = 'The archive is encrypted and requires password';



(********************************************************************************************************************************)
procedure SetTranslation;
begin
  LANGF2Button_Caption := LANGfrF2Button_Caption;
  LANGF3Button_Caption := LANGfrF3Button_Caption;
  LANGF4Button_Caption := LANGfrF4Button_Caption;
  LANGF5Button_Caption := LANGfrF5Button_Caption;
  LANGF6Button_Caption := LANGfrF6Button_Caption;
  LANGF7Button_Caption := LANGfrF7Button_Caption;
  LANGF8Button_Caption := LANGfrF8Button_Caption;

  LANGmnuFile_Caption := LANGfrmnuFile_Caption;
  LANGmnuMark_Caption := LANGfrmnuMark_Caption;
  LANGmnuCommands_Caption := LANGfrmnuCommands_Caption;
  LANGmnuHelp_Caption := LANGfrmnuHelp_Caption;
  LANGmiExit_Caption := LANGfrmiExit_Caption;
  LANGmiSelectGroup_Caption := LANGfrmiSelectGroup_Caption;
  LANGmiUnselectGroup_Caption := LANGfrmiUnselectGroup_Caption;
  LANGmiSelectAll_Caption := LANGfrmiSelectAll_Caption;
  LANGmiUnselectAll_Caption := LANGfrmiUnselectAll_Caption;
  LANGmiInvertSelection_Caption := LANGfrmiInvertSelection_Caption;
  LANGmiRefresh_Caption := LANGfrmiRefresh_Caption;
  LANGmiAbout_Caption := LANGfrmiAbout_Caption;

  LANGColumn1_Caption := LANGfrColumn1_Caption;
  LANGColumn2_Caption := LANGfrColumn2_Caption;
  LANGColumn3_Caption := LANGfrColumn3_Caption;
  LANGColumn4_Caption := LANGfrColumn4_Caption;
  LANGColumn5_Caption := LANGfrColumn5_Caption;

  LANGExpandSelection := LANGfrExpandSelection;
  LANGShrinkSelection := LANGfrShrinkSelection;
  LANGNoMatchesFound := LANGfrNoMatchesFound;
  LANGNoFilesSelected := LANGfrNoFilesSelected;
  LANGSelectedFilesDirectories := LANGfrSelectedFilesDirectories;
  LANGDirectoryS := LANGfrDirectoryS;
  LANGFileS := LANGfrFileS;
  LANGDoYouReallyWantToDeleteTheS := LANGfrDoYouReallyWantToDeleteTheS;
  LANGDoYouReallyWantToDeleteTheSS := LANGfrDoYouReallyWantToDeleteTheSS;
  LANGCopyFiles := LANGfrCopyFiles;
  LANGMoveRenameFiles := LANGfrMoveRenameFiles;
  LANGCopyDFileDirectoriesTo := LANGfrCopyDFileDirectoriesTo;
  LANGMoveRenameDFileDirectoriesTo := LANGfrMoveRenameDFileDirectoriesTo;
  LANGCopySC := LANGfrCopySC;
  LANGMoveRenameSC := LANGfrMoveRenameSC;

  LANGQuickFind := LANGfrQuickFind;

  LANGAboutString := LANGfrAboutString;
  LANGAboutStringGnome := LANGfrAboutStringGnome;
  LANGDiskStatFmt := LANGfrDiskStatFmt;
  LANGDiskStatVolNameFmt := LANGfrDiskStatVolNameFmt;
  LANGStatusLineFmt := LANGfrStatusLineFmt;
  LANGPanelStrings[False] := LANGfrPanelStrings[False];
  LANGPanelStrings[True] := LANGfrPanelStrings[True];
  LANGDIR := LANGfrDIR;
  LANGErrorGettingListingForSPanel := LANGfrErrorGettingListingForSPanel;
  LANGErrorGettingListingForSPanelNoPath := LANGfrErrorGettingListingForSPanelNoPath;
  LANGErrorCreatingNewDirectorySInSPanel := LANGfrErrorCreatingNewDirectorySInSPanel;
  LANGErrorCreatingNewDirectorySInSPanelNoPath := LANGfrErrorCreatingNewDirectorySInSPanelNoPath;
  LANGTheFileDirectory := LANGfrTheFileDirectory;
  LANGCouldNotBeDeleted := LANGfrCouldNotBeDeleted;
  LANGCouldNotBeDeletedS := LANGfrCouldNotBeDeletedS;
  LANGUserCancelled := LANGfrUserCancelled;
  LANGTheDirectorySIsNotEmpty := LANGfrTheDirectorySIsNotEmpty;
  LANGCannotCopyFile := LANGfrCannotCopyFile;
  LANGCopyError := LANGfrCopyError;
  LANGMoveError := LANGfrMoveError;
  LANGOverwriteS := LANGfrOverwriteS;
  LANGWithFileS := LANGfrWithFileS;
  LANGOvewriteSBytesS := LANGfrOvewriteSBytesS;
  LANGTheFile := LANGfrTheFile;
  LANGCopy := LANGfrCopy;
  LANGMove := LANGfrMove;
  LANGTheDirectory := LANGfrTheDirectory;
  LANGTheSymbolicLink := LANGfrTheSymbolicLink;
  LANGCannotMoveFile := LANGfrCannotMoveFile;
  LANGCouldNotBeCreated := LANGfrCouldNotBeCreated;
  LANGCouldNotBeCreatedS := LANGfrCouldNotBeCreatedS;
  LANGFromS := LANGfrFromS;
  LANGToS := LANGfrToS;
  LANGCannotCopyFileToItself := LANGfrCannotCopyFileToItself;
  LANGMemoryAllocationFailed := LANGfrMemoryAllocationFailed;
  LANGCannotOpenSourceFile := LANGfrCannotOpenSourceFile;
  LANGCannotOpenDestinationFile := LANGfrCannotOpenDestinationFile;
  LANGCannotCloseDestinationFile := LANGfrCannotCloseDestinationFile;
  LANGCannotCloseSourceFile := LANGfrCannotCloseSourceFile;
  LANGCannotReadFromSourceFile := LANGfrCannotReadFromSourceFile;
  LANGCannotWriteToDestinationFile := LANGfrCannotWriteToDestinationFile;

  LANGUnknownException := LANGfrUnknownException;
  LANGNoAccess := LANGfrNoAccess;
  LANGUnknownError := LANGfrUnknownError;

  LANGCreateANewDirectory := LANGfrCreateANewDirectory;
  LANGEnterDirectoryName := LANGfrEnterDirectoryName;

  LANGOverwriteQuestion := LANGfrOverwriteQuestion;
  LANGOverwriteButton_Caption := LANGfrOverwriteButton_Caption;
  LANGOverwriteAllButton_Caption := LANGfrOverwriteAllButton_Caption;
  LANGSkipButton_Caption := LANGfrSkipButton_Caption;
  LANGOverwriteAllOlderButton_Caption := LANGfrOverwriteAllOlderButton_Caption;
  LANGSkipAllButton_Caption := LANGfrSkipAllButton_Caption;
  LANGRenameButton_Caption := LANGfrRenameButton_Caption;
  LANGAppendButton_Caption := LANGfrAppendButton_Caption;
  LANGRename := LANGfrRename;
  LANGRenameFile := LANGfrRenameFile;
  LANGIgnoreButton_Caption := LANGfrIgnoreButton_Caption;

  LANGProgress := LANGfrProgress;
  LANGCancel := LANGfrCancel;
  LANGDelete := LANGfrDelete;

  LANGSpecifyFileType := LANGfrSpecifyFileType;

  LANGRemoveDirectory := LANGfrRemoveDirectory;
  LANGDoYouWantToDeleteItWithAllItsFilesAndSubdirectories := LANGfrDoYouWantToDeleteItWithAllItsFilesAndSubdirectories;
  LANGRetry := LANGfrRetry;
  LANGDeleteButton_Caption := LANGfrDeleteButton_Caption;
  LANGAll := LANGfrAll;

  LANGCopyFilesSC := LANGfrCopyFilesSC;
  LANGAppendQuestion := LANGfrAppendQuestion;
  LANGPreparingList := LANGfrPreparingList;

  LANGYouMustSelectAValidFile := LANGfrYouMustSelectAValidFile;
  LANGmiVerifyChecksums := LANGfrmiVerifyChecksums;
  LANGVerifyChecksumsCaption := LANGfrVerifyChecksumsCaption;
  LANGCheckButtonCaptionCheck := LANGfrCheckButtonCaptionCheck;
  LANGCheckButtonCaptionStop := LANGfrCheckButtonCaptionStop;
  LANGFileListTooltip := LANGfrFileListTooltip;
  LANGFilenameColumnCaption := LANGfrFilenameColumnCaption;
  LANGTheFileSYouAreTryingToOpenIsQuiteBig := LANGfrTheFileSYouAreTryingToOpenIsQuiteBig;
  LANGAnErrorOccuredWhileInitializingMemoryBlock := LANGfrAnErrorOccuredWhileInitializingMemoryBlock;
  LANGAnErrorOccuredWhileOpeningFileSS := LANGfrAnErrorOccuredWhileOpeningFileSS;
  LANGAnErrorOccuredWhileReadingFileSS := LANGfrAnErrorOccuredWhileReadingFileSS;
  LANGChecksumNotChecked := LANGfrChecksumNotChecked;
  LANGChecksumChecking := LANGfrChecksumChecking;
  LANGChecksumInterrupted := LANGfrChecksumInterrupted;
  LANGChecksumDOK := LANGfrChecksumDOK;

  LANGmiCreateChecksumsCaption := LANGfrmiCreateChecksumsCaption;
  LANGYouMustSelectAtLeastOneFileToCalculateChecksum := LANGfrYouMustSelectAtLeastOneFileToCalculateChecksum;
  LANGCreateChecksumsCaption := LANGfrCreateChecksumsCaption;
  LANGCCHKSUMPage1Text := LANGfrCCHKSUMPage1Text;
  LANGCCHKSUMPage4Text := LANGfrCCHKSUMPage4Text;
  LANGCCHKSUMPage6Text := LANGfrCCHKSUMPage6Text;
  LANGCCHKSUMPage7Text := LANGfrCCHKSUMPage7Text;
  LANGCCHKSUMPage1Title := LANGfrCCHKSUMPage1Title;
  LANGCCHKSUMPage2Title := LANGfrCCHKSUMPage2Title;
  LANGCCHKSUMPage3Title := LANGfrCCHKSUMPage3Title;
  LANGCCHKSUMPage4Title := LANGfrCCHKSUMPage4Title;
  LANGCCHKSUMPage5Title := LANGfrCCHKSUMPage5Title;
  LANGCCHKSUMPage6Title := LANGfrCCHKSUMPage6Title;
  LANGCCHKSUMPage7Title := LANGfrCCHKSUMPage7Title;
  LANGCCHKSUMSFVFile := LANGfrCCHKSUMSFVFile;
  LANGCCHKSUMMD5sumFile := LANGfrCCHKSUMMD5sumFile;
  LANGCCHKSUMFileName := LANGfrCCHKSUMFileName;
  LANGCCHKSUMCreateSeparateChecksumFiles := LANGfrCCHKSUMCreateSeparateChecksumFiles;
  LANGCCHKSUMNowProcessingFileS := LANGfrCCHKSUMNowProcessingFileS;
  LANGCCHKSUMFinishCaption := LANGfrCCHKSUMFinishCaption;
  LANGCCHKSUMAreYouSureYouWantToAbortTheProcessing := LANGfrCCHKSUMAreYouSureYouWantToAbortTheProcessing;
  LANGCCHKSUMAnErrorOccuredWhileOpeningFileSS := LANGfrCCHKSUMAnErrorOccuredWhileOpeningFileSS;
  LANGCCHKSUMAnErrorOccuredWhileReadingFileSS := LANGfrCCHKSUMAnErrorOccuredWhileReadingFileSS;
  LANGCCHKSUMAnErrorOccuredWhileWritingFileSS := LANGfrCCHKSUMAnErrorOccuredWhileWritingFileSS;

  LANGAnErrorOccuredWhileWritingFileSS := LANGfrAnErrorOccuredWhileWritingFileSS;
  LANGTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt := LANGfrTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt;
  LANGTheTargetFileSCannotBeRemovedS := LANGfrTheTargetFileSCannotBeRemovedS;
  LANGMergeCaption := LANGfrMergeCaption;
  LANGPleaseInsertNextDiskOrGiveDifferentLocation := LANGfrPleaseInsertNextDiskOrGiveDifferentLocation;
  LANGMergeOfSSucceeded := LANGfrMergeOfSSucceeded;
  LANGWarningCreatedFileFailsCRCCheck := LANGfrWarningCreatedFileFailsCRCCheck;
  LANGMergeOfSSucceeded_NoCRCFileAvailable := LANGfrMergeOfSSucceeded_NoCRCFileAvailable;
  LANGMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory := LANGfrMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory;
  LANGMergeSC := LANGfrMergeSC;
  LANGmiSplitFileCaption := LANGfrmiSplitFileCaption;
  LANGmiMergeFilesCaption := LANGfrmiMergeFilesCaption;

  LANGSplitTheFileSToDirectory := LANGfrSplitTheFileSToDirectory;
  LANGSplitSC := LANGfrSplitSC;
  LANGSplitFile := LANGfrSplitFile;
  LANGBytesPerFile := LANGfrBytesPerFile;
  LANGAutomatic := LANGfrAutomatic;
  LANGDeleteFilesOnTargetDisk := LANGfrDeleteFilesOnTargetDisk;
  LANGSplitCaption := LANGfrSplitCaption;
  LANGCannotOpenFileS := LANGfrCannotOpenFileS;
  LANGCannotSplitTheFileToMoreThan999Parts := LANGfrCannotSplitTheFileToMoreThan999Parts;
  LANGThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem := LANGfrThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem;
  LANGThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem := LANGfrThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem;
  LANGAnErrorOccuredWhileOperationS := LANGfrAnErrorOccuredWhileOperationS;
  LANGSplitOfSSucceeded := LANGfrSplitOfSSucceeded;
  LANGSplitOfSFailed := LANGfrSplitOfSFailed;

  LANGmnuShow_Caption := LANGfrmnuShow_Caption;
  LANGmiShowDotFiles_Caption := LANGfrmiShowDotFiles_Caption;
  LANGTheFileYouAreTryingToOpenIsQuiteBig := LANGfrTheFileYouAreTryingToOpenIsQuiteBig;
  LANGCannotExecuteSPleaseCheckTheConfiguration := LANGfrCannotExecuteSPleaseCheckTheConfiguration;
  LANGEdit := LANGfrEdit;
  LANGenterFilenameToEdit := LANGfrEnterFilenameToEdit;

  LANGmnuSettings_Caption := LANGfrmnuSettings_Caption;
  LANGmiFileTypes_Caption := LANGfrmiFileTypes_Caption;
  LANGThereIsNoApplicationAssociatedWithS := LANGfrThereIsNoApplicationAssociatedWithS;
  LANGErrorExecutingCommand := LANGfrErrorExecutingCommand;
  LANGEditFileTypesCaption := LANGfrEditFileTypesCaption;
  LANGTitleLabel_Caption := LANGfrTitleLabel_Caption;
  LANGExtensionsColumn := LANGfrExtensionsColumn;
  LANGDescriptionColumn := LANGfrDescriptionColumn;
  LANGFileTypesList := LANGfrFileTypesList;
  LANGActionName := LANGfrActionName;
  LANGCommand := LANGfrCommand;
  LANGSetDefaultActionButton_Caption := LANGfrSetDefaultActionButton_Caption;
  LANGRunInTerminalCheckBox_Caption := LANGfrRunInTerminalCheckBox_Caption;
  LANGAutodetectCheckBox_Caption := LANGfrAutodetectCheckBox_Caption;
  LANGBrowseButton_Caption := LANGfrBrowseButton_Caption;
  LANGCommandLabel_Caption := LANGfrCommandLabel_Caption;
  LANGDescriptionLabel_Caption := LANGfrDescriptionLabel_Caption;
  LANGFNameExtLabel_Caption := LANGfrFNameExtLabel_Caption;
  LANGNotebookPageExtensions := LANGfrNotebookPageExtensions;
  LANGNotebookPageActions := LANGfrNotebookPageActions;
  LANGDefault := LANGfrDefault;
  LANGCannotSaveFileTypeAssociationsBecauseOtherProcess := LANGfrCannotSaveFileTypeAssociationsBecauseOtherProcess;

  LANGDefaultColor := LANGfrDefaultColor;
  LANGIcon := LANGfrIcon;
  LANGBrowseForIcon := LANGfrBrowseForIcon;
  LANGSelectFileTypeColor := LANGfrSelectFileTypeColor;
  LANGColor := LANGfrColor;

  LANGmiChangePermissions_Caption := LANGfrmiChangePermissions_Caption;
  LANGmiChangeOwner_Caption := LANGfrmiChangeOwner_Caption;
  LANGmiCreateSymlink_Caption := LANGfrmiCreateSymlink_Caption;
  LANGmiEditSymlink_Caption := LANGfrmiEditSymlink_Caption;
  LANGChmodProgress := LANGfrChmodProgress;
  LANGChownProgress := LANGfrChownProgress;
  LANGYouMustSelectAValidSymbolicLink := LANGfrYouMustSelectAValidSymbolicLink;
  LANGPopupRunS := LANGfrPopupRunS;
  LANGPopupOpenS := LANGfrPopupOpenS;
  LANGPopupGoUp := LANGfrPopupGoUp;
  LANGPopupOpenWithS := LANGfrPopupOpenWithS;
  LANGPopupDefault := LANGfrPopupDefault;
  LANGPopupOpenWith := LANGfrPopupOpenWith;
  LANGPopupViewFile := LANGfrPopupViewFile;
  LANGPopupEditFile := LANGfrPopupEditFile;
  LANGPopupMakeSymlink := LANGfrPopupMakeSymlink;
  LANGPopupRename := LANGfrPopupRename;
  LANGPopupDelete := LANGfrPopupDelete;
  LANGDialogChangePermissions := LANGfrDialogChangePermissions;
  LANGCouldNotBeChmoddedS := LANGfrCouldNotBeChmoddedS;
  LANGDialogChangeOwner := LANGfrDialogChangeOwner;
  LANGCouldNotBeChownedS := LANGfrCouldNotBeChownedS;
  LANGDialogMakeSymlink := LANGfrDialogMakeSymlink;
  LANGDialogEditSymlink := LANGfrDialogEditSymlink;
  LANGFEditSymlink_Caption := LANGfrFEditSymlink_Caption;
  LANGFEditSymlink_SymbolicLinkFilename := LANGfrFEditSymlink_SymbolicLinkFilename;
  LANGFEditSymlink_SymbolicLinkPointsTo := LANGfrFEditSymlink_SymbolicLinkPointsTo;

  LANGFChmod_Caption := LANGfrFChmod_Caption;
  LANGFChmod_PermissionFrame := LANGfrFChmod_PermissionFrame;
  LANGFChmod_FileFrame := LANGfrFChmod_FileFrame;
  LANGFChmod_ApplyRecursivelyFor := LANGfrFChmod_ApplyRecursivelyFor;
  LANGFChmod_miAllFiles := LANGfrFChmod_miAllFiles;
  LANGFChmod_miDirectories := LANGfrFChmod_miDirectories;
  LANGFChmod_OctalLabel := LANGfrFChmod_OctalLabel;
  LANGFChmod_SUID := LANGfrFChmod_SUID;
  LANGFChmod_SGID := LANGfrFChmod_SGID;
  LANGFChmod_Sticky := LANGfrFChmod_Sticky;
  LANGFChmod_RUSR := LANGfrFChmod_RUSR;
  LANGFChmod_WUSR := LANGfrFChmod_WUSR;
  LANGFChmod_XUSR := LANGfrFChmod_XUSR;
  LANGFChmod_RGRP := LANGfrFChmod_RGRP;
  LANGFChmod_WGRP := LANGfrFChmod_WGRP;
  LANGFChmod_XGRP := LANGfrFChmod_XGRP;
  LANGFChmod_ROTH := LANGfrFChmod_ROTH;
  LANGFChmod_WOTH := LANGfrFChmod_WOTH;
  LANGFChmod_XOTH := LANGfrFChmod_XOTH;
  LANGFChmod_TextLabel := LANGfrFChmod_TextLabel;
  LANGFChmod_FileLabel := LANGfrFChmod_FileLabel;
  LANGFChown_Caption := LANGfrFChown_Caption;
  LANGFChown_OwnerFrame := LANGfrFChown_OwnerFrame;
  LANGFChown_GroupFrame := LANGfrFChown_GroupFrame;
  LANGFChown_FileFrame := LANGfrFChown_FileFrame;
  LANGFChown_ApplyRecursively := LANGfrFChown_ApplyRecursively;

  LANGFSymlink_Caption := LANGfrFSymlink_Caption;
  LANGFSymlink_ExistingFilename := LANGfrFSymlink_ExistingFilename;
  LANGFSymlink_SymlinkFilename := LANGfrFSymlink_SymlinkFilename;

  LANGmnuBookmarks_Caption := LANGfrmnuBookmarks_Caption;
  LANGmiAddBookmark_Caption := LANGfrmiAddBookmark_Caption;
  LANGmiEditBookmarks_Caption := LANGfrmiEditBookmarks_Caption;
  LANGBookmarkPopupDelete_Caption := LANGfrBookmarkPopupDelete_Caption;
  LANGmiPreferences_Caption := LANGfrmiPreferences_Caption;
  LANGTheCurrentDirectoryAlreadyExistsInTheBookmarksList := LANGfrTheCurrentDirectoryAlreadyExistsInTheBookmarksList;
  LANGSomeOtherInstanceChanged := LANGfrSomeOtherInstanceChanged;

  LANGPreferences_Caption := LANGfrPreferences_Caption;
  LANGPreferences_TitleLabel_Caption := LANGfrPreferences_TitleLabel_Caption;
  LANGPreferences_GeneralPage := LANGfrPreferences_GeneralPage;
  LANGPreferences_FontsPage := LANGfrPreferences_FontsPage;
  LANGPreferences_ColorsPage := LANGfrPreferences_ColorsPage;
  LANGPreferences_RowHeight := LANGfrPreferences_RowHeight;
  LANGPreferences_NumHistoryItems := LANGfrPreferences_NumHistoryItems;
  LANGPreferences_Default := LANGfrPreferences_Default;
  LANGPreferences_ClearReadonlyAttribute := LANGfrPreferences_ClearReadonlyAttribute;
  LANGPreferences_DisableMouseRenaming := LANGfrPreferences_DisableMouseRenaming;
  LANGPreferences_ShowFiletypeIconsInList := LANGfrPreferences_ShowFiletypeIconsInList;
  LANGPreferences_ExternalAppsLabel := LANGfrPreferences_ExternalAppsLabel;
  LANGPreferences_Viewer := LANGfrPreferences_Viewer;
  LANGPreferences_Editor := LANGfrPreferences_Editor;
  LANGPreferences_Terminal := LANGfrPreferences_Terminal;
  LANGPreferences_ListFont := LANGfrPreferences_ListFont;
  LANGPreferences_Change := LANGfrPreferences_Change;
  LANGPreferences_UseDefaultFont := LANGfrPreferences_UseDefaultFont;
  LANGPreferences_Foreground := LANGfrPreferences_Foreground;
  LANGPreferences_Background := LANGfrPreferences_Background;
  LANGPreferences_NormalItem := LANGfrPreferences_NormalItem;
  LANGPreferences_SetToDefaultToUseGTKThemeColors := LANGfrPreferences_SetToDefaultToUseGTKThemeColors;
  LANGPreferences_Cursor := LANGfrPreferences_Cursor;
  LANGPreferences_InactiveItem := LANGfrPreferences_InactiveItem;
  LANGPreferences_SelectedItem := LANGfrPreferences_SelectedItem;
  LANGPreferences_LinkItem := LANGfrPreferences_LinkItem;
  LANGPreferences_LinkItemHint := LANGfrPreferences_LinkItemHint;
  LANGPreferences_DotFileItem := LANGfrPreferences_DotFileItem;
  LANGPreferences_DotFileItemHint := LANGfrPreferences_DotFileItemHint;
  LANGPreferences_BrowseForApplication := LANGfrPreferences_BrowseForApplication;
  LANGPreferences_DefaultS := LANGfrPreferences_DefaultS;
  LANGPreferences_SelectFont := LANGfrPreferences_SelectFont;

  LANGBookmarkButton_Tooltip := LANGfrBookmarkButton_Tooltip;
  LANGUpButton_Tooltip := LANGfrUpButton_Tooltip;
  LANGRootButton_Tooltip := LANGfrRootButton_Tooltip;
  LANGHomeButton_Tooltip := LANGfrHomeButton_Tooltip;
  LANGLeftEqualButton_Tooltip := LANGfrLeftEqualButton_Tooltip;
  LANGRightEqualButton_Tooltip := LANGfrRightEqualButton_Tooltip;
  LANGmiShowDirectorySizes_Caption := LANGfrmiShowDirectorySizes_Caption;
  LANGmiTargetSource_Caption := LANGfrmiTargetSource_Caption;
  LANGFileTypeDirectory := LANGfrFileTypeDirectory;
  LANGFileTypeFile := LANGfrFileTypeFile;
  LANGFileTypeMetafile := LANGfrFileTypeMetafile;
  LANGPreferencesPanelsPage := LANGfrPreferencesPanelsPage;
  LANGPreferencesApplicationsPage := LANGfrPreferencesApplicationsPage;
  LANGPreferencesExperimentalPage := LANGfrPreferencesExperimentalPage;
  LANGPreferencesSelectAllDirectoriesCheckBox_Caption := LANGfrPreferencesSelectAllDirectoriesCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Caption := LANGfrPreferencesNewStyleAltOCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Tooltip := LANGfrPreferencesNewStyleAltOCheckBox_Tooltip;
  LANGPreferencesShowFuncButtonsCheckBox_Caption := LANGfrPreferencesShowFuncButtonsCheckBox_Caption;
  LANGPreferencesSizeFormatLabel_Caption := LANGfrPreferencesSizeFormatLabel_Caption;
  LANGPreferencesmiSizeFormat1 := LANGfrPreferencesmiSizeFormat1;
  LANGPreferencesmiSizeFormat6 := LANGfrPreferencesmiSizeFormat6;
  LANGPreferencesAutodetectXApp := LANGfrPreferencesAutodetectXApp;
  LANGPreferencesAlwaysRunInTerminal := LANGfrPreferencesAlwaysRunInTerminal;
  LANGPreferencesNeverRunInTerminal := LANGfrPreferencesNeverRunInTerminal;
  LANGPreferencesCmdLineBehaviourLabel_Caption := LANGfrPreferencesCmdLineBehaviourLabel_Caption;
  LANGPreferencesFeatures := LANGfrPreferencesFeatures;
  LANGPreferencesDisableMouseRename_Tooltip := LANGfrPreferencesDisableMouseRename_Tooltip;
  LANGPreferencesDisableFileTipsCheckBox_Caption := LANGfrPreferencesDisableFileTipsCheckBox_Caption;
  LANGPreferencesDisableFileTipsCheckBox_Tooltip := LANGfrPreferencesDisableFileTipsCheckBox_Tooltip;
  LANGPreferencesShow := LANGfrPreferencesShow;
  LANGPreferencesDirsInBoldCheckBox_Caption := LANGfrPreferencesDirsInBoldCheckBox_Caption;
  LANGPreferencesDisableDirectoryBracketsCheckBox_Caption := LANGfrPreferencesDisableDirectoryBracketsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Caption := LANGfrPreferencesOctalPermissionsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Tooltip := LANGfrPreferencesOctalPermissionsCheckBox_Tooltip;
  LANGPreferencesMovement := LANGfrPreferencesMovement;
  LANGPreferencesLynxLikeMotionCheckBox_Caption := LANGfrPreferencesLynxLikeMotionCheckBox_Caption;
  LANGPreferencesInsertMovesDownCheckBox_Caption := LANGfrPreferencesInsertMovesDownCheckBox_Caption;
  LANGPreferencesSpaceMovesDownCheckBox_Caption := LANGfrPreferencesSpaceMovesDownCheckBox_Caption;
  LANGPreferencesViewer := LANGfrPreferencesViewer;
  LANGPreferencesCommandSC := LANGfrPreferencesCommandSC;
  LANGPreferencesUseInternalViewer := LANGfrPreferencesUseInternalViewer;
  LANGPreferencesEditor := LANGfrPreferencesEditor;
  LANGPreferencesTerminal := LANGfrPreferencesTerminal;
  LANGPreferencesExperimentalFeatures := LANGfrPreferencesExperimentalFeatures;
  LANGPreferencesExperimentalWarningLabel_Caption := LANGfrPreferencesExperimentalWarningLabel_Caption;
  LANGPreferencesFocusRefreshCheckBox_Caption := LANGfrPreferencesFocusRefreshCheckBox_Caption;
  LANGPreferencesFocusRefreshCheckBox_Tooltip := LANGfrPreferencesFocusRefreshCheckBox_Tooltip;
  LANGPreferencesWMCompatModeCheckBox_Caption := LANGfrPreferencesWMCompatModeCheckBox_Caption;
  LANGPreferencesWMCompatModeCheckBox_Tooltip := LANGfrPreferencesWMCompatModeCheckBox_Tooltip;
  LANGPreferencesCompatUseLibcSystemCheckBox_Caption := LANGfrPreferencesCompatUseLibcSystemCheckBox_Caption;
  LANGPreferencesCompatUseLibcSystemCheckBox_Tooltip := LANGfrPreferencesCompatUseLibcSystemCheckBox_Tooltip;

  LANGmiSearchCaption2 := LANGfrmiSearchCaption2;
  LANGmiNoMounterBarCaption := LANGfrmiNoMounterBarCaption;
  LANGmiShowOneMounterBarCaption := LANGfrmiShowOneMounterBarCaption;
  LANGmiShowTwoMounterBarCaption := LANGfrmiShowTwoMounterBarCaption;
  LANGmnuNetworkCaption := LANGfrmnuNetworkCaption;
  LANGmiConnectionsCaption := LANGfrmiConnectionsCaption;
  LANGmiOpenConnectionCaption := LANGfrmiOpenConnectionCaption;
  LANGmiQuickConnectCaption := LANGfrmiQuickConnectCaption;
  LANGmnuPluginsCaption := LANGfrmnuPluginsCaption;
  LANGmiTestPluginCaption := LANGfrmiTestPluginCaption;
  LANGmiMounterSettingsCaption := LANGfrmiMounterSettingsCaption;
  LANGmiColumnsCaption := LANGfrmiColumnsCaption;
  LANGmiSavePositionCaption := LANGfrmiSavePositionCaption;
  LANGmiMountCaption := LANGfrmiMountCaption;
  LANGmiUmountCaption := LANGfrmiUmountCaption;
  LANGmiEjectCaption := LANGfrmiEjectCaption;
  LANGmiDuplicateTabCaption := LANGfrmiDuplicateTabCaption;
  LANGmiCloseTabCaption := LANGfrmiCloseTabCaption;
  LANGmiCloseAllTabsCaption := LANGfrmiCloseAllTabsCaption;
  LANGCannotDetermineDestinationEngine := LANGfrCannotDetermineDestinationEngine;
  LANGCannotLoadFile := LANGfrCannotLoadFile;
  LANGMountPointDevice := LANGfrMountPointDevice;
  LANGMountSC := LANGfrMountSC;
  LANGNoPluginsFound := LANGfrNoPluginsFound;
  LANGPluginAbout := LANGfrPluginAbout;
  LANGCouldntOpenURI := LANGfrCouldntOpenURI;
  LANGPluginAboutInside := LANGfrPluginAboutInside;
  LANGAreYouSureCloseAllTabs := LANGfrAreYouSureCloseAllTabs;
  LANGCouldntOpenURIArchive := LANGfrCouldntOpenURIArchive;
  LANGThereIsNoModuleAvailable := LANGfrThereIsNoModuleAvailable;
  LANGIgnoreError := LANGfrIgnoreError;
  LANGErrorMount := LANGfrErrorMount;
  LANGErrorUmount := LANGfrErrorUmount;
  LANGErrorEject := LANGfrErrorEject;

  LANGMounterPrefs_Caption := LANGfrMounterPrefs_Caption;
  LANGMounterPrefs_TitleLabelCaption := LANGfrMounterPrefs_TitleLabelCaption;
  LANGMounterPrefs_ListViewFrameCaption := LANGfrMounterPrefs_ListViewFrameCaption;
  LANGMounterPrefs_MountName := LANGfrMounterPrefs_MountName;
  LANGMounterPrefs_MountPoint := LANGfrMounterPrefs_MountPoint;
  LANGMounterPrefs_Device := LANGfrMounterPrefs_Device;
  LANGMounterPrefs_MoveUpButtonTooltip := LANGfrMounterPrefs_MoveUpButtonTooltip;
  LANGMounterPrefs_MoveDownButtonTooltip := LANGfrMounterPrefs_MoveDownButtonTooltip;
  LANGMounterPrefs_UseFSTabDefaultsCheckBox := LANGfrMounterPrefs_UseFSTabDefaultsCheckBox;
  LANGMounterPrefs_UseFSTabDefaultsCheckBoxTooltip := LANGfrMounterPrefs_UseFSTabDefaultsCheckBoxTooltip;
  LANGMounterPrefs_ToggleModeCheckBox := LANGfrMounterPrefs_ToggleModeCheckBox;
  LANGMounterPrefs_ToggleModeCheckBoxTooltip := LANGfrMounterPrefs_ToggleModeCheckBoxTooltip;
  LANGMounterPrefs_PropertiesFrameCaption := LANGfrMounterPrefs_PropertiesFrameCaption;
  LANGMounterPrefs_DisplayTextLabelCaption := LANGfrMounterPrefs_DisplayTextLabelCaption;
  LANGMounterPrefs_MountPointLabelCaption := LANGfrMounterPrefs_MountPointLabelCaption;
  LANGMounterPrefs_MountDeviceLabelCaption := LANGfrMounterPrefs_MountDeviceLabelCaption;
  LANGMounterPrefs_DeviceTypeLabelCaption := LANGfrMounterPrefs_DeviceTypeLabelCaption;
  LANGMounterPrefs_miLocalDiskCaption := LANGfrMounterPrefs_miLocalDiskCaption;
  LANGMounterPrefs_miRemovableCaption := LANGfrMounterPrefs_miRemovableCaption;
  LANGMounterPrefs_miCDCaption := LANGfrMounterPrefs_miCDCaption;
  LANGMounterPrefs_miFloppyCaption := LANGfrMounterPrefs_miFloppyCaption;
  LANGMounterPrefs_miNetworkCaption := LANGfrMounterPrefs_miNetworkCaption;
  LANGMounterPrefs_MountCommandLabelCaption := LANGfrMounterPrefs_MountCommandLabelCaption;
  LANGMounterPrefs_UmountCommandLabelCaption := LANGfrMounterPrefs_UmountCommandLabelCaption;
  LANGMounterPrefs_MountCommandEntryTooltip := LANGfrMounterPrefs_MountCommandEntryTooltip;
  LANGMounterPrefs_UmountCommandEntryTooltip := LANGfrMounterPrefs_UmountCommandEntryTooltip;
  LANGMounterPrefs_IconLabelCaption := LANGfrMounterPrefs_IconLabelCaption;

  LANGConnMgr_Caption := LANGfrConnMgr_Caption;
  LANGConnMgr_ConnectButton := LANGfrConnMgr_ConnectButton;
  LANGConnMgr_OpenConnection := LANGfrConnMgr_OpenConnection;
  LANGConnMgr_NameColumn := LANGfrConnMgr_NameColumn;
  LANGConnMgr_URIColumn := LANGfrConnMgr_URIColumn;
  LANGConnMgr_AddConnectionButtonCaption := LANGfrConnMgr_AddConnectionButtonCaption;
  LANGConnMgr_AddConnectionButtonTooltip := LANGfrConnMgr_AddConnectionButtonTooltip;
  LANGConnMgr_EditButtonCaption := LANGfrConnMgr_EditButtonCaption;
  LANGConnMgr_EditButtonTooltip := LANGfrConnMgr_EditButtonTooltip;
  LANGConnMgr_RemoveButtonCaption := LANGfrConnMgr_RemoveButtonCaption;
  LANGConnMgr_RemoveButtonTooltip := LANGfrConnMgr_RemoveButtonTooltip;
  LANGConnMgr_DoYouWantDelete := LANGfrConnMgr_DoYouWantDelete;

  LANGConnProp_FTP := LANGfrConnProp_FTP;
  LANGConnProp_SFTP := LANGfrConnProp_SFTP;
  LANGConnProp_SMB := LANGfrConnProp_SMB;
  LANGConnProp_HTTP := LANGfrConnProp_HTTP;
  LANGConnProp_HTTPS := LANGfrConnProp_HTTPS;
  LANGConnProp_Other := LANGfrConnProp_Other;
  LANGConnProp_Caption := LANGfrConnProp_Caption;
  LANGConnProp_VFSModule := LANGfrConnProp_VFSModule;
  LANGConnProp_URI := LANGfrConnProp_URI;
  LANGConnProp_URIEntryTooltip := LANGfrConnProp_URIEntryTooltip;
  LANGConnProp_DetailedInformations := LANGfrConnProp_DetailedInformations;
  LANGConnProp_Name := LANGfrConnProp_Name;
  LANGConnProp_Server := LANGfrConnProp_Server;
  LANGConnProp_Username := LANGfrConnProp_Username;
  LANGConnProp_UserNameEntryTooltip := LANGfrConnProp_UserNameEntryTooltip;
  LANGConnProp_Password := LANGfrConnProp_Password;
  LANGConnProp_TargetDirectory := LANGfrConnProp_TargetDirectory;
  LANGConnProp_ServiceType := LANGfrConnProp_ServiceType; 
  LANGConnProp_MaskPassword := LANGfrConnProp_MaskPassword; 
  LANGConnProp_MenuItemCaption := LANGfrConnProp_MenuItemCaption; 

  LANGConnLogin_Caption := LANGfrConnLogin_Caption; 
  LANGConnLogin_Login := LANGfrConnLogin_Login;
  LANGConnLogin_ExperimentalWarningLabelCaption := LANGfrConnLogin_ExperimentalWarningLabelCaption; 
  LANGConnLogin_Username := LANGfrConnLogin_Username; 
  LANGConnLogin_Password := LANGfrConnLogin_Password; 
  LANGConnLogin_AnonymousCheckButton := LANGfrConnLogin_AnonymousCheckButton; 

  LANGColumns_Caption := LANGfrColumns_Caption;
  LANGColumns_Title := LANGfrColumns_Title;
  LANGColumns_MoveUpButtonTooltip := LANGfrColumns_MoveUpButtonTooltip;
  LANGColumns_MoveDownButtonTooltip := LANGfrColumns_MoveDownButtonTooltip; 
  LANGColumns_TitlesLongName := LANGfrColumns_TitlesLongName; 
  LANGColumns_TitlesLongNameExt := LANGfrColumns_TitlesLongNameExt; 
  LANGColumns_TitlesLongExt := LANGfrColumns_TitlesLongExt;
  LANGColumns_TitlesLongSize := LANGfrColumns_TitlesLongSize; 
  LANGColumns_TitlesLongDateTime := LANGfrColumns_TitlesLongDateTime; 
  LANGColumns_TitlesLongDate := LANGfrColumns_TitlesLongDate; 
  LANGColumns_TitlesLongTime := LANGfrColumns_TitlesLongTime; 
  LANGColumns_TitlesLongUser := LANGfrColumns_TitlesLongUser; 
  LANGColumns_TitlesLongGroup := LANGfrColumns_TitlesLongGroup;
  LANGColumns_TitlesLongAttr := LANGfrColumns_TitlesLongAttr; 
  LANGColumns_TitlesShortName := LANGfrColumns_TitlesShortName; 
  LANGColumns_TitlesShortNameExt := LANGfrColumns_TitlesShortNameExt; 
  LANGColumns_TitlesShortExt := LANGfrColumns_TitlesShortExt;
  LANGColumns_TitlesShortSize := LANGfrColumns_TitlesShortSize;
  LANGColumns_TitlesShortDateTime := LANGfrColumns_TitlesShortDateTime;
  LANGColumns_TitlesShortDate := LANGfrColumns_TitlesShortDate; 
  LANGColumns_TitlesShortTime := LANGfrColumns_TitlesShortTime; 
  LANGColumns_TitlesShortUser := LANGfrColumns_TitlesShortUser; 
  LANGColumns_TitlesShortGroup := LANGfrColumns_TitlesShortGroup;
  LANGColumns_TitlesShortAttr := LANGfrColumns_TitlesShortAttr; 

  LANGTestPlugin_Caption := LANGfrTestPlugin_Caption; 
  LANGTestPlugin_Title := LANGfrTestPlugin_Title; 
  LANGTestPlugin_ExperimentalWarningLabelCaption := LANGfrTestPlugin_ExperimentalWarningLabelCaption;
  LANGTestPlugin_Plugin := LANGfrTestPlugin_Plugin; 
  LANGTestPlugin_Command := LANGfrTestPlugin_Command; 
  LANGTestPlugin_Username := LANGfrTestPlugin_Username;
  LANGTestPlugin_Password := LANGfrTestPlugin_Password; 
  LANGTestPlugin_AnonymousCheckButton := LANGfrTestPlugin_AnonymousCheckButton; 
  LANGTestPlugin_NoPluginsFound := LANGfrTestPlugin_NoPluginsFound; 

  LANGRemoteWait_Caption := LANGfrRemoteWait_Caption; 
  LANGRemoteWait_OperationInProgress := LANGfrRemoteWait_OperationInProgress;
  LANGRemoteWait_ItemsFound := LANGfrRemoteWait_ItemsFound; 

  LANGSearch_Bytes := LANGfrSearch_Bytes; 
  LANGSearch_kB := LANGfrSearch_kB; 
  LANGSearch_MB := LANGfrSearch_MB; 
  LANGSearch_days := LANGfrSearch_days;
  LANGSearch_weeks := LANGfrSearch_weeks; 
  LANGSearch_months := LANGfrSearch_months; 
  LANGSearch_years := LANGfrSearch_years; 
  LANGSearch_Caption := LANGfrSearch_Caption; 
  LANGSearch_General := LANGfrSearch_General; 
  LANGSearch_Advanced := LANGfrSearch_Advanced;
  LANGSearch_SearchResults := LANGfrSearch_SearchResults; 
  LANGSearch_SearchFor := LANGfrSearch_SearchFor; 
  LANGSearch_FileMaskEntryTooltip := LANGfrSearch_FileMaskEntryTooltip; 
  LANGSearch_SearchIn := LANGfrSearch_SearchIn; 
  LANGSearch_SearchArchivesCheckButton := LANGfrSearch_SearchArchivesCheckButton;
  LANGSearch_FindText := LANGfrSearch_FindText;
  LANGSearch_FindTextEntryTooltip := LANGfrSearch_FindTextEntryTooltip;
  LANGSearch_CaseSensitiveCheckButton := LANGfrSearch_CaseSensitiveCheckButton;
  LANGSearch_StayCurrentFSCheckButton := LANGfrSearch_StayCurrentFSCheckButton;
  LANGSearch_CaseSensitiveMatchCheckButton := LANGfrSearch_CaseSensitiveMatchCheckButton;
  LANGSearch_Size := LANGfrSearch_Size;
  LANGSearch_Date := LANGfrSearch_Date;
  LANGSearch_BiggerThan := LANGfrSearch_BiggerThan;
  LANGSearch_SmallerThan := LANGfrSearch_SmallerThan;
  LANGSearch_ModifiedBetweenRadioButton := LANGfrSearch_ModifiedBetweenRadioButton;
  LANGSearch_NotModifiedAfterRadioButton := LANGfrSearch_NotModifiedAfterRadioButton;
  LANGSearch_ModifiedLastRadioButton := LANGfrSearch_ModifiedLastRadioButton;
  LANGSearch_ModifiedNotLastRadionButton := LANGfrSearch_ModifiedNotLastRadionButton;
  LANGSearch_ModifiedBetweenEntry1 := LANGfrSearch_ModifiedBetweenEntry1;
  LANGSearch_ViewButtonCaption := LANGfrSearch_ViewButtonCaption;
  LANGSearch_NewSearchButtonCaption := LANGfrSearch_NewSearchButtonCaption;
  LANGSearch_GoToFileButtonCaption := LANGfrSearch_GoToFileButtonCaption;
  LANGSearch_FeedToListboxButtonCaption := LANGfrSearch_FeedToListboxButtonCaption;
  LANGSearch_StatusSC := LANGfrSearch_StatusSC;
  LANGSearch_Ready := LANGfrSearch_Ready;
  LANGSearch_PreparingToSearch := LANGfrSearch_PreparingToSearch;
  LANGSearch_SearchInProgress := LANGfrSearch_SearchInProgress;
  LANGSearch_UserCancelled := LANGfrSearch_UserCancelled;
  LANGSearch_SearchFinished := LANGfrSearch_SearchFinished;
  LANGSearch_FilesFound := LANGfrSearch_FilesFound;
  LANGSearch_And := LANGfrSearch_And;

  LANGCloseOpenConnection := LANGfrCloseOpenConnection;
  LANGDuplicateTabWarning := LANGfrDuplicateTabWarning;
  LANGDontShowAgain := LANGfrDontShowAgain;
  LANGSwitchOtherPanelWarning := LANGfrSwitchOtherPanelWarning;
  LANGOpenConnectionsWarning := LANGfrOpenConnectionsWarning;
  LANGmiDisconnect_Caption := LANGfrmiDisconnect_Caption;
  LANGDisconnectButton_Tooltip := LANGfrDisconnectButton_Tooltip;
  LANGLeaveArchiveButton_Tooltip := LANGfrLeaveArchiveButton_Tooltip;
  LANGOpenTerminalButton_Tooltip := LANGfrOpenTerminalButton_Tooltip;
  LANGOpenTerminalButton_Caption := LANGfrOpenTerminalButton_Caption;
  LANGShowTextUIDsCheckBox_Caption := LANGfrShowTextUIDsCheckBox_Caption;
  LANGShowTextUIDsCheckBox_Tooltip := LANGfrShowTextUIDsCheckBox_Tooltip;

  LANGmiNewTab_Caption := LANGfrmiNewTab_Caption;
  LANGFilePopupMenu_Properties := LANGfrFilePopupMenu_Properties;
  LANGCommandEntry_Tooltip := LANGfrCommandEntry_Tooltip;
  LANGmiFiles_Caption := LANGfrmiFiles_Caption;

  LANGPasswordButton_Tooltip := LANGfrPasswordButton_Tooltip;
  LANGHandleRunFromArchive_Bytes := LANGfrHandleRunFromArchive_Bytes;
  LANGHandleRunFromArchive_FileTypeDesc_Unknown := LANGfrHandleRunFromArchive_FileTypeDesc_Unknown;
  LANGHandleRunFromArchive_NotAssociated := LANGfrHandleRunFromArchive_NotAssociated;
  LANGHandleRunFromArchive_SelfExecutable := LANGfrHandleRunFromArchive_SelfExecutable;
  LANGHandleRunFromArchive_CouldntCreateTemporaryDirectory := LANGfrHandleRunFromArchive_CouldntCreateTemporaryDirectory;
  LANGFRunFromVFS_Caption := LANGfrFRunFromVFS_Caption;
  LANGFRunFromVFS_TitleLabel := LANGfrFRunFromVFS_TitleLabel;
  LANGFRunFromVFS_FileNameLabel := LANGfrFRunFromVFS_FileNameLabel;
  LANGFRunFromVFS_FileTypeLabel := LANGfrFRunFromVFS_FileTypeLabel;
  LANGFRunFromVFS_SizeLabel := LANGfrFRunFromVFS_SizeLabel;
  LANGFRunFromVFS_PackedSizeLabel := LANGfrFRunFromVFS_PackedSizeLabel;
  LANGFRunFromVFS_DateLabel := LANGfrFRunFromVFS_DateLabel;
  LANGFRunFromVFS_InfoLabel := LANGfrFRunFromVFS_InfoLabel;
  LANGFRunFromVFS_OpensWithLabel := LANGfrFRunFromVFS_OpensWithLabel;
  LANGFRunFromVFS_ExecuteButton := LANGfrFRunFromVFS_ExecuteButton;
  LANGFRunFromVFS_ExecuteAllButton := LANGfrFRunFromVFS_ExecuteAllButton;
  LANGFSetPassword_Caption := LANGfrFSetPassword_Caption;
  LANGFSetPassword_Label1_Caption := LANGfrFSetPassword_Label1_Caption;
  LANGFSetPassword_Label2_Caption := LANGfrFSetPassword_Label2_Caption;
  LANGFSetPassword_ShowPasswordCheckButton := LANGfrFSetPassword_ShowPasswordCheckButton;

  LANGCopyFileNamesToClipboard := LANGfrCopyFileNamesToClipboard;
  LANGCopyFullPathNamesToClipboard := LANGfrCopyFullPathNamesToClipboard;
  LANGCopyPathToClipboard := LANGfrCopyPathToClipboard;
  LANGPreferences_DateFormatLabel_Caption := LANGfrPreferences_DateFormatLabel_Caption;
  LANGPreferences_System := LANGfrPreferences_System;
  LANGPreferences_Custom := LANGfrPreferences_Custom;
  LANGPreferences_CustomDateFormatEntry_Tooltip := LANGfrPreferences_CustomDateFormatEntry_Tooltip;
  LANGPreferences_TimeFormatLabel_Caption := LANGfrPreferences_TimeFormatLabel_Caption;
  LANGPreferences_CustomTimeFormatEntry_Tooltip := LANGfrPreferences_CustomTimeFormatEntry_Tooltip;
  LANGPreferences_DateTimeFormatLabel_Caption := LANGfrPreferences_DateTimeFormatLabel_Caption;
  LANGPreferences_QuickRenameSkipExtCheckBox := LANGfrPreferences_QuickRenameSkipExtCheckBox;
  LANGPreferences_QuickRenameSkipExtCheckBox_Tooltip := LANGfrPreferences_QuickRenameSkipExtCheckBox_Tooltip;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox := LANGfrPreferences_SortDirectoriesLikeFilesCheckBox;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip := LANGfrPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip;
  LANGPreferences_QuickSearchLabel_Caption := LANGfrPreferences_QuickSearchLabel_Caption;
  LANGPreferences_QuickSearchOptionMenu_Tooltip := LANGfrPreferences_QuickSearchOptionMenu_Tooltip;
  LANGPreferences_QuickSearch_Option1 := LANGfrPreferences_QuickSearch_Option1;
  LANGPreferences_QuickSearch_Option2 := LANGfrPreferences_QuickSearch_Option2;
  LANGPreferences_QuickSearch_Option3 := LANGfrPreferences_QuickSearch_Option3;
  LANGPreferences_QuickSearch_Option4 := LANGfrPreferences_QuickSearch_Option4;
  LANGPreferences_TempPathLabel_Caption := LANGfrPreferences_TempPathLabel_Caption;
  LANGPreferences_VFSTempPathLabel_Caption := LANGfrPreferences_VFSTempPathLabel_Caption;
  LANGPreferences_VFSTempPathEntry_Tooltip := LANGfrPreferences_VFSTempPathEntry_Tooltip;

  LANGPreferences_RightClickSelectCheckBox := LANGfrPreferences_RightClickSelectCheckBox;
  LANGPreferences_RightClickSelectCheckBox_Tooltip := LANGfrPreferences_RightClickSelectCheckBox_Tooltip;
  LANGGtkMountOperation_ConnectAnonymously := LANGfrGtkMountOperation_ConnectAnonymously;
  LANGGtkMountOperation_ConnectAsUser := LANGfrGtkMountOperation_ConnectAsUser;
  LANGGtkMountOperation_Username := LANGfrGtkMountOperation_Username;
  LANGGtkMountOperation_Domain := LANGfrGtkMountOperation_Domain;
  LANGGtkMountOperation_Password := LANGfrGtkMountOperation_Password;
  LANGGtkMountOperation_DoNotSavePassword :=  LANGfrGtkMountOperation_DoNotSavePassword;
  LANGGtkMountOperation_ForgetPasswordImmediately := LANGfrGtkMountOperation_ForgetPasswordImmediately;
  LANGGtkMountOperation_RememberPasswordUntilYouLogout := LANGfrGtkMountOperation_RememberPasswordUntilYouLogout;
  LANGGtkMountOperation_SavePasswordInConnectionManager := LANGfrGtkMountOperation_SavePasswordInConnectionManager;
  LANGGtkMountOperation_RememberForever := LANGfrGtkMountOperation_RememberForever;
  LANGFSymlink_RelativePath := LANGfrFSymlink_RelativePath;
  LANGFConnectionManager_DuplicateButton_Caption := LANGfrFConnectionManager_DuplicateButton_Caption;
  LANGFConnectionManager_DuplicateButton_Tooltip := LANGfrFConnectionManager_DuplicateButton_Tooltip;
  LANGFConnectionManager_DoNotSavePasswordsCheckBox_Label := LANGfrFConnectionManager_DoNotSavePasswordsCheckBox_Label;
  LANGFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip := LANGfrFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip;
  LANGFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label := LANGfrFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label;
  LANGFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip := LANGfrFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip;
  LANGFConnectionManager_DuplicateMenuItem_Caption := LANGfrFConnectionManager_DuplicateMenuItem_Caption;
  LANGFQuickConnect_Caption := LANGfrFQuickConnect_Caption;
  LANGFQuickConnect_TitleLabel_Caption := LANGfrFQuickConnect_TitleLabel_Caption;
  LANGFQuickConnect_ConnectToURILabel_Caption := LANGfrFQuickConnect_ConnectToURILabel_Caption;
  LANGLinkToS := LANGfrLinkToS;
  LANGOpenDirectoryInBackgroundTab := LANGfrOpenDirectoryInBackgroundTab;
  LANGTheActiveConnectionHasNotBeenSaved := LANGfrTheActiveConnectionHasNotBeenSaved;
  LANGTheArchiveIsEncryptedAndRequiresPassword := LANGfrTheArchiveIsEncryptedAndRequiresPassword;
end;

initialization
  AddTranslation('FR', @SetTranslation);
  AddTranslation('fr_FR', @SetTranslation);
end.
