/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;

public class RelativeDynamicURI
extends DynamicURI {
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.getScriptName());
        if (this.hasPathInfo) {
            output.append("/");
            output.append(this.renderPathInfo(this.pathInfo));
        }
        if (this.hasQueryData) {
            output.append("?");
            output.append(this.renderQueryString(this.queryData));
        }
        if (this.res != null) {
            if (this.redirect) {
                return this.res.encodeRedirectUrl(output.toString());
            }
            return this.res.encodeUrl(output.toString());
        }
        return output.toString();
    }

    public static String toString(RunData data) {
        StringBuffer output = new StringBuffer();
        HttpServletRequest request = data.getRequest();
        output.append(data.getServerData().getScriptName());
        if (request.getPathInfo() != null) {
            output.append(request.getPathInfo());
        }
        if (request.getQueryString() != null) {
            output.append("?");
            output.append(request.getQueryString());
        }
        return output.toString();
    }

    public RelativeDynamicURI(RunData data) {
        super(data);
    }

    public RelativeDynamicURI(RunData data, String screen) {
        super(data, screen);
    }

    public RelativeDynamicURI(RunData data, String screen, String action) {
        super(data, screen, action);
    }

    public RelativeDynamicURI(RunData data, String screen, String action, boolean redirect) {
        super(data, screen, action, redirect);
    }

    public RelativeDynamicURI(RunData data, String screen, boolean redirect) {
        super(data, screen, redirect);
    }

    public RelativeDynamicURI(RunData data, boolean redirect) {
        super(data, redirect);
    }

    public RelativeDynamicURI(ServerData sd) {
        super(sd);
    }

    public RelativeDynamicURI(ServerData sd, String screen) {
        super(sd, screen);
    }

    public RelativeDynamicURI(ServerData sd, String screen, String action) {
        super(sd, screen, action);
    }

    public RelativeDynamicURI(ServerData sd, String screen, String action, boolean redirect) {
        super(sd, screen, action, redirect);
    }

    public RelativeDynamicURI(ServerData sd, String screen, boolean redirect) {
        super(sd, screen, redirect);
    }

    public RelativeDynamicURI(ServerData sd, boolean redirect) {
        super(sd, redirect);
    }
}

