/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import java.io.File;

public class PerfTestGet {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: PerfTestGet filenamebase url username password");
            System.exit(-1);
        }
        String filenameBase = args[0];
        String mHostStr = args[1];
        String username = args[2];
        String passwd = args[3];
        long totalUncached = 0L;
        long minUncached = 0L;
        long maxUncached = 0L;
        long totalCached = 0L;
        long minCached = 0L;
        long maxCached = 0L;
        try {
            DSI dsi = new DSI(mHostStr, username, passwd);
            for (int i = 0; i < 100; ++i) {
                String filename = filenameBase + i + ".txt";
                long start = System.currentTimeMillis();
                dsi.setURL(mHostStr + "/" + filename);
                File file = dsi.getDataSet(filename);
                long end = System.currentTimeMillis();
                long durationUncached = end - start;
                System.out.println("file " + file.toString() + " uncached time: " + durationUncached + "ms");
                totalUncached += durationUncached;
                start = System.currentTimeMillis();
                file = dsi.getDataSet(filename);
                end = System.currentTimeMillis();
                long durationCached = end - start;
                System.out.println("file " + file.toString() + " cached time: " + durationCached + "ms");
                totalCached += durationCached;
                if (i == 0) {
                    minUncached = durationUncached;
                    maxUncached = durationUncached;
                    minCached = durationCached;
                    maxCached = durationCached;
                    continue;
                }
                if (durationUncached < minUncached) {
                    minUncached = durationUncached;
                }
                if (durationUncached > maxUncached) {
                    maxUncached = durationUncached;
                }
                if (durationCached < minCached) {
                    minCached = durationCached;
                }
                if (durationCached <= maxCached) continue;
                maxCached = durationCached;
            }
            dsi.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        System.out.println("");
        System.out.println("Uncached Times\n   Total uncached time: " + totalUncached + " ms\n" + "   Average uncached time: " + totalUncached / 100L + " ms\n" + "   Min uncached time: " + minUncached + " ms\n" + "   Max uncached time: " + maxUncached + " ms\n");
        System.out.println("");
        System.out.println("Cached Times\n   Total cached time: " + totalCached + " ms\n" + "   Average cached time: " + totalCached / 100L + " ms\n" + "   Min cached time: " + minCached + " ms\n" + "   Max cached time: " + maxCached + " ms\n");
        System.exit(0);
    }
}

