%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

#
# Build dependency descrepancies across platforms
#
%if %{?suse_version:1}%{!?suse_version:0}
%global glibmm2_devel  glibmm2-devel
%global openldap_devel openldap2-devel
%global nss_devel mozilla-nss-devel
%else
%global glibmm2_devel  glibmm24-devel
%global openldap_devel openldap-devel
%global nss_devel nss-devel
%endif

#
# xROOTd
#
%if %{?fedora}%{!?fedora:0} >= 24 || %{?rhel}%{!?rhel:0}
%global with_xrootd %{!?_without_xrootd:1}%{?_without_xrootd:0}
%else
%global with_xrootd 0
%endif

#
# Python
#
%if %{?fedora}%{!?fedora:0} >= 32 || %{?rhel}%{!?rhel:0} >= 8
%global with_python2 0
%else
%global with_python2 1
%endif

%if %{?fedora}%{!?fedora:0} >= 13 || %{?rhel}%{!?rhel:0} >= 7
%global with_python3 1
%else
%global with_python3 0
%endif

%if %{with_python2}
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -Esc "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -Esc "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%endif

%if %{with_python3}
%{!?python3_pkgversion: %global python3_pkgversion 3}
%endif

%if %{?rhel}%{!?rhel:0} == 6
%filter_provides_in %{python2_sitearch}/.*\.so$
%filter_setup
%endif

%if %{?fedora}%{!?fedora:0} || %{?rhel}%{!?rhel:0} >= 7 || %{?suse_version:1}%{!?suse_version:0}
%global with_pylint %{!?_without_pylint:1}%{?_without_pylint:0}
%else
%global with_pylint 0
%endif

%if %{?fedora}%{!?fedora:0} >= 29 || %{?rhel}%{!?rhel:0} >= 8
%global py3default 1
%else
%global py3default 0
%endif

%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 5 || %{?suse_version}%{!?suse_version:0} >= 1110
%global with_acix 1
%else
%global with_acix 0
%endif

%if %{?fedora}%{!?fedora:0} >= 21 || %{?rhel}%{!?rhel:0} >= 5
%global with_s3 1
%else
%global with_s3 0
%endif

%if %{?fedora}%{!?fedora:0} >= 21 || %{?rhel}%{!?rhel:0} >= 5
%global with_gfal 1
%else
%global with_gfal 0
%endif

%if %{?fedora}%{!?fedora:0} || %{?rhel}%{!?rhel:0}
%global with_xmlsec1 %{!?_without_xmlsec1:1}%{?_without_xmlsec1:0}
%else
%global with_xmlsec1 0
%endif

%if %{?fedora}%{!?fedora:0} >= 21 || %{?rhel}%{!?rhel:0} == 6 || %{?rhel}%{!?rhel:0} == 7
# Dependency missing in EPEL 8
%global with_pythonlrms 1
%else
%global with_pythonlrms 0
%endif

# LDNS
%if %{?fedora}%{!?fedora:0} >= 13 || %{?rhel}%{!?rhel:0} >= 5
%global with_ldns 1
%else
%global with_ldns 0
%endif

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 7
%global use_systemd 1
%else
%global use_systemd 0
%endif

%global with_ldap_service 1

%global pkgdir arc

# bash-completion
%global _bashcompdir %(pkg-config --variable=completionsdir bash-completion 2>/dev/null || echo %{_sysconfdir}/bash_completion.d)

#
# Macros for scripts
#

# Stop and disable service on package removal
%if %{use_systemd}
%define stop_on_removal() %{expand:%%systemd_preun %(sed 's/[^ ]*/&.service/g' <<< '%{?*}')}
%else
%if %{?stop_on_removal:0}%{!?stop_on_removal:1}
%global stop_on_removal() if [ $1 -eq 0 ]; then for s in %*; do service $s stop > /dev/null 2>&1 || : ; done; for s in %*; do /sbin/chkconfig --del $s; done; fi
%endif
%endif

# Enable a service
%if %{use_systemd}
%define enable_service() %{expand:%%systemd_post %(sed 's/[^ ]*/&.service/g' <<< '%{?*}')}
%else
%if %{?suse_version:1}%{!?suse_version:0}
%define enable_service() %{expand:%%fillup_and_insserv -f %{?*}}
%else
%define enable_service() for s in %{?*}; do /sbin/chkconfig --add $s ; done
%endif
%endif

# Conditionally restart service on package update
%if %{use_systemd}
%define condrestart_on_update() %{expand:%%systemd_postun_with_restart %(sed 's/[^ ]*/&.service/g' <<< '%{?*}')}
%else
%if %{?suse_version:1}%{!?suse_version:0}
%define condrestart_on_update() %{expand:%%restart_on_update %{?*}} %{expand:%%insserv_cleanup}
%else
%define condrestart_on_update() if [ $1 -ge 1 ]; then for s in %{?*}; do service $s condrestart > /dev/null 2>&1 || : ; done; fi
%endif
%endif

# Standard service requirements
%if %{use_systemd}
%define service_post_requires	systemd-units
%define service_preun_requires	systemd-units
%define service_postun_requires	systemd-units
%else
%if %{?suse_version:1}%{!?suse_version:0}
%define service_post_requires	%{insserv_prereq}
%define service_preun_requires	%{insserv_prereq}
%define service_postun_requires	%{insserv_prereq}
%else
%define service_post_requires	chkconfig
%define service_preun_requires	chkconfig, initscripts
%define service_postun_requires	initscripts
%endif
%endif

Name:		nordugrid-arc
Version:	6.8.1
Release:	1%{?dist}
Summary:	Advanced Resource Connector Middleware
Group:		System Environment/Daemons
License:	ASL 2.0
URL:		http://www.nordugrid.org/
Source:		http://download.nordugrid.org/packages/%{name}/releases/%{version}/src/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

#		Packages dropped without replacements
Obsoletes:	%{name}-chelonia < 2.0.0
Obsoletes:	%{name}-hopi < 2.0.0
Obsoletes:	%{name}-isis < 2.0.0
Obsoletes:	%{name}-janitor < 2.0.0
Obsoletes:	%{name}-doxygen < 4.0.0
Obsoletes:	%{name}-arcproxyalt < 6.0.0
Obsoletes:	%{name}-java < 6.0.0
Obsoletes:	%{name}-egiis < 6.0.0
%if ! %{with_python2}
Obsoletes:	python2-%{name} < %{version}-%{release}
Obsoletes:	%{name}-python < 5.3.3
%endif
%if ! %{with_ldap_service}
Obsoletes:	%{name}-infosys-ldap < %{version}-%{release}
Obsoletes:	%{name}-ldap-infosys < 6.0.0
Obsoletes:	%{name}-aris < 6.0.0
%endif

BuildRequires:	gcc-c++
BuildRequires:	cppunit-devel
BuildRequires:	pkgconfig
%if %{use_systemd}
BuildRequires:	systemd-devel
%endif
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6 || %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	libuuid-devel
%else
BuildRequires:	e2fsprogs-devel
%endif
BuildRequires:	gettext
%if %{with_python2}
BuildRequires:	python2-devel
%endif
%if %{with_python3}
BuildRequires:	python%{python3_pkgversion}-devel
%endif
%if %{with_pylint}
BuildRequires:	pylint
%endif
BuildRequires:	%{glibmm2_devel}
BuildRequires:	glib2-devel
BuildRequires:	libxml2-devel
BuildRequires:	openssl
BuildRequires:	openssl-devel
%if %{with_xmlsec1}
BuildRequires:	xmlsec1-devel >= 1.2.4
BuildRequires:	xmlsec1-openssl-devel >= 1.2.4
%endif
BuildRequires:	%{nss_devel}
BuildRequires:	%{openldap_devel}
BuildRequires:	globus-common-devel
BuildRequires:	globus-ftp-client-devel
BuildRequires:	globus-ftp-control-devel
%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	globus-gssapi-gsi-devel >= 12.2
%else
BuildRequires:	globus-gssapi-gsi-devel < 12.2
%endif
%if %{with_xrootd}
BuildRequires:	xrootd-client-devel >= 1:4.5.0
%endif
%if %{with_gfal}
BuildRequires:	gfal2-devel
%endif
%if %{with_s3}
BuildRequires:	libs3-devel
%endif
%if %{?suse_version}%{!?suse_version:0} == 1110
BuildRequires:	db43-devel
%else
%if %{?fedora}%{!?fedora:0} >= 15 || %{?rhel}%{!?rhel:0} >= 7
BuildRequires:	libdb-cxx-devel
%else
%if %{?fedora}%{!?fedora:0} == 14
BuildRequires:	libdb-devel
%else
BuildRequires:	db4-devel
%endif
%endif
%endif
%if %{?fedora}%{!?fedora:0} >= 21 || %{?rhel}%{!?rhel:0}
BuildRequires:	perl-generators
%endif
# Needed for Boinc backend testing during make check
BuildRequires:	perl(DBI)
# Needed for infoprovider testing during make check
BuildRequires:	perl(English)
BuildRequires:	perl(JSON::XS)
BuildRequires:	perl(Sys::Hostname)
BuildRequires:	perl(XML::Simple)
# Needed for LRMS testing during make check
BuildRequires:	perl(Test::Harness)
BuildRequires:	perl(Test::Simple)
# Needed to run ACIX unit tests
%if %{with_acix}
%if %{py3default}
BuildRequires:	python3-twisted
BuildRequires:	python3-pyOpenSSL
%else
%if %{?fedora}%{!?fedora:0} || %{?rhel}%{!?rhel:0} >= 8 || %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	python-twisted
%else
BuildRequires:	python-twisted-core
BuildRequires:	python-twisted-web
%endif
%if %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	python-openssl
%else
BuildRequires:	pyOpenSSL
%endif
%endif
%endif
BuildRequires:	swig
%if %{?fedora}%{!?fedora:0} >= 4 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	libtool-ltdl-devel
%else
BuildRequires:	libtool
%endif
%if %{with_pythonlrms}
BuildRequires:	perl(Inline)
BuildRequires:	perl(Inline::Python)
%endif
BuildRequires:	sqlite-devel >= 3.6
%if %{with_ldns}
BuildRequires:	ldns-devel >= 1.6.8
%endif
%if %{?fedora}%{!?fedora:0} >= 17 || %{?rhel}%{!?rhel:0} >= 7 || %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	pkgconfig(bash-completion)
%endif
%if %{?fedora}%{!?fedora:0} <= 13 && %{?rhel}%{!?rhel:0} <= 6
BuildRequires:	python-argparse
Requires:	python-argparse
%endif
%if %{?fedora}%{!?fedora:0} >= 13 || %{?rhel}%{!?rhel:0} >= 7 || %{?suse_version:1}%{!?suse_version:0}
Requires:	hostname
%else
Requires:	net-tools
%endif
Requires:	openssl

%description
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

The ARC middleware is a software solution that uses distributed
computing technologies to enable sharing and federation of computing
resources across different administrative and application domains.
ARC is used to create distributed infrastructures of various scope and
complexity, from campus to national and global deployments.

%package client
Summary:	ARC command line clients
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

%description client
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This client package contains all the CLI tools that are needed to
operate with x509 proxies, submit and manage jobs and handle data
transfers.

%package hed
Summary:	ARC Hosting Environment Daemon
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description hed
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

The ARC Hosting Environment Daemon (HED) is a Web Service container
for ARC services.

%package gridftpd
Summary:	ARC gridftp server
Group:		System Environment/Daemons
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-gridftp = %{version}-%{release}
Requires:	%{name}-arcctl-service = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description gridftpd
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC gridftp server which can be used as a
custom job submission interface in front of an ARC enabled computing
cluster or as a low-level dedicated gridftp file server.

%package datadelivery-service
Summary:	ARC data delivery service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Requires:	%{name}-arcctl-service = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description datadelivery-service
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC data delivery service.

%if %{with_ldap_service}
%package infosys-ldap
Summary:	ARC LDAP-based information services
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.10
Requires:	bdii
Requires:	%{name}-arcctl-service = %{version}-%{release}
Provides:	%{name}-ldap-infosys = %{version}-%{release}
Obsoletes:	%{name}-ldap-infosys < 6.0.0
Provides:	%{name}-aris = %{version}-%{release}
Obsoletes:	%{name}-aris < 6.0.0

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 8
Requires(post):		policycoreutils-python-utils
Requires(postun):	policycoreutils-python-utils
%else
%if %{?fedora}%{!?fedora:0} >= 11 || %{?rhel}%{!?rhel:0} >= 6
Requires(post):		policycoreutils-python
Requires(postun):	policycoreutils-python
%else
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%endif
%endif
%endif

%description infosys-ldap
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC information services relying on BDII and
LDAP technologies to publish ARC CE information according to various
LDAP schemas. Please note that the information collectors are part of
another package, the nordugrid-arc-arex.
%endif

%package monitor
Summary:	ARC LDAP monitor web application
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	php
Requires:	php-gd
Requires:	php-ldap
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Obsoletes:	%{name}-ldap-monitor < 6.0.0
Obsoletes:	%{name}-ws-monitor < 6.0.0

%description monitor
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the PHP web application that is used to set up a
web-based monitor which pulls information from the LDAP information
system and visualizes it.

%package arcctl
Summary:	ARC Control Tool
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}

%description arcctl
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC Control Tool with basic set of control
modules suitable for both server and client side.

%package arcctl-service
Summary:	ARC Control Tool - service control modules
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-arcctl = %{version}-%{release}

%description arcctl-service
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the service control modules for ARC Contol Tool
that allow working with server-side config and manage ARC services.

%package arex
Summary:	ARC Resource-coupled EXecution service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-arcctl = %{version}-%{release}
Requires:	%{name}-arcctl-service = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
%if %{py3default}
Requires:	python3-dirq
Requires:	python3-isodate
Requires:	python3-ldap
Requires:	python3-stomppy
%else
Requires:	python-dirq
Requires:	python-isodate
Requires:	python-ldap
%if %{?fedora}%{!?fedora:0} >= 26 || %{?rhel}%{!?rhel:0} >= 8
Requires:	python2-stomppy
%else
Requires:	stomppy
%endif
%endif
Provides:	%{name}-cache-service = %{version}-%{release}
Obsoletes:	%{name}-cache-service < 6.0.0
Provides:	%{name}-candypond = %{version}-%{release}
Obsoletes:	%{name}-candypond < 6.0.0

Requires(post):		%{name}-arcctl = %{version}-%{release}
Requires(preun):	%{name}-arcctl = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 13 || %{?rhel}%{!?rhel:0} >= 7 || %{?suse_version:1}%{!?suse_version:0}
Requires(post):		hostname
%else
Requires(post):		net-tools
%endif
Requires(post):		openssl
Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description arex
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

The ARC Resource-coupled EXecution service (AREX) is the Computing
Element of the ARC middleware. AREX offers a full-featured middle
layer to manage computational tasks including interfacing to local
batch systems, taking care of complex environments such as data
staging, data caching, software environment provisioning, information
collection and exposure, accounting information gathering and
publishing.

%if %{with_pythonlrms}
%package arex-python-lrms
Summary:	ARC Resource-coupled EXecution service - Python LRMS backends
Group:		System Environment/Libraries
Requires:	%{name}-arex = %{version}-%{release}
%if %{py3default}
Requires:	python%{python3_pkgversion}-%{name} = %{version}-%{release}
%else
Requires:	python2-%{name} = %{version}-%{release}
%endif
Requires:	perl(Inline)
Requires:	perl(Inline::Python)

%description arex-python-lrms
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

The Python LRMS backends are a new implementation of the AREX LRMS
backend scripts written in Python. Currently only the SLURM LRMS is
supported. It is released as a technology preview.
%endif

%package community-rtes
Summary:	Community-defined RTEs support
Group:		System Environment/Libraries
Requires:	%{name}-arex = %{version}-%{release}
Requires:	%{name}-arcctl = %{version}-%{release}
Requires:	gnupg2
%if %{py3default}
Requires:	python3-dns
%else
Requires:	python-dns
%endif

%description community-rtes
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Community RTEs is the framework that allows deploying software packages
(tarballs, containers, etc) provided by trusted communities to ARC CE
using simple arcctl commands.
It is released as a technology preview.

%package plugins-needed
Summary:	ARC base plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-needed
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC base plugins. This includes the Message Chain Components (MCCs)
and Data Manager Components (DMCs).

%package plugins-globus
Summary:	ARC Globus plugins (compat)
Group:		System Environment/Libraries
Requires:	%{name}-plugins-gridftp = %{version}-%{release}
Requires:	%{name}-plugins-gridftpjob = %{version}-%{release}
Requires:	%{name}-plugins-lcas-lcmaps = %{version}-%{release}

%description plugins-globus
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC Globus plugins. This compat metapackage brings all Globus dependent
plugins at once, including: Data Manager Components (DMCs), Client plugin
and LCAS/LCMAPS tools.

This package is meant to allow smooth transition and will be removed from
the upcoming releases.

%package plugins-globus-common
Summary:	ARC Globus plugins common libraries
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-globus-common
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC Globus plugins common libraries package includes the bundle of
necessary Globus libraries needed for all other globus-dependent ARC
components.

%package plugins-gridftp
Summary:	ARC Globus dependent DMCs
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-globus-common = %{version}-%{release}

%description plugins-gridftp
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC Globus GridFTP plugins. These allow access to data through the
gridftp protocol.

%package plugins-lcas-lcmaps
Summary:	ARC LCAS/LCMAPS plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-globus-common = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 5
Requires:	globus-gssapi-gsi >= 12.2
%else
Requires:	globus-gssapi-gsi < 12.2
%endif

%description plugins-lcas-lcmaps
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC LCAS/LCMAPS tools allow configuring ARC CE to use LCAS/LCMAPS
services for authorization and mapping.

%package plugins-gridftpjob
Summary:	ARC GRIDFTPJOB client plugin
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-globus-common = %{version}-%{release}
Requires:	%{name}-plugins-gridftp = %{version}-%{release}

%description plugins-gridftpjob
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC GRIDFTPJOB plugin allows submitting jobs via the gridftpd interface.

%if %{with_xrootd}
%package plugins-xrootd
Summary:	ARC xrootd plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-xrootd
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC xrootd plugins. These allow access to data through the xrootd
protocol.
%endif

%if %{with_gfal}
%package plugins-gfal
Summary:	ARC GFAL2 plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-gfal
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC plugins for GFAL2. This allows third-party transfer and adds
support for several extra transfer protocols (rfio, dcap, gsidcap).
Support for specific protocols is provided by separate 3rd-party GFAL2
plugin packages.
%endif

%if %{with_s3}
%package plugins-s3
Summary:	ARC S3 plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-s3
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC plugins for S3. These allow access to data through the S3
protocol.
%endif

%package plugins-internal
Summary:	ARC internal plugin
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-arex = %{version}-%{release}

%description plugins-internal
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

The ARC internal plugin. A special interface aimed for restrictive HPC
sites, to be used with a local installation of the ARC Control Tower.

%package plugins-arcrest
Summary:	ARC REST plugin
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-arcrest
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC plugin for ARC REST interface technology preview.

%package plugins-python
Summary:	ARC Python dependent plugin
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
%if %{py3default}
Requires:	python%{python3_pkgversion}-%{name} = %{version}-%{release}
%else
Requires:	python2-%{name} = %{version}-%{release}
%endif

%description plugins-python
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

ARC plugins dependent on Python.

%if %{with_acix}
%package acix-core
Summary:	ARC cache index - core
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
%if %{py3default}
Requires:	python3-twisted
Requires:	python3-pyOpenSSL
%else
%if %{?fedora}%{!?fedora:0} || %{?rhel}%{!?rhel:0} >= 8 || %{?suse_version:1}%{!?suse_version:0}
Requires:	python-twisted
%else
Requires:	python-twisted-core
Requires:	python-twisted-web
%endif
%if %{?suse_version:1}%{!?suse_version:0}
Requires:	python-openssl
%else
Requires:	pyOpenSSL
%endif
%endif

%description acix-core
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Core components of the ARC Cache Index (ACIX).

%package acix-scanner
Summary:	ARC cache index - scanner server
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-acix-core = %{version}-%{release}
Requires:	%{name}-arcctl-service = %{version}-%{release}
Obsoletes:	%{name}-acix-cache < 6.0.0

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description acix-scanner
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Cache scanner component of the ARC Cache Index (ACIX), usually
installed alongside A-REX. This component collects information on the
content of an A-REX cache.

%package acix-index
Summary:	ARC cache index - index server
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-arcctl-service = %{version}-%{release}
Requires:	%{name}-acix-core = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description acix-index
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Index server component of the ARC Cache Index (ACIX), usually
installed independently of any A-REX installation. This component
pulls cache content from ACIX cache scanner servers and can be queried
by clients for the location of cached files.
%endif

%package devel
Summary:	ARC development files
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{glibmm2_devel}
Requires:	glib2-devel
Requires:	libxml2-devel
Requires:	openssl-devel

%description devel
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Header files and libraries needed to develop applications using ARC.

%if %{with_python2}
%package -n python2-%{name}
Summary:	ARC Python 2 wrapper
Group:		Development/Libraries
%{?python_provide:%python_provide python2-%{name}}
Provides:	%{name}-python = %{version}-%{release}
Obsoletes:	%{name}-python < 5.3.3
Requires:	%{name} = %{version}-%{release}

%description -n python2-%{name}
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Python 2 bindings for ARC.
%endif

%if %{with_python3}
%package -n python%{python3_pkgversion}-%{name}
Summary:	ARC Python 3 wrapper
Group:		Development/Libraries
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
Provides:	%{name}-python%{python3_pkgversion} = %{version}-%{release}
Obsoletes:	%{name}-python%{python3_pkgversion} < 5.3.3
Requires:	%{name} = %{version}-%{release}

%description -n python%{python3_pkgversion}-%{name}
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

Python 3 bindings for ARC.
%endif

%package nordugridmap
Summary:	ARC's nordugridmap tool
Group:		Applications/Internet
Requires:	perl(Crypt::SSLeay)
Requires:	perl(Crypt::OpenSSL::X509)
Requires:	crontabs
Obsoletes:	%{name}-gridmap-utils < 6.0.0
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description nordugridmap
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

A simple tool to fetch list of users and eventually generate gridmap
files.

%package test-utils
Summary:	ARC test tools
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Obsoletes:	%{name}-misc-utils < 6.0.0

%description test-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains a few utilities useful to test various ARC
subsystems. The package is not required by users or sysadmins and it
is mainly for developers.

%package archery-manage
Summary:	ARCHERY administration tool
Group:		Applications/Internet
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
%if %{?fedora}%{!?fedora:0} <= 13 && %{?rhel}%{!?rhel:0} <= 6
Requires:	python-argparse
%endif
%if %{py3default}
Requires:	python3-dns
Requires:	python3-ldap
%else
Requires:	python-dns
Requires:	python-ldap
%endif

%description archery-manage
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the archery-manage utility for administration of
an ARCHERY DNS-embedded service endpoint registry.

%package wn
Summary:	ARC optional worker nodes components
Group:		Applications/Internet

%description wn
NorduGrid is a collaboration aiming at development, maintenance and
support of the middleware, known as the Advanced Resource
Connector (ARC).

This package contains the optional components that provide new job
management features on the worker nodes (WN).

%prep
%setup -q

%build
if pkg-config --atleast-version 2.6 sigc++-2.0 ; then
  if [ `echo __GNUC__ | gcc -E - | tail -1` -lt 6 ] ; then
    # Workaround for too new libsigc++/glibmm, too old gcc combination
    export CXXFLAGS="%{optflags} -std=c++11"
  fi
fi

%configure --disable-static \
%if ! %{with_acix}
     --disable-acix \
%endif
%if %{with_gfal}
     --enable-gfal \
%endif
%if %{with_s3}
     --enable-s3 \
%endif
%if %{py3default}
     --with-python=python3 \
%if %{with_python2}
     --with-altpython=python2 \
%endif
%else
     --with-python=python2 \
%if %{with_python3}
     --with-altpython=python3 \
%endif
%endif
%if ! %{with_xrootd}
     --disable-xrootd \
%endif
%if %{with_pythonlrms}
     --with-inline-python \
%endif
%if ! %{with_ldns}
     --disable-ldns \
%endif
     --enable-internal \
%if %{use_systemd}
     --enable-systemd \
     --with-systemd-units-location=%{_unitdir} \
%endif
%if ! %{with_ldap_service}
     --disable-ldap-service \
%endif
     --disable-doc \
     --docdir=%{_pkgdocdir}

make %{?_smp_mflags}

%check
make %{?_smp_mflags} check

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

# Install Logrotate.
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -p -m 644 debian/%{name}-arex.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-arex
install -p -m 644 debian/%{name}-gridftpd.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-gridftpd
%if %{with_ldap_service}
install -p -m 644 debian/%{name}-infosys-ldap.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-infosys-ldap
%endif
install -p -m 644 debian/%{name}-datadelivery-service.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-datadelivery-service

find $RPM_BUILD_ROOT -type f -name \*.la -exec rm -fv '{}' ';'

# The py-compile script in the source tarball is old (RHEL 6)
# It does the wrong thing for python 3 - remove and let rpmbuild do it right
find $RPM_BUILD_ROOT -type f -name \*.pyc -exec rm -fv '{}' ';'
find $RPM_BUILD_ROOT -type f -name \*.pyo -exec rm -fv '{}' ';'

# libarcglobusutils is not part of the ARC api.
find $RPM_BUILD_ROOT -name libarcglobusutils.so -exec rm -fv '{}' ';'

# Create log directory
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/arc

# Create spool directories for Jura
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/spool/arc
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/spool/arc/ssm
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/spool/arc/urs

%find_lang %{name}

# Remove examples and let RPM package them under /usr/share/doc using the doc macro
rm -rf $RPM_BUILD_ROOT%{_datadir}/%{pkgdir}/examples
make -C src/libs/data-staging/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/libs/compute/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/libs/data/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/acc/PythonBroker	DESTDIR=$PWD/docdir/python pkgdatadir= install-exampleDATA
make -C python/examples			DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/tests/echo			DESTDIR=$PWD/docdir/hed	   pkgdatadir= install-exampleDATA
make -C src/hed				DESTDIR=$PWD/docdir/hed	   pkgdatadir= install-profileDATA

# client.conf needs special handling
make -C src/clients DESTDIR=$RPM_BUILD_ROOT install-exampleDATA

# Link to client.conf from doc
ln -s %{_datadir}/%{pkgdir}/examples/client.conf $PWD/docdir/client.conf

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post plugins-globus-common -p /sbin/ldconfig

%postun plugins-globus-common -p /sbin/ldconfig

%post hed
%enable_service arched

%preun hed
%stop_on_removal arched

%postun hed
%condrestart_on_update arched

%post arex
%enable_service arc-arex

# out-of-package testing host certificate
if [ $1 -eq 1 ]; then
  arcctl test-ca init
  arcctl test-ca hostcert
fi

%preun arex
%stop_on_removal arc-arex

if [ $1 -eq 0 ]; then
  arcctl test-ca cleanup
fi

%postun arex
%condrestart_on_update arc-arex

%post gridftpd
%enable_service arc-gridftpd

%preun gridftpd
%stop_on_removal arc-gridftpd

%postun gridftpd
%condrestart_on_update arc-gridftpd

%post datadelivery-service
%enable_service arc-datadelivery-service

%preun datadelivery-service
%stop_on_removal arc-datadelivery-service

%postun datadelivery-service
%condrestart_on_update arc-datadelivery-service

%if %{with_ldap_service}
%post infosys-ldap
%enable_service arc-infosys-ldap

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
semanage port -a -t ldap_port_t -p tcp 2135 2>/dev/null || :
semanage fcontext -a -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :
semanage fcontext -a -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
semanage fcontext -a -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :
%endif

%preun infosys-ldap
%stop_on_removal arc-infosys-ldap

%postun infosys-ldap
%condrestart_on_update arc-infosys-ldap

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ]; then
  semanage port -d -t ldap_port_t -p tcp 2135 2>/dev/null || :
  semanage fcontext -d -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :
  semanage fcontext -d -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
  semanage fcontext -d -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :
fi
%endif

%triggerpostun infosys-ldap -- %{name}-ldap-infosys
# Uninstalling the old %{name}-ldap-infosys will remove some selinux config
# for %{name}-infosys-ldap - put them back in this triggerpostun script
semanage port -a -t ldap_port_t -p tcp 2135 2>/dev/null || :
semanage fcontext -a -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :

%triggerpostun infosys-ldap -- %{name}-aris
# Uninstalling the old %{name}-aris will remove some selinux config
# for %{name}-infosys-ldap - put them back in this triggerpostun script
semanage fcontext -a -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
semanage fcontext -a -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :

%triggerun infosys-ldap -- bdii
%if %{?suse_version:1}%{!?suse_version:0}
FIRST_ARG=1
%restart_on_update arc-infosys-ldap
%else
service arc-infosys-ldap condrestart > /dev/null 2>&1 || :
%endif
%endif

%if %{with_acix}
%post acix-scanner
%enable_service arc-acix-scanner

%preun acix-scanner
%stop_on_removal arc-acix-scanner

%postun acix-scanner
%condrestart_on_update arc-acix-scanner

%post acix-index
%enable_service arc-acix-index

%preun acix-index
%stop_on_removal arc-acix-index

%postun acix-index
%condrestart_on_update arc-acix-index
%endif

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc src/doc/arc.conf.reference src/doc/arc.conf.DELETED src/doc/arc.conf.DELETED-6.8.0
%doc README AUTHORS LICENSE NOTICE
%{_libdir}/libarccompute.so.*
%{_libdir}/libarccommunication.so.*
%{_libdir}/libarccommon.so.*
%{_libdir}/libarccredential.so.*
%{_libdir}/libarccredentialstore.so.*
%{_libdir}/libarccrypto.so.*
%{_libdir}/libarcdata.so.*
%{_libdir}/libarcdatastaging.so.*
%{_libdir}/libarcloader.so.*
%{_libdir}/libarcmessage.so.*
%{_libdir}/libarcsecurity.so.*
%{_libdir}/libarcotokens.so.*
%{_libdir}/libarcinfosys.so.*
%{_libdir}/libarcwsaddressing.so.*
%{_libdir}/libarcwssecurity.so.*
%if %{with_xmlsec1}
%{_libdir}/libarcxmlsec.so.*
%endif
%dir %{_libdir}/%{pkgdir}
# We need to have libmodcrypto.so close to libarccrypto
%{_libdir}/%{pkgdir}/libmodcrypto.so
%{_libdir}/%{pkgdir}/libmodcrypto.apd
# We need to have libmodcredential.so close to libarccredential
%{_libdir}/%{pkgdir}/libmodcredential.so
%{_libdir}/%{pkgdir}/libmodcredential.apd
%{_libdir}/%{pkgdir}/arc-file-access
%{_libdir}/%{pkgdir}/arc-hostname-resolver
%{_libdir}/%{pkgdir}/DataStagingDelivery
%{_libdir}/%{pkgdir}/arc-dmc
%dir %{_libexecdir}/%{pkgdir}
%{_libexecdir}/%{pkgdir}/arcconfig-parser
%if %{py3default}
%dir %{python3_sitearch}/%{pkgdir}
%{python3_sitearch}/%{pkgdir}/utils
%{python3_sitearch}/%{pkgdir}/__init__.py
%{python3_sitearch}/%{pkgdir}/paths.py
%{python3_sitearch}/%{pkgdir}/paths_dist.py
%dir %{python3_sitearch}/%{pkgdir}/__pycache__
%{python3_sitearch}/%{pkgdir}/__pycache__/__init__.*
%{python3_sitearch}/%{pkgdir}/__pycache__/paths.*
%{python3_sitearch}/%{pkgdir}/__pycache__/paths_dist.*
%else
%dir %{python2_sitearch}/%{pkgdir}
%{python2_sitearch}/%{pkgdir}/utils
%{python2_sitearch}/%{pkgdir}/__init__.py*
%{python2_sitearch}/%{pkgdir}/paths.py*
%{python2_sitearch}/%{pkgdir}/paths_dist.py*
%endif
%dir %{_datadir}/%{pkgdir}
%{_datadir}/%{pkgdir}/arc.parser.defaults
%dir %{_datadir}/%{pkgdir}/test-jobs
%{_datadir}/%{pkgdir}/test-jobs/test-job-*
%{_datadir}/%{pkgdir}/schema

%files client
%defattr(-,root,root,-)
%doc docdir/client.conf
%{_bindir}/arccat
%{_bindir}/arcclean
%{_bindir}/arccp
%{_bindir}/arcget
%{_bindir}/arcinfo
%{_bindir}/arckill
%{_bindir}/arcls
%{_bindir}/arcmkdir
%{_bindir}/arcrename
%{_bindir}/arcproxy
%{_bindir}/arcrenew
%{_bindir}/arcresub
%{_bindir}/arcresume
%{_bindir}/arcrm
%{_bindir}/arcstat
%{_bindir}/arcsub
%{_bindir}/arcsync
%{_bindir}/arctest
%dir %{_datadir}/%{pkgdir}/examples
%{_datadir}/%{pkgdir}/examples/client.conf
%dir %{_sysconfdir}/%{pkgdir}
%config(noreplace) %{_sysconfdir}/%{pkgdir}/client.conf
%doc %{_mandir}/man1/arccat.1*
%doc %{_mandir}/man1/arcclean.1*
%doc %{_mandir}/man1/arccp.1*
%doc %{_mandir}/man1/arcget.1*
%doc %{_mandir}/man1/arcinfo.1*
%doc %{_mandir}/man1/arckill.1*
%doc %{_mandir}/man1/arcls.1*
%doc %{_mandir}/man1/arcmkdir.1*
%doc %{_mandir}/man1/arcrename.1*
%doc %{_mandir}/man1/arcproxy.1*
%doc %{_mandir}/man1/arcrenew.1*
%doc %{_mandir}/man1/arcresub.1*
%doc %{_mandir}/man1/arcresume.1*
%doc %{_mandir}/man1/arcrm.1*
%doc %{_mandir}/man1/arcstat.1*
%doc %{_mandir}/man1/arcsub.1*
%doc %{_mandir}/man1/arcsync.1*
%doc %{_mandir}/man1/arctest.1*
%dir %{_bashcompdir}
%{_bashcompdir}/arc-client-tools

%files hed
%defattr(-,root,root,-)
%doc docdir/hed/*
%if %{use_systemd}
%{_unitdir}/arched.service
%else
%{_initrddir}/arched
%endif
%{_sbindir}/arched
%{_libdir}/%{pkgdir}/libecho.so
%{_libdir}/%{pkgdir}/libecho.apd
%{_datadir}/%{pkgdir}/arched-start
%{_datadir}/%{pkgdir}/profiles
%doc %{_mandir}/man8/arched.8*
%doc %{_mandir}/man5/arc.conf.5*

%files gridftpd
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/arc-gridftpd.service
%else
%{_initrddir}/arc-gridftpd
%endif
%{_sbindir}/gridftpd
%{_libdir}/%{pkgdir}/jobsplugin.*
%{_libdir}/%{pkgdir}/filedirplugin.*
%{_datadir}/%{pkgdir}/arc-gridftpd-start
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-gridftpd
%doc %{_mandir}/man8/gridftpd.8*

%files datadelivery-service
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/arc-datadelivery-service.service
%else
%{_initrddir}/arc-datadelivery-service
%endif
%{_libdir}/%{pkgdir}/libdatadeliveryservice.so
%{_libdir}/%{pkgdir}/libdatadeliveryservice.apd
%{_datadir}/%{pkgdir}/arc-datadelivery-service-start
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-datadelivery-service

%if %{with_ldap_service}
%files infosys-ldap
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/arc-infosys-ldap.service
%{_unitdir}/arc-infosys-ldap-slapd.service
%else
%{_initrddir}/arc-infosys-ldap
%endif
%{_datadir}/%{pkgdir}/create-bdii-config
%{_datadir}/%{pkgdir}/create-slapd-config
%{_datadir}/%{pkgdir}/glue-generator.pl
%{_datadir}/%{pkgdir}/glite-info-provider-ldap
%{_datadir}/%{pkgdir}/ldap-schema
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-infosys-ldap
%endif

%files monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/monitor
%doc %{_mandir}/man7/monitor.7*

%files arcctl
%{_sbindir}/arcctl
%if %{py3default}
%dir %{python3_sitearch}/%{pkgdir}/control
%{python3_sitearch}/%{pkgdir}/control/__init__.py
%{python3_sitearch}/%{pkgdir}/control/CertificateGenerator.py
%{python3_sitearch}/%{pkgdir}/control/ControlCommon.py
%{python3_sitearch}/%{pkgdir}/control/OSPackage.py
%{python3_sitearch}/%{pkgdir}/control/TestCA.py
%{python3_sitearch}/%{pkgdir}/control/ThirdPartyDeployment.py
%dir %{python3_sitearch}/%{pkgdir}/control/__pycache__
%{python3_sitearch}/%{pkgdir}/control/__pycache__/__init__.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/CertificateGenerator.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/ControlCommon.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/OSPackage.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/TestCA.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/ThirdPartyDeployment.*
%else
%dir %{python2_sitearch}/%{pkgdir}/control
%{python2_sitearch}/%{pkgdir}/control/__init__.py*
%{python2_sitearch}/%{pkgdir}/control/CertificateGenerator.py*
%{python2_sitearch}/%{pkgdir}/control/ControlCommon.py*
%{python2_sitearch}/%{pkgdir}/control/OSPackage.py*
%{python2_sitearch}/%{pkgdir}/control/TestCA.py*
%{python2_sitearch}/%{pkgdir}/control/ThirdPartyDeployment.py*
%endif
%doc %{_mandir}/man1/arcctl.1*

%files arcctl-service
%if %{py3default}
%{python3_sitearch}/%{pkgdir}/control/Config.py
%{python3_sitearch}/%{pkgdir}/control/ServiceCommon.py
%{python3_sitearch}/%{pkgdir}/control/Services.py
%{python3_sitearch}/%{pkgdir}/control/OSService.py
%{python3_sitearch}/%{pkgdir}/control/__pycache__/Config.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/ServiceCommon.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/Services.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/OSService.*
%else
%{python2_sitearch}/%{pkgdir}/control/Config.py*
%{python2_sitearch}/%{pkgdir}/control/ServiceCommon.py*
%{python2_sitearch}/%{pkgdir}/control/Services.py*
%{python2_sitearch}/%{pkgdir}/control/OSService.py*
%endif

%files arex
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/arc-arex.service
%else
%{_initrddir}/arc-arex
%endif
%{_libexecdir}/%{pkgdir}/cache-clean
%{_libexecdir}/%{pkgdir}/cache-list
%{_libexecdir}/%{pkgdir}/jura-ng
%{_libexecdir}/%{pkgdir}/gm-delegations-converter
%{_libexecdir}/%{pkgdir}/gm-jobs
%{_libexecdir}/%{pkgdir}/gm-kick
%{_libexecdir}/%{pkgdir}/smtp-send
%{_libexecdir}/%{pkgdir}/smtp-send.sh
%{_libexecdir}/%{pkgdir}/inputcheck
%{_libexecdir}/%{pkgdir}/arc-config-check
%{_libexecdir}/%{pkgdir}/arc-blahp-logger
%{_datadir}/%{pkgdir}/cancel-*-job
%{_datadir}/%{pkgdir}/scan-*-job
%{_datadir}/%{pkgdir}/submit-*-job
%{_libdir}/%{pkgdir}/libarex.so
%{_libdir}/%{pkgdir}/libarex.apd
%{_libdir}/%{pkgdir}/libcandypond.so
%{_libdir}/%{pkgdir}/libcandypond.apd
%{_datadir}/%{pkgdir}/CEinfo.pl
%{_datadir}/%{pkgdir}/ARC0mod.pm
%{_datadir}/%{pkgdir}/FORKmod.pm
%{_datadir}/%{pkgdir}/Fork.pm
%{_datadir}/%{pkgdir}/SGEmod.pm
%{_datadir}/%{pkgdir}/SGE.pm
%{_datadir}/%{pkgdir}/LL.pm
%{_datadir}/%{pkgdir}/LSF.pm
%{_datadir}/%{pkgdir}/PBS.pm
%{_datadir}/%{pkgdir}/PBSPRO.pm
%{_datadir}/%{pkgdir}/Condor.pm
%{_datadir}/%{pkgdir}/SLURMmod.pm
%{_datadir}/%{pkgdir}/SLURM.pm
%{_datadir}/%{pkgdir}/Boinc.pm
%{_datadir}/%{pkgdir}/XmlPrinter.pm
%{_datadir}/%{pkgdir}/InfosysHelper.pm
%{_datadir}/%{pkgdir}/LdifPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2xmlPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2ldifPrinter.pm
%{_datadir}/%{pkgdir}/NGldifPrinter.pm
%{_datadir}/%{pkgdir}/ARC0ClusterInfo.pm
%{_datadir}/%{pkgdir}/ARC1ClusterInfo.pm
%{_datadir}/%{pkgdir}/ConfigCentral.pm
%{_datadir}/%{pkgdir}/GMJobsInfo.pm
%{_datadir}/%{pkgdir}/HostInfo.pm
%{_datadir}/%{pkgdir}/RTEInfo.pm
%{_datadir}/%{pkgdir}/InfoChecker.pm
%{_datadir}/%{pkgdir}/IniParser.pm
%{_datadir}/%{pkgdir}/LRMSInfo.pm
%{_datadir}/%{pkgdir}/Sysinfo.pm
%{_datadir}/%{pkgdir}/LogUtils.pm
%{_datadir}/%{pkgdir}/condor_env.pm
%{_datadir}/%{pkgdir}/cancel_common.sh
%{_datadir}/%{pkgdir}/configure-*-env.sh
%{_datadir}/%{pkgdir}/submit_common.sh
%{_datadir}/%{pkgdir}/scan_common.sh
%{_datadir}/%{pkgdir}/lrms_common.sh
%{_datadir}/%{pkgdir}/perferator
%{_datadir}/%{pkgdir}/PerfData.pl
%{_datadir}/%{pkgdir}/arc-arex-start
%{_datadir}/%{pkgdir}/sql-schema/arex_accounting_db_schema_v1.sql
%doc %{_mandir}/man1/arc-config-check.1*
%doc %{_mandir}/man1/cache-clean.1*
%doc %{_mandir}/man1/cache-list.1*
%doc %{_mandir}/man8/gm-delegations-converter.8*
%doc %{_mandir}/man8/gm-jobs.8*
%doc %{_mandir}/man8/arc-blahp-logger.8*
%doc %{_mandir}/man8/a-rex-backtrace-collect.8*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-arex
%dir %{_localstatedir}/log/arc
%dir %{_localstatedir}/spool/arc
%dir %{_localstatedir}/spool/arc/ssm
%dir %{_localstatedir}/spool/arc/urs
%{_libexecdir}/%{pkgdir}/ssmsend
%if %{py3default}
%{python3_sitearch}/%{pkgdir}/ssm
%{python3_sitearch}/%{pkgdir}/control/AccountingDB.py
%{python3_sitearch}/%{pkgdir}/control/AccountingPublishing.py
%{python3_sitearch}/%{pkgdir}/control/Accounting.py
%{python3_sitearch}/%{pkgdir}/control/Cache.py
%{python3_sitearch}/%{pkgdir}/control/DataStaging.py
%{python3_sitearch}/%{pkgdir}/control/Jobs.py
%{python3_sitearch}/%{pkgdir}/control/RunTimeEnvironment.py
%{python3_sitearch}/%{pkgdir}/control/__pycache__/AccountingDB.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/AccountingPublishing.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/Accounting.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/Cache.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/DataStaging.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/Jobs.*
%{python3_sitearch}/%{pkgdir}/control/__pycache__/RunTimeEnvironment.*
%else
%{python2_sitearch}/%{pkgdir}/ssm
%{python2_sitearch}/%{pkgdir}/control/AccountingDB.py*
%{python2_sitearch}/%{pkgdir}/control/AccountingPublishing.py*
%{python2_sitearch}/%{pkgdir}/control/Accounting.py*
%{python2_sitearch}/%{pkgdir}/control/Cache.py*
%{python2_sitearch}/%{pkgdir}/control/DataStaging.py*
%{python2_sitearch}/%{pkgdir}/control/Jobs.py*
%{python2_sitearch}/%{pkgdir}/control/RunTimeEnvironment.py*
%endif
%{_libexecdir}/%{pkgdir}/arccandypond
%dir %{_datadir}/%{pkgdir}/rte
%dir %{_datadir}/%{pkgdir}/rte/ENV
%{_datadir}/%{pkgdir}/rte/ENV/LRMS-SCRATCH
%{_datadir}/%{pkgdir}/rte/ENV/PROXY
%{_datadir}/%{pkgdir}/rte/ENV/RTE
%{_datadir}/%{pkgdir}/rte/ENV/CANDYPOND
%{_datadir}/%{pkgdir}/rte/ENV/SINGULARITY
%dir %{_datadir}/%{pkgdir}/rte/ENV/CONDOR
%{_datadir}/%{pkgdir}/rte/ENV/CONDOR/DOCKER
%{_sbindir}/a-rex-backtrace-collect
%config(noreplace) %{_sysconfdir}/arc.conf

%if %{with_pythonlrms}
%files arex-python-lrms
%defattr(-,root,root,-)
%{_libexecdir}/%{pkgdir}/arc-sshfs-mount
%if %{py3default}
%{python3_sitearch}/%{pkgdir}/lrms
%else
%{python2_sitearch}/%{pkgdir}/lrms
%endif
%{_datadir}/%{pkgdir}/SLURMPYmod.pm
%{_datadir}/%{pkgdir}/job_script.stubs
%endif

%files community-rtes
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/community_rtes.sh
%if %{py3default}
%{python3_sitearch}/%{pkgdir}/control/CommunityRTE.py
%{python3_sitearch}/%{pkgdir}/control/__pycache__/CommunityRTE.*
%else
%{python2_sitearch}/%{pkgdir}/control/CommunityRTE.py*
%endif

%files plugins-needed
%defattr(-,root,root,-)
%dir %{_libdir}/%{pkgdir}/test
%{_libdir}/%{pkgdir}/test/libaccTEST.so
%{_libdir}/%{pkgdir}/libaccBroker.so
%{_libdir}/%{pkgdir}/libaccEMIES.so
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.so
%if %{with_ldns}
%{_libdir}/%{pkgdir}/libaccARCHERY.so
%endif
%{_libdir}/%{pkgdir}/libaccLDAP.so
%{_libdir}/%{pkgdir}/libarcshc.so
%{_libdir}/%{pkgdir}/libarcshclegacy.so
%{_libdir}/%{pkgdir}/libarcshcotokens.so
%{_libdir}/%{pkgdir}/libdmcfile.so
%{_libdir}/%{pkgdir}/libdmchttp.so
%{_libdir}/%{pkgdir}/libdmcldap.so
%{_libdir}/%{pkgdir}/libdmcsrm.so
%{_libdir}/%{pkgdir}/libdmcrucio.so
%{_libdir}/%{pkgdir}/libdmcacix.so
%{_libdir}/%{pkgdir}/libidentitymap.so
%{_libdir}/%{pkgdir}/libarguspdpclient.so
%{_libdir}/%{pkgdir}/libmcchttp.so
%{_libdir}/%{pkgdir}/libmccmsgvalidator.so
%{_libdir}/%{pkgdir}/libmccsoap.so
%{_libdir}/%{pkgdir}/libmcctcp.so
%{_libdir}/%{pkgdir}/libmcctls.so
%{_libdir}/%{pkgdir}/test/libaccTEST.apd
%{_libdir}/%{pkgdir}/libaccBroker.apd
%{_libdir}/%{pkgdir}/libaccEMIES.apd
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.apd
%if %{with_ldns}
%{_libdir}/%{pkgdir}/libaccARCHERY.apd
%endif
%{_libdir}/%{pkgdir}/libaccLDAP.apd
%{_libdir}/%{pkgdir}/libarcshc.apd
%{_libdir}/%{pkgdir}/libarcshclegacy.apd
%{_libdir}/%{pkgdir}/libarcshcotokens.apd
%{_libdir}/%{pkgdir}/libdmcfile.apd
%{_libdir}/%{pkgdir}/libdmchttp.apd
%{_libdir}/%{pkgdir}/libdmcldap.apd
%{_libdir}/%{pkgdir}/libdmcsrm.apd
%{_libdir}/%{pkgdir}/libdmcrucio.apd
%{_libdir}/%{pkgdir}/libdmcacix.apd
%{_libdir}/%{pkgdir}/libidentitymap.apd
%{_libdir}/%{pkgdir}/libarguspdpclient.apd
%{_libdir}/%{pkgdir}/libmcchttp.apd
%{_libdir}/%{pkgdir}/libmccmsgvalidator.apd
%{_libdir}/%{pkgdir}/libmccsoap.apd
%{_libdir}/%{pkgdir}/libmcctcp.apd
%{_libdir}/%{pkgdir}/libmcctls.apd

%files plugins-globus
%defattr(-,root,root,-)

%files plugins-globus-common
%defattr(-,root,root,-)
%{_libdir}/libarcglobusutils.so.*

%files plugins-gridftp
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/arc-dmcgridftp
%{_libdir}/%{pkgdir}/libdmcgridftpdeleg.so
%{_libdir}/%{pkgdir}/libdmcgridftpdeleg.apd

%files plugins-lcas-lcmaps
%defattr(-,root,root,-)
%{_libexecdir}/%{pkgdir}/arc-lcas
%{_libexecdir}/%{pkgdir}/arc-lcmaps

%files plugins-gridftpjob
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccGRIDFTPJOB.so
%{_libdir}/%{pkgdir}/libaccGRIDFTPJOB.apd

%if %{with_xrootd}
%files plugins-xrootd
%defattr(-,root,root,-)
%dir %{_libdir}/%{pkgdir}/external
%{_libdir}/%{pkgdir}/external/libdmcxrootd.so
%{_libdir}/%{pkgdir}/external/libdmcxrootd.apd
%{_libdir}/%{pkgdir}/libdmcxrootddeleg.so
%{_libdir}/%{pkgdir}/libdmcxrootddeleg.apd
%endif

%if %{with_gfal}
%files plugins-gfal
%defattr(-,root,root,-)
%dir %{_libdir}/%{pkgdir}/external
%{_libdir}/%{pkgdir}/external/libdmcgfal.so
%{_libdir}/%{pkgdir}/external/libdmcgfal.apd
%{_libdir}/%{pkgdir}/libdmcgfaldeleg.so
%{_libdir}/%{pkgdir}/libdmcgfaldeleg.apd
%endif

%if %{with_s3}
%files plugins-s3
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdmcs3.so
%{_libdir}/%{pkgdir}/libdmcs3.apd
%endif

%files plugins-internal
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccINTERNAL.so
%{_libdir}/%{pkgdir}/libaccINTERNAL.apd

%files plugins-arcrest
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARCREST.so
%{_libdir}/%{pkgdir}/libaccARCREST.apd

%files plugins-python
%defattr(-,root,root,-)
%doc docdir/python/*
%{_libdir}/%{pkgdir}/libaccPythonBroker.so
%{_libdir}/%{pkgdir}/libaccPythonBroker.apd
%{_libdir}/%{pkgdir}/libpythonservice.so
%{_libdir}/%{pkgdir}/libpythonservice.apd

%if %{with_acix}
%files acix-core
%defattr(-,root,root,-)
%if %{py3default}
%dir %{python3_sitelib}/acix
%{python3_sitelib}/acix/__init__.py
%dir %{python3_sitelib}/acix/__pycache__
%{python3_sitelib}/acix/__pycache__/__init__.*
%{python3_sitelib}/acix/core
%else
%dir %{python2_sitelib}/acix
%{python2_sitelib}/acix/__init__.py*
%{python2_sitelib}/acix/core
%endif

%files acix-scanner
%defattr(-,root,root,-)
%if %{py3default}
%{python3_sitelib}/acix/scanner
%else
%{python2_sitelib}/acix/scanner
%endif
%if %{use_systemd}
%{_unitdir}/arc-acix-scanner.service
%else
%{_initrddir}/arc-acix-scanner
%endif
%{_datadir}/%{pkgdir}/arc-acix-scanner-start

%files acix-index
%defattr(-,root,root,-)
%if %{py3default}
%{python3_sitelib}/acix/indexserver
%else
%{python2_sitelib}/acix/indexserver
%endif
%if %{use_systemd}
%{_unitdir}/arc-acix-index.service
%else
%{_initrddir}/arc-acix-index
%endif
%{_datadir}/%{pkgdir}/arc-acix-index-start
%endif

%files devel
%defattr(-,root,root,-)
%doc docdir/devel/* src/hed/shc/arcpdp/*.xsd
%{_includedir}/%{pkgdir}
%{_libdir}/lib*.so
%{_bindir}/wsdl2hed
%doc %{_mandir}/man1/wsdl2hed.1*
%{_bindir}/arcplugin
%doc %{_mandir}/man1/arcplugin.1*

%if %{with_python2}
%files -n python2-%{name}
%defattr(-,root,root,-)
%{python2_sitearch}/_arc.*so
%if %{py3default}
%dir %{python2_sitearch}/%{pkgdir}
%{python2_sitearch}/%{pkgdir}/__init__.py*
%endif
%{python2_sitearch}/%{pkgdir}/[^_p]*.py*
%endif

%if %{with_python3}
%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root,-)
%{python3_sitearch}/_arc.*so
%if %{?fedora}%{!?fedora:0} >= 15 || %{?rhel}%{!?rhel:0} >= 7
# Python >= 3.2 uses __pycache__
%if ! %{py3default}
%dir %{python3_sitearch}/%{pkgdir}
%{python3_sitearch}/%{pkgdir}/__init__.py
%dir %{python3_sitearch}/%{pkgdir}/__pycache__
%{python3_sitearch}/%{pkgdir}/__pycache__/__init__.*
%endif
%{python3_sitearch}/%{pkgdir}/[^_p]*.py
%{python3_sitearch}/%{pkgdir}/__pycache__/[^_p]*.*
%else
# Python 3.1 doesn't use __pycache__
%dir %{python3_sitearch}/%{pkgdir}
%{python3_sitearch}/%{pkgdir}/__init__.py*
%{python3_sitearch}/%{pkgdir}/[^_p]*.py*
%endif
%endif

%files nordugridmap
%defattr(-,root,root,-)
%{_sbindir}/nordugridmap
%config(noreplace) %{_sysconfdir}/cron.d/nordugridmap
%doc %{_mandir}/man8/nordugridmap.8*

%files test-utils
%defattr(-,root,root,-)
%{_bindir}/arcemiestest
%{_bindir}/arcperftest
%doc %{_mandir}/man1/arcemiestest.1*
%doc %{_mandir}/man1/arcperftest.1*

%files archery-manage
%defattr(-,root,root,-)
%{_sbindir}/archery-manage

%files wn
%defattr(-,root,root,-)
%attr(4755,root,root) %{_bindir}/arc-job-cgroup

