---
layout: "guides"
page_title: "Installing Nomad for QuickStart"
sidebar_current: "guides-install-quickstart"
description: |-
  Learn how to install Nomad locally or in a sandbox.
---
#Quickstart

This page lists multiple methods to installing Nomad locally or in a sandbox
environment.  

These installations are designed to get you started with Nomad easily and should
be used only for experimentation purposes.  If you are looking to install Nomad
in production, please refer to our [Production
Installation](/guides/install/production/index.html) guide here.

##Local
Install Nomad on your local machine.

* [Installing the Pre-compiled Binary][installing-binary]
* [Installing Nomad with Vagrant][vagrant-environment]

##Cloud
Install Nomad on the public cloud.

* AWS
  * [CloudFormation](https://aws.amazon.com/quickstart/architecture/nomad/)
  * [Terraform](https://github.com/hashicorp/nomad/blob/master/terraform/aws/README.md)
* Azure
  * [Terraform](https://github.com/hashicorp/nomad/tree/master/terraform/azure)

##Katacoda
Experiment with Nomad in your browser via KataCoda's interactive learning platform.

* [Introduction to Nomad](https://www.katacoda.com/hashicorp/scenarios/nomad-introduction)
* [Nomad Playground](https://katacoda.com/hashicorp/scenarios/playground)

[installing-binary]: /guides/install/index.html#precompiled-binaries
[vagrant-environment]: /intro/getting-started/install.html#vagrant-setup-optional-