import { Arbitrary } from './definition/Arbitrary';
export interface MixedCaseConstraints {
    /** Transform a character to its upper and/or lower case version */
    toggleCase?: (rawChar: string) => string;
}
/** @hidden */
export declare function countToggledBits(n: bigint): number;
/** @hidden */
export declare function computeNextFlags(flags: bigint, nextSize: number): bigint;
/**
 * Randomly switch the case of characters generated by `stringArb` (upper/lower)
 *
 * WARNING:
 * Require bigint support.
 * Under-the-hood the arbitrary relies on bigint to compute the flags that should be toggled or not.
 *
 * @param stringArb Arbitrary able to build string values
 * @param constraints Constraints to be applied when computing upper/lower case version
 */
export declare function mixedCase(stringArb: Arbitrary<string>, constraints?: MixedCaseConstraints): Arbitrary<string>;
