### `Rx.Observable.prototype.lastIndexOf(searchElement, [fromIndex])`
[&#x24C8;](https://github.com/Reactive-Extensions/RxJS/blob/master/src/core/linq/observable/lastindexof.js "View in source")

Returns the last index at which a given element can be found in the observable sequence, or -1 if it is not present.

#### Arguments
1. `searchElement` *(`Any`)*: The value to locate in the source sequence.
2. `[fromIndex]` *(`Number`)*: The index to start the search.  If not specified, defaults to 0.

#### Returns
*(`Observable`)*: And observable sequence containing the last index at which a given element can be found in the observable sequence, or -1 if it is not present.

#### Example
```js
/* Without an index */
var source = Rx.Observable.of(1,2,3,1,2,3)
  .lastIndexOf(3);

var subscription = source.subscribe(
  function (x) {
    console.log('Next: %s', x);
  },
  function (err) {
    console.log('Error: %s', err);
  },
  function () {
      console.log('Completed');
  });

// => Next: 5
// => Completed

/* With an index */
var source = Rx.Observable.of(1,2,3,1,2,3)
  .lastIndexOf(2, 1);

var subscription = source.subscribe(
  function (x) {
    console.log('Next: %s', x);
  },
  function (err) {
    console.log('Error: %s', err);
  },
  function () {
    console.log('Completed');
  });

// => Next: 5
// => Completed
```
### Location

File:
- [`/src/core/linq/observable/lastindexof.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/src/core/linq/observable/lastindexof.js)

Dist:
- [`rx.all.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.all.js)
- [`rx.all.compat.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.all.js)
- [`rx.aggregates.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.aggregates.js)

Prerequisites:
- [`rx.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.js) | [`rx.compat.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.compat.js) | [`rx.lite.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.lite.js) | [`rx.lite.compat.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.lite.compat.js)

NPM Packages:
- [`rx`](https://www.npmjs.org/package/rx)

NuGet Packages:
- [`RxJS-All`](http://www.nuget.org/packages/RxJS-All/)
- [`RxJS-Aggregates`](http://www.nuget.org/packages/RxJS-Aggregates/)

Unit Tests:
- [`/tests/observable/lastindexof.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/tests/observable/lastindexof.js)
