import commonjs from "@rollup/plugin-commonjs";
import resolve from "@rollup/plugin-node-resolve";
import typescript from "rollup-plugin-typescript";
import pkg from "../package.json";

module.exports = [
  {
    input: "dist/lib/route-recognizer.js",
    output: [
      {
        name: "RouteRecognizer",
        file: pkg.main,
        format: "umd",
      },
      {
        file: pkg.module,
        format: "es",
      },
    ],
    plugins: [commonjs(), resolve({
            customResolveOptions: {
              moduleDirectory: ['/usr/share/nodejs','/usr/lib/nodejs','node_modules']
            }
        }), typescript()],
  },
];
