// Generated by LiveScript 1.6.0
var ref$, id, ref1$, values, keys, pairsToObj, objToPairs, listsToObj, objToLists, empty, each, map, filter, compact, reject, partition, find, eq, deepEq, ok;
ref$ = require('../..'), id = ref$.id, ref1$ = ref$.Obj, values = ref1$.values, keys = ref1$.keys, pairsToObj = ref1$.pairsToObj, objToPairs = ref1$.objToPairs, listsToObj = ref1$.listsToObj, objToLists = ref1$.objToLists, empty = ref1$.empty, each = ref1$.each, map = ref1$.map, filter = ref1$.filter, compact = ref1$.compact, reject = ref1$.reject, partition = ref1$.partition, find = ref1$.find;
ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
suite('values', function(){
  test('empty object as input', function(){
    return deepEq([], values({}));
  });
  return test('object as input', function(){
    return deepEq([1, 2, 3], values({
      sadf: 1,
      asdf: 2,
      fdas: 3
    }));
  });
});
suite('keys', function(){
  test('empty object as input', function(){
    return deepEq([], keys({}));
  });
  return test('object as input', function(){
    return deepEq(['sadf', 'asdf', 'fdas'], keys({
      sadf: 1,
      asdf: 2,
      fdas: 3
    }));
  });
});
suite('pairs-to-obj', function(){
  test('empty list as input', function(){
    return deepEq({}, pairsToObj([]));
  });
  return test('pairs as input', function(){
    return deepEq({
      a: 'b',
      c: 'd',
      e: 1
    }, pairsToObj([['a', 'b'], ['c', 'd'], ['e', 1]]));
  });
});
suite('obj-to-pairs', function(){
  test('empty object as input', function(){
    return deepEq([], objToPairs({}));
  });
  return test('object as input', function(){
    return deepEq([['a', 'b'], ['c', 'd'], ['e', 1]], objToPairs({
      a: 'b',
      c: 'd',
      e: 1
    }));
  });
});
suite('lists-to-obj', function(){
  test('empty lists as input', function(){
    return deepEq({}, listsToObj([], []));
  });
  test('two lists of the same length', function(){
    return deepEq({
      a: 1,
      b: 2,
      c: 3
    }, listsToObj(['a', 'b', 'c'], [1, 2, 3]));
  });
  test('first list is shorter', function(){
    return deepEq({
      a: 1,
      b: 2
    }, listsToObj(['a', 'b'], [1, 2, 3]));
  });
  test('first list is longer', function(){
    return deepEq({
      a: 1,
      b: 2,
      c: void 8
    }, listsToObj(['a', 'b', 'c'], [1, 2]));
  });
  return test('curried', function(){
    var f;
    f = listsToObj(['a', 'b', 'c']);
    return deepEq({
      a: 1,
      b: 2,
      c: 3
    }, f([1, 2, 3]));
  });
});
suite('obj-to-lists', function(){
  test('empty object as input', function(){
    return deepEq([[], []], objToLists({}));
  });
  return test('two lists of the same length', function(){
    return deepEq([['a', 'b', 'c'], [1, 2, 3]], objToLists({
      a: 1,
      b: 2,
      c: 3
    }));
  });
});
suite('empty', function(){
  test('empty object as input', function(){
    return ok(empty({}));
  });
  return test('non-empty object as input', function(){
    return ok(!empty({
      x: 1
    }));
  });
});
suite('each', function(){
  test('empty object as input', function(){
    return deepEq({}, each(id, {}));
  });
  test('iterate over object values', function(){
    var count;
    count = 4;
    each(function(it){
      return count += it;
    }, {
      a: 1,
      b: 2,
      c: 3
    });
    return eq(10, count);
  });
  return test('curried', function(){
    var count, f;
    count = 4;
    f = each(function(it){
      return count += it;
    });
    f({
      a: 1,
      b: 2,
      c: 3
    });
    return eq(10, count);
  });
});
suite('map', function(){
  test('empty object as input', function(){
    return deepEq({}, map(id, {}));
  });
  test('mapping over object', function(){
    return deepEq({
      a: 2,
      b: 4
    }, map((function(it){
      return it * 2;
    }), {
      a: 1,
      b: 2
    }));
  });
  return test('curried', function(){
    var f;
    f = map((function(it){
      return it * 2;
    }));
    return deepEq({
      a: 2,
      b: 4
    }, f({
      a: 1,
      b: 2
    }));
  });
});
suite('compact', function(){
  test('empty object as input', function(){
    return deepEq({}, compact({}));
  });
  return test('compacting object', function(){
    return deepEq({
      b: 1,
      e: 'ha'
    }, compact({
      a: 0,
      b: 1,
      c: false,
      d: '',
      e: 'ha'
    }));
  });
});
suite('filter', function(){
  test('empty object as input', function(){
    return deepEq({}, filter(id, {}));
  });
  test('filtering object', function(){
    return deepEq({
      b: 2
    }, filter((function(it){
      return it === 2;
    }), {
      a: 1,
      b: 2
    }));
  });
  return test('curried', function(){
    var f;
    f = filter((function(it){
      return it === 2;
    }));
    return deepEq({
      b: 2
    }, f({
      a: 1,
      b: 2
    }));
  });
});
suite('reject', function(){
  test('empty object as input', function(){
    return deepEq({}, reject(id, {}));
  });
  test('reject object', function(){
    return deepEq({
      a: 1
    }, reject((function(it){
      return it === 2;
    }), {
      a: 1,
      b: 2
    }));
  });
  return test('curried', function(){
    var f;
    f = reject((function(it){
      return it === 2;
    }));
    return deepEq({
      a: 1
    }, f({
      a: 1,
      b: 2
    }));
  });
});
suite('partition', function(){
  test('empty object as input', function(){
    return deepEq([{}, {}], partition(id, {}));
  });
  test('partition object', function(){
    return deepEq([
      {
        b: 2
      }, {
        a: 1,
        c: 3
      }
    ], partition((function(it){
      return it === 2;
    }), {
      a: 1,
      b: 2,
      c: 3
    }));
  });
  return test('curried', function(){
    var f;
    f = partition((function(it){
      return it === 2;
    }));
    return deepEq([
      {
        b: 2
      }, {
        a: 1,
        c: 3
      }
    ], f({
      a: 1,
      b: 2,
      c: 3
    }));
  });
});
suite('find', function(){
  test('empty object as input', function(){
    return eq(void 8, find(id, {}));
  });
  test('find from object', function(){
    return eq(2, find((function(it){
      return it === 2;
    }), {
      a: 1,
      b: 2
    }));
  });
  return test('curried', function(){
    var f;
    f = find((function(it){
      return it === 2;
    }));
    return eq(2, f({
      a: 1,
      b: 2
    }));
  });
});
