(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.assume = f()}})(function(){var define,module,exports;return (function(){function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s}return e})()({1:[function(require,module,exports){
(function (process){
'use strict';

var stringify = require('object-inspect')
  , pruddy = require('pruddy-error')
  , displayName = require('fn.name')
  , isBuffer = require('is-buffer')
  , propget = require('propget')
  , deep = require('deep-eql');

var undefined
  , called = 0
  , toString = Object.prototype.toString
  , hasOwn = Object.prototype.hasOwnProperty
  , nodejs = !!(typeof process != 'undefined' && process.versions && process.versions.node);

/**
 * Get class information for a given type.
 *
 * @param {Mixed} of Type to check.
 * @returns {String} The name of the type.
 * @api private
 */
function type(of) {
  if (isBuffer(of)) return 'buffer';
  if (of === undefined) return 'undefined';
  if (of === null) return 'null';
  if (of !== of) return 'nan';

  return toString.call(of).slice(8, -1).toLowerCase();
}

/**
 * Determine the size of a collection.
 *
 * @param {Mixed} collection The object we want to know the size of.
 * @returns {Number} The size of the collection.
 * @api private
 */
function size(collection) {
  var x, i = 0;

  if ('object' === type(collection)) {
    if ('number' === type(collection.length)) return collection.length;

    for (x in collection) {
      if (hasOwn.call(collection, x)) i++;
    }

    return i;
  }

  try { return +collection.length || 0; }
  catch (e) { return 0; }
}

/**
 * Iterate over each item in an array.
 *
 * @param {Array} arr Array to iterate over.
 * @param {Function} fn Callback for each item.
 * @api private
 */
function each(what, fn) {
  if ('array' === type(what)) {
    for (var i = 0, length = what.length; i < length; i++) {
      if (false === fn(what[i], i, what)) break;
    }
  } else {
    for (var key in what) {
      if (false === fn(what[key], key, what)) break;
    }
  }
}

/**
 * Return a formatter function which compiles the expectation message. The
 * message can contain various of patterns which will be replaced with
 * a stringified/parsed version of the supplied argument for that given
 * placeholder pattern. The following patterns are supported:
 *
 * - %% : Escape the % so you can write %d in your messages as %%d
 * - %d : Cast argument in to a number.
 * - %s : Cast argument in to a string.
 * - %f : Transform function in to the name of the function.
 * - %j : Transform object to a string.
 *
 * @param {String} expectation The expectation message.
 * @returns {Function}
 * @api private
 */
function format() {
  var args = Array.prototype.slice.call(arguments, 0)
    , expectation = args.shift()
    , length = args.length
    , i = 0;

  return function compile(not) {
    if (not) expectation = expectation.replace(/@/g, 'not');
    else expectation = expectation.replace(/@\s/g, '');

    return expectation.replace(/%[sdjf%]/g, function replace(char) {
      if (i >= length) return char;

      switch (char) {
        case '%%':
        return '%';

        case '%s':
        return String(args[i++]);

        case '%d':
        return Number(args[i++]);

        case '%f':
        return displayName(args[i++]);

        case '%j':
        try { return stringify(args[i++]); }
        catch (e) { return '<error was thrown: '+ e.message +'>'; }

        default: return char;
      }
    });
  };
}

/**
 * Assert values.
 *
 * Flags:
 *
 * - **stacktrace**: Include stacktrace in the assertion.
 * - **diff**: Attempt to show the difference in object/values so we know why
 *   the assertion failed.
 * - **sliceStack**: The amount of stacks we should slice off errors messages.
 *
 * @constructor
 * @param {Mixed} value Value we need to assert.
 * @param {Object} flags Assertion flags.
 * @api public
 */
function Assume(value, flags) {
  if (!(this instanceof Assume)) return new Assume(value, flags);
  flags = flags || {};

  this.stacktrace = 'stacktrace' in flags ? flags.stacktrace : Assume.config.includeStack;
  this.sliceStack = 'slice' in flags ? flags.slice : Assume.config.sliceStack;
  this.diff = 'diff' in flags ? flags.diff : Assume.config.showDiff;

  //
  // These flags are by the alias function so we can generate .not and .deep
  // properties which are basically new Assume instances with these flags set.
  //
  for (var alias in Assume.flags) {
    this[alias] = alias in flags ? flags[alias] : false;
  }

  this.value = value;

  Assume.assign(this)('to, be, been, is, was, and, has, have, had, with, that, at, of, same, does, did, itself, which');
  Assume.alias(value, this);
}

/**
 * Attempt to mimic the configuration API of chai.js so it's dead simple to
 * migrate from chai.js to assume.
 *
 * @type {Object}
 * @public
 */
Assume.config = {
  includeStack: true,     // mapped to `stacktrace` as default value.
  showDiff: true,         // mapped to `diff` as default value.
  sliceStack: 2           // Number of stacks that we should slice of the err stack..
};

/**
 * List of flags and properties that need to be created for chaining purposes.
 * Plugins could add extra properties that needed to be chained as well.
 *
 * @type {Object}
 * @public
 */
Assume.flags = {
  _not: 'doesnt, not, dont',
  _deep: 'deep, deeply, strict, strictly'
};

/**
 * Certain assertions can be disabled based on their environment that they are
 * executing in. This object allows you in spect which of these conditional
 * assertions are supported.
 *
 * @type {Object}
 * @public
 */
Assume.supports = (function detect() {
  var supports = {
    generators: true,
    native: true
  };

  try { eval('(function*(){})()'); }
  catch (e) { supports.generators = false; }

  try { eval('%GetV8Version()'); }
  catch (e) { supports.native = false; }

  return supports;
}(/* Douglas Crockford wants the dog balls inside youtu.be/taaEzHI9xyY#t=2020s */));

/**
 * Registry of manually read files that are registered using Assume#register.
 *
 * @type {Object}
 * @private
 */
Assume.registry = {};

/**
 * By default we will try to read file's from disk or using Ajax calls to get
 * correct line numbers for assertion errors but there are environments where
 * both of these options are not available or preferred. You can manually
 * register those files.
 *
 * @param {String} file File path for the given source code
 * @param {String} source The source of the given file.
 * @returns {Assume}
 * @public
 */
Assume.register = function register(file, source) {
  if ('object' === type(file)) {
    each(file, function iterate(value, key) {
      Assume.register(key, value);
    });
  } else {
    Assume.registry[file] = source;
  }

  return Assume;
};

/**
 * Assign values to a given thing.
 *
 * @param {Mixed} where Where do the new properties need to be assigned on.
 * @returns {Function}
 * @api public
 */
Assume.assign = function assign(where) {
  return function assigns(aliases, value) {
    if ('string' === typeof aliases) {
      if (~aliases.indexOf(',')) aliases = aliases.split(/[\s|\,]+/);
      else aliases = [aliases];
    }

    for (var i = 0, length = aliases.length; i < length; i++) {
      where[aliases[i]] = value || where;
    }

    return where;
  };
};

/**
 * Add aliases to the given constructed asserts. This allows us to chain
 * assertion calls together.
 *
 * @param {Mixed} value Value that we need to assert.
 * @param {Assume} assert The constructed assert instance.
 * @returns {Assume} The given assert instance.
 * @api private
 */
Assume.alias = function alias(value, assert) {
  var assign = Assume.assign(assert)
    , flags, flag, prop;

  for (prop in Assume.flags) {
    if (!hasOwn.call(Assume.flags, prop)) continue;

    if (!assert[prop]) {
      flags = {};

      for (flag in Assume.flags) {
        if (!hasOwn.call(Assume.flags, flag)) continue;
        flags[flag] = assert[flag];
      }

      //
      // Add some default values to the flags.
      //
      flags.stacktrace = assert.stacktrace;
      flags.diff = assert.diff;
      flags[prop] = true;

      assign(Assume.flags[prop], new Assume(value, flags));
    } else assign(Assume.flags);
  }

  return assert;
};

/**
 * API sugar of adding aliased prototypes to the Assume. This makes the code
 * a bit more workable and human readable.
 *
 * @param {String|Array} aliases List of methods.
 * @param {Function} fn Actual assertion function.
 * @returns {Assume}
 * @api public
 */
Assume.add = Assume.assign(Assume.prototype);

/**
 * Asserts if the given value is the correct type. We need to use
 * Object.toString here because there are some implementation bugs the `typeof`
 * operator:
 *
 * - Chrome <= 9: /Regular Expressions/ are evaluated to `function`
 *
 * As well as all common flaws like Arrays being seen as Objects etc. This
 * eliminates all these edge cases.
 *
 * @param {String} of Type of class it should equal
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('a, an', function typecheck(of, msg) {
  of = of.toString().toLowerCase();

  var value = type(this.value)
    , expect = format('`%j` (%s) to @ be a %s', this.value, value, of);

  return this.test(value === of, msg, expect);
});

/**
 * Asserts if the given value is the correct type from a list of types.
 * The same caveats regarding `typeof` apply as described in `a`, `an`.
 *
 * @param {String[]} ofs Acceptable types to check against
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('eitherOfType, oneOfType', function multitypecheck(ofs, msg) {
  var value = type(this.value)
    , expect = format('`%j` (%s) to @ be a %s', this.value, value, ofs.join(' or a '));

  var test = false;
  for (var i = 0; i < ofs.length; i++) {
    if (ofs[i].toString().toLowerCase() === value) {
      test = true;
      break;
    }
  }

  return this.test(test, msg, expect);
});

/**
 * Asserts that the value is instanceof the given constructor.
 *
 * @param {Function} constructor Constructur the value should inherit from.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('instanceOf, instanceof, inherits, inherit', function of(constructor, msg) {
  var expect = format('%f to @ be an instanceof %f', this.value, constructor);

  return this.test(this.value instanceof constructor, msg, expect);
});

/**
 * Assert that the value includes the given value.
 *
 * @param {Mixed} val Value to match.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('include, includes, contain, contains', function contain(val, msg) {
  var includes = false
    , of = type(this.value)
    , expect = format('`%j` to @ include %j', this.value, val);

  switch (of) {
    case 'array':
      for (var i = 0, length = this.value.length; i < length; i++) {
        if (this._deep ? deep(this.value[i], val) : this.value[i] === val) {
          includes = true;
          break;
        }
      }
    break;

    case 'object':
      if (val in this.value) {
        includes = true;
      }
    break;

    case 'string':
      if (~this.value.indexOf(val)) {
        includes = true;
      }
    break;
  }

  return this.test(includes === true, msg, expect);
});

/**
 * Assert that the value is truthy.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('ok, okay, truthy, truly', function ok(msg) {
  var expect = format('`%j` to @ be truthy', this.value);

  return this.test(Boolean(this.value), msg, expect);
});

/**
 * Assert that the value is falsey.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('falsely, falsey, falsy', function nope(msg) {
  var expect = format('`%j` to @ be falsely', this.value);

  return this.test(Boolean(this.value) === false, msg, expect);
});

/**
 * Assert that the value is `true`.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('true', function ok(msg) {
  var expect = format('`%j` to @ equal (===) true', this.value);

  return this.test(this.value === true, msg, expect);
});

/**
 * Assert that the value is `true`.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('false', function nope(msg) {
  var expect = format('`%j` to @ equal (===) false', this.value);

  return this.test(this.value === false, msg, expect);
});

/**
 * Assert that the value exists.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('exists, exist', function exists(msg) {
  var expect = format('`%j` to @ exist', this.value);

  return this.test(this.value != null, msg, expect);
});

/**
 * Asserts that the value's length is the given value.
 *
 * @param {Number} value Size of the value.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('length, lengthOf, size', function length(value, msg) {
  var actualValue = size(this.value);
  var expect = format('`%j` to @ have a length of %d, found %d', this.value, value, actualValue);

  return this.test(actualValue === +value, msg, expect);
});

/**
 * Asserts that the value's length is 0 or doesn't contain any enumerable keys.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('empty', function empty(msg) {
  var expect = format('`%j` to @ be empty', this.value);

  return this.test(size(this.value) === 0, msg, expect);
});

/**
 * Assert that the value is greater than the specified value.
 *
 * @param {Number} value The greater than value.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('above, gt, greater, greaterThan', function above(value, msg) {
  var amount = type(this.value) !== 'number' ? size(this.value) : this.value
    , expect = format('%d to @ be greater than %d', amount, value);

  return this.test(amount > value, msg, expect);
});

/**
 * Assert that the value is equal or greater than the specified value.
 *
 * @param {Number} value The specified value.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('least, gte, atleast', function least(value, msg) {
  var amount = type(this.value) !== 'number' ? size(this.value) : this.value
    , expect = format('%d to @ be greater or equal to %d', amount, value);

  return this.test(amount >= value, msg, expect);
});

/**
 * Assert that the value starts with the given value.
 *
 * @param {String|Array} value String it should start with.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('start, starts, startsWith, startWith', function start(value, msg) {
  var expect = format('`%j` to @ start with %j', this.value, value);

  return this.test(0 === this.value.indexOf(value), msg, expect);
});

/**
 * Assert that the value ends with the given value.
 *
 * @param {String} value String it should start with.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('end, ends, endsWith, endWith', function end(value, msg) {
  var index = this.value.indexOf(value, this.value.length - value.length)
    , expect = format('`%j` to @ end with %j', this.value, value);

  return this.test(index >= 0, msg, expect);
});

/**
 * Assert a floating point number is near the give value within the delta
 * margin.
 *
 * @param {Number} value The specified value.
 * @param {Number} delta Radius.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('closeTo, close, approximately, near', function close(value, delta, msg) {
  var expect = format('`%j` to @ be close to %d ± %d', this.value, value, delta);

  return this.test(Math.abs(this.value - value) <= delta, msg, expect);
});

/**
 * Assert that the value is below the specified value.
 *
 * @param {Number} value The specified value.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('below, lt, less, lessThan', function below(value, msg) {
  var amount = type(this.value) !== 'number' ? size(this.value) : this.value
    , expect = format('%d to @ be less than %d', amount, value);

  return this.test(amount < value, msg, expect);
});

/**
 * Assert that the value is below or equal to the specified value.
 *
 * @param {Number} value The specified value.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('most, lte, atmost', function most(value, msg) {
  var amount = type(this.value) !== 'number' ? size(this.value) : this.value
    , expect = format('%d to @ be less or equal to %d', amount, value);

  return this.test(amount <= value, msg, expect);
});

/**
 * Assert that that value is within the given range.
 *
 * @param {Number} start Lower bound.
 * @param {Number} finish Upper bound.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('within, between', function within(start, finish, msg) {
  var amount = type(this.value) !== 'number' ? size(this.value) : this.value
    , expect = format('%d to @ be greater or equal to %d and @ be less or equal to %d', amount, start, finish);

  return this.test(amount >= start && amount <= finish, msg, expect);
});

/**
 * Assert that the value has an own property with the given prop.
 *
 * @param {String} prop Property name.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('hasOwn, own, ownProperty, haveOwnProperty, property, owns, hasown', function has(prop, value, msg) {
  var expect = format('`%j` @ to have own property %s', this.value, prop)
    , tested = this.test(hasOwn.call(this.value, prop), msg, expect);

  return arguments.length > 1
    ? this.clone(this.value[prop]).equals(value)
    : tested;
});

/**
 * Asserts that the value matches a regular expression.
 *
 * @param {RegExp} regex Regular expression to match against.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('match, matches', function test(regex, msg) {
  if ('string' === typeof regex) regex = new RegExp(regex);

  var expect = format('`%j` to @ match %j', this.value, regex);

  return this.test(!!regex.test(this.value), msg, expect);
});

/**
 * Assert that the value equals a given thing.
 *
 * @param {Mixed} thing Thing it should equal.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('equal, equals, eq, eqs, exactly', function equal(thing, msg) {
  var expect = format('`%j` to @ equal (===) `%j`', this.value, thing);

  if (!this._deep) return this.test(this.value === thing, msg, expect);

  this.sliceStack++;
  return this.eql(thing, msg);
});

/**
 * Assert that the value **deeply** equals a given thing.
 *
 * @param {Mixed} thing Thing it should equal.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('eql, eqls', function eqls(thing, msg) {
  var expect = format('`%j` to deeply equal `%j`', this.value, thing);

  return this.test(deep(this.value, thing), msg, expect);
});

/**
 * Assert that the value is either one of the given values.
 *
 * @param {Array} arrgs All the values it can match.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('either', function either(args, msg) {
  var expect = '`%j` to equal either `%j` '
    , i = args.length
    , result = false
    , values = [];

  while (i-- || result) {
    if (!this._deep) result = this.value === args[i];
    else result = deep(this.value, args[i]);
    if (result) break;

    values.push(args[i]);
  }

  expect = format.apply(null, [expect + (new Array(values)).join('or `%j` ')].concat(values));
  return this.test(result, msg, expect);
});

/**
 * Assert if the given function throws.
 *
 * @param {Mixed} thing Thing it should equal.
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('throw, throws, fails, fail', function throws(thing, msg) {
  try { this.value(); }
  catch (e) {
    var message = 'object' === typeof e ? e.message : e;

    switch (type(thing)) {
      case 'string': return this.clone(message).includes(thing, msg);
      case 'regexp': return this.clone(message).matches(thing, msg);
      case 'function': return this.clone(e).instanceOf(thing, msg);
      case 'undefined': return this.test(true, msg, format('%f to @ throw', this.value));
      default: return this.clone(e).equals(thing);
    }
  }

  return this.test(false, msg, format('%f to @ throw', this.value));
});

/**
 * Assert if the given value is finite.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('isFinite, finite, finiteness', function finite(msg) {
  var expect = format('`%j`s @ a is a finite number', this.value)
    , result;

  if (this._deep) {
    result = Number.isFinite
    ? Number.isFinite(this.value)
    : 'number' === type(this.value) && isFinite(this.value);
  } else {
    result = isFinite(this.value);
  }

  return this.test(result, msg, expect);
});

/**
 * Assert if the given function is an ES6 generator.
 *
 * @param {String} msg Reason of failure.
 * @returns {Assume}
 * @api public
 */
Assume.add('generator', function generators(msg) {
  var expect = format('%f to @ be a generator', this.value)
    , result;

  //
  // Non standard function from Mozilla allows us to check if a function is
  // a generator.
  //
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/isGenerator
  //
  if ('function' === typeof this.value.isGenerator) {
    result = this.value.isGenerator();
  } else if ('generatorfunction' === type(this.value)) {
    result = true;
  } else {
    result = 'function' === type(this.value) && this.value.toString().indexOf('function*') === 0;
  }

  return this.test(result, msg, expect);
});

/**
 * Assert if the given thenable/async function results in a rejected/error state
 *
 * @param {String} msg Reason of failure.
 * @api public
 */
Assume.add('rejected, rejects, throwAsync, throwsAsync, failAsync, failsAsync', function rejects(msg) {
  var expectation = format('Thenable did @ end in a rejected state');
  var value = typeof this.value == 'function' ? this.value() : this.value;
  var self = this;

  function test(success, resolveValue, resolve, reject) {
    try {
      self.test(success, msg, expectation);
      resolve(resolveValue);
    } catch (ex) {
      reject(ex);
    }
  }

  return {
    then: function then(resolve, reject) {
      value.then(function (s) {
        test(false, s, resolve, reject);
      }, function (r) {
        test(true, r, resolve, reject);
      });
    }
  };
});

/**
 * Assert if the given thenable/async function completed and a result filled synchronously
 *
 * @param {String} msg Reason of failure
 * @api public
 */
Assume.add('resolveSync, resolvesSync, resolvedSync, completeSync, completesSync, completedSync', function completedSync(msg) {
  var expectation = format('Thenable did @ complete synchronously');
  var value = typeof this.value == 'function' ? this.value() : this.value;
  var self = this;

  return {
    then: function then(resolve, reject) {
      var completed = false;
      var resolveValue;

      value.then(function (s) {
        resolveValue = s;
        completed = true;
      }, function (r) {
        resolveValue = r;
        completed = true;
      });

      try {
        self.test(completed, msg, expectation);
        resolve(resolveValue);
      } catch (ex) {
        reject(ex);
      }
    }
  };
});

//
// The following assertions require's v8's allow-natives-syntax flag to be
// enabled as this allows us to hook in to the more internal parts of the
// engine. The native syntax is wrapped in a try catch with a new Function
// construction so the rest of the code will execute when JavaScript engines do
// not understand the instructions.
//
(function v8() {
  var states = 'void,yes,no,always,never,void,maybe'.split(',')
    , detect;

  if (!Assume.supports.native) detect = function optimized() { return 0; };
  else detect = new Function('fn', 'args', 'selfie', [
    'fn.apply(selfie, args);',
    '%OptimizeFunctionOnNextCall(fn);',
    'fn.apply(selfie, args);',
    'return %GetOptimizationStatus(fn);'
  ].join('\n'));

  /**
   * Assert that a given function has reached a certain optimization level.
   *
   * @param {String} level Optimization level
   * @param {Array} args Arguments for the function
   * @param {Mixed} selfie This context for the function
   * @param {String} msg Reason of failure
   * @returns {Assume}
   * @api public
   */
  Assume.add('optimisation, optimization', function optimization(level, args, selfie, msg) {
    var expect = format('%f to be optimized as %s', this.value, level)
      , status = states[detect(this.value, args, selfie)];

    return this.test(status === level, msg, expect);
  });

  /**
   * Assert that the function is optimized.
   *
   * @param {String} msg Reason of failure
   * @returns {Assume}
   * @api public
   */
  Assume.add('optimized, optimised', function optimized(msg) {
    var expect = format('%f to be optimized', this.value)
      , status = states[detect(this.value, [])];

    return this.test(status === 'yes', msg, expect);
  });
}());

/**
 * Create a clone of the current assertion instance which has the same
 * configuration but a different value.
 *
 * @param {Mixed} value The new value
 * @returns {Assume}
 * @api public
 */
Assume.add('clone', function clone(value) {
  var configuration = {
    stacktrace: this.stacktrace,
    slice: this.sliceStack + 1,
    diff: this.diff
  };

  for (var alias in Assume.flags) {
    if (!hasOwn.call(Assume.flags, alias)) continue;
    configuration[alias] = this[alias];
  }

  return new Assume(arguments.length ? value : this.value, configuration);
});

/**
 * Validate the assertion.
 *
 * @param {Boolean} passed Didn't the test pass or fail.
 * @param {String} msg Custom message provided by users.
 * @param {Function} expectation Compiled expectation template
 * @param {Number} slice The amount of stack traces we need to remove.
 * @returns {Assume}
 * @api public
 */
Assume.add('test', function test(passed, msg, expectation, slice) {
  called++; // Needed for tracking the amount of executed assertions.

  if (this._not) passed = !passed;
  if (passed) return this;

  msg = msg || 'Unknown assertation failure occured';
  slice = slice || this.sliceStack;

  if (expectation) msg += ', assumed ' + expectation(this._not);

  var failure = new Error(msg)
    , err = { message: failure.message, stack: '' };

  if (this.stacktrace) {
    err.stack = failure.stack || err.stack;
  }

  //
  // Pre-scrub, it's possible that the error message is a multi line error
  // message and that really messes up the slicing of the call stack, to prevent
  // this from happening, we're just going to replace the error message that is
  // on the stack with a single line as we use the `err.message` instead of the
  // message that is in the stack anyways.
  //
  err.stack = err.stack.replace(err.message, 'assume-replaced-the-err-message');

  //
  // Clean up the stack by slicing off the parts that are pointless to most
  // people. (Like where it enters this assertion library).
  //
  err.stack = err.stack.split('\n').slice(slice).join('\n') || err.stack;
  err.stack = pruddy(err, {
    read: function read(failing) {
      if (!size(Assume.registry)) return;

      return Assume.registry[failing.filename];
    }
  });

  if ('function' !== typeof Object.create) {
    if ('object' === typeof console && 'function' === typeof console.error) {
      console.error(err.stack);
    }

    throw failure;
  }

  failure = Object.create(Error.prototype);
  failure.message = err.message;
  failure.stack = err.stack;

  throw failure;
});

/**
 * Plan for the amount of assertions that needed to run. This is great way to
 * figure out if you have edge cases in your code which prevented an assertion or
 * callback from running.
 *
 * ```js
 * it('run a lot of assertions', function (next) {
 *   next = assume.plan(10, next);
 * });
 * ```
 *
 * @param {Number} tests The amount of assertions you expect to run.
 * @param {Function} fn Optional completion callback which receives the error.
 * @returns {Function} Completion callback.
 * @api public
 */
Assume.plan = function plan(tests, fn) {
  fn = fn || function next(err) {
    if (err) throw err;
  };

  var atm = called;

  return function validate(err) {
    var ran = called - atm
      , msg;

    if (err) return fn(err);
    if (tests === ran) return fn();

    msg = [
      'We ran',
      ran - tests,
      ran > tests ? 'more' : 'less',
      'assertations than the expected',
      tests
    ];

    fn(new Error(msg.join(' ')));
  };
};

/**
 * Wait until the returned callback is called x times before advancing. This
 * makes it a bit easier to write async tests that require multiple callbacks.
 *
 * ```js
 * it('does async things', function (next) {
 *   next = assume.wait(2, 4, next);
 *
 *   asynctask(function (err, data) {
 *     assume(err).is.a('undefined');
 *     assume(data).equals('testing');
 *
 *     next();
 *   });
 *
 *   asynctaskfail(function (err, data) {
 *     assume(err).is.a('undefined');
 *     assume(data).equals('testing');
 *
 *     next();
 *   });
 * });
 * ```
 *
 * @param {Number} calls The amount of calls the returned callback should called.
 * @param {Number} tests The amount of tests that should be completed before cb.
 * @param {Function} fn Completion callback.
 * @returns {Function} New function that does the counting.
 * @api public
 */
Assume.wait = function wait(calls, tests, fn) {
  //
  // Make the `tests` argument optional by allowing callback to be used there.
  //
  if ('function' === typeof tests) {
    fn = tests;
    tests = 0;
  }

  //
  // If `tests` are specified, pass it directly in to the Assume.plan function
  // so we can use that as given callback.
  //
  if (tests) fn = Assume.plan(tests, fn);

  var ignore = false;

  return function counter(err) {
    if (ignore) return;
    if (err || !--calls) return ignore = true, fn(err);
  };
};

/**
 * Load/execute a new plugin.
 *
 * @param {Function} plugin Plugin to be executed.
 * @returns {Function} Assume, for chaining purposes.
 * @api public
 */
Assume.use = function use(plugin) {
  plugin(this, {
    name: displayName,    // Extract the name of a function.
    string: stringify,    // Transform thing to a string.
    get: propget,         // Get a value from an object.
    format: format,       // Format an expectation message.
    nodejs: nodejs,       // Are we running on Node.js.
    deep: deep,           // Deep assertion.
    type: type,           // Get class information.
    size: size,           // Get the size of an object.
    each: each            // Iterate over arrays.
  });

  return Assume;
};

//
// Create type checks for all build-in JavaScript classes.
//
each(('new String§new Number§new Array§new Date§new Error§new RegExp§new Boolean§'
  + 'new Float32Array§new Float64Array§new Int16Array§new Int32Array§new Int8Array§'
  + 'new Uint16Array§new Uint32Array§new Uint8Array§new Uint8ClampedArray§'
  + 'new ParallelArray§new Map§new Set§new WeakMap§new WeakSet§new TypedArray(1)§'
  + 'new DataView(new ArrayBuffer(1))§new ArrayBuffer(1)§new Promise(function(){})§'
  + 'new Blob§arguments§null§undefined§new Buffer(1)§NaN§navigator§location§'
  + 'new Function§new Proxy({}, function(){})§Symbol("assume")§Math§async function () {}§'
  + 'WebAssembly'
).split('§'), function iterate(code) {
  var name, arg;

  //
  // Not all of these constructors are supported in the browser, we're going to
  // compile dedicated functions that returns a new instance of the given
  // constructor. If it's not supported the code will throw and we will simply
  // return.
  //
  try { arg = (new Function('return '+ code))(); }
  catch (e) { return; }

  name = type(arg);

  Assume.add(name, function typecheck(msg) {
    var expect = format('`%j` to @ be an %s', this.value, name)
      , of = type(this.value);

    return this.test(of === name, msg, expect, 3);
  });
});

//
// Introduce an alternate API:
//
// ```js
// var i = require('assume');
//
// i.assume.that('foo').equals('bar');
// i.sincerely.hope.that('foo').equals('bar');
// i.expect.that('foo').equals('bar');
// ```
//
Assume.hope = { that: Assume };
Assume.assign(Assume)('sincerely, expect');
Assume.assign(Assume)('assume, expect', Assume.hope);

//
// Expose the module.
//
module.exports = Assume;

}).call(this,require('_process'))
},{"_process":3,"deep-eql":4,"fn.name":6,"is-buffer":7,"object-inspect":8,"propget":9,"pruddy-error":14}],2:[function(require,module,exports){

},{}],3:[function(require,module,exports){
// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };

},{}],4:[function(require,module,exports){
'use strict';
/* globals Symbol: false, Uint8Array: false, WeakMap: false */
/*!
 * deep-eql
 * Copyright(c) 2013 Jake Luer <jake@alogicalparadox.com>
 * MIT Licensed
 */

var type = require('type-detect');
function FakeMap() {
  this._key = 'chai/deep-eql__' + Math.random() + Date.now();
}

FakeMap.prototype = {
  get: function getMap(key) {
    return key[this._key];
  },
  set: function setMap(key, value) {
    if (Object.isExtensible(key)) {
      Object.defineProperty(key, this._key, {
        value: value,
        configurable: true,
      });
    }
  },
};

var MemoizeMap = typeof WeakMap === 'function' ? WeakMap : FakeMap;
/*!
 * Check to see if the MemoizeMap has recorded a result of the two operands
 *
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @param {MemoizeMap} memoizeMap
 * @returns {Boolean|null} result
*/
function memoizeCompare(leftHandOperand, rightHandOperand, memoizeMap) {
  // Technically, WeakMap keys can *only* be objects, not primitives.
  if (!memoizeMap || isPrimitive(leftHandOperand) || isPrimitive(rightHandOperand)) {
    return null;
  }
  var leftHandMap = memoizeMap.get(leftHandOperand);
  if (leftHandMap) {
    var result = leftHandMap.get(rightHandOperand);
    if (typeof result === 'boolean') {
      return result;
    }
  }
  return null;
}

/*!
 * Set the result of the equality into the MemoizeMap
 *
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @param {MemoizeMap} memoizeMap
 * @param {Boolean} result
*/
function memoizeSet(leftHandOperand, rightHandOperand, memoizeMap, result) {
  // Technically, WeakMap keys can *only* be objects, not primitives.
  if (!memoizeMap || isPrimitive(leftHandOperand) || isPrimitive(rightHandOperand)) {
    return;
  }
  var leftHandMap = memoizeMap.get(leftHandOperand);
  if (leftHandMap) {
    leftHandMap.set(rightHandOperand, result);
  } else {
    leftHandMap = new MemoizeMap();
    leftHandMap.set(rightHandOperand, result);
    memoizeMap.set(leftHandOperand, leftHandMap);
  }
}

/*!
 * Primary Export
 */

module.exports = deepEqual;
module.exports.MemoizeMap = MemoizeMap;

/**
 * Assert deeply nested sameValue equality between two objects of any type.
 *
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @param {Object} [options] (optional) Additional options
 * @param {Array} [options.comparator] (optional) Override default algorithm, determining custom equality.
 * @param {Array} [options.memoize] (optional) Provide a custom memoization object which will cache the results of
    complex objects for a speed boost. By passing `false` you can disable memoization, but this will cause circular
    references to blow the stack.
 * @return {Boolean} equal match
 */
function deepEqual(leftHandOperand, rightHandOperand, options) {
  // If we have a comparator, we can't assume anything; so bail to its check first.
  if (options && options.comparator) {
    return extensiveDeepEqual(leftHandOperand, rightHandOperand, options);
  }

  var simpleResult = simpleEqual(leftHandOperand, rightHandOperand);
  if (simpleResult !== null) {
    return simpleResult;
  }

  // Deeper comparisons are pushed through to a larger function
  return extensiveDeepEqual(leftHandOperand, rightHandOperand, options);
}

/**
 * Many comparisons can be canceled out early via simple equality or primitive checks.
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @return {Boolean|null} equal match
 */
function simpleEqual(leftHandOperand, rightHandOperand) {
  // Equal references (except for Numbers) can be returned early
  if (leftHandOperand === rightHandOperand) {
    // Handle +-0 cases
    return leftHandOperand !== 0 || 1 / leftHandOperand === 1 / rightHandOperand;
  }

  // handle NaN cases
  if (
    leftHandOperand !== leftHandOperand && // eslint-disable-line no-self-compare
    rightHandOperand !== rightHandOperand // eslint-disable-line no-self-compare
  ) {
    return true;
  }

  // Anything that is not an 'object', i.e. symbols, functions, booleans, numbers,
  // strings, and undefined, can be compared by reference.
  if (isPrimitive(leftHandOperand) || isPrimitive(rightHandOperand)) {
    // Easy out b/c it would have passed the first equality check
    return false;
  }
  return null;
}

/*!
 * The main logic of the `deepEqual` function.
 *
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @param {Object} [options] (optional) Additional options
 * @param {Array} [options.comparator] (optional) Override default algorithm, determining custom equality.
 * @param {Array} [options.memoize] (optional) Provide a custom memoization object which will cache the results of
    complex objects for a speed boost. By passing `false` you can disable memoization, but this will cause circular
    references to blow the stack.
 * @return {Boolean} equal match
*/
function extensiveDeepEqual(leftHandOperand, rightHandOperand, options) {
  options = options || {};
  options.memoize = options.memoize === false ? false : options.memoize || new MemoizeMap();
  var comparator = options && options.comparator;

  // Check if a memoized result exists.
  var memoizeResultLeft = memoizeCompare(leftHandOperand, rightHandOperand, options.memoize);
  if (memoizeResultLeft !== null) {
    return memoizeResultLeft;
  }
  var memoizeResultRight = memoizeCompare(rightHandOperand, leftHandOperand, options.memoize);
  if (memoizeResultRight !== null) {
    return memoizeResultRight;
  }

  // If a comparator is present, use it.
  if (comparator) {
    var comparatorResult = comparator(leftHandOperand, rightHandOperand);
    // Comparators may return null, in which case we want to go back to default behavior.
    if (comparatorResult === false || comparatorResult === true) {
      memoizeSet(leftHandOperand, rightHandOperand, options.memoize, comparatorResult);
      return comparatorResult;
    }
    // To allow comparators to override *any* behavior, we ran them first. Since it didn't decide
    // what to do, we need to make sure to return the basic tests first before we move on.
    var simpleResult = simpleEqual(leftHandOperand, rightHandOperand);
    if (simpleResult !== null) {
      // Don't memoize this, it takes longer to set/retrieve than to just compare.
      return simpleResult;
    }
  }

  var leftHandType = type(leftHandOperand);
  if (leftHandType !== type(rightHandOperand)) {
    memoizeSet(leftHandOperand, rightHandOperand, options.memoize, false);
    return false;
  }

  // Temporarily set the operands in the memoize object to prevent blowing the stack
  memoizeSet(leftHandOperand, rightHandOperand, options.memoize, true);

  var result = extensiveDeepEqualByType(leftHandOperand, rightHandOperand, leftHandType, options);
  memoizeSet(leftHandOperand, rightHandOperand, options.memoize, result);
  return result;
}

function extensiveDeepEqualByType(leftHandOperand, rightHandOperand, leftHandType, options) {
  switch (leftHandType) {
    case 'String':
    case 'Number':
    case 'Boolean':
    case 'Date':
      // If these types are their instance types (e.g. `new Number`) then re-deepEqual against their values
      return deepEqual(leftHandOperand.valueOf(), rightHandOperand.valueOf());
    case 'Promise':
    case 'Symbol':
    case 'function':
    case 'WeakMap':
    case 'WeakSet':
    case 'Error':
      return leftHandOperand === rightHandOperand;
    case 'Arguments':
    case 'Int8Array':
    case 'Uint8Array':
    case 'Uint8ClampedArray':
    case 'Int16Array':
    case 'Uint16Array':
    case 'Int32Array':
    case 'Uint32Array':
    case 'Float32Array':
    case 'Float64Array':
    case 'Array':
      return iterableEqual(leftHandOperand, rightHandOperand, options);
    case 'RegExp':
      return regexpEqual(leftHandOperand, rightHandOperand);
    case 'Generator':
      return generatorEqual(leftHandOperand, rightHandOperand, options);
    case 'DataView':
      return iterableEqual(new Uint8Array(leftHandOperand.buffer), new Uint8Array(rightHandOperand.buffer), options);
    case 'ArrayBuffer':
      return iterableEqual(new Uint8Array(leftHandOperand), new Uint8Array(rightHandOperand), options);
    case 'Set':
      return entriesEqual(leftHandOperand, rightHandOperand, options);
    case 'Map':
      return entriesEqual(leftHandOperand, rightHandOperand, options);
    default:
      return objectEqual(leftHandOperand, rightHandOperand, options);
  }
}

/*!
 * Compare two Regular Expressions for equality.
 *
 * @param {RegExp} leftHandOperand
 * @param {RegExp} rightHandOperand
 * @return {Boolean} result
 */

function regexpEqual(leftHandOperand, rightHandOperand) {
  return leftHandOperand.toString() === rightHandOperand.toString();
}

/*!
 * Compare two Sets/Maps for equality. Faster than other equality functions.
 *
 * @param {Set} leftHandOperand
 * @param {Set} rightHandOperand
 * @param {Object} [options] (Optional)
 * @return {Boolean} result
 */

function entriesEqual(leftHandOperand, rightHandOperand, options) {
  // IE11 doesn't support Set#entries or Set#@@iterator, so we need manually populate using Set#forEach
  if (leftHandOperand.size !== rightHandOperand.size) {
    return false;
  }
  if (leftHandOperand.size === 0) {
    return true;
  }
  var leftHandItems = [];
  var rightHandItems = [];
  leftHandOperand.forEach(function gatherEntries(key, value) {
    leftHandItems.push([ key, value ]);
  });
  rightHandOperand.forEach(function gatherEntries(key, value) {
    rightHandItems.push([ key, value ]);
  });
  return iterableEqual(leftHandItems.sort(), rightHandItems.sort(), options);
}

/*!
 * Simple equality for flat iterable objects such as Arrays, TypedArrays or Node.js buffers.
 *
 * @param {Iterable} leftHandOperand
 * @param {Iterable} rightHandOperand
 * @param {Object} [options] (Optional)
 * @return {Boolean} result
 */

function iterableEqual(leftHandOperand, rightHandOperand, options) {
  var length = leftHandOperand.length;
  if (length !== rightHandOperand.length) {
    return false;
  }
  if (length === 0) {
    return true;
  }
  var index = -1;
  while (++index < length) {
    if (deepEqual(leftHandOperand[index], rightHandOperand[index], options) === false) {
      return false;
    }
  }
  return true;
}

/*!
 * Simple equality for generator objects such as those returned by generator functions.
 *
 * @param {Iterable} leftHandOperand
 * @param {Iterable} rightHandOperand
 * @param {Object} [options] (Optional)
 * @return {Boolean} result
 */

function generatorEqual(leftHandOperand, rightHandOperand, options) {
  return iterableEqual(getGeneratorEntries(leftHandOperand), getGeneratorEntries(rightHandOperand), options);
}

/*!
 * Determine if the given object has an @@iterator function.
 *
 * @param {Object} target
 * @return {Boolean} `true` if the object has an @@iterator function.
 */
function hasIteratorFunction(target) {
  return typeof Symbol !== 'undefined' &&
    typeof target === 'object' &&
    typeof Symbol.iterator !== 'undefined' &&
    typeof target[Symbol.iterator] === 'function';
}

/*!
 * Gets all iterator entries from the given Object. If the Object has no @@iterator function, returns an empty array.
 * This will consume the iterator - which could have side effects depending on the @@iterator implementation.
 *
 * @param {Object} target
 * @returns {Array} an array of entries from the @@iterator function
 */
function getIteratorEntries(target) {
  if (hasIteratorFunction(target)) {
    try {
      return getGeneratorEntries(target[Symbol.iterator]());
    } catch (iteratorError) {
      return [];
    }
  }
  return [];
}

/*!
 * Gets all entries from a Generator. This will consume the generator - which could have side effects.
 *
 * @param {Generator} target
 * @returns {Array} an array of entries from the Generator.
 */
function getGeneratorEntries(generator) {
  var generatorResult = generator.next();
  var accumulator = [ generatorResult.value ];
  while (generatorResult.done === false) {
    generatorResult = generator.next();
    accumulator.push(generatorResult.value);
  }
  return accumulator;
}

/*!
 * Gets all own and inherited enumerable keys from a target.
 *
 * @param {Object} target
 * @returns {Array} an array of own and inherited enumerable keys from the target.
 */
function getEnumerableKeys(target) {
  var keys = [];
  for (var key in target) {
    keys.push(key);
  }
  return keys;
}

/*!
 * Determines if two objects have matching values, given a set of keys. Defers to deepEqual for the equality check of
 * each key. If any value of the given key is not equal, the function will return false (early).
 *
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @param {Array} keys An array of keys to compare the values of leftHandOperand and rightHandOperand against
 * @param {Object} [options] (Optional)
 * @return {Boolean} result
 */
function keysEqual(leftHandOperand, rightHandOperand, keys, options) {
  var length = keys.length;
  if (length === 0) {
    return true;
  }
  for (var i = 0; i < length; i += 1) {
    if (deepEqual(leftHandOperand[keys[i]], rightHandOperand[keys[i]], options) === false) {
      return false;
    }
  }
  return true;
}

/*!
 * Recursively check the equality of two Objects. Once basic sameness has been established it will defer to `deepEqual`
 * for each enumerable key in the object.
 *
 * @param {Mixed} leftHandOperand
 * @param {Mixed} rightHandOperand
 * @param {Object} [options] (Optional)
 * @return {Boolean} result
 */

function objectEqual(leftHandOperand, rightHandOperand, options) {
  var leftHandKeys = getEnumerableKeys(leftHandOperand);
  var rightHandKeys = getEnumerableKeys(rightHandOperand);
  if (leftHandKeys.length && leftHandKeys.length === rightHandKeys.length) {
    leftHandKeys.sort();
    rightHandKeys.sort();
    if (iterableEqual(leftHandKeys, rightHandKeys) === false) {
      return false;
    }
    return keysEqual(leftHandOperand, rightHandOperand, leftHandKeys, options);
  }

  var leftHandEntries = getIteratorEntries(leftHandOperand);
  var rightHandEntries = getIteratorEntries(rightHandOperand);
  if (leftHandEntries.length && leftHandEntries.length === rightHandEntries.length) {
    leftHandEntries.sort();
    rightHandEntries.sort();
    return iterableEqual(leftHandEntries, rightHandEntries, options);
  }

  if (leftHandKeys.length === 0 &&
      leftHandEntries.length === 0 &&
      rightHandKeys.length === 0 &&
      rightHandEntries.length === 0) {
    return true;
  }

  return false;
}

/*!
 * Returns true if the argument is a primitive.
 *
 * This intentionally returns true for all objects that can be compared by reference,
 * including functions and symbols.
 *
 * @param {Mixed} value
 * @return {Boolean} result
 */
function isPrimitive(value) {
  return value === null || typeof value !== 'object';
}

},{"type-detect":5}],5:[function(require,module,exports){
(function (global){
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.typeDetect = factory());
}(this, (function () { 'use strict';

/* !
 * type-detect
 * Copyright(c) 2013 jake luer <jake@alogicalparadox.com>
 * MIT Licensed
 */
var promiseExists = typeof Promise === 'function';

/* eslint-disable no-undef */
var globalObject = typeof self === 'object' ? self : global; // eslint-disable-line id-blacklist

var symbolExists = typeof Symbol !== 'undefined';
var mapExists = typeof Map !== 'undefined';
var setExists = typeof Set !== 'undefined';
var weakMapExists = typeof WeakMap !== 'undefined';
var weakSetExists = typeof WeakSet !== 'undefined';
var dataViewExists = typeof DataView !== 'undefined';
var symbolIteratorExists = symbolExists && typeof Symbol.iterator !== 'undefined';
var symbolToStringTagExists = symbolExists && typeof Symbol.toStringTag !== 'undefined';
var setEntriesExists = setExists && typeof Set.prototype.entries === 'function';
var mapEntriesExists = mapExists && typeof Map.prototype.entries === 'function';
var setIteratorPrototype = setEntriesExists && Object.getPrototypeOf(new Set().entries());
var mapIteratorPrototype = mapEntriesExists && Object.getPrototypeOf(new Map().entries());
var arrayIteratorExists = symbolIteratorExists && typeof Array.prototype[Symbol.iterator] === 'function';
var arrayIteratorPrototype = arrayIteratorExists && Object.getPrototypeOf([][Symbol.iterator]());
var stringIteratorExists = symbolIteratorExists && typeof String.prototype[Symbol.iterator] === 'function';
var stringIteratorPrototype = stringIteratorExists && Object.getPrototypeOf(''[Symbol.iterator]());
var toStringLeftSliceLength = 8;
var toStringRightSliceLength = -1;
/**
 * ### typeOf (obj)
 *
 * Uses `Object.prototype.toString` to determine the type of an object,
 * normalising behaviour across engine versions & well optimised.
 *
 * @param {Mixed} object
 * @return {String} object type
 * @api public
 */
function typeDetect(obj) {
  /* ! Speed optimisation
   * Pre:
   *   string literal     x 3,039,035 ops/sec ±1.62% (78 runs sampled)
   *   boolean literal    x 1,424,138 ops/sec ±4.54% (75 runs sampled)
   *   number literal     x 1,653,153 ops/sec ±1.91% (82 runs sampled)
   *   undefined          x 9,978,660 ops/sec ±1.92% (75 runs sampled)
   *   function           x 2,556,769 ops/sec ±1.73% (77 runs sampled)
   * Post:
   *   string literal     x 38,564,796 ops/sec ±1.15% (79 runs sampled)
   *   boolean literal    x 31,148,940 ops/sec ±1.10% (79 runs sampled)
   *   number literal     x 32,679,330 ops/sec ±1.90% (78 runs sampled)
   *   undefined          x 32,363,368 ops/sec ±1.07% (82 runs sampled)
   *   function           x 31,296,870 ops/sec ±0.96% (83 runs sampled)
   */
  var typeofObj = typeof obj;
  if (typeofObj !== 'object') {
    return typeofObj;
  }

  /* ! Speed optimisation
   * Pre:
   *   null               x 28,645,765 ops/sec ±1.17% (82 runs sampled)
   * Post:
   *   null               x 36,428,962 ops/sec ±1.37% (84 runs sampled)
   */
  if (obj === null) {
    return 'null';
  }

  /* ! Spec Conformance
   * Test: `Object.prototype.toString.call(window)``
   *  - Node === "[object global]"
   *  - Chrome === "[object global]"
   *  - Firefox === "[object Window]"
   *  - PhantomJS === "[object Window]"
   *  - Safari === "[object Window]"
   *  - IE 11 === "[object Window]"
   *  - IE Edge === "[object Window]"
   * Test: `Object.prototype.toString.call(this)``
   *  - Chrome Worker === "[object global]"
   *  - Firefox Worker === "[object DedicatedWorkerGlobalScope]"
   *  - Safari Worker === "[object DedicatedWorkerGlobalScope]"
   *  - IE 11 Worker === "[object WorkerGlobalScope]"
   *  - IE Edge Worker === "[object WorkerGlobalScope]"
   */
  if (obj === globalObject) {
    return 'global';
  }

  /* ! Speed optimisation
   * Pre:
   *   array literal      x 2,888,352 ops/sec ±0.67% (82 runs sampled)
   * Post:
   *   array literal      x 22,479,650 ops/sec ±0.96% (81 runs sampled)
   */
  if (
    Array.isArray(obj) &&
    (symbolToStringTagExists === false || !(Symbol.toStringTag in obj))
  ) {
    return 'Array';
  }

  // Not caching existence of `window` and related properties due to potential
  // for `window` to be unset before tests in quasi-browser environments.
  if (typeof window === 'object' && window !== null) {
    /* ! Spec Conformance
     * (https://html.spec.whatwg.org/multipage/browsers.html#location)
     * WhatWG HTML$7.7.3 - The `Location` interface
     * Test: `Object.prototype.toString.call(window.location)``
     *  - IE <=11 === "[object Object]"
     *  - IE Edge <=13 === "[object Object]"
     */
    if (typeof window.location === 'object' && obj === window.location) {
      return 'Location';
    }

    /* ! Spec Conformance
     * (https://html.spec.whatwg.org/#document)
     * WhatWG HTML$3.1.1 - The `Document` object
     * Note: Most browsers currently adher to the W3C DOM Level 2 spec
     *       (https://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26809268)
     *       which suggests that browsers should use HTMLTableCellElement for
     *       both TD and TH elements. WhatWG separates these.
     *       WhatWG HTML states:
     *         > For historical reasons, Window objects must also have a
     *         > writable, configurable, non-enumerable property named
     *         > HTMLDocument whose value is the Document interface object.
     * Test: `Object.prototype.toString.call(document)``
     *  - Chrome === "[object HTMLDocument]"
     *  - Firefox === "[object HTMLDocument]"
     *  - Safari === "[object HTMLDocument]"
     *  - IE <=10 === "[object Document]"
     *  - IE 11 === "[object HTMLDocument]"
     *  - IE Edge <=13 === "[object HTMLDocument]"
     */
    if (typeof window.document === 'object' && obj === window.document) {
      return 'Document';
    }

    if (typeof window.navigator === 'object') {
      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/multipage/webappapis.html#mimetypearray)
       * WhatWG HTML$8.6.1.5 - Plugins - Interface MimeTypeArray
       * Test: `Object.prototype.toString.call(navigator.mimeTypes)``
       *  - IE <=10 === "[object MSMimeTypesCollection]"
       */
      if (typeof window.navigator.mimeTypes === 'object' &&
          obj === window.navigator.mimeTypes) {
        return 'MimeTypeArray';
      }

      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/multipage/webappapis.html#pluginarray)
       * WhatWG HTML$8.6.1.5 - Plugins - Interface PluginArray
       * Test: `Object.prototype.toString.call(navigator.plugins)``
       *  - IE <=10 === "[object MSPluginsCollection]"
       */
      if (typeof window.navigator.plugins === 'object' &&
          obj === window.navigator.plugins) {
        return 'PluginArray';
      }
    }

    if ((typeof window.HTMLElement === 'function' ||
        typeof window.HTMLElement === 'object') &&
        obj instanceof window.HTMLElement) {
      /* ! Spec Conformance
      * (https://html.spec.whatwg.org/multipage/webappapis.html#pluginarray)
      * WhatWG HTML$4.4.4 - The `blockquote` element - Interface `HTMLQuoteElement`
      * Test: `Object.prototype.toString.call(document.createElement('blockquote'))``
      *  - IE <=10 === "[object HTMLBlockElement]"
      */
      if (obj.tagName === 'BLOCKQUOTE') {
        return 'HTMLQuoteElement';
      }

      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/#htmltabledatacellelement)
       * WhatWG HTML$4.9.9 - The `td` element - Interface `HTMLTableDataCellElement`
       * Note: Most browsers currently adher to the W3C DOM Level 2 spec
       *       (https://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-82915075)
       *       which suggests that browsers should use HTMLTableCellElement for
       *       both TD and TH elements. WhatWG separates these.
       * Test: Object.prototype.toString.call(document.createElement('td'))
       *  - Chrome === "[object HTMLTableCellElement]"
       *  - Firefox === "[object HTMLTableCellElement]"
       *  - Safari === "[object HTMLTableCellElement]"
       */
      if (obj.tagName === 'TD') {
        return 'HTMLTableDataCellElement';
      }

      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/#htmltableheadercellelement)
       * WhatWG HTML$4.9.9 - The `td` element - Interface `HTMLTableHeaderCellElement`
       * Note: Most browsers currently adher to the W3C DOM Level 2 spec
       *       (https://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-82915075)
       *       which suggests that browsers should use HTMLTableCellElement for
       *       both TD and TH elements. WhatWG separates these.
       * Test: Object.prototype.toString.call(document.createElement('th'))
       *  - Chrome === "[object HTMLTableCellElement]"
       *  - Firefox === "[object HTMLTableCellElement]"
       *  - Safari === "[object HTMLTableCellElement]"
       */
      if (obj.tagName === 'TH') {
        return 'HTMLTableHeaderCellElement';
      }
    }
  }

  /* ! Speed optimisation
  * Pre:
  *   Float64Array       x 625,644 ops/sec ±1.58% (80 runs sampled)
  *   Float32Array       x 1,279,852 ops/sec ±2.91% (77 runs sampled)
  *   Uint32Array        x 1,178,185 ops/sec ±1.95% (83 runs sampled)
  *   Uint16Array        x 1,008,380 ops/sec ±2.25% (80 runs sampled)
  *   Uint8Array         x 1,128,040 ops/sec ±2.11% (81 runs sampled)
  *   Int32Array         x 1,170,119 ops/sec ±2.88% (80 runs sampled)
  *   Int16Array         x 1,176,348 ops/sec ±5.79% (86 runs sampled)
  *   Int8Array          x 1,058,707 ops/sec ±4.94% (77 runs sampled)
  *   Uint8ClampedArray  x 1,110,633 ops/sec ±4.20% (80 runs sampled)
  * Post:
  *   Float64Array       x 7,105,671 ops/sec ±13.47% (64 runs sampled)
  *   Float32Array       x 5,887,912 ops/sec ±1.46% (82 runs sampled)
  *   Uint32Array        x 6,491,661 ops/sec ±1.76% (79 runs sampled)
  *   Uint16Array        x 6,559,795 ops/sec ±1.67% (82 runs sampled)
  *   Uint8Array         x 6,463,966 ops/sec ±1.43% (85 runs sampled)
  *   Int32Array         x 5,641,841 ops/sec ±3.49% (81 runs sampled)
  *   Int16Array         x 6,583,511 ops/sec ±1.98% (80 runs sampled)
  *   Int8Array          x 6,606,078 ops/sec ±1.74% (81 runs sampled)
  *   Uint8ClampedArray  x 6,602,224 ops/sec ±1.77% (83 runs sampled)
  */
  var stringTag = (symbolToStringTagExists && obj[Symbol.toStringTag]);
  if (typeof stringTag === 'string') {
    return stringTag;
  }

  var objPrototype = Object.getPrototypeOf(obj);
  /* ! Speed optimisation
  * Pre:
  *   regex literal      x 1,772,385 ops/sec ±1.85% (77 runs sampled)
  *   regex constructor  x 2,143,634 ops/sec ±2.46% (78 runs sampled)
  * Post:
  *   regex literal      x 3,928,009 ops/sec ±0.65% (78 runs sampled)
  *   regex constructor  x 3,931,108 ops/sec ±0.58% (84 runs sampled)
  */
  if (objPrototype === RegExp.prototype) {
    return 'RegExp';
  }

  /* ! Speed optimisation
  * Pre:
  *   date               x 2,130,074 ops/sec ±4.42% (68 runs sampled)
  * Post:
  *   date               x 3,953,779 ops/sec ±1.35% (77 runs sampled)
  */
  if (objPrototype === Date.prototype) {
    return 'Date';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-promise.prototype-@@tostringtag)
   * ES6$25.4.5.4 - Promise.prototype[@@toStringTag] should be "Promise":
   * Test: `Object.prototype.toString.call(Promise.resolve())``
   *  - Chrome <=47 === "[object Object]"
   *  - Edge <=20 === "[object Object]"
   *  - Firefox 29-Latest === "[object Promise]"
   *  - Safari 7.1-Latest === "[object Promise]"
   */
  if (promiseExists && objPrototype === Promise.prototype) {
    return 'Promise';
  }

  /* ! Speed optimisation
  * Pre:
  *   set                x 2,222,186 ops/sec ±1.31% (82 runs sampled)
  * Post:
  *   set                x 4,545,879 ops/sec ±1.13% (83 runs sampled)
  */
  if (setExists && objPrototype === Set.prototype) {
    return 'Set';
  }

  /* ! Speed optimisation
  * Pre:
  *   map                x 2,396,842 ops/sec ±1.59% (81 runs sampled)
  * Post:
  *   map                x 4,183,945 ops/sec ±6.59% (82 runs sampled)
  */
  if (mapExists && objPrototype === Map.prototype) {
    return 'Map';
  }

  /* ! Speed optimisation
  * Pre:
  *   weakset            x 1,323,220 ops/sec ±2.17% (76 runs sampled)
  * Post:
  *   weakset            x 4,237,510 ops/sec ±2.01% (77 runs sampled)
  */
  if (weakSetExists && objPrototype === WeakSet.prototype) {
    return 'WeakSet';
  }

  /* ! Speed optimisation
  * Pre:
  *   weakmap            x 1,500,260 ops/sec ±2.02% (78 runs sampled)
  * Post:
  *   weakmap            x 3,881,384 ops/sec ±1.45% (82 runs sampled)
  */
  if (weakMapExists && objPrototype === WeakMap.prototype) {
    return 'WeakMap';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-dataview.prototype-@@tostringtag)
   * ES6$24.2.4.21 - DataView.prototype[@@toStringTag] should be "DataView":
   * Test: `Object.prototype.toString.call(new DataView(new ArrayBuffer(1)))``
   *  - Edge <=13 === "[object Object]"
   */
  if (dataViewExists && objPrototype === DataView.prototype) {
    return 'DataView';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%mapiteratorprototype%-@@tostringtag)
   * ES6$23.1.5.2.2 - %MapIteratorPrototype%[@@toStringTag] should be "Map Iterator":
   * Test: `Object.prototype.toString.call(new Map().entries())``
   *  - Edge <=13 === "[object Object]"
   */
  if (mapExists && objPrototype === mapIteratorPrototype) {
    return 'Map Iterator';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%setiteratorprototype%-@@tostringtag)
   * ES6$23.2.5.2.2 - %SetIteratorPrototype%[@@toStringTag] should be "Set Iterator":
   * Test: `Object.prototype.toString.call(new Set().entries())``
   *  - Edge <=13 === "[object Object]"
   */
  if (setExists && objPrototype === setIteratorPrototype) {
    return 'Set Iterator';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%arrayiteratorprototype%-@@tostringtag)
   * ES6$22.1.5.2.2 - %ArrayIteratorPrototype%[@@toStringTag] should be "Array Iterator":
   * Test: `Object.prototype.toString.call([][Symbol.iterator]())``
   *  - Edge <=13 === "[object Object]"
   */
  if (arrayIteratorExists && objPrototype === arrayIteratorPrototype) {
    return 'Array Iterator';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%stringiteratorprototype%-@@tostringtag)
   * ES6$21.1.5.2.2 - %StringIteratorPrototype%[@@toStringTag] should be "String Iterator":
   * Test: `Object.prototype.toString.call(''[Symbol.iterator]())``
   *  - Edge <=13 === "[object Object]"
   */
  if (stringIteratorExists && objPrototype === stringIteratorPrototype) {
    return 'String Iterator';
  }

  /* ! Speed optimisation
  * Pre:
  *   object from null   x 2,424,320 ops/sec ±1.67% (76 runs sampled)
  * Post:
  *   object from null   x 5,838,000 ops/sec ±0.99% (84 runs sampled)
  */
  if (objPrototype === null) {
    return 'Object';
  }

  return Object
    .prototype
    .toString
    .call(obj)
    .slice(toStringLeftSliceLength, toStringRightSliceLength);
}

return typeDetect;

})));

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],6:[function(require,module,exports){
'use strict';

var toString = Object.prototype.toString;

/**
 * Extract names from functions.
 *
 * @param {Function} fn The function who's name we need to extract.
 * @returns {String}
 * @api public
 */
module.exports = function name(fn) {
  if ('string' === typeof fn.displayName && fn.constructor.name) {
    return fn.displayName;
  } else if ('string' === typeof fn.name && fn.name) {
    return fn.name;
  }

  //
  // Check to see if the constructor has a name.
  //
  if (
       'object' === typeof fn
    && fn.constructor
    && 'string' === typeof fn.constructor.name
  ) return fn.constructor.name;

  //
  // toString the given function and attempt to parse it out of it, or determine
  // the class.
  //
  var named = fn.toString()
    , type = toString.call(fn).slice(8, -1);

  if ('Function' === type) {
    named = named.substring(named.indexOf('(') + 1, named.indexOf(')'));
  } else {
    named = type;
  }

  return named || 'anonymous';
};

},{}],7:[function(require,module,exports){
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */

module.exports = function isBuffer (obj) {
  return obj != null && obj.constructor != null &&
    typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
}

},{}],8:[function(require,module,exports){
var hasMap = typeof Map === 'function' && Map.prototype;
var mapSizeDescriptor = Object.getOwnPropertyDescriptor && hasMap ? Object.getOwnPropertyDescriptor(Map.prototype, 'size') : null;
var mapSize = hasMap && mapSizeDescriptor && typeof mapSizeDescriptor.get === 'function' ? mapSizeDescriptor.get : null;
var mapForEach = hasMap && Map.prototype.forEach;
var hasSet = typeof Set === 'function' && Set.prototype;
var setSizeDescriptor = Object.getOwnPropertyDescriptor && hasSet ? Object.getOwnPropertyDescriptor(Set.prototype, 'size') : null;
var setSize = hasSet && setSizeDescriptor && typeof setSizeDescriptor.get === 'function' ? setSizeDescriptor.get : null;
var setForEach = hasSet && Set.prototype.forEach;
var booleanValueOf = Boolean.prototype.valueOf;
var objectToString = Object.prototype.toString;

var inspectCustom = require('./util.inspect').custom;
var inspectSymbol = (inspectCustom && isSymbol(inspectCustom)) ? inspectCustom : null;

module.exports = function inspect_ (obj, opts, depth, seen) {
    if (!opts) opts = {};

    if (has(opts, 'quoteStyle') && (opts.quoteStyle !== 'single' && opts.quoteStyle !== 'double')) {
        throw new TypeError('option "quoteStyle" must be "single" or "double"');
    }

    if (typeof obj === 'undefined') {
        return 'undefined';
    }
    if (obj === null) {
        return 'null';
    }
    if (typeof obj === 'boolean') {
        return obj ? 'true' : 'false';
    }

    if (typeof obj === 'string') {
        return inspectString(obj, opts);
    }
    if (typeof obj === 'number') {
      if (obj === 0) {
        return Infinity / obj > 0 ? '0' : '-0';
      }
      return String(obj);
    }

    var maxDepth = typeof opts.depth === 'undefined' ? 5 : opts.depth;
    if (typeof depth === 'undefined') depth = 0;
    if (depth >= maxDepth && maxDepth > 0 && typeof obj === 'object') {
        return '[Object]';
    }

    if (typeof seen === 'undefined') seen = [];
    else if (indexOf(seen, obj) >= 0) {
        return '[Circular]';
    }

    function inspect (value, from) {
        if (from) {
            seen = seen.slice();
            seen.push(from);
        }
        return inspect_(value, opts, depth + 1, seen);
    }

    if (typeof obj === 'function') {
        var name = nameOf(obj);
        return '[Function' + (name ? ': ' + name : '') + ']';
    }
    if (isSymbol(obj)) {
        var symString = Symbol.prototype.toString.call(obj);
        return typeof obj === 'object' ? markBoxed(symString) : symString;
    }
    if (isElement(obj)) {
        var s = '<' + String(obj.nodeName).toLowerCase();
        var attrs = obj.attributes || [];
        for (var i = 0; i < attrs.length; i++) {
            s += ' ' + attrs[i].name + '=' + wrapQuotes(quote(attrs[i].value), 'double', opts);
        }
        s += '>';
        if (obj.childNodes && obj.childNodes.length) s += '...';
        s += '</' + String(obj.nodeName).toLowerCase() + '>';
        return s;
    }
    if (isArray(obj)) {
        if (obj.length === 0) return '[]';
        return '[ ' + arrObjKeys(obj, inspect).join(', ') + ' ]';
    }
    if (isError(obj)) {
        var parts = arrObjKeys(obj, inspect);
        if (parts.length === 0) return '[' + String(obj) + ']';
        return '{ [' + String(obj) + '] ' + parts.join(', ') + ' }';
    }
    if (typeof obj === 'object') {
        if (inspectSymbol && typeof obj[inspectSymbol] === 'function') {
            return obj[inspectSymbol]();
        } else if (typeof obj.inspect === 'function') {
            return obj.inspect();
        }
    }
    if (isMap(obj)) {
        var parts = [];
        mapForEach.call(obj, function (value, key) {
            parts.push(inspect(key, obj) + ' => ' + inspect(value, obj));
        });
        return collectionOf('Map', mapSize.call(obj), parts);
    }
    if (isSet(obj)) {
        var parts = [];
        setForEach.call(obj, function (value ) {
            parts.push(inspect(value, obj));
        });
        return collectionOf('Set', setSize.call(obj), parts);
    }
    if (isNumber(obj)) {
        return markBoxed(inspect(Number(obj)));
    }
    if (isBoolean(obj)) {
        return markBoxed(booleanValueOf.call(obj));
    }
    if (isString(obj)) {
        return markBoxed(inspect(String(obj)));
    }
    if (!isDate(obj) && !isRegExp(obj)) {
        var xs = arrObjKeys(obj, inspect);
        if (xs.length === 0) return '{}';
        return '{ ' + xs.join(', ') + ' }';
    }
    return String(obj);
};

function wrapQuotes (s, defaultStyle, opts) {
    var quoteChar = (opts.quoteStyle || defaultStyle) === 'double' ? '"' : "'";
    return quoteChar + s + quoteChar;
}

function quote (s) {
    return String(s).replace(/"/g, '&quot;');
}

function isArray (obj) { return toStr(obj) === '[object Array]' }
function isDate (obj) { return toStr(obj) === '[object Date]' }
function isRegExp (obj) { return toStr(obj) === '[object RegExp]' }
function isError (obj) { return toStr(obj) === '[object Error]' }
function isSymbol (obj) { return toStr(obj) === '[object Symbol]' }
function isString (obj) { return toStr(obj) === '[object String]' }
function isNumber (obj) { return toStr(obj) === '[object Number]' }
function isBoolean (obj) { return toStr(obj) === '[object Boolean]' }

var hasOwn = Object.prototype.hasOwnProperty || function (key) { return key in this; };
function has (obj, key) {
    return hasOwn.call(obj, key);
}

function toStr (obj) {
    return objectToString.call(obj);
}

function nameOf (f) {
    if (f.name) return f.name;
    var m = String(f).match(/^function\s*([\w$]+)/);
    if (m) return m[1];
}

function indexOf (xs, x) {
    if (xs.indexOf) return xs.indexOf(x);
    for (var i = 0, l = xs.length; i < l; i++) {
        if (xs[i] === x) return i;
    }
    return -1;
}

function isMap (x) {
    if (!mapSize) {
        return false;
    }
    try {
        mapSize.call(x);
        try {
            setSize.call(x);
        } catch (s) {
            return true;
        }
        return x instanceof Map; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isSet (x) {
    if (!setSize) {
        return false;
    }
    try {
        setSize.call(x);
        try {
            mapSize.call(x);
        } catch (m) {
            return true;
        }
        return x instanceof Set; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isElement (x) {
    if (!x || typeof x !== 'object') return false;
    if (typeof HTMLElement !== 'undefined' && x instanceof HTMLElement) {
        return true;
    }
    return typeof x.nodeName === 'string'
        && typeof x.getAttribute === 'function'
    ;
}

function inspectString (str, opts) {
    var s = str.replace(/(['\\])/g, '\\$1').replace(/[\x00-\x1f]/g, lowbyte);
    return wrapQuotes(s, 'single', opts);
}

function lowbyte (c) {
    var n = c.charCodeAt(0);
    var x = { 8: 'b', 9: 't', 10: 'n', 12: 'f', 13: 'r' }[n];
    if (x) return '\\' + x;
    return '\\x' + (n < 0x10 ? '0' : '') + n.toString(16);
}

function markBoxed (str) {
    return 'Object(' + str + ')';
}

function collectionOf (type, size, entries) {
    return type + ' (' + size + ') {' + entries.join(', ') + '}';
}

function arrObjKeys (obj, inspect) {
    var isArr = isArray(obj);
    var xs = [];
    if (isArr) {
        xs.length = obj.length;
        for (var i = 0; i < obj.length; i++) {
            xs[i] = has(obj, i) ? inspect(obj[i], obj) : '';
        }
    }
    for (var key in obj) {
        if (!has(obj, key)) continue;
        if (isArr && String(Number(key)) === key && key < obj.length) continue;
        if (/[^\w$]/.test(key)) {
            xs.push(inspect(key, obj) + ': ' + inspect(obj[key], obj));
        } else {
            xs.push(key + ': ' + inspect(obj[key], obj));
        }
    }
    return xs;
}

},{"./util.inspect":2}],9:[function(require,module,exports){
'use strict';

/**
 * Small helper function that allows you get a key from an object by
 * specifying it's depth using dot notations.
 *
 * Example:
 *
 * - path.to.0.keys
 * - key.depth
 *
 * @param {Object|Array} data Data structure that we need search.
 * @param {String} prop Property structure.
 * @param {Args} args Possible arguments for function calls.
 * @returns {Mixed}
 * @api private
 */
module.exports = function find(data, prop) {
  data = data || {};
  prop = prop || '';

  //
  // Fastest match, direct match against a key in the data.
  //
  if (prop in data) return data[prop];

  var args = Array.prototype.slice.call(arguments, 2)
    , paths = prop.split('.')
    , length = paths.length
    , structure = data
    , result = prop
    , i = 0;

  for (; i < length && structure; i++) {
    var fn = /(.+)\(([^\)]+?)?\)$/g.exec(paths[i]);

    if (fn) {
      if (!fn[2]) {
        result = structure[fn[1]]();
      } else {
        result = structure[fn[1]].apply(null, args.splice(0, fn[2].split(/[\s,]+/).length));
      }
    } else {
      result = structure[paths[i]];
    }

    structure = result;
  }

  return result;
};

},{}],10:[function(require,module,exports){
module.exports={
  "reset": "\u001b[0m",
  "bold": "\u001b[1m",
  "italic": "\u001b[3m",
  "blink": "\u001b[5m",
  "underline": "\u001b[4m",
  "underlineOff": "\u001b[24m",
  "inverse": "\u001b[7m",
  "inverseOff": "\u001b[27m",
  "strikethrough": "\u001b[9m",
  "strikethroughOff": "\u001b[29m",
  "def": "\u001b[39m",
  "white": "\u001b[37m",
  "black": "\u001b[30m",
  "grey": "\u001b[90m",
  "red": "\u001b[31m",
  "green": "\u001b[32m",
  "blue": "\u001b[34m",
  "yellow": "\u001b[33m",
  "magenta": "\u001b[35m",
  "cyan": "\u001b[36m",
  "defBg": "\u001b[49m",
  "whiteBg": "\u001b[47m",
  "blackBg": "\u001b[40m",
  "redBg": "\u001b[41m",
  "greenBg": "\u001b[42m",
  "blueBg": "\u001b[44m",
  "yellowBg": "\u001b[43m",
  "magentaBg": "\u001b[45m",
  "cyanBg": "\u001b[46m",
  "brightBlack": "\u001b[90m",
  "brightRed": "\u001b[91m",
  "brightGreen": "\u001b[92m",
  "brightYellow": "\u001b[93m",
  "brightBlue": "\u001b[94m",
  "brightMagenta": "\u001b[95m",
  "brightCyan": "\u001b[96m",
  "brightWhite": "\u001b[97m",
  "brightBlackBg": "\u001b[100m",
  "brightRedBg": "\u001b[101m",
  "brightGreenBg": "\u001b[102m",
  "brightYellowBg": "\u001b[103m",
  "brightBlueBg": "\u001b[104m",
  "brightMagentaBg": "\u001b[105m",
  "brightCyanBg": "\u001b[106m",
  "brightWhiteBg": "\u001b[107m"
}

},{}],11:[function(require,module,exports){
var failingLine = require('./failing-line');
var nodeRequire;
var fs;

//
// wut, yeah, this is for browserify to prevent it from bundling
// a file system polyfill.
//
if (require('is-node')) {
  nodeRequire = require;
  fs = nodeRequire('fs');
  nodeRequire = null;
}

/**
 * Failing code.
 *
 * @param {Error} error Error.
 * @param {Object} options Configuration.
 * @returns {Undefined|Array} Parsed failed code.
 * @private
 */
function failingCode(error, options) {
  var ln = failingLine(error, options.shift);

  if (!ln) return;

  var doc = options.read && options.read(ln);
  if (!doc && fs) {
    try {
      doc = fs.readFileSync(ln.filename).toString();
    } catch (e) {
      return undefined;
    }
  }

  if (!doc) return undefined;

  var lines = typeof doc === 'string' ? doc.split('\n') : doc;
  var result = [];

  var i = ln.line - 3;
  while (++i < ln.line + 1) {
    if (i + 1 != ln.line) {
      result.push({
        line: ln.line - (ln.line - i -1),
        code: lines[i]
      });

      continue;
    }

    result.push({
      line: ln.line,
      col: ln.col,
      fn: ln.fn,
      filename: ln.filename,
      code: lines[i],
      failed: true
    });
  }

  return result;
}

//
// Expose the module.
//
module.exports = failingCode;

},{"./failing-line":12,"is-node":15}],12:[function(require,module,exports){
/**
 * Parse v8 stack traces.
 *
 * @param {Error} error JavaScript Object
 * @param {Number} shift Stacks to shift.
 * @returns {Object} Parsed stack trace.
 * @private
 */
function safari(error, shift) {
  var index = 0;
  if (shift) index += shift;

  var fn, filename, line, col;
  var lines = error.stack.split('\n');
  var stack = lines[index] || lines[0];

  var fields = stack.split(/\:(\d+)\:(\d+)$/);
  var numbers = fields.slice(1, 3);
  fields = fields[0].split('@');

  return {
    fn: fields[0],
    filename: fields[1],
    line: Number(numbers[0]),
    col: Number(numbers[1])
  };
}

/**
 * Parse v8 stack traces.
 *
 * @param {Error} error JavaScript Object
 * @param {Number} shift Stacks to shift.
 * @returns {Object} Parsed stack trace.
 * @private
 */
function v8(error, shift) {
  if (!error || !error.stack) return;

  var index = 1;
  if (shift) index += shift;

  var fn, filename, line, col;
  var lines = error.stack.split('\n');
  var stack = lines[index] || lines[1];

  if (!stack) return;

  var match = stack.match(/at ([\(\)\w\.<>\[\]\s]+) \((.+):(\d+):(\d+)/);

  if (!match) {
    match = stack.match(/at (.+):(\d+):(\d+)/);
    if (!match) return undefined;

    filename = match[1];
    line = Number(match[2]);
    col = Number(match[3]);
  } else {
    fn = match[1];
    filename = match[2];
    line = Number(match[3]);
    col = Number(match[4]);
  }

  return {
    fn: fn,
    filename: filename,
    line: line,
    col: col
  };
}

/**
 * Parse firefox stack traces.
 *
 * @param {Error} error JavaScript Object
 * @param {Number} shift Stacks to shift.
 * @returns {Object} Parsed stack trace.
 * @private
 */
function firefox(error, shift) {
  var index = 0;
  if (shift) index += shift;

  var fn, filename, line, col;
  var lines = error.stack.split('\n');
  var stack = lines[index] || lines[0];

  var fields = stack.split(/\:(\d+)$/);
  var numbers = fields.slice(1, 2);
  fields = fields[0].split('@');

  if (index == 0) {
    col = error.columnNumber;
  }

  return {
    fn: fields[0],
    filename: fields[1],
    line: Number(numbers[0]),
    col: col
  };
}

/**
 * Parse the stacktrace and fine the failing line.
 *
 * @param {Error} error JavaScript Object
 * @param {Number} shift Stacks to shift.
 * @returns {Object} Parsed stack trace.
 * @public
 */
function failingLine(error, shift) {
  if (!error || !error.stack) return;

  if (/  at /.test(error.stack)) return v8(error, shift);

  if (/:\d+:\d+$/.test(error.stack)) return safari(error, shift);

  return firefox(error, shift);
}

//
// Expose the module.
//
module.exports = failingLine;

},{}],13:[function(require,module,exports){

/**
 * Format the text according to the template.
 *
 * @param {String} text Template that needs to be formatted.
 * @param {Arguments..} .. The arguments that need to be applied.
 * @returns {String} The replaced text.
 */
function format(text) {
  var context;

  if (typeof arguments[1] == 'object' && arguments[1]) {
    context = arguments[1];
  } else {
    context = Array.prototype.slice.call(arguments, 1);
  }

  return String(text).replace(/\{?\{([^{}]+)}}?/g, replace(context));
};

/**
 * Replaces the placeholders with the actual data.
 *
 * @param {object} context data for the template
 * @returns {String} The new template data
 * @private
 */
function replace(context){
  return function replacer(tag, name) {
    if (tag.substring(0, 2) == '{{' && tag.substring(tag.length - 2) == '}}') {
      return '{' + name + '}';
    }

    if (!context.hasOwnProperty(name)) {
      return tag;
    }

    if (typeof context[name] == 'function') {
      return context[name]();
    }

    return context[name];
  }
}

//
// Expose the actual module.
//
module.exports = format;

},{}],14:[function(require,module,exports){
var failingCode = require('./failing-code');
var style = require('./style-format');
var format = require('./format-text');
var leftpad = require('left-pad');

/**
 * The template that is rendered with the error detailed error information.
 *
 * @type {String}
 * @private
 */
var template = style([
  '{bold}{red}{title} {grey}{filename}{reset}',
  '    {red}{v}',
  '    {grey}{previousLineNo}. {previousLine}',
  '    {reset}{failingLineNo}. {failingLine}',
  '    {grey}{nextLineNo}. {nextLine}',
  '    {red}{^}{reset}',
  '    {stack}',
  '{reset}'
].join('\n'));

/**
 * Replaces the newlines with tabbed newlines.
 *
 * @param {String} Stack error stack that needs to be tabbed
 * @returns {String} Tabbed stacktrace
 * @private
 */
function tabStack(stack) {
  return stack.replace(/\n/g, '\n    ');
}

/**
 * Shows the column
 *
 * @param {Array} code The failing code information.
 * @param {Number} tabn Tabs
 * @param {String} ch Character that needs to be shown.
 * @private
 */
function showColumn(code, tabn, ch) {
  var i = String(code[1].line).length + code[1].col + 1 + tabn;
  var result = '';

  while (i--) {
    result += ' ';
  }

  return result + ch;
}

/**
 * Reformat an error so it shows detailed debug information.
 *
 * @param {Error} error The error that needs to be pretty.
 * @param {Object} options Addition configuration.
 * @returns {Undefined|String} Rendered template or bust.
 * @public
 */
function pruddy(error, options) {
  if (!error || !error.stack) return;

  options = options || {};

  var code = options.code || failingCode(error, options);
  if (!code) return;

  var previous = String(code[0].line);
  var failing = String(code[1].line);
  var next = String(code[2].line);
  var line = Math.max(previous.length, failing.length, next.length);

  return format(template, {
    title: error.message,
    filename: code[1].filename,
    previousLine: code[0].code,
    previousLineNo: leftpad(previous, line),
    previousColNo: code[0].col,
    failingLine: code[1].code,
    failingLineNo: leftpad(failing, line),
    failingColNo: code[1].col,
    nextLine: code[2].code,
    nextLineNo: leftpad(next, line),
    nextColNo: code[2].col,
    stack: tabStack(error.stack),
    '^': showColumn(code, line - failing.length, '^'),
    'v': showColumn(code, line - failing.length, 'v')
  });
}

//
// Expose the module
//
module.exports = pruddy;

},{"./failing-code":11,"./format-text":13,"./style-format":17,"left-pad":16}],15:[function(require,module,exports){
(function (process){
// Coding standard for this project defined @ https://github.com/MatthewSH/standards/blob/master/JavaScript.md
'use strict';

exports = module.exports = !!(typeof process !== 'undefined' && process.versions && process.versions.node);

}).call(this,require('_process'))
},{"_process":3}],16:[function(require,module,exports){
/* This program is free software. It comes without any warranty, to
     * the extent permitted by applicable law. You can redistribute it
     * and/or modify it under the terms of the Do What The Fuck You Want
     * To Public License, Version 2, as published by Sam Hocevar. See
     * http://www.wtfpl.net/ for more details. */
'use strict';
module.exports = leftPad;

var cache = [
  '',
  ' ',
  '  ',
  '   ',
  '    ',
  '     ',
  '      ',
  '       ',
  '        ',
  '         '
];

function leftPad (str, len, ch) {
  // convert `str` to a `string`
  str = str + '';
  // `len` is the `pad`'s length now
  len = len - str.length;
  // doesn't need to pad
  if (len <= 0) return str;
  // `ch` defaults to `' '`
  if (!ch && ch !== 0) ch = ' ';
  // convert `ch` to a `string` cuz it could be a number
  ch = ch + '';
  // cache common use cases
  if (ch === ' ' && len < 10) return cache[len] + str;
  // `pad` starts with an empty string
  var pad = '';
  // loop
  while (true) {
    // add `ch` to `pad` if `len` is odd
    if (len & 1) pad += ch;
    // divide `len` by 2, ditch the remainder
    len >>= 1;
    // "double" the `ch` so this operation count grows logarithmically on `len`
    // each time `ch` is "doubled", the `len` would need to be "doubled" too
    // similar to finding a value in binary search tree, hence O(log(n))
    if (len) ch += ch;
    // `len` is 0, exit the loop
    else break;
  }
  // pad `str`!
  return pad + str;
}

},{}],17:[function(require,module,exports){
var ansi = require('./ansi-codes.json');
var format = require('./format-text');

/**
 * Introduce ASCII as template tags.
 *
 * @param {String} text
 * @returns {String} ANSI injected Template
 * @public
 */
function styleFormat(text) {
  return format(text, ansi);
}

//
// Expose the module.
//
module.exports = styleFormat;

},{"./ansi-codes.json":10,"./format-text":13}]},{},[1])(1)
});
