# Changelog
All notable changes to this project will be documented in this file. This CHANGELOG roughly follows the guidelines from [www.keepachangelog.com](https://keepachangelog.com/en/1.0.0/).

## [0.16.3](https://github.com/KaTeX/KaTeX/compare/v0.16.2...v0.16.3) (2022-10-22)


### Bug Fixes

* \hline after \cr ([#3735](https://github.com/KaTeX/KaTeX/issues/3735)) ([ebf6bf5](https://github.com/KaTeX/KaTeX/commit/ebf6bf5b50a98ac6c5aca1896c0a6ba985c1c91c)), closes [#3734](https://github.com/KaTeX/KaTeX/issues/3734)

## [0.16.2](https://github.com/KaTeX/KaTeX/compare/v0.16.1...v0.16.2) (2022-08-29)


### Bug Fixes

* **auto-render:** concatenate content of successive text nodes ([#3422](https://github.com/KaTeX/KaTeX/issues/3422)) ([4d3fdd8](https://github.com/KaTeX/KaTeX/commit/4d3fdd8647a1c320dc7bcb9c9ea2af81379f700d))
* Implement \pmb via CSS text-shadow ([#3505](https://github.com/KaTeX/KaTeX/issues/3505)) ([176552a](https://github.com/KaTeX/KaTeX/commit/176552a69183d71425b491d4cc2fa1d462a1246a))

## [0.16.1](https://github.com/KaTeX/KaTeX/compare/v0.16.0...v0.16.1) (2022-08-28)


### Bug Fixes

* Use SVGs for some stacked delims ([#3686](https://github.com/KaTeX/KaTeX/issues/3686)) ([8a65a2e](https://github.com/KaTeX/KaTeX/commit/8a65a2e1fd69ffeee2fac62229f9f05ebf6afd45))

# [0.16.0](https://github.com/KaTeX/KaTeX/compare/v0.15.6...v0.16.0) (2022-06-06)


### Bug Fixes

* **copy-tex:** Use JS (instead of CSS) to select full equation, solving display glitches ([#3586](https://github.com/KaTeX/KaTeX/issues/3586)) ([8c2d852](https://github.com/KaTeX/KaTeX/commit/8c2d852c4af213ba4e2f4a3b875498c367e9a119))


### BREAKING CHANGES

* **copy-tex:** copy-tex extension no longer has (or requires) a CSS file.

## [0.15.6](https://github.com/KaTeX/KaTeX/compare/v0.15.5...v0.15.6) (2022-05-20)


### Features

* Support \Braket, \set, and \Set ([#3214](https://github.com/KaTeX/KaTeX/issues/3214)) ([9e3ae4d](https://github.com/KaTeX/KaTeX/commit/9e3ae4d5a81b825b90a055b46d5c7ab0a3a50379))

## [0.15.5](https://github.com/KaTeX/KaTeX/compare/v0.15.4...v0.15.5) (2022-05-20)


### Bug Fixes

* Avoid crash when \ce{} is empty ([#3627](https://github.com/KaTeX/KaTeX/issues/3627)) ([4865e45](https://github.com/KaTeX/KaTeX/commit/4865e4543774441467f81f81ef45c9b59f1349ae))

## [0.15.4](https://github.com/KaTeX/KaTeX/compare/v0.15.3...v0.15.4) (2022-05-20)


### Features

* Support Unicode (sub|super)script characters ([#3633](https://github.com/KaTeX/KaTeX/issues/3633)) ([d8fc35e](https://github.com/KaTeX/KaTeX/commit/d8fc35e6a97f8e561c723b93ad275cf5a7f3094a))

## [0.15.3](https://github.com/KaTeX/KaTeX/compare/v0.15.2...v0.15.3) (2022-03-13)


### Bug Fixes

* Apply operator spacing to Unicode ∙ ∘ ∖ ([#3584](https://github.com/KaTeX/KaTeX/issues/3584)) ([b362fc0](https://github.com/KaTeX/KaTeX/commit/b362fc0b3941926a7a752cab34af6e29570c669a))

## [0.15.2](https://github.com/KaTeX/KaTeX/compare/v0.15.1...v0.15.2) (2022-01-12)


### Bug Fixes

* \mathinner MathML when invoked as a denominator. ([#3501](https://github.com/KaTeX/KaTeX/issues/3501)) ([1f85125](https://github.com/KaTeX/KaTeX/commit/1f8512577b58962db2615175121ac9636245f596)), closes [#3500](https://github.com/KaTeX/KaTeX/issues/3500)

## [0.15.1](https://github.com/KaTeX/KaTeX/compare/v0.15.0...v0.15.1) (2021-10-31)


### Features

* \nonumber/\notag support, \tag per row of {align} ([#2952](https://github.com/KaTeX/KaTeX/issues/2952)) ([52c4778](https://github.com/KaTeX/KaTeX/commit/52c4778b156110c0b2bdd3d7a3b81bbf76d21800)), closes [#2950](https://github.com/KaTeX/KaTeX/issues/2950) [#2379](https://github.com/KaTeX/KaTeX/issues/2379)

# [0.15.0](https://github.com/KaTeX/KaTeX/compare/v0.14.1...v0.15.0) (2021-10-31)


### Features

* implement \relax as no-op function ([#3384](https://github.com/KaTeX/KaTeX/issues/3384)) ([40109f6](https://github.com/KaTeX/KaTeX/commit/40109f624805af41c42897cd428b83a93587f58d))


### BREAKING CHANGES

* `\relax` is now implemented as a function. It'll stop
expansions and parsing, so the behavior around `\relax` may change.
For example, `\kern2\relax em` will no longer work.

## [0.14.1](https://github.com/KaTeX/KaTeX/compare/v0.14.0...v0.14.1) (2021-10-30)


### Bug Fixes

* **Settings:** use schema ([#3375](https://github.com/KaTeX/KaTeX/issues/3375)) ([b58a432](https://github.com/KaTeX/KaTeX/commit/b58a43212e4178ed46cf8e42d67e88b9c8df9c24))

# [0.14.0](https://github.com/KaTeX/KaTeX/compare/v0.13.24...v0.14.0) (2021-10-30)


### Features

* conditionally export ECMAScript modules ([#3377](https://github.com/KaTeX/KaTeX/issues/3377)) ([15ee9b4](https://github.com/KaTeX/KaTeX/commit/15ee9b4a5a0ccf26ee271577e469f8b83f8b3ff8))


### BREAKING CHANGES

* With module loaders that support conditional exports
and ECMAScript modules, `import katex from 'katex';` will import the
ECMAScript module.

You can now use:
|Before                                    |After                             |
|------------------------------------------|----------------------------------|
|`require('katex/dist/contrib/[name].js')` | `require('katex/contrib/[name]')`|
|`import katex from 'katex/dist/katex.mjs'`| `import katex from 'katex'`      |
|`import 'katex/dist/contrib/[name].mjs'`  | `import 'katex/contrib/[name]'`  |

## [0.13.24](https://github.com/KaTeX/KaTeX/compare/v0.13.23...v0.13.24) (2021-10-30)


### Bug Fixes

* round dimensions to 4 places ([#2460](https://github.com/KaTeX/KaTeX/issues/2460)) ([09ee1c8](https://github.com/KaTeX/KaTeX/commit/09ee1c886740fe8283a77468bc28c30b7816b446))

## [0.13.23](https://github.com/KaTeX/KaTeX/compare/v0.13.22...v0.13.23) (2021-10-30)


### Bug Fixes

* **fonts:** correct width of \cong glyph, fix \boldsymbol{\cong} ([#3206](https://github.com/KaTeX/KaTeX/issues/3206)) ([35db4ff](https://github.com/KaTeX/KaTeX/commit/35db4ff40337cc2e2dfebeac1458d6aa9afc8bab)), closes [#2199](https://github.com/KaTeX/KaTeX/issues/2199)

## [0.13.22](https://github.com/KaTeX/KaTeX/compare/v0.13.21...v0.13.22) (2021-10-30)


### Bug Fixes

* **deps:** update dependency commander to v8 [skip netlify] ([#3374](https://github.com/KaTeX/KaTeX/issues/3374)) ([4df1922](https://github.com/KaTeX/KaTeX/commit/4df1922ae9d99927ef9a497209f1691200f39829))

## [0.13.21](https://github.com/KaTeX/KaTeX/compare/v0.13.20...v0.13.21) (2021-10-29)


### Bug Fixes

* **fonts:** fix the timestamp of fonts to the epoch ([#3370](https://github.com/KaTeX/KaTeX/issues/3370)) ([dde05db](https://github.com/KaTeX/KaTeX/commit/dde05db6b775d8726a6654db13de26410195be48))

## [0.13.20](https://github.com/KaTeX/KaTeX/compare/v0.13.19...v0.13.20) (2021-10-26)


### Performance Improvements

* Avoid vertical-align:0em style ([#3358](https://github.com/KaTeX/KaTeX/issues/3358)) ([6d6d627](https://github.com/KaTeX/KaTeX/commit/6d6d627ca49244d53928b6e0e1a238495cef4bd2)), closes [#3351](https://github.com/KaTeX/KaTeX/issues/3351)

## [0.13.19](https://github.com/KaTeX/KaTeX/compare/v0.13.18...v0.13.19) (2021-10-26)


### Features

* **cli:** --trust flag for trusting cli input ([#3339](https://github.com/KaTeX/KaTeX/issues/3339)) ([503f7d7](https://github.com/KaTeX/KaTeX/commit/503f7d79f9b346585248dfe7451b8d635bd3328d)), closes [#2428](https://github.com/KaTeX/KaTeX/issues/2428)

## [0.13.18](https://github.com/KaTeX/KaTeX/compare/v0.13.17...v0.13.18) (2021-09-02)


### Features

* unicode support for minus and asterisk operators ([#3227](https://github.com/KaTeX/KaTeX/issues/3227)) ([9dbfc1c](https://github.com/KaTeX/KaTeX/commit/9dbfc1c91725a9db348ce212488690147b9b9dd4)), closes [#3225](https://github.com/KaTeX/KaTeX/issues/3225)

## [0.13.17](https://github.com/KaTeX/KaTeX/compare/v0.13.16...v0.13.17) (2021-09-01)


### Bug Fixes

* **fonts:** remove hints from unknown symbols ([#3222](https://github.com/KaTeX/KaTeX/issues/3222)) ([9420f8a](https://github.com/KaTeX/KaTeX/commit/9420f8a2a98442158a9cd2b3fd650092d216d0a2)), closes [#3219](https://github.com/KaTeX/KaTeX/issues/3219)

## [0.13.16](https://github.com/KaTeX/KaTeX/compare/v0.13.15...v0.13.16) (2021-08-28)


### Bug Fixes

* \char support for >16-bit Unicode characters ([#3006](https://github.com/KaTeX/KaTeX/issues/3006)) ([ff1734f](https://github.com/KaTeX/KaTeX/commit/ff1734f7c4882fb350cb0e1f366f04ce63675643)), closes [#3004](https://github.com/KaTeX/KaTeX/issues/3004)
* remove local macros upon parse error ([#3114](https://github.com/KaTeX/KaTeX/issues/3114)) ([a6f29e3](https://github.com/KaTeX/KaTeX/commit/a6f29e36121a31b46866d1985bbc86a06080fbd4)), closes [#3122](https://github.com/KaTeX/KaTeX/issues/3122)

## [0.13.15](https://github.com/KaTeX/KaTeX/compare/v0.13.14...v0.13.15) (2021-08-28)


### Features

* text-mode cedilla accent via \c ([#3036](https://github.com/KaTeX/KaTeX/issues/3036)) ([952fb84](https://github.com/KaTeX/KaTeX/commit/952fb844da9c99d5fca41a87b86e8857a677c899)), closes [#638](https://github.com/KaTeX/KaTeX/issues/638)

## [0.13.14](https://github.com/KaTeX/KaTeX/compare/v0.13.13...v0.13.14) (2021-08-28)


### Bug Fixes

* **fonts:** update fonts dependencies ([#2866](https://github.com/KaTeX/KaTeX/issues/2866)) ([ea409ea](https://github.com/KaTeX/KaTeX/commit/ea409eaf1d7f8fe712a966edc66c545ae5fe5425))

## [0.13.13](https://github.com/KaTeX/KaTeX/compare/v0.13.12...v0.13.13) (2021-07-21)


### Bug Fixes

* add namespace for svg, making output XHTML+SVG+MathML compatible ([#2725](https://github.com/KaTeX/KaTeX/issues/2725)) ([35ff5ac](https://github.com/KaTeX/KaTeX/commit/35ff5ac2231b53fdb849f639611e0e44c01aa16b))

## [0.13.12](https://github.com/KaTeX/KaTeX/compare/v0.13.11...v0.13.12) (2021-07-21)


### Bug Fixes

* Correct invalid box-sizing property, adjusting spacing of \angl ([#3053](https://github.com/KaTeX/KaTeX/issues/3053)) ([910e523](https://github.com/KaTeX/KaTeX/commit/910e523633da555a758dd176fb28ec139ed3b608)), closes [#3052](https://github.com/KaTeX/KaTeX/issues/3052)

## [0.13.11](https://github.com/KaTeX/KaTeX/compare/v0.13.10...v0.13.11) (2021-05-14)


### Bug Fixes

* matrix environment with zero or inconsistent columns ([#3018](https://github.com/KaTeX/KaTeX/issues/3018)) ([f779bac](https://github.com/KaTeX/KaTeX/commit/f779bac684c16c8f513b57b37f855f0772dc20d1)), closes [#3017](https://github.com/KaTeX/KaTeX/issues/3017)


### Features

* Allow text-mode accents in math mode, except in strict mode ([#3009](https://github.com/KaTeX/KaTeX/issues/3009)) ([0e9acce](https://github.com/KaTeX/KaTeX/commit/0e9acce9bef7b8001067ef3aa3ed188418278b2d)), closes [#2983](https://github.com/KaTeX/KaTeX/issues/2983)

## [0.13.10](https://github.com/KaTeX/KaTeX/compare/v0.13.9...v0.13.10) (2021-05-12)


### Bug Fixes

* Correct for negative margin in integrand lower limits ([#2987](https://github.com/KaTeX/KaTeX/issues/2987)) ([9b4acc9](https://github.com/KaTeX/KaTeX/commit/9b4acc971c4d3d0d05960ed2237a4bbcabde2e39))

## [0.13.9](https://github.com/KaTeX/KaTeX/compare/v0.13.8...v0.13.9) (2021-05-07)


### Bug Fixes

* MathML for stretchy accents. [#2990](https://github.com/KaTeX/KaTeX/issues/2990) ([#2991](https://github.com/KaTeX/KaTeX/issues/2991)) ([1cb6279](https://github.com/KaTeX/KaTeX/commit/1cb62799c6b9484df5c5ba500f5144f61a24288d))

## [0.13.8](https://github.com/KaTeX/KaTeX/compare/v0.13.7...v0.13.8) (2021-05-06)


### Features

* \operatornamewithlimits (and clean up \operatorname support) ([#2984](https://github.com/KaTeX/KaTeX/issues/2984)) ([e9b751b](https://github.com/KaTeX/KaTeX/commit/e9b751b72d08ff2ceed71062e3bf84c8020d684f))

## [0.13.7](https://github.com/KaTeX/KaTeX/compare/v0.13.6...v0.13.7) (2021-05-06)


### Bug Fixes

* binom delimiter size in scriptscriptstyle. ([#2976](https://github.com/KaTeX/KaTeX/issues/2976)) ([980b004](https://github.com/KaTeX/KaTeX/commit/980b0040232f5b7d2162d4067ed4bce431933286))

## [0.13.6](https://github.com/KaTeX/KaTeX/compare/v0.13.5...v0.13.6) (2021-05-06)


### Bug Fixes

* Correctly parse \ followed by whitespace ([#2877](https://github.com/KaTeX/KaTeX/issues/2877)) ([c85250d](https://github.com/KaTeX/KaTeX/commit/c85250d14e7dcace95eca76a66973d10d1b6ee9f)), closes [#2860](https://github.com/KaTeX/KaTeX/issues/2860)

## [0.13.5](https://github.com/KaTeX/KaTeX/compare/v0.13.4...v0.13.5) (2021-05-02)


### Bug Fixes

* Support \S and \P in math mode ([#2977](https://github.com/KaTeX/KaTeX/issues/2977)) ([3f7163d](https://github.com/KaTeX/KaTeX/commit/3f7163daf57b5c0bd7441e029170305557f0ab4e))

## [0.13.4](https://github.com/KaTeX/KaTeX/compare/v0.13.3...v0.13.4) (2021-05-02)


### Bug Fixes

* Avoid crash when \operatorname has \limits ([#2979](https://github.com/KaTeX/KaTeX/issues/2979)) ([fbda0b1](https://github.com/KaTeX/KaTeX/commit/fbda0b1136cfe3f1a0c47f16a2a1e1e99c284ea8))

## [0.13.3](https://github.com/KaTeX/KaTeX/compare/v0.13.2...v0.13.3) (2021-04-24)


### Bug Fixes

* Respect catcode in macro expansion and set ~'s catcode correctly ([#2949](https://github.com/KaTeX/KaTeX/issues/2949)) ([01ae7f8](https://github.com/KaTeX/KaTeX/commit/01ae7f8eef09bcddc6e327c2cb5a3460800652d5)), closes [#2924](https://github.com/KaTeX/KaTeX/issues/2924)
* **array:** Keep single empty row in AMS environments ([#2947](https://github.com/KaTeX/KaTeX/issues/2947)) ([24332e0](https://github.com/KaTeX/KaTeX/commit/24332e053c0f33b37e6d30384b42232f321a6fc7)), closes [#2944](https://github.com/KaTeX/KaTeX/issues/2944)

## [0.13.2](https://github.com/KaTeX/KaTeX/compare/v0.13.1...v0.13.2) (2021-04-06)


### Bug Fixes

* update version and SRI in dist/README.md ([#2905](https://github.com/KaTeX/KaTeX/issues/2905)) ([319c52d](https://github.com/KaTeX/KaTeX/commit/319c52db6433f5fc5327b1f3f32ff361e6a00e50))

## [0.13.1](https://github.com/KaTeX/KaTeX/compare/v0.13.0...v0.13.1) (2021-04-05)


### Bug Fixes

* Protect fraction bars from CSS border-color ([#2870](https://github.com/KaTeX/KaTeX/issues/2870)) ([2f62c0d](https://github.com/KaTeX/KaTeX/commit/2f62c0d8ee8135f4d5b7fe727add6ad25d5c86a0))

## [v0.13.0]
### See https://github.com/KaTeX/KaTeX/issues/2490 for breaking changes and migration guide!

### Bug Fixes
- fix: Remove topEnv parameter. (#2712)
- fix(builder): combine characters together in all expressions (#2080)
- fix: Prevent global group from adversely affecting color. (#2703)
- fix: Use SVGs to avoid gaps in tall delimiters. (#2698)
- fix: rewrite of splitAtDelimiters.js -- new fix for #2523 (#2679)
- fix: Improve MathML for math operators with subscripts (#2596)
- fix: Remove premature CD screenshotter images (#2641)
- fix: Support Armenian characters (#2618)
- fix: MathML \lim\limits in Safari (#2556)
- fix: Support MathML \oiint and \oiiint (#2461)
- fix: \injlim typo (#2459)

### Features
- feat: Support \underbar (#2713)
- feat: Add {CD} to auto-render. (#2710)
- feat: Set Auto-render to recognize AMS environments without $$…$$ delimiters. (#2701)
- feat: Support {CD} (#2396)
- feat: Support \vcenter and \hbox (#2452)
- feat(function): add `allowedInArgument` instead of `greediness` property (#2134)
- feat: Support matrix*, pmatrix*, bmatrix*, Bmatrix*, vmatrix*, and  Vmatrix*. (#2488)
- feat(macro): improve argument parsing (#2085)
- feat: support AMS log-like symbols (#2429)
- feat: support Unicode ◯, U+25EF (#2430)
- feat: Support \phase (#2406)
- feat: Support \mathstrut (#2416)
- feat: support {equation}, {equation*}, and {split} (#2369)
- feat(css): use postcss-preset-env (#2313)
- feat: support {align}, {align*}, {alignat}, and {alignat*} (#2341)
- Support {gather} and {gather*} (#2183)
- feat: support MathML \big, \bigg, \Big, and \Bigg (#2332)
- feat: support \angl and \angln (#2334)
- Support \origof and \imageof (#2283)

### Documentation
- docs: Add TiddlyWiki to list of users (#2765)
- docs: Fix fallback CSS classes (#2809)
- docs: Rearrange environment documentation. (#2700)
- docs: Explain how to make macros persist. (#2702)
- docs: Revise placement of colonequals in Relations table (#2704)
- docs: delete stray backtick (#2680)
- docs: Add colonequals functions to docs (#2651)
- docs: add new user link (#2597)
- fix: typo in example on homepage (#2577)
- docs: Add \char to support_table. (#2620)
- docs: Update \operatorname in supported_table.md 0.12.0 (#2571)
- docs: Fix documentation typo in operatorname* (#2570)
- docs: add warning re:defer to mhchem documentation (#2485)
- docs: update Gastby logo and link (#2481)
- docs: add MonsterWriter to the users page (#2478)
- docs: add comment re: \arrowvert (#2449)
- docs: add link to Discussions (#2405)
- Update \color documentation (#2370)
- docs: add Marker as a KaTeX user (#2329)

### Other Changes
- ci: run screenshotter in container (#2644)
- ci: setup CodeQL code scanning (#2645)
- fix(browserslist): remove Chrome 49, Samsung 4, and Node (#2591)
- chore: add devcontainer.json (#2545)
- Configure Renovate (#2493)
- ci: don't persist credentials and run scripts (#2450)
- build: upgrade Yarn to 2.2.0 (#2477)
- build: make vscode work with PnP (#2444)
- refactor: Delete obsolete comment re: mn elements (#2472)
- test: lint all js files and inline scripts in workflow (#2442)
- refactor: Delete obsolete comment re: limsup (#2464)
- ci: migrate to GitHub Actions from CircleCI, allow running Browserstack on forked repo via label (#2417)
- ci: enable Dependabot for website, submodules, and GitHub Actions (#2424)
- test: add missing screenshots for safari (#2423)
- ci: fix Dependabot autofix (#2400)
- chore: don't include `dist` in the release commit (#2385)
- ci: autofix Dependabot commits (#2394)
- chore(screenshotter): support Browserstack and test on Safari 13.1 (#2306)
- chore: enable Gitpod (#2335)
- chore: migrate to Yarn 2 (#2316)
- test: mock console implementation (#2363)
- Update LICENSE year (#2374)
- test(screenshotter): move coverage to Jest (#2324)
- Fix test/symgroups.js (#2314)
- Use base revision provided by CircleCI (#2309)
- Delete bower.json (#2372)
- Enable a MathML option in the KaTeX demo. (#2371)
- Create dependabot.yml (#2311)
- Run screenshotter using Chrome 83 and Firefox 76 (#2304)


## [v0.12.0]
### Added
- `globalGroup` option to place definitions in global scope (#2091)
- `\cal` (#2116)
- `{rcases}` and `{drcases}` (#2149)
- HTML extension (#2082)
  - HTML extension can be enabled using `strict` and `trust` setting. See https://katex.org/docs/options.html for more details. **Please review its security implication before enabling the extension.**
- `\message`, `\errmessage`, and `\show` for debugging (#2135)
- bra-ket notation (#2162)
- `\expandafter`, `\noexpand`, `\edef`, `\let`, and `\long` (#2122)
- Support MathML display mode (#2220)
- `\minuso` (#2213)

### Changed
- Update documentation (#2086, #2108, #2107, #2106, #2143, #2178, #2195, #2231, #2239, #2263, #2279, #2289, #2280. #2269, #2294, #2296, #2297)
- `mathtex-script`: Use html 'defer' attribute (#2069)
- `auto-render`: do not touch text nodes w/o formulas (#2154)
- Move \global and \def to functions (#2138)
- Cleanup font build scripts & font updates (#2155, #2171, #2156)
  - **BREAKING CHANGE:** old-style numerals are now available via `\mathnormal` instead of `\mathcal`
- Upgrade minimum development Node version to v10 (#2177)

### Removed
- **BREAKING CHANGE:** IE 9/10 support (#2136)

### Fixed
- Set `border-collapse: collapse` in vlist, fix misalignment in table (#2103)
- `\@ifnextchar` consumes spaces (#2118)
- Add spacing on left of fleqn display math (#2127)
- Fix `\boxed` inherited color (#2130)
- Fix laps having visible width in Safari (#1919)
- Improve MathML for corners (#1922)
- `auto-render`: ignore "option" tags (#2180)
- Fix delimiter error message (#2186)
- Fix under accent depth (#2252)
- Enable empty environment (#2258)
- Enable an empty `\substack` (#2278)
- Fix jagged parentheses (#2234)
- `\boldsymbol` not italic for textords such as Greek (#2290, #2299)
- Protect fraction bars from CSS border-color (#2292)
- Reset to leftmost spacing mode after newline (#1841)
- Fix missing metrics for space (0x20) and no-break space (0xa0) (#2298)


## [v0.11.1]
### Changed
- [Security] Bump mixin-deep from 1.3.1 to 1.3.2 (#2090)
- [Security] Bump eslint-utils from 1.3.1 to 1.4.2 (#2089)

### Fixed
- Fix parse timing by separating consume() into fetch() and consume() (#2054)
- Use current font for accents (#2066)
- Fix \gray's macro definition (#2075)

## [v0.11.0]
### Added
- **BREAKING CHANGE:** trust setting to indicate whether input text is trusted (#1794)
  - `\href` and `\url` will break without adjusting the trust setting
- Add test for double square brackets to katex-spec (#1956)
- Add option to render only MathML so that its visible (#1966)
- Support {smallmatrix}, {subarray}, and \substack (#1969)
- Enable minRuleThickness in rendering options (#1964)
- Add \plim (#1952)
- Support Unicode \digamma (#2010)
- Support \operatorname* (#1899)
- Support \includegraphics, with appropriate trust setting (#2053)
- Add render-a11y-string add-on (#2062)

### Changed
- DOC: Fix path to built file (#1976)
- Remove unclosed TODO comment (#1979)
- Add "Tutti Quanti Shelf" app to users page (#1997)
- Document mhchem \cf not supported (use \ce instead) (#2008)
- Replace greenkeeper badge with dependabot badge (#2022)
- Add Unicode digamma to documentation (#2045)
- Add katex-expression to libs page (#2049)
- Suggest <!DOCTYPE html> in documentation (#2052)
- Unicode characters in math render in text mode (#2040)

### Fixed
- Improve output of fonts in MathML (#1965)
- Fix \pmb (#1924)
- \color affects following \right, put array cells in their own groups (#1845)
- Improve MathML for classes (#1929)
- Prevent gaps in tall delimiters (#1986)
- Fix \sqrt SVG path (#2009)
- Do not force sizing groups to display inline-block (#2044)
- Fix font choice in operators like \log (e.g. \boldsymbol{\log}) (#2041)
- Fix argument font sizing in \fbox and \raisebox, fix font sizing in \TeX, \LaTeX, \KaTeX (#1787)

## [v0.10.2]
### Added
- Approximate font metrics only when metrics don't exist (#1898)
- Add KaTeX version to stylesheet and troubleshooting guide (#1893)
- Add symbol double square brackets (#1947, #1954)
- Support double-square curly braces (#1953)

### Changed
- Upgrade minimum development Node version to v8 (#1861)
- Disable @babel/env debug (#1874)
- Add issue templates (#1862)
- Added 'katex-element' (#1905)
- Fix Users' logo and url (#1896)
- Load fonts before running screenshotter (#1891)
- Add Browserstack logo (#1879)
- Added Android library (#1943)
- Move custom colors used by Khan into macros.js (#1933)
- Test for duplicate symbols/macros (#1955)
- Include extensions mhchem & copy-tex in home-page (#1932)

### Fixed
- Fix \Rho (#1870)
- Fix nested \dfrac (#1825)
- Improve MathML accents (#1877)
- Improve MathML for \overset, \stackrel, and \underset (#1886)
- Fix \not (U+E020) RBearing (width) (#1878)
- Fix ApplyFunction character (#1890)
- Improve MathML for \limits (#1897)
- Improve MathML for \hphantom and \vphantom (#1883)
- Improve MathML for \coloneqq, \dblcolon, \eqcolon, and \eqqcolon (#1889)
- Improve MathML for \brace (#1884)
- Fix \middle spacing (#1906)
- Get a tall \middle\vert from MathML (#1911)
- Improve more coloneq (#1902)
- Make \smallint small in \displaystyle (#1907)
- Improve MathML for characters in Unicode private use area (#1908)
- Improve MathML for extensible arrows (#1901)
- Improve MathML for \rule (#1912)
- Improve MathML for fractions (#1882)
- Improve MathML for \tag (#1915)
- Improve MathML for \colorbox and \fcolorbox (#1914)
- Improve MathML for environments (#1910)
- Improve MathML for \genfrac barline (#1925)
- Support \textup and \textmd (#1921) 
- Improve MathML for \not (#1923)
- Improve MathML for \Bbbk (#1930)
- Prevent inadvertent tall delims (#1948)

### Removed
- Re-added code for \includegraphics but disabled the function until trust settings is merged (#1951) 

## [v0.10.1]
### Added
- ECMAScript module for contrib (#1624)
- mhchem extension (#1436)
- auto-render: optional pre-process callback (#1784)
- \argmax and \argmin (#1820)
- \textbackslash and \textasciicircum (#1839)
- leqno and fleqn support (#1814)

### Changed
- Include only necessary fonts for target environment specified by Browserslist (#1674)

### Fixed
- Support blackboard bold in text mode (#1757)
- Fix spacings in semisimple groups (#1706)
- Fix parsing comments (#1789)
- Fix \\ and \newline after operator (#1796)
- Fix \hphantom width (#1809)
- Remove double encoding in MathML (#1813)
- Fix Unicode bigcup (#1836)
- Fix \genfrac w/ empty delimiter arguments (#1816)
- \fbox inherits default color (#1847)
- Fix \not and \neq on Chrome 72 (#1852)


## [v0.10.0]
### Added
- Unicode: °, delimiters, 1D400-1D7FF, \ll, \lll, ≘≙≚≛≝≞≟, Unicode Mathematical Alphanumeric Symbols, ⟂ ¬ ⊨ ‼ ∌ ≲ ⩽ ⪅ ≶ ⋚ ⪋, corner, ⟦⟧ (#1203, #1207, #1260, #1273, #1274, #1232, #1377, #1389, #1459, #1750)
- \yen support on text mode (#1208)
- `\(` (#1213)
- Add defineSymbol to the main katex object (#1263)
- Capital Greek letters (#1283, #1285)
- Add version to katex object (#1279, #1475)
- \copyright, \textregistered, \textcircled (#1073)
- Tilde \textasciitilde (#1286)
- Line breaks for inline formulas (#1287)
- \hline (#1306)
- Top-level \newline and `\\` in inline math (#1298)
- Strict mode, unicode text in math mode (#1117, #1278)
- Strict setting for \newline display-mode behavior (#1314)
- Allow all Unicode symbols in nonstrict mode (#1217)
- \tag, \tag*, and \gdef (#1309)
- \def, \gdef, and \global\def (#1348, #1425)
- Change default maxExpand limit to 1000 (#1383)
- \cfrac (#1392)
- \arraystretch as a macro definition (#1381)
- Add ability to create a dashed vertical line in arrays, using ':' (#1395)
- \widecheck (#1406)
- \hdashline (#1407)
- \newcommand, \renewcommand, \providecommand (#1382)
- Add a utility function (setFontMetrics) to extend builtin fontMetrics (#1269)
- \oiint and \oiiint (#1430)
- Remove `match-at` dependency, use RegExp for lexer (#1447)
- \brace and \brack (#1453)
- Allow only allowed protocols in \href (#1440)
  - **BREAKING CHANGE:** Only "http", "https", "mailto", and relative URLs are allowed in \href and \url by default.
- \genfrac and \above (#1455, #1458)
- \char character escaping and nicer MathML via \html@mathml (#1454)
- \@binrel (#1487)
- \pmb (#1418)
- KaTeX website & documentation (#1484, #1515, #1518, #1514, #1526, #1516, #1519, #1527, #1564, #1566, #1584, #1571, #1642, #1680, #1683, #1688, #1631, #1727)
- Improve supported functions documentation (#1511, #1517, #1532, #1533, #1576, #1556, #1580, #1602)
- Alpha sorted function support page (#1536)
- MediaWiki (texvc) (#1558)
- Add ignore option for class names in auto-render (#1555)
- ScrollSpy for table of contents in the documentation (#1557, #1567, #1568)
- Build ECMAScript modules (#1479, #1622, #1653)
- Enable environment variable USE_TTF to disable bundling TTF fonts (#1600)
- List of KaTeX users (#1569, #1579)
- Browserslist (#1662)
- 6-digit color without # (#1690)
- \mathnormal (#1700)
- \lparen and \rparen (#1741)
- `\>` (#1752)

### Changed
- Port to @flow: delimiter, spacingData, unicodeSymbols, buildHTML, buildMathML, parseNode, defineFunction, CssStyle (#1177, #1195, #1206, #1239, #1247, #1276, #1312, #1324, #1361, #1373, #1393, #1386, #1387, #1408, #1478, #1486, #1534, #1541, #1542, #1551, #1552, #1554, #1559, #1606, #1609, #1612, #1637, #1684)
- Online screenshot diff/generation using CircleCI (#1187)
- Add display/displayMode toggle on test page (#1193)
- Change CDN links (#1243)
- Changelog for KaTeX (#1322)
- Move test helpers into common modules (#1318)
- Move function handlers to functions/ (#1323, #1325, #1328, #1329, #1331, #1327, #1334, #1339, #1349, #1359, #1332, #1335)
- Improve screenshotter (#1220, #1644, #1643)
- Upgrade to webpack 4 (#1337, #1435)
- Automatic submodule updating via husky tool (#1391)
- Refactor test helpers (#1336)
- Change build directory to `dist` and cleanup NPM scripts (#1500, #1610)
- Switch from nomnom to commander (#1496)
- Add test job to CircleCI (#1235, #1658)
- Switch npm to Yarn (#1522, #1528)
- Improve release script & enable versioning documentation (#1521, #1603, #1660, #1665)
- Enable stylelint-config-standard, lint CSS files (#1575)
- Rename Screenshotter -> screenshotter (#1573)
- Refactor buildCommon (#1633, #1640)
- Upgrade to Babel 7 (#1595)
- Refactor Parser (#1711, #1723)

### Fixed
- Fix nested math mode in non-default text mode (#1111)
- Fix contenteditable mode (#1179)
- Work around negative space bug in Chrome (#1194)
- Fix \nobreakspace (#1200)
- Fix instant mode switching for $, \(, \text (#1213)
- Add metrics for \S and \P (#1224)
- Fix anchor.toMarkup (#1246)
- Specify height for SVG elements (#1252)
- Include Bold-Italic fonts for \boldsymbol (#1257)
- Fix space width in \texttt (#1261)
- Fix \underset (#1277)
- Remove special \verb space handling now that space is in Typewriter-Regular (#1258)
- Switch makeGlue from .mord .rule to .mspace (#1295)
- Fix ~ in \verb (#1286)
- Stop throwing ParseError when throwOnError is false (#1169, #1302, #1308)
- Fix extensible arrow sup vertical alignment (#1256)
- Adjust \underset alignment and spacing (#1290)
- Revert frac-lines and \rule to borders (min-height) (#1249, #1417, #1594)
- Fix vertical alignment of \underbrace (#1304)
- Use one strut instead of two (#1307)
- Fix MacroExpander space handling (#1314)
- Cleanup MathML `<mrow>`, `<mtext>`, `<mn>` (#1338)
- Fix lap vertical alignment. (#1162)
- Fix nested \tfrac (#1370)
- Fix \coloneq etc (#1372)
- Fix wide character spacing (#1371)
- Fix auto-render \\[…] bug (#1375)
- Rewrite spacing commands as macros (#1156)
- Enable output modules to be used in browser or Node (#1401)
- Add vertical kern to \vdots (#1402)
- Implement \neq and \notin via macros like LaTeX's (#1400, #1499)
- Improve \cancel (#1398)
- Fix ligatures vs. \tt (#1379)
- Implement \colon as amsmath does (#1410)
- Automatic mrel/mbin spacing for \boldsymbol (#1388)
- Phantom text (#1449)
- Fix arrowheads for mhchem <--> (#1451)
- Set `documentFragment.style` to empty object (#1471)
- Remove tree cloning before building HTML (#1470)
- Fix \operatorname to support general math functions (#1461)
- Use \not character without left side-bearing correction (#1267)
- Remove codes that require expensive polyfill (#1469, #1563, #1591, #1597)
- Fix \not vertical alignment (#1497)
- Comments without terminating newlines, \href fixes, \url support (#1529)
- Fix \textdaggerdbl (#1539)
- Fix \neq (#1548, #1574)
- Fix wide characters (#1549)
- Fix \fbox (#1550)
- Fix \Large roots (#1485)
- index.html: replace font, make responsive, improve demo (#1547, #1577, #1615, #1601)
- Remove duplicate defineFunction invocation for \mathop (#1701)
- Fix tag positioning to live within katex-html parent (#1721)
- Fix \mathit font and italic correction (#1700)


## [v0.9.0] - 2018-02-18
### Added
- Italic Greek capital letters [#1118](https://github.com/KaTeX/KaTeX/pull/1103)
- Added support for `\mathring` [#1125](https://github.com/KaTeX/KaTeX/pull/1125)
- Added support for unicode angle brackets, single vertical bar, double vertical bar [#1123](https://github.com/KaTeX/KaTeX/pull/1123)
- Added support for Reaction Arrows [#1078](https://github.com/KaTeX/KaTeX/pull/1078)
- Added `\nobreakspace` [#1145](https://github.com/KaTeX/KaTeX/pull/1145)
- Added support for Unicode colon equals ≔ [#1151](https://github.com/KaTeX/KaTeX/pull/1151)
- Added support for `\underline` in text mode [#1159](https://github.com/KaTeX/KaTeX/pull/1159)

### Changed
- Enable spacing functions in text mode [#1139](https://github.com/KaTeX/KaTeX/pull/1139)

### Fixed
- Improved JS spacing [#1103](https://github.com/KaTeX/KaTeX/pull/1103)
- Fixed handling of Unicode characters ð, Å, å [#1157](https://github.com/KaTeX/KaTeX/pull/1157)
- Padding over `\sqrt` and Paths for frac-line [#1143](https://github.com/KaTeX/KaTeX/pull/1143)


## [v0.9.0-beta1] - 2018-01-28
### Added
- Added support for `\aa`, `\AA`, `\lq`, `\rq`, `\lbrack`, `\rbrack` [#1069](https://github.com/KaTeX/KaTeX/pull/1069)
- Added support for more scripts in `\text{}` environments such as Czech, Georgian, Hungarian, Turkish. [#1076](https://github.com/KaTeX/KaTeX/pull/1076)
- add Main-BoldItalic font to allow nesting of `\textit` and `\textbf`
- Added `\S` and `\P` [#1110](https://github.com/KaTeX/KaTeX/pull/1110)

### Changed
- Remove symlink to support devs using Windows [#1090](https://github.com/KaTeX/KaTeX/pull/1090)

### Fixed
- Do not inherit SVG style properties from the environment. [#1089](https://github.com/KaTeX/KaTeX/pull/1089)
- Update fonts and metrics so that accents are positioned correctly [#1094](https://github.com/KaTeX/KaTeX/pull/1094)
- Non-portable use of String method `.includes`. Fixed [#1093](https://github.com/KaTeX/KaTeX/issues/1093)
- Use correct spacing with tight styles. See [#1106](https://github.com/KaTeX/KaTeX/pull/1106) for more details.


## [v0.9.0-beta] - 2018-01-14
### Added
- `\kern` fixed and support `\hskip`, `\TeX`, `\LaTeX`, `\KaTeX`. See [#974](https://github.com/KaTeX/KaTeX/pull/974)
- Supported Unicode middle dot and Unicode accents.
- Added basic support for Indic scripts in addition to CJK. [#1060](https://github.com/KaTeX/KaTeX/pull/1060)
- Added support for bold italic symbols. [#1011](https://github.com/KaTeX/KaTeX/pull/1011)
- add `\ae`, `\AE`, `\oe`, `\OE`, `\o`, `\O`, `\ss` with unicode support for those characters in text mode. [#1030](https://github.com/KaTeX/KaTeX/pull/1030)
- Added `\i` and `\j` for text mode. [#1029](https://github.com/KaTeX/KaTeX/pull/1029)
- Added `buildHTMLTree`. [#1022](https://github.com/KaTeX/KaTeX/pull/1022)
- Implemented `\TextOrMath`, @secondoftwo. [#1024](https://github.com/KaTeX/KaTeX/pull/1024)
- Added a 'common issues' section to the `README.md`. [#1034](https://github.com/KaTeX/KaTeX/pull/1034)

### Changed
- Made a more working example in README.md. Fixed [#1049](https://github.com/KaTeX/KaTeX/issues/1049) PR is [#1050](https://github.com/KaTeX/KaTeX/pull/1050)
- Exposing the build tree. [#1017](https://github.com/KaTeX/KaTeX/pull/1017)
- Changed `\xLongequal` to `\xlongequal`. [#997](https://github.com/KaTeX/KaTeX/pull/997)

### Fixed
- Avoid negative space in `\bmod`. [#984](https://github.com/KaTeX/KaTeX/pull/984)
- Stacking text commands. [#1009](https://github.com/KaTeX/KaTeX/pull/1009)
- Fixed `\vec` by replacing the combining font glyph with an SVG. [#1018](https://github.com/KaTeX/KaTeX/pull/1018)
- Made accents zero width. [#1033](https://github.com/KaTeX/KaTeX/pull/1033)
- Fixed frac-line. [#1025](https://github.com/KaTeX/KaTeX/pull/1025)
- Implemented correct macros for `liminf` and `limsup`. Fixed [#111](https://github.com/KaTeX/KaTeX/issues/111)
- `\kern` generates right-margin instead of left-margin. Fixed [#995](https://github.com/KaTeX/KaTeX/issues/995)


## [v0.9.0-alpha2] - 2017-11-26
### Added
- Added Unicode Relations and Unicode Symbol support. Supports Unicode ∴, ∵, `\mid`, Arrows, Big Operators, Binary Operators, Negated Relations.
- Implemented the `alignedat` environment for flexible math spacing. [#930](https://github.com/KaTeX/KaTeX/pull/930)
- Implemented `\mathchoice` command. [#969](https://github.com/KaTeX/KaTeX/pull/969)
- Implemented `\href` command. [#923](https://github.com/KaTeX/KaTeX/pull/923)
- `\hspace*`, `\@ifstar`, `\@ifnextchar`, `\@firstoftwo` (#975)
- Added `\notni` character `∌`. [#710](https://github.com/KaTeX/KaTeX/pull/710)
- Added ng-katex link to README.md. [#959](https://github.com/KaTeX/KaTeX/pull/959)

### Changed
- Single-character macros like active characters. [#973](https://github.com/KaTeX/KaTeX/pull/973)
- Re `@flow`:
  - Port buildTree, katex, mathMLTree, parseTree, stretchy to @flow.

### Fixed
- Fixed the spacing between columns in the {aligned} environment. [#942](https://github.com/KaTeX/KaTeX/pull/942)
- Fixed issue where the {aligned} environment skips the last line if the first column is empty. [#949](https://github.com/KaTeX/KaTeX/pull/949)
- Appended `ApplyFunction` to math functions in MathML. [#960](https://github.com/KaTeX/KaTeX/pull/960)
- Changed `\undertilde` to `\utilde`. [#948](https://github.com/KaTeX/KaTeX/pull/948)
- Changed `frac-line` from border to full span. [#976](https://github.com/KaTeX/KaTeX/pull/976)


## [v0.9.0-alpha1] - 2017-10-15
### Changed
- Edited link to Function Support page. [#922](https://github.com/KaTeX/KaTeX/pull/922)
- Re `@flow`:
  - Exported svgGeometry to @flow. [#936](https://github.com/KaTeX/KaTeX/pull/936)
  - Ported utils to @flow. [#935](https://github.com/KaTeX/KaTeX/pull/935)

### Fixed
- Fixed space handling. [#912](https://github.com/KaTeX/KaTeX/pull/912)
- Prevents disappearing fraction lines. [#931](https://github.com/KaTeX/KaTeX/pull/931)


## [v0.9.0-alpha] - 2017-10-05
### Added
- Added MathJax compatibility script. [#680](https://github.com/KaTeX/KaTeX/pull/680)
- Added a maxSize option to limit user-specified sizes. [#803](https://github.com/KaTeX/KaTeX/pull/803)
- Added `\smash`, laps, spaces, and phantoms. [#833](https://github.com/KaTeX/KaTeX/pull/833)
- Support for `\raisebox`, `\operatorname`, `\And`, `\colorbox`, `\fcolorbox` and `\verb`.
- Added support for comments. Fixed [#20](https://github.com/KaTeX/KaTeX/issues/20)
- To `@flow`:
  - fontMetrics, fontMetricsData, Token, Lexer, MacroExpander, Options, ParseError, ParseNode, Settings, Style.

### Removed
- Removed the positions array computed by Parser's parseArguments(). [#864](https://github.com/KaTeX/KaTeX/pull/864)

### Changed
- Advanced macro support and magic `\dots`. [#794](https://github.com/KaTeX/KaTeX/pull/794)
- Allow sizing commands inside optional groups. [#885](https://github.com/KaTeX/KaTeX/pull/885)
- Upgraded `\sqrt` zoom and width. [#890](https://github.com/KaTeX/KaTeX/pull/890)
- Refactored defineEnvironment to also accept HTML and MathML builders. [#875](https://github.com/KaTeX/KaTeX/pull/875)
- For `@flow`:
  - Ported environments.js, functions.js, symbol.js, unit.js.
- Separated mandatory and optional arguments in parseArguments. [#903](https://github.com/KaTeX/KaTeX/pull/903)

### Breaking Changes
- Require [text]color HTML colors to be well-formed. See [#827](https://github.com/KaTeX/KaTeX/pull/827)
- `\llap` and `\rlap` now render contents in math mode. Use `\mathllap` (new) and `\mathrlap` (new) if you need the previous behavior.

### Fixed
- Fixed exponential behavior in accent production. [#834](https://github.com/KaTeX/KaTeX/pull/834)
- Use mpadded for `\raisebox` MathML. [#876](https://github.com/KaTeX/KaTeX/pull/876)
- Array/Matrix environments do not trim newlines. Fixed [#337](https://github.com/KaTeX/KaTeX/issues/337). PR is [#479](https://github.com/KaTeX/KaTeX/pull/479).
- For `@flow`:
  - Corrected @flow types. Refactor some Parser code for stricter typing. [#896](https://github.com/KaTeX/KaTeX/pull/896)
  - Fixed match-at flow errors. [#847](https://github.com/KaTeX/KaTeX/pull/847)


## [v0.8.3] - 2017-08-27
### Added
- Added latin-1 letters as math symbols. See [#796](https://github.com/KaTeX/KaTeX/pull/796)
- Added support for `\not`. [#140](https://github.com/KaTeX/KaTeX/pull/140)

### Changed
- Support CJK full-width punctuation + Unicode dots. See [#814](https://github.com/KaTeX/KaTeX/pull/814)
- Support for ```' \` ^ ~ = \u . " \r \H \v``` text-mode accents. See [#802](https://github.com/KaTeX/KaTeX/pull/802)
- Modernized font creation. See [#624](https://github.com/KaTeX/KaTeX/pull/624)

### Fixed
- Use inline SVG for stretchy elements. [#807](https://github.com/KaTeX/KaTeX/pull/807)
- Improve `\sqrt`. [#810](https://github.com/KaTeX/KaTeX/issues/810)


## [v0.8.2] - 2017-08-17
### Added
- Accepts all existing Greek letters using unicode characters in math mode. See [#410](https://github.com/KaTeX/KaTeX/pull/410)

### Fixed
- Fixed MathML output for ' and large operators with limits. [#788](https://github.com/KaTeX/KaTeX/pull/788)
- Updated package.json to point 'main' at dist/katex.js. [#791](https://github.com/KaTeX/KaTeX/pull/791)
- Fixed color support for stretchy, strikethrough, and fbox. [#792](https://github.com/KaTeX/KaTeX/pull/792)
- Detect attachEvent() support correctly. See [#771](https://github.com/KaTeX/KaTeX/issues/771) and [#772](https://github.com/KaTeX/KaTeX/pull/772) for the issue and PR fix respectively.

## [v0.8.1] - 2017-08-11
### Fixed
- Note: The v0.8.0 release did not include the SVG images which are necessary for rendering wide and stretchy accents as well as `\overbrace` and `\underbrace`. This release corrects that.

- Note that if you're including copies of KaTeX in your web application, you should now include the dist/images directory in addition to the usual the dist/fonts directory.

## [v0.8.0] - 2017-08-11
### Added
- Added some international operators. See [#509](https://github.com/KaTeX/KaTeX/issues/509)
- Old font command support: `\rm`, `\sf`, `\tt`, `\bf`, `\it`. [#675](https://github.com/KaTeX/KaTeX/pull/675)
- Builtin macros, macro arguments, `\overset` and `\underset`. [#605](https://github.com/KaTeX/KaTeX/pull/605)
- Added `\iff`, `\implies`, `\impliedby` support. [#697](https://github.com/KaTeX/KaTeX/pull/697)
- Support <, >, | and many `\text`... commands in text mode. [#684](https://github.com/KaTeX/KaTeX/pull/684)
- Implemented $...$ via styling node. [#637](https://github.com/KaTeX/KaTeX/pull/637)
- Added `\jot` lineskip to aligned environment, switch contents to displaystyle, and add gathered. [#725](https://github.com/KaTeX/KaTeX/pull/725)
- Support stretchy wide elements. [#670](https://github.com/KaTeX/KaTeX/pull/670)
- Set maxFontSize on rules. [#744](https://github.com/KaTeX/KaTeX/pull/744)


### Changes
- Added support for Windows high-contrast mode. Fixed [#716](https://github.com/KaTeX/KaTeX/issues/716)  [#724](https://github.com/KaTeX/KaTeX/pull/724)
-Implemented `\coloneqq`, `\colonequals`, etc. based on mathtools and colonequals. [#727](https://github.com/KaTeX/KaTeX/pull/727)
- Added configurable error callback. [#658](https://github.com/KaTeX/KaTeX/pull/658)
- Added support for absolute TeX units. [#732](https://github.com/KaTeX/KaTeX/pull/732)
- Revert "Remove trailing commas for IE 9 compatibility". [#622](https://github.com/KaTeX/KaTeX/pull/622)
- Use utils.deflt for Settings. [#649](https://github.com/KaTeX/KaTeX/pull/649)
- Refactored and commented space splicing code. [#699](https://github.com/KaTeX/KaTeX/pull/699)
- Vertically center single-character `\mathop`. [#745](https://github.com/KaTeX/KaTeX/pull/745)
- Associate font metrics with Options, not Style. [#743](https://github.com/KaTeX/KaTeX/pull/743)
- Upgraded the source to use ES6 syntax including classes, import and static properties.
[#679](https://github.com/KaTeX/KaTeX/pull/679)
- Use `\displaystyle` within `\over/\underbrace`. [#765](https://github.com/KaTeX/KaTeX/pull/765)
- Shrinkwrap vlists in table-like CSS. [#768](https://github.com/KaTeX/KaTeX/pull/768)
- Improve rule coding, including for `\sqrt`. [#776](https://github.com/KaTeX/KaTeX/pull/776)

### Breaking Changes
- Implicit `\color`, explicitly grouped `\textcolor`. See [#619](https://github.com/KaTeX/KaTeX/pull/619)

### Fixed
- Fixed high contrast mode better. [#733](https://github.com/KaTeX/KaTeX/pull/733)
- Fixed all AMS mathord symbols. [#618](https://github.com/KaTeX/KaTeX/pull/618)
- Fixed x'^2 [#636](https://github.com/KaTeX/KaTeX/pull/636)
- Fixed font typo math -> main. [#678](https://github.com/KaTeX/KaTeX/pull/678)
- Fixed spaces before `\middle`. [#689](https://github.com/KaTeX/KaTeX/pull/689)
- Fixed [#711](https://github.com/KaTeX/KaTeX/issues/711) issue with multiple superscripts.  [#718](https://github.com/KaTeX/KaTeX/pull/718)
- Fixed interaction between styles and sizes. [#719](https://github.com/KaTeX/KaTeX/pull/719)
- Correct handling of unbraced kerns followed by spaces. [#751](https://github.com/KaTeX/KaTeX/pull/751)
- Corrected computation of TeX sizes. [#755](https://github.com/KaTeX/KaTeX/pull/755)
- Solved Safari rendering issues with font-size overrides. [#780](https://github.com/KaTeX/KaTeX/pull/780)


## [v0.7.1] - 2017-01-21
### Fixed
- Restored creation of dist directory during release process.


## [v0.7.0] - 2017-01-08
### Added
- Added `\atop`, `\bmod`, `\degree`, `\kern`, `\ldots`, `\maltese`, `\mathbin`, `\mathclose`, `\mathellipsis`, `\mathop`, `\mathopen`, `\mathord`, `\mathpunct`, `\mathrel`, `\middle`, `\mod`, `\pod`, `\pounds`, `\pmod`, `\stackre`, `\textbf`, `\textellipsis`, `\textit`, `\textnormal`, `\textrm`, `\textsf`, `\texttt`, `--`, `---`, `'''`, `'`, `` ``​ and `""`.
- Added `\#`, `\&`, `\$`, `\%`, `\_`, `\{`, and `\}` in text mode.

### Changed
- Allow specifying macros (without arguments) in the settings object.
- Combine adjacent spans in text mode.

### Fixed
- Do not apply italic correction in text mode.
- Fixed the MathML fence attribute on delimiters.
- Fixed converting bins to ords.
- Made `\llap` and `\rlap` produce ords.
- Fixed spacing around `\color`, `\mathbf`, and in other places.
- Added per-style font metrics.
- Complain when trying to render a non-string.
- Fixed subscript positioning with changed-font bases.
- Fixed superscript/subscript centering in fractions.


## [v0.6.0] - 2016-04-15
### Added
- Added  `\gt`, `\lt` and `\underline` support.
- Introduced the aligned environment.

### Removed
- Removed 3px border around rules.

### Changed
- Bundle CSS and fonts in npm package.

### Fixed
- Fixed sub- and super-scripts not being centered inside of math display.
- Set the greediness of font functions to 2 so that `e^\mathbf{x}` will parse.


## [v0.5.1] - 2015-09-01
### Added
- Added the font changing functions `\mathrm`, `\mathit`, `\mathbf`, `\mathbb`, `\mathcal`, `\mathfrak`, `\mathscr`, `\mathsf`, `\mathtt`, `\Bbb`, `\bold`, and `\frak`.
- Added the `\limits` and `\nolimits` functions.
- Added a throwOnError option to allow generating red error text when rendering invalid commands instead of throwing errors, and a corresponding errorColor option to decide the color of invalid commands.
- Added support for `|` column delimiters in the array environment.
- Added `\lVert` and `\rVert` symbols.

### Changed
- Allow `\lvert`, `\rvert`, `\lVert`, `\rVert`, `\lgroup`, `\rgroup`, `\lmoustache`, and `\rmoustache` in delimiters.

### Fixed
- Fix the spacing of the `\ulcorner`, `\urcorner`, `\llcorner`, `\lrcorner`, `\barwedge`, `\veebar`, `\circledcirc`, `\boxdot`, `\uparrow`, `\Uparrow`, `\downarrow`, `\Downarrow`, `\updownarrow`, `\Updownarrow`, and `\ldots` symbols.


## [v0.5.0] - 2015-07-16
### Added
- Added the cases and Bmatrix environments.
- Added `\checkmark` and `\circledR` symbols.

### Changed
- Ran `ttfautohint` on our fonts to produce better results at small font sizes.
- Improved the spacing inside fractions.
- Correctly set environments to the ord type.


## [v0.4.3] - 2015-06-20
### Fixed
- Fixed bower.json to include a "main" entry


## [v0.4.0] - 2015-06-18
### Added
- Added support for some `\begin`/`\end` environments, including support for `array`, `matrix`, `pmatrix`, `bmatrix`, `vmatrix`, and `Vmatrix`.
- Added support for optional `\sqrt` arguments, e.g. `\sqrt[3]{x}`.
- Bower package is now available: run `bower install katex` to download the built files.


### Changed
- Added a display mode flag to the cli.
- Exposed an unstable `__parse` method for retrieving the parse tree.
- Prevent elements from inheriting `text-indent`.


## [v0.3.0] - 2015-04-01
### Added
- Added an auto-render extension for automatically rendering math on a page.
- Added support for `\phantom`.
- Added `\#`, `\&`.

### Removed
- Removed `!important` from MathML hiding rules, so they can be overridden.

### Breaking Changes
- The greediness of the `\color` function has changed to maintain compatibility with MathJax, so expressions like `\color{red}\text{a}` will no longer work and instead need to be rewritten as `\color{red}{\text{a}}`.

### Fixed
- Fixed spacing for `\odot`, `\oplus`, `\otimes`, `\oslash`, `\bigtriangleup`, `\bigtriangledown`, `\dagger`, `\diamond`, `\star`, `\triangleleft`, `\triangleright`.
- Fixed MathML handling of text operators.


## [v0.2.0] - 2015-03-02
### Added
- Added accessibility through the use of MathML.
- Added the ability to render math in display mode, centered on a single line in display style.
- Added support for new symbols: `\aleph`, `\amalg`, `\approxeq`, `\ast`, `\asymp`, `\backepsilon`, `\backprime`, `\backsim`, `\backsimeq`, `\Bbbk`, `\because`, `\beth`, `\between`, `\bigcirc`, `\bigstar`, `\blacklozenge`, `\blacksquare`, `\blacktriangle`, `\blacktriangledown`, `\blacktriangleleft`, `\blacktriangleright`, `\bowtie`, `\Box`, `\boxminus`, `\boxplus`, `\boxtimes`, `\bullet`, `\bumpeq`, `\Bumpeq`, `\Cap`, `\cdotp`, `\centerdot`, `\circeq`, `\circlearrowleft`, `\circlearrowright`, `\circledast`, `\circleddash`, `\circledS`, `\clubsuit`, `\complement`, `\Cup`, `\curlyeqprec`, `\curlyeqsucc`, `\curlyvee`, `\curlywedge`, `\curvearrowleft`, `\curvearrowright`, `\dag`, `\daleth`, `\dashleftarrow`, `\dashrightarrow`, `\dashv`, `\ddag`, `\ddagger`, `\diagdown`, `\diagup`, `\Diamond`, `\diamondsuit`, `\digamma`, `\divideontimes`, `\doteq`, `\Doteq`, `\doteqdot`, `\dotplus`, `\doublebarwedge`, `\doublecap`, `\doublecup`, `\downdownarrows`, `\downharpoonleft`, `\downharpoonright`, `\ell`, `\eqcirc`, `\eqsim`, `\eqslantgtr`, `\eqslantless`, `\equiv`, `\eth, `\exists, `\fallingdotseq`, `\Finv`, `\flat`, `\forall`, `\frown`, `\Game`, `\geqq`, `\geqslant`, `\gg`, `\ggg`, `\gggtr`, `\gimel`, `\gnapprox`, `\gneq`, `\gneqq`, `\gnsim`, `\gtrapprox`, `\gtrdot`, `\gtreqless`, `\gtreqqless`, `\gtrless`, `\gtrsim`, `\gvertneqq`, `\hbar`, `\heartsuit`, `\hookleftarrow`, `\hookrightarrow`, `\hslash`, `\Im`, `\intercal`, `\Join`, `\ldotp`, `\leadsto`, `\Leftarrow`, `\leftarrowtail`, `\leftharpoondown`, `\leftharpoonup`, `\leftleftarrows`, `\leftrightarrow`, `\Leftrightarrow`, `\leftrightarrows`, `\leftrightharpoons`, `\leftrightsquigarrow`, `\leftthreetimes`, `\leqq`, `\leqslant`, `\lessapprox`, `\lessdot`, `\lesseqgtr`, `\lesseqqgtr`, `\lessgtr`, `\lesssim`, `\lgroup`, `\lhd`, `\ll`, `\llcorner`, `\Lleftarrow`, `\lll`, `\llless`, `\lmoustache`, `\lnapprox`, `\lneq`, `\lneqq`, `\lnsim`, `\longleftarrow`, `\Longleftarrow`, `\longleftrightarrow`, `\Longleftrightarrow`, `\longmapsto`, `\longrightarrow`, `\Longrightarrow`, `\looparrowleft`, `\looparrowright`, `\lozenge`, `\lrcorner`, `\Lsh`, `\ltimes`, `\lvertneqq`, `\mapsto`, `\measuredangle`, `\mho`, `\mid`, `\mp`, `\multimap`, `\nabla`, `\natural`, `\ncong`, `\nearrow`, `\nexists`, `\ngeqq`, `\ngeqslant`, `\ngtr`, `\ni`, `\nleftarrow`, `\nLeftarrow`, `\nleftrightarrow`, `\nLeftrightarrow`, `\nleqq`, `\nleqslant`, `\nless`, `\nmid`, `\nparallel`, `\nprec`, `\npreceq`, `\nrightarrow`, `\nRightarrow`, `\nshortmid`, `\nshortparallel`, `\nsim`, `\nsubseteqq`, `\nsucc`, `\nsucceq`, `\nsupseteqq`, `\ntriangleleft`, `\ntrianglelefteq`, `\ntriangleright`, `\ntrianglerighteq`, `\nvdash`, `\nvDash`, `\nVdash`, `\nVDash`, `\nwarrow`, `\ominus`, `\owns`, `\parallel`, `\perp`, `\pitchfork`, `\prec`, `\precapprox`, `\preccurlyeq`, `\preceq`, `\precnapprox`, `\precneqq`, `\precnsim`, `\precsim`, `\propto`, `\Re`, `\restriction`, `\rgroup`, `\rhd`, `\Rightarrow`, `\rightarrowtail`, `\rightharpoondown`, `\rightharpoonup`, `\rightleftarrows`, `\rightleftharpoons`, `\rightrightarrows`, `\rightsquigarrow`, `\rightthreetimes`, `\risingdotseq`, `\rmoustache`, `\Rrightarrow`, `\Rsh`, `\rtimes`, `\searrow`, `\sharp`, `\shortmid`, `\shortparallel`, `\sim`, `\simeq`, `\smallfrown`, `\smallsetminus`, `\smallsmile`, `\smile`, `\spadesuit`, `\sphericalangle`, `\sqcap`, `\sqcup`, `\sqsubset`, `\sqsubseteq`, `\sqsupset`, `\sqsupseteq`, `\square`, `\Subset`, `\subseteqq`, `\subsetneq`, `\subsetneqq`, `\succ`, `\succapprox`, `\succcurlyeq`, `\succeq`, `\succnapprox`, `\succneqq`, `\succnsim`, `\succsim`, `\Supset`, `\supseteqq`, `\supsetneq`, `\supsetneqq`, `\swarrow`, `\therefore`, `\thickapprox`, `\thicksim`, `\triangledown`, `\trianglelefteq`, `\triangleq`, `\trianglerighteq`, `\twoheadleftarrow`, `\twoheadrightarrow`, `\ulcorner`, `\unlhd`, `\unrhd`, `\upharpoonleft`, `\upharpoonright`, `\uplus`, `\upuparrows`, `\urcorner`, `\varkappa`, `\varpropto`, `\varsubsetneq`, `\varsubsetneqq`, `\varsupsetneq` `\varsupsetneqq`, `\vartriangle`, `\vartriangleleft`, `\vartriangleright`, `\vdash`, `\vDash`, `\Vdash`, `\Vvdash`, `\wp`, `\wr`, `\yen`.

### Removed
- Removed unused greek fonts.


## [v0.1.1] - 2014-10-15
### Added
- Added support for `\binom`
- Added support for `\over` and `\choose`
- Added `\partial`, `\subset`, `\supset`, `\subseteq`, `\supseteq`, `\cap`, `\cup`, `\setminus`, `\neg`, `\lnot`, `\top`, `\bot`, `\emptyset`, `\varnothing`, `\land`, `\lor`, `\wedge`, `\vee`, `\notin`, `\nsubseteq`, `\nsupseteq`, `\models`.
- Added simple `katex` command-line binary to convert TeX to HTML on the server.
- Added WOFF2 fonts for faster downloads in Chrome and Opera.

### Changed
- Correctly throws on `\sqrt[3]{x}` to indicate lack of support.
- Warn when in quirks mode (i.e., missing a `<!DOCTYPE html>` declaration).
- Built files now only use ASCII characters to avoid character encoding problems.

### Fixed
- Fixed spacing for `\iint` and `\iiint`.


## [v0.1.0] - 2014-09-15
Initial Public Release
