export const KEYS = {
  Ed25519: {
    jwk: {
      crv: 'Ed25519',
      d: 'lootR5J6UdF-1tvFpnCZzr2N9AmRwgX92MzH_uuaGCQ',
      kty: 'OKP',
      x: 'lBZ9GShvbQEtyyaGs-0Nd4aurH7ERq6UOIvXGb5_tXA',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MC4CAQAwBQYDK2VwBCIEIJaKLUeSelHRftbbxaZwmc69jfQJkcIF/djMx/7rmhgk\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MCowBQYDK2VwAyEAlBZ9GShvbQEtyyaGs+0Nd4aurH7ERq6UOIvXGb5/tXA=\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIIBoTCCAVOgAwIBAgIUde5G4y+mtbb0eRISc7vnINRbSXkwBQYDK2VwMEUxCzAJ\n' +
      'BgNVBAYTAkNaMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQKDBhJbnRlcm5l\n' +
      'dCBXaWRnaXRzIFB0eSBMdGQwIBcNMjIxMDExMTIyMTUzWhgPMjEyMjA5MTcxMjIx\n' +
      'NTNaMEUxCzAJBgNVBAYTAkNaMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQK\n' +
      'DBhJbnRlcm5ldCBXaWRnaXRzIFB0eSBMdGQwKjAFBgMrZXADIQCUFn0ZKG9tAS3L\n' +
      'Joaz7Q13hq6sfsRGrpQ4i9cZvn+1cKNTMFEwHQYDVR0OBBYEFAATzoAtBcYTcOdY\n' +
      'jkcQqsWXipnSMB8GA1UdIwQYMBaAFAATzoAtBcYTcOdYjkcQqsWXipnSMA8GA1Ud\n' +
      'EwEB/wQFMAMBAf8wBQYDK2VwA0EApfw+9jSO0x0IorDfdr5ZVGRBVgrfrd9XhxqQ\n' +
      'Krphj6cA4Ls9aMYAHf5w+OW9D/t3a9p6mYm78AKIdBsPEtT1AQ==\n' +
      '-----END CERTIFICATE-----\n',
  },
  Ed448: {
    jwk: {
      crv: 'Ed448',
      d: '35yNO4M8bgte2BEjaCxrx9epQhzZ4VqF5GhjDaBHGPHHCznFXtmQuOps4XvrNpnVUtiawY4j3FCq',
      kty: 'OKP',
      x: 'pNAfXkImnUHY52ePCZoU4TKCnrq8baLpCiboNxlmN2AbG2xqmLW5F1DA3lsf-S6GWVIfXPysVd0A',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MEcCAQAwBQYDK2VxBDsEOd+cjTuDPG4LXtgRI2gsa8fXqUIc2eFaheRoYw2gRxjx\n' +
      'xws5xV7ZkLjqbOF76zaZ1VLYmsGOI9xQqg==\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MEMwBQYDK2VxAzoApNAfXkImnUHY52ePCZoU4TKCnrq8baLpCiboNxlmN2AbG2xq\n' +
      'mLW5F1DA3lsf+S6GWVIfXPysVd0A\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIIB7DCCAWygAwIBAgIUL85nVDm2evUiy7tWzGv6OxRjclswBQYDK2VxMEUxCzAJ\n' +
      'BgNVBAYTAkNaMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQKDBhJbnRlcm5l\n' +
      'dCBXaWRnaXRzIFB0eSBMdGQwIBcNMjIxMDExMTIyMTQwWhgPMjEyMjA5MTcxMjIx\n' +
      'NDBaMEUxCzAJBgNVBAYTAkNaMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQK\n' +
      'DBhJbnRlcm5ldCBXaWRnaXRzIFB0eSBMdGQwQzAFBgMrZXEDOgCk0B9eQiadQdjn\n' +
      'Z48JmhThMoKeurxtoukKJug3GWY3YBsbbGqYtbkXUMDeWx/5LoZZUh9c/KxV3QCj\n' +
      'UzBRMB0GA1UdDgQWBBSA9Hb5PA/vVojQWg4Per+myWHvCzAfBgNVHSMEGDAWgBSA\n' +
      '9Hb5PA/vVojQWg4Per+myWHvCzAPBgNVHRMBAf8EBTADAQH/MAUGAytlcQNzAN9G\n' +
      '9bFcVViH8c/zexozB/QCtueCu2kLNCLM9auSlFoHEy8u7+Gxyg1O+3bc43YxBObB\n' +
      '+wwH7G+8gKKOkFL/43b7o2HNOlZUDHcWAP25cGY6lDFUvQDc0FGO0ge+h4tt075x\n' +
      'e52JbhpyuHQlrWYQqHQSAA==\n' +
      '-----END CERTIFICATE-----\n',
  },
  P256: {
    jwk: {
      crv: 'P-256',
      d: 'WBuVA9Z5CghAbxxspv2j1SiHur5BIR-PSDedvQOzun8',
      kty: 'EC',
      x: '4CsFZERaJG_bMfC8AZNAtXbMT4hS6UHTQDsFDVFmZWs',
      y: '-geyNWMPfctokhFckoSvx-tb_zfRoLZG1fqb3sqaNWw',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgWBuVA9Z5CghAbxxs\n' +
      'pv2j1SiHur5BIR+PSDedvQOzun+hRANCAATgKwVkRFokb9sx8LwBk0C1dsxPiFLp\n' +
      'QdNAOwUNUWZla/oHsjVjD33LaJIRXJKEr8frW/830aC2RtX6m97KmjVs\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE4CsFZERaJG/bMfC8AZNAtXbMT4hS\n' +
      '6UHTQDsFDVFmZWv6B7I1Yw99y2iSEVyShK/H61v/N9GgtkbV+pveypo1bA==\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIIBCTCBsAIJAP3LUepKb7jlMAoGCCqGSM49BAMCMA0xCzAJBgNVBAYTAkNaMB4X\n' +
      'DTIyMTAxMTEyMjUwOVoXDTIzMTAwNjEyMjUwOVowDTELMAkGA1UEBhMCQ1owWTAT\n' +
      'BgcqhkjOPQIBBggqhkjOPQMBBwNCAATgKwVkRFokb9sx8LwBk0C1dsxPiFLpQdNA\n' +
      'OwUNUWZla/oHsjVjD33LaJIRXJKEr8frW/830aC2RtX6m97KmjVsMAoGCCqGSM49\n' +
      'BAMCA0gAMEUCIQDUxxIyJy8FQvrou0eGSLzAoNNKrYLIeI/OJzBIu6VkZwIgZvHb\n' +
      'W78UlObaQoVHfmO5TbgLpIEiskde4STWKDYIZmI=\n' +
      '-----END CERTIFICATE-----\n',
  },
  P384: {
    jwk: {
      crv: 'P-384',
      d: '5bt5RH4yyhwdtO2_gDHUgLn8aJqvlOaMHAznINEvkucDqiwrXL4ul42yNpx3biuM',
      kty: 'EC',
      x: 'sb8kfa8h1WbOGJC8lOMBEeXBYOM-EQNJjBSl7Ro5uiDI8Bk3cZpz0XPztPSHTXbw',
      y: '4tyg6L2MAzZ53Sj7l8O7yYYGOYtpNmuoV8vDSjjk_X7KQY-s0G3uT30uoSWvN0vH',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MIG2AgEAMBAGByqGSM49AgEGBSuBBAAiBIGeMIGbAgEBBDDlu3lEfjLKHB207b+A\n' +
      'MdSAufxomq+U5owcDOcg0S+S5wOqLCtcvi6XjbI2nHduK4yhZANiAASxvyR9ryHV\n' +
      'Zs4YkLyU4wER5cFg4z4RA0mMFKXtGjm6IMjwGTdxmnPRc/O09IdNdvDi3KDovYwD\n' +
      'NnndKPuXw7vJhgY5i2k2a6hXy8NKOOT9fspBj6zQbe5PfS6hJa83S8c=\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEsb8kfa8h1WbOGJC8lOMBEeXBYOM+EQNJ\n' +
      'jBSl7Ro5uiDI8Bk3cZpz0XPztPSHTXbw4tyg6L2MAzZ53Sj7l8O7yYYGOYtpNmuo\n' +
      'V8vDSjjk/X7KQY+s0G3uT30uoSWvN0vH\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIIBRTCBzQIJAL/fppsFowYgMAoGCCqGSM49BAMCMA0xCzAJBgNVBAYTAkNaMB4X\n' +
      'DTIyMTAxMTEyMjUyMloXDTIzMTAwNjEyMjUyMlowDTELMAkGA1UEBhMCQ1owdjAQ\n' +
      'BgcqhkjOPQIBBgUrgQQAIgNiAASxvyR9ryHVZs4YkLyU4wER5cFg4z4RA0mMFKXt\n' +
      'Gjm6IMjwGTdxmnPRc/O09IdNdvDi3KDovYwDNnndKPuXw7vJhgY5i2k2a6hXy8NK\n' +
      'OOT9fspBj6zQbe5PfS6hJa83S8cwCgYIKoZIzj0EAwIDZwAwZAIwRc/RKmaCus0F\n' +
      '7/q6D5fPafPTU1iLIcgpdK9pS+7tsCY8UZF2j5fSTFbYG39XaMEYAjB+piZKxCxh\n' +
      '/9jkdLz6ax866tMp9hQNTYU98lO44IQXhcEqh13zR3Bek4KhEnpkWiE=\n' +
      '-----END CERTIFICATE-----\n',
  },
  P521: {
    jwk: {
      crv: 'P-521',
      d: 'Ae6uBN9ZtZD-yfB_--VPF_aEXTUlPENfj0mepT0chVvfi4BfWvs9NNCrv3YtWl1Q2FdYPop8Ch5_aiiiAH0QnmxH',
      kty: 'EC',
      x: 'AV6RoNRH5egig9TgU5CKHCf2H6XW7Rlqs_LZZKnQKJCZP_1x6RBw2Qgwwy8VCvUd_C_oxv45jU-boutt_ewcx7Wo',
      y: 'Abou9L-hVPMkzKNpJPGvhWnAhHNL1DKsXTAty-BmNBZPGtEwWsod8Vv2KN8wcIc7ts3dLedTPIn77O63V32t-cc5',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MIHuAgEAMBAGByqGSM49AgEGBSuBBAAjBIHWMIHTAgEBBEIB7q4E31m1kP7J8H/7\n' +
      '5U8X9oRdNSU8Q1+PSZ6lPRyFW9+LgF9a+z000Ku/di1aXVDYV1g+inwKHn9qKKIA\n' +
      'fRCebEehgYkDgYYABAFekaDUR+XoIoPU4FOQihwn9h+l1u0ZarPy2WSp0CiQmT/9\n' +
      'cekQcNkIMMMvFQr1Hfwv6Mb+OY1Pm6Lrbf3sHMe1qAG6LvS/oVTzJMyjaSTxr4Vp\n' +
      'wIRzS9QyrF0wLcvgZjQWTxrRMFrKHfFb9ijfMHCHO7bN3S3nUzyJ++zut1d9rfnH\n' +
      'OQ==\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQBXpGg1Efl6CKD1OBTkIocJ/Yfpdbt\n' +
      'GWqz8tlkqdAokJk//XHpEHDZCDDDLxUK9R38L+jG/jmNT5ui62397BzHtagBui70\n' +
      'v6FU8yTMo2kk8a+FacCEc0vUMqxdMC3L4GY0Fk8a0TBayh3xW/Yo3zBwhzu2zd0t\n' +
      '51M8ifvs7rdXfa35xzk=\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIIBkDCB8wIJALGXk5Wy5tmGMAoGCCqGSM49BAMCMA0xCzAJBgNVBAYTAkNaMB4X\n' +
      'DTIyMTAxMTEyMjUzNFoXDTIzMTAwNjEyMjUzNFowDTELMAkGA1UEBhMCQ1owgZsw\n' +
      'EAYHKoZIzj0CAQYFK4EEACMDgYYABAFekaDUR+XoIoPU4FOQihwn9h+l1u0ZarPy\n' +
      '2WSp0CiQmT/9cekQcNkIMMMvFQr1Hfwv6Mb+OY1Pm6Lrbf3sHMe1qAG6LvS/oVTz\n' +
      'JMyjaSTxr4VpwIRzS9QyrF0wLcvgZjQWTxrRMFrKHfFb9ijfMHCHO7bN3S3nUzyJ\n' +
      '++zut1d9rfnHOTAKBggqhkjOPQQDAgOBiwAwgYcCQgCfBR/x6atEB5KAaYmNOiKm\n' +
      'OHhQISZU62ayPDipxsXf9vh4OK5WDdI4SmC1du07kAlwa2tFVSvz7vkMXGGXVYBr\n' +
      'PQJBSjIXjpo07m26F0Jmv0OVX2on98+GN7xP8pRCviAuQj8UWKIQvwnj3esymVWb\n' +
      'kmEjhnWo8H38/2wddwksoxHvinU=\n' +
      '-----END CERTIFICATE-----\n',
  },
  RSA: {
    jwk: {
      d: 'Z6bZKZhloVo5eMB7zpu0PuvBuDTGnyPTg16foy5EuIYF9zU8pnePTkAMzix2qKLjDELiaakvCNyeQIR4PFZv7YcHSlDVf7dmWDKK4wVKZbTWaAC5fPG1gyIIPAD0Gg4YWPqCEAThzeSYXjF1XQMwGd0jnKaxKMO4763MvXI5CkkmS8F9pLAoAqCjntGkA3yCB_byGDlFQ50UMZiesZyv-t_8tF8Yp4BFQyGG6aRYBntO1WzcTbVov4JJ0DA-jc1psqpIIMrFz044h5Ovm30spZRDTztwBIcXoGGs-d9AW8tgyWgmmA7YQpddpplNa9H6z-24LRGPv-OABA6U1QeeOQ',
      dp: 'lRCClYTQvzgsVoVJjdyADVtceVsH7KfwpFxnrot_V40XJkUmiHj2yWGld8kB78q66faOavY-TFpmFlo-BQpEiXCDGzCqNCLJ-lF_ZnWyARfQHBBQPFHH2MqaNiS29yjpt7V4vc4z1DL_v5CaiR1wq9AZTABIUf8l2dAkHFrSTKk',
      dq: 'DMfbSrlSf71Ng5WuZxtENbQOSTOOP3rIyYibdPzbjJyb5raj09XQW_EJiaM45qbSwJfzFOnrFrQcoOJYmQTlHkVMcnXis2r1WXT0So32_D_kDevNZjHFG4PvqnK4ToV_GCGy1IbG4vHdjyMmHtG00zy9-02j7WV8-OerFP7QIAk',
      e: 'AQAB',
      kty: 'RSA',
      n: 'wINok6pE72n8ry3P6EIR-4B9oJmudAK_Q9mKkbG7eZlnP2Nvn5Fq6IhbsLn-ygT9OO_PzT23UdkxnjF8DUgSt7fVStQ40z4_lHVSPVIQeeDkML9Pipu1zUx6RqweUZdXnoN0JFNM93iUfJEvEukYxrWAeFVrRL2DU2E8DSrlJUyCO-c2NaO3YFsFdowW8pviMAnOs39VZNemiQtT-D4fg48dRX5bkrzjaRymhY7bWGelts0FhrNb6Jy-WMnSPxqpozbQ0ODI4kGQYSrKiUNLDfnSUAR-o5I4Hp2bkOrXt6lLccNu0PpPksVAWzTLyFtixxC9APKyUJSKQ7zNpKhqwQ',
      p: '4EqeWf4b6BJ_7v0Dwa_prSvDRylomA_IZpSDP_1Cqy24IFP1dBzdqm0gYbLNq3xQJkhptbBbC7xOPt4Zz0n-wJOHOkGf31m5-Gc4BiR9fTOEdFRtEQJyLfPu-7D9UbJH_bz_zsOQw9TDzllZp1H9X87AzkkkMfqjinxC749tJ1s',
      q: '27qzE-tl4V0HT_8PGI6YG2rphRfe5PArRSFgRmampXve6d_vgu5IpZEoNG7YGcT_J6tcdxF19-M2VEeNyqTPl2X91ba-RjkAByOTcT4n57-M4aK9yJt8un8BPBBNco42GmDnb5ZkC1UwJrrHc8QSmTjDBmvvjJYNUseWeYvCrRM',
      qi: 'yjY4FSvy_h8BXcbZJq1rLpMiEAqI3yMZ2wK8THJSfD37xbhil5PrDzzOluM_qkaC1aKTTAksFsx8f5AOEePCyjW095OBQe379EizSIC_EnByBdkfms8u5VOOKrZUI6I024QMhFsWCodaDDoNg-xXGD-viRtxpam9ZxVnyLRDOdg',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDAg2iTqkTvafyv\n' +
      'Lc/oQhH7gH2gma50Ar9D2YqRsbt5mWc/Y2+fkWroiFuwuf7KBP0478/NPbdR2TGe\n' +
      'MXwNSBK3t9VK1DjTPj+UdVI9UhB54OQwv0+Km7XNTHpGrB5Rl1eeg3QkU0z3eJR8\n' +
      'kS8S6RjGtYB4VWtEvYNTYTwNKuUlTII75zY1o7dgWwV2jBbym+IwCc6zf1Vk16aJ\n' +
      'C1P4Ph+Djx1FfluSvONpHKaFjttYZ6W2zQWGs1vonL5YydI/GqmjNtDQ4MjiQZBh\n' +
      'KsqJQ0sN+dJQBH6jkjgenZuQ6te3qUtxw27Q+k+SxUBbNMvIW2LHEL0A8rJQlIpD\n' +
      'vM2kqGrBAgMBAAECggEAZ6bZKZhloVo5eMB7zpu0PuvBuDTGnyPTg16foy5EuIYF\n' +
      '9zU8pnePTkAMzix2qKLjDELiaakvCNyeQIR4PFZv7YcHSlDVf7dmWDKK4wVKZbTW\n' +
      'aAC5fPG1gyIIPAD0Gg4YWPqCEAThzeSYXjF1XQMwGd0jnKaxKMO4763MvXI5Ckkm\n' +
      'S8F9pLAoAqCjntGkA3yCB/byGDlFQ50UMZiesZyv+t/8tF8Yp4BFQyGG6aRYBntO\n' +
      '1WzcTbVov4JJ0DA+jc1psqpIIMrFz044h5Ovm30spZRDTztwBIcXoGGs+d9AW8tg\n' +
      'yWgmmA7YQpddpplNa9H6z+24LRGPv+OABA6U1QeeOQKBgQDgSp5Z/hvoEn/u/QPB\n' +
      'r+mtK8NHKWiYD8hmlIM//UKrLbggU/V0HN2qbSBhss2rfFAmSGm1sFsLvE4+3hnP\n' +
      'Sf7Ak4c6QZ/fWbn4ZzgGJH19M4R0VG0RAnIt8+77sP1Rskf9vP/Ow5DD1MPOWVmn\n' +
      'Uf1fzsDOSSQx+qOKfELvj20nWwKBgQDburMT62XhXQdP/w8YjpgbaumFF97k8CtF\n' +
      'IWBGZqale97p3++C7kilkSg0btgZxP8nq1x3EXX34zZUR43KpM+XZf3Vtr5GOQAH\n' +
      'I5NxPifnv4zhor3Im3y6fwE8EE1yjjYaYOdvlmQLVTAmusdzxBKZOMMGa++Mlg1S\n' +
      'x5Z5i8KtEwKBgQCVEIKVhNC/OCxWhUmN3IANW1x5Wwfsp/CkXGeui39XjRcmRSaI\n' +
      'ePbJYaV3yQHvyrrp9o5q9j5MWmYWWj4FCkSJcIMbMKo0Isn6UX9mdbIBF9AcEFA8\n' +
      'UcfYypo2JLb3KOm3tXi9zjPUMv+/kJqJHXCr0BlMAEhR/yXZ0CQcWtJMqQKBgAzH\n' +
      '20q5Un+9TYOVrmcbRDW0Dkkzjj96yMmIm3T824ycm+a2o9PV0FvxCYmjOOam0sCX\n' +
      '8xTp6xa0HKDiWJkE5R5FTHJ14rNq9Vl09EqN9vw/5A3rzWYxxRuD76pyuE6Ffxgh\n' +
      'stSGxuLx3Y8jJh7RtNM8vftNo+1lfPjnqxT+0CAJAoGBAMo2OBUr8v4fAV3G2Sat\n' +
      'ay6TIhAKiN8jGdsCvExyUnw9+8W4YpeT6w88zpbjP6pGgtWik0wJLBbMfH+QDhHj\n' +
      'wso1tPeTgUHt+/RIs0iAvxJwcgXZH5rPLuVTjiq2VCOiNNuEDIRbFgqHWgw6DYPs\n' +
      'Vxg/r4kbcaWpvWcVZ8i0QznY\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwINok6pE72n8ry3P6EIR\n' +
      '+4B9oJmudAK/Q9mKkbG7eZlnP2Nvn5Fq6IhbsLn+ygT9OO/PzT23UdkxnjF8DUgS\n' +
      't7fVStQ40z4/lHVSPVIQeeDkML9Pipu1zUx6RqweUZdXnoN0JFNM93iUfJEvEukY\n' +
      'xrWAeFVrRL2DU2E8DSrlJUyCO+c2NaO3YFsFdowW8pviMAnOs39VZNemiQtT+D4f\n' +
      'g48dRX5bkrzjaRymhY7bWGelts0FhrNb6Jy+WMnSPxqpozbQ0ODI4kGQYSrKiUNL\n' +
      'DfnSUAR+o5I4Hp2bkOrXt6lLccNu0PpPksVAWzTLyFtixxC9APKyUJSKQ7zNpKhq\n' +
      'wQIDAQAB\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIICljCCAX4CCQDz0yP7UQpRIjANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJD\n' +
      'WjAeFw0yMjEwMTExMjI2NTVaFw0yMzEwMDYxMjI2NTVaMA0xCzAJBgNVBAYTAkNa\n' +
      'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwINok6pE72n8ry3P6EIR\n' +
      '+4B9oJmudAK/Q9mKkbG7eZlnP2Nvn5Fq6IhbsLn+ygT9OO/PzT23UdkxnjF8DUgS\n' +
      't7fVStQ40z4/lHVSPVIQeeDkML9Pipu1zUx6RqweUZdXnoN0JFNM93iUfJEvEukY\n' +
      'xrWAeFVrRL2DU2E8DSrlJUyCO+c2NaO3YFsFdowW8pviMAnOs39VZNemiQtT+D4f\n' +
      'g48dRX5bkrzjaRymhY7bWGelts0FhrNb6Jy+WMnSPxqpozbQ0ODI4kGQYSrKiUNL\n' +
      'DfnSUAR+o5I4Hp2bkOrXt6lLccNu0PpPksVAWzTLyFtixxC9APKyUJSKQ7zNpKhq\n' +
      'wQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQCgIGx+4WgwLtSGAxquNk7pMoewqyCx\n' +
      'PO1v/3Snte5sHcn2+yBHaVeRrbnvniJIUNWnvGs/MuGA5fhsSgRBeXqOsLq0eprX\n' +
      'YfPG7PG532NoaZ97Gp9X/YH3tTLCh/gyp0kQ2R0eci6f3J7nDzSPazHskEGTujHS\n' +
      'uSczHvQsD8HdAd2CsZLPp02NgKhiG4VwMP2CeaUTG/62eZp/fGEAAqrXn4YoHsnY\n' +
      'DPCORtzlkel/kV8r0/ktXt+fWoPIpn3dUaHDwi9V9RMkML9IMyLYFfLnpfxFMqdg\n' +
      '7KWOOFnaMmoDLlICZk7Ym3SjNt86hzmJ+eWiUuHAdFN4PeKj9wXd0t90\n' +
      '-----END CERTIFICATE-----\n',
  },
  X25519: {
    jwk: {
      crv: 'X25519',
      d: 'WCN6m3ZhxgzgsmacDlbq_O347na7uQe6cW8T6ZJ19mw',
      kty: 'OKP',
      x: 'aq1ZuCRIE3XXXcRpbC_txuESJ4KFH8VwQlz1nVa8Ugk',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MC4CAQAwBQYDK2VuBCIEIFgjept2YcYM4LJmnA5W6vzt+O52u7kHunFvE+mSdfZs\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MCowBQYDK2VuAyEAaq1ZuCRIE3XXXcRpbC/txuESJ4KFH8VwQlz1nVa8Ugk=\n' +
      '-----END PUBLIC KEY-----\n',
    x509: undefined,
  },
  X448: {
    jwk: {
      crv: 'X448',
      d: 'tMpYXWcUg7vGrUcZ1cUMVodjB6rWSOaBKgmaigThaInGRTCmaWPDYrE93wwPmyxOhVYRsmIRFv0',
      kty: 'OKP',
      x: 'jk-IiddcEYNq6CwHnqsQleaB86W2tUITnIMwkurT5BUdw2YpJxQt9rgnEZQW0KnQE-ORhEl0kaA',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MEYCAQAwBQYDK2VvBDoEOLTKWF1nFIO7xq1HGdXFDFaHYweq1kjmgSoJmooE4WiJ\n' +
      'xkUwpmljw2KxPd8MD5ssToVWEbJiERb9\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MEIwBQYDK2VvAzkAjk+IiddcEYNq6CwHnqsQleaB86W2tUITnIMwkurT5BUdw2Yp\n' +
      'JxQt9rgnEZQW0KnQE+ORhEl0kaA=\n' +
      '-----END PUBLIC KEY-----\n',
    x509: undefined,
  },
  secp256k1: {
    jwk: {
      crv: 'secp256k1',
      d: '4FnXRICPA8cKwNZhg1XvGS3cyWXzuJ17imMFjlgn42w',
      kty: 'EC',
      x: 'hwxzC9RSkkBmbBche2iTjNCLbB7XG6h5lfHmOXTQDmQ',
      y: 'xzddq8Sa9Gn6EOCeYghU6uyWQoh1mWAHx0p6Zd0N9Bo',
    },
    pkcs8:
      '-----BEGIN PRIVATE KEY-----\n' +
      'MIGEAgEAMBAGByqGSM49AgEGBSuBBAAKBG0wawIBAQQg4FnXRICPA8cKwNZhg1Xv\n' +
      'GS3cyWXzuJ17imMFjlgn42yhRANCAASHDHML1FKSQGZsFyF7aJOM0ItsHtcbqHmV\n' +
      '8eY5dNAOZMc3XavEmvRp+hDgnmIIVOrslkKIdZlgB8dKemXdDfQa\n' +
      '-----END PRIVATE KEY-----\n',
    spki:
      '-----BEGIN PUBLIC KEY-----\n' +
      'MFYwEAYHKoZIzj0CAQYFK4EEAAoDQgAEhwxzC9RSkkBmbBche2iTjNCLbB7XG6h5\n' +
      'lfHmOXTQDmTHN12rxJr0afoQ4J5iCFTq7JZCiHWZYAfHSnpl3Q30Gg==\n' +
      '-----END PUBLIC KEY-----\n',
    x509:
      '-----BEGIN CERTIFICATE-----\n' +
      'MIIBBTCBrQIJAMqeTnxEXkWqMAoGCCqGSM49BAMCMA0xCzAJBgNVBAYTAkNaMB4X\n' +
      'DTIyMTAxMTEyMjUxNFoXDTIzMTAwNjEyMjUxNFowDTELMAkGA1UEBhMCQ1owVjAQ\n' +
      'BgcqhkjOPQIBBgUrgQQACgNCAASHDHML1FKSQGZsFyF7aJOM0ItsHtcbqHmV8eY5\n' +
      'dNAOZMc3XavEmvRp+hDgnmIIVOrslkKIdZlgB8dKemXdDfQaMAoGCCqGSM49BAMC\n' +
      'A0cAMEQCICLsIR+59yZbMsxvtYMH+Lmlko0/ihPHU/vbpfc7XXa1AiALT04GYkMx\n' +
      '/xy0TNunfynvxfMAX+9x+3tO8g/KbPZp7w==\n' +
      '-----END CERTIFICATE-----\n',
  },
}
