"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const uid = process.platform === 'win32' ? undefined : process.getuid();
const gid = process.platform === 'win32' ? undefined : process.getgid();
class Stats {
    constructor(_options = {}) {
        this._options = _options;
        this._date = new Date();
        // eslint-disable-next-line unicorn/prevent-abbreviations
        this.dev = 'dev' in this._options ? this._options.dev : 0;
        this.ino = 'ino' in this._options ? this._options.ino : 0;
        this.mode = 'mode' in this._options ? this._options.mode : 0;
        this.nlink = 'nlink' in this._options ? this._options.nlink : 0;
        this.uid = 'uid' in this._options ? this._options.uid : uid;
        this.gid = 'gid' in this._options ? this._options.gid : gid;
        this.rdev = 'rdev' in this._options ? this._options.rdev : 0;
        this.size = 'size' in this._options ? this._options.size : 0;
        this.blksize = 'blksize' in this._options ? this._options.blksize : 0;
        this.blocks = 'blocks' in this._options ? this._options.blocks : 0;
        this.atimeMs = 'atimeMs' in this._options ? this._options.atimeMs : this._date.getTime();
        this.mtimeMs = 'mtimeMs' in this._options ? this._options.mtimeMs : this._date.getTime();
        this.ctimeMs = 'ctimeMs' in this._options ? this._options.ctimeMs : this._date.getTime();
        this.birthtimeMs = 'birthtimeMs' in this._options ? this._options.birthtimeMs : this._date.getTime();
        this.atime = 'atime' in this._options ? this._options.atime : this._date;
        this.mtime = 'mtime' in this._options ? this._options.mtime : this._date;
        this.ctime = 'ctime' in this._options ? this._options.ctime : this._date;
        this.birthtime = 'birthtime' in this._options ? this._options.birthtime : this._date;
    }
    isFile() {
        return 'isFile' in this._options ? this._options.isFile : true;
    }
    isDirectory() {
        return 'isDirectory' in this._options ? this._options.isDirectory : false;
    }
    isBlockDevice() {
        return 'isBlockDevice' in this._options ? this._options.isBlockDevice : false;
    }
    isCharacterDevice() {
        return 'isCharacterDevice' in this._options ? this._options.isCharacterDevice : false;
    }
    isSymbolicLink() {
        return 'isSymbolicLink' in this._options ? this._options.isSymbolicLink : false;
    }
    isFIFO() {
        return 'isFIFO' in this._options ? this._options.isFIFO : false;
    }
    isSocket() {
        return 'isSocket' in this._options ? this._options.isSocket : false;
    }
}
exports.default = Stats;
