'use strict';
var path = require('path');
module.exports = {
  resolve: {
    modules: ['/usr/lib/nodejs', '.'],
  },
  resolveLoader: {
    modules: ['/usr/lib/nodejs'],
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        loader: 'babel-loader',
        options: {
          presets: [ 'es2015' ],
          plugins: ['add-module-exports']
        }
      }
    ]
  },
  externals: {
    'd3-collection': {
      commonjs: 'd3-collection',
      commonjs2: 'd3-collection',
      amd: 'd3-collection',
      root: '_'
    },
    'd3-dsv': {
      commonjs: 'd3-dsv',
      commonjs2: 'd3-dsv',
      amd: 'd3-dsv',
      root: '_'
    },
    'd3-dispatch': {
      commonjs: 'd3-dispatch',
      commonjs2: 'd3-dispatch',
      amd: 'd3-dispatch',
      root: '_'
    },
  }
};
