module.exports = (request, options) => {
  // Apelle defaultResolver, ainsi nous utilisons son cache, sa gestion d'erreur, etc.
  return options.defaultResolver(request, {
    ...options,
    // Utilise packageFilter pour traiter `package.json` avant la résolution (voir https://www.npmjs.com/package/resolve#resolveid-opts-cb)
    packageFilter: (pkg) => {
      let main = pkg.exports && pkg.exports.require ? pkg.exports.require : pkg.main;
      return {
        ...pkg,
        // Modifie la valeur de `main` avant la résolution du paquet
        main: main
      };
    },
  });
};
