#ifndef JSDLEXER_HPP
#define JSDLEXER_HPP

/*  $Id: jsdlexer.hpp 532212 2017-04-03 13:24:13Z gouriano $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* Author: Andrei Gourianov
*
* File Description:
*   JSON Schema lexer
*
* ===========================================================================
*/

#include "dtdlexer.hpp"
#include <list>

BEGIN_NCBI_SCOPE

class JSDLexer : public DTDLexer
{
public:
    JSDLexer(CNcbiIstream& in, const string& name);
    virtual ~JSDLexer(void);

protected:
    void SkipWhitespace(void);
    virtual void LookupComments(void);
    virtual TToken LookupToken(void);
    TToken LookupNumber(void);
    void LookupIdentifier(void);
    TToken LookupKeyword(void);
};

END_NCBI_SCOPE

#endif // JSDLEXER_HPP
