/* $Id: Suspect_rule.hpp 547096 2017-09-26 12:04:35Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Suspect_rule.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Suspect_rule_.hpp


#ifndef OBJECTS_MACRO_SUSPECT_RULE_HPP
#define OBJECTS_MACRO_SUSPECT_RULE_HPP


// generated includes
#include <objects/macro/Suspect_rule_.hpp>
#include <objects/macro/Replace_rule.hpp>
#include <objects/seqfeat/Seq_feat.hpp>

// generated classes

BEGIN_NCBI_SCOPE
BEGIN_objects_SCOPE // namespace ncbi::objects::

// forward declarations
class CConstraint_choice;
class CConstraint_choice_set;
class CField_constraint;
class CField_type;
class CLocation_constraint;
class CLocation_pos_constraint;
class CReplace_rule;
class CSearch_func;
class CSource_constraint;
class CString_constraint;

/////////////////////////////////////////////////////////////////////////////
class CSuspect_rule : public CSuspect_rule_Base
{
    typedef CSuspect_rule_Base Tparent;
public:
    CSuspect_rule() {}
    ~CSuspect_rule() {}
 
    // C's MatchesSuspectProductRule()
    bool StringMatchesSuspectProductRule (const string& str) const;

    bool ApplyToString(string& val) const;

    string GetRuleTypeName(void) const;
    string SummarizeRule(void) const;
    bool IsFatal(void) const { return GetFatal() || GetRule_type() == eFix_type_remove_organism_name || GetRule_type() == eFix_type_inappropriate_symbol;}

private:
    // Prohibit copy constructor and assignment operator
    CSuspect_rule(const CSuspect_rule& value);
    CSuspect_rule& operator=(const CSuspect_rule& value);

    string SummarizeSearchFunc(const CSearch_func&) const;
    string SummarizeReplaceRule(const CReplace_rule&) const;
    string SummarizeStringConstraint(const CString_constraint&) const;
    string SummarizeConstraintSet(const CConstraint_choice_set&) const;
    string SummarizeConstraint(const CConstraint_choice&) const;
    string SummarizeLocationConstraint(const CLocation_constraint&) const;
    string SummarizeEndDistance(const CLocation_pos_constraint&) const;
    string SummarizeSourceConstraint(const CSource_constraint&) const;
    string SummarizeFieldConstraint(const CField_constraint&) const;
    string SummarizeFieldType(const CField_type&) const;
};

END_objects_SCOPE // namespace ncbi::objects::
END_NCBI_SCOPE

#endif // OBJECTS_MACRO_SUSPECT_RULE_HPP
