/* $Id: User_object.cpp 490266 2016-01-22 16:40:57Z kornbluh $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'general.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/general/User_object.hpp>
#include <objects/general/User_field.hpp>
#include <objects/general/Object_id.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


SAFE_CONST_STATIC_STRING(kUnverifiedOrganism,     "Organism");
SAFE_CONST_STATIC_STRING(kUnverifiedMisassembled, "Misassembled");
SAFE_CONST_STATIC_STRING(kUnverifiedFeature,      "Features");


// destructor
CUser_object::~CUser_object(void)
{
}


//
// retrieve a named field.  The named field can recurse, depending
// on a set of user-defined delimiters
//
const CUser_field& CUser_object::GetField(const string& str,
                                          const string& delim,
                                          NStr::ECase use_case) const
{
    CConstRef<CUser_field> ref(GetFieldRef(str, delim, use_case));
    if (ref.Empty()) {
        NCBI_THROW(CCoreException, eNullPtr,
                   "Unable to find User-field " + str);
    }
    return *ref;
}


CConstRef<CUser_field> CUser_object::GetFieldRef(const string& str,
                                                 const string& delim,
                                                 NStr::ECase use_case) const
{
    list<string> toks;
    NStr::Split(str, delim, toks);
    if ( !toks.size() ) {
        return CConstRef<CUser_field>();
    }

    ///
    /// step 1: scan one level deep for a nested object
    /// we scan only with the first token
    ///
    string sub;
    string first;
    {{
        list<string>::iterator iter = toks.begin();
        first = *iter;
        for (++iter;  iter != toks.end();  ++iter) {
            if ( !sub.empty() ) {
                sub += delim;
            }
            sub += *iter;
        }
    }}

    ITERATE(TData, field_iter, GetData()) {
        bool found = false;
        const CUser_field& field = **field_iter;
        if (field.IsSetLabel()  &&  field.GetLabel().IsStr()) {
            const string& this_label = field.GetLabel().GetStr();
            if ( NStr::Equal(this_label, first, use_case) ) {
                found = true;
            }
        }
        if ( !found ) {
            continue;
        }

        if ( !sub.empty() ) {
            CConstRef<CUser_field> field_ref =
                (*field_iter)->GetFieldRef(sub, delim, use_case);
            if (field_ref) {
                return field_ref;
            }
        } else {
            return CConstRef<CUser_field>(&field);
        }
    }
    return CConstRef<CUser_field>();
}


bool CUser_object::HasField(const string& str,
                            const string& delim,
                            NStr::ECase use_case) const
{
    return GetFieldRef(str, delim, use_case).GetPointer() ? true : false;
}


//
// retrieve a named field.  The named field can recurse, depending
// on a set of user-defined delimiters
//
CUser_field& CUser_object::SetField(const string& str,
                                    const string& delim,
                                    const string& obj_subtype,
                                    NStr::ECase use_case)
{
    return *SetFieldRef(str, delim, obj_subtype, use_case);
}


CRef<CUser_field> CUser_object::SetFieldRef(const string& str,
                                            const string& delim,
                                            const string& /* obj_subtype */,
                                            NStr::ECase use_case)
{
    list<string> toks;
    NStr::Split(str, delim, toks);

    CRef<CUser_field>  field_ref;

    /// pass 1: see if we have a field that starts with this label already
    NON_CONST_ITERATE(TData, field_iter, SetData()) {
        CUser_field& field = **field_iter;
        if (field.GetLabel().IsStr()  &&
            NStr::Equal(field.GetLabel().GetStr(), toks.front(), use_case))
        {
            field_ref = *field_iter;
            break;
        }
    }

    if ( !field_ref ) {
        field_ref.Reset(new CUser_field());
        field_ref->SetLabel().SetStr(toks.front());
        SetData().push_back(field_ref);
    }

    toks.pop_front();
    if (toks.size()) {
        string s = NStr::Join(toks, delim);
        CRef<CUser_field> f = field_ref->SetFieldRef(s, delim, use_case);
        field_ref = f;
    }

    return field_ref;
}


// add a data field to the user object that holds a given value
CUser_object& CUser_object::AddField(const string& label,
                                     const string& value,
                                     EParseField parse)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value, CUser_field::EParseField(parse));

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const char* value,
                                     EParseField parse)
{
    return AddField(label, string(value), parse);
}


CUser_object& CUser_object::AddField(const string& label,
                                     Int8          value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     int           value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}


#ifdef NCBI_STRICT_GI
CUser_object& CUser_object::AddField(const string& label,
                                     TGi           value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}
#endif


CUser_object& CUser_object::AddField(const string& label,
                                     double        value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     bool          value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}



CUser_object& CUser_object::AddField(const string& label,
                                     CUser_object& object)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(object);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<string>& value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<int>&    value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<double>& value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(value);

    SetData().push_back(field);
    return *this;
}


CUser_object&
CUser_object::AddField(const string& label,
                       const vector< CRef<CUser_object> >& objects)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(objects);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<CRef<CUser_field> >& objects)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetValue(objects);

    SetData().push_back(field);
    return *this;
}



// static consts here allow us to use reference counting
static const char* s_ncbi   = "NCBI";
static const char* s_expres = "experimental_results";
static const char* s_exp    = "experiment";
static const char* s_sage   = "SAGE";
static const char* s_tag    = "tag";
static const char* s_count  = "count";


// accessors: classify a given user object
CUser_object::ECategory CUser_object::GetCategory(void) const
{
    if (!IsSetClass()  ||
        GetClass() != s_ncbi) {
        // we fail to recognize non-NCBI classes of user-objects
        return eCategory_Unknown;
    }

    //
    // experimental results
    //
    if (GetType().IsStr()  &&
        NStr::CompareNocase(GetType().GetStr(), s_expres) == 0  &&
        GetData().size() == 1) {

        ITERATE (CUser_object::TData, iter, GetData()) {
            const CUser_field& field       = **iter;
            const CUser_field::TData& data = field.GetData();
            if (data.Which() != CUser_field::TData::e_Object  ||
                !field.IsSetLabel()  ||
                !field.GetLabel().IsStr()  ||
                NStr::CompareNocase(field.GetLabel().GetStr(),
                                    s_exp) != 0) {
                // poorly formed experiment spec
                return eCategory_Unknown;
            }
        }

        return eCategory_Experiment;
    }

    //
    // unrecognized - catch-all
    //
    return eCategory_Unknown;
}


// sub-category accessors:
CUser_object::EExperiment CUser_object::GetExperimentType(void) const
{
    // check to see if we have an experiment
    if ( GetCategory() != eCategory_Experiment) {
        return eExperiment_Unknown;
    }

    // we do - so we have one nested user object that contains the
    // specification of the experimental data
    const CUser_field& field = *GetData().front();
    const CUser_object& obj = field.GetData().GetObject();
    if (obj.GetType().IsStr()  &&
        NStr::CompareNocase(obj.GetType().GetStr(), s_sage) == 0) {
        return eExperiment_Sage;
    }

    //
    // catch-all
    //
    return eExperiment_Unknown;
}


// sub-category accessors:
const CUser_object& CUser_object::GetExperiment(void) const
{
    switch (GetExperimentType()) {
    case eExperiment_Sage:
        // we have one nested user object that contains the
        // specification of the experimental data
        return GetData().front()->GetData().GetObject();

    case eExperiment_Unknown:
    default:
        return *this;
    }
}


//
// format the type specification fo a given user object
//
static string s_GetUserObjectType(const CUser_object& obj)
{
    switch (obj.GetCategory()) {
    case CUser_object::eCategory_Experiment:
        switch (obj.GetExperimentType()) {
        case CUser_object::eExperiment_Sage:
            return "SAGE";

        case CUser_object::eExperiment_Unknown:
        default:
            return "Experiment";
        }
        break;

    case CUser_object::eCategory_Unknown:
    default:
        break;
    }

    return "User";
}


static string s_GetUserObjectContent(const CUser_object& obj)
{
    switch (obj.GetCategory()) {
    case CUser_object::eCategory_Experiment:
        switch (obj.GetExperimentType()) {
        case CUser_object::eExperiment_Sage:
            {{
                string label;
                const CUser_object& nested_obj =
                    obj.GetData().front()->GetData().GetObject();

                // grab the tag and count fields
                const CUser_field* tag = NULL;
                const CUser_field* count = NULL;
                ITERATE (CUser_object::TData, iter, nested_obj.GetData()) {
                    const CUser_field& field = **iter;
                    if (!field.GetLabel().IsStr()) {
                        continue;
                    }

                    const string& lbl = field.GetLabel().GetStr();
                    if (NStr::CompareNocase(lbl, s_tag) == 0) {
                        tag = &field;
                    } else if (NStr::CompareNocase(lbl, s_count) == 0) {
                        count = &field;
                    }
                }

                if (tag  &&  tag->GetData().IsStr()) {
                    if ( !label.empty() ) {
                        label += " ";
                    }
                    label += string(s_tag) + "=" + tag->GetData().GetStr();
                }

                if (count  &&  count->GetData().IsInt()) {
                    if ( !label.empty() ) {
                        label += " ";
                    }
                    label += string(s_count) + "=" +
                        NStr::NumericToString(count->GetData().GetInt());
                }

                return label;
            }}

        case CUser_object::eExperiment_Unknown:
        default:
            break;
        }
        return "[experiment]";

    case CUser_object::eCategory_Unknown:
    default:
        break;
    }
    return "[User]";
}


//
// append a formatted string to a label describing this object
//
void CUser_object::GetLabel(string* label, ELabelContent mode) const
{
    // Check the label is not null
    if (!label) {
        return;
    }

    switch (mode) {
    case eType:
        *label += s_GetUserObjectType(*this);
        break;
    case eContent:
        *label += s_GetUserObjectContent(*this);
        break;
    case eBoth:
        *label += s_GetUserObjectType(*this) + ": " +
            s_GetUserObjectContent(*this);
        break;
    }
}


CUser_object& CUser_object::SetCategory(ECategory category)
{
    Reset();
    SetClass(s_ncbi);
    switch (category) {
    case eCategory_Experiment:
        SetType().SetStr(s_expres);
        {{
            CRef<CUser_object> subobj(new CUser_object());
            AddField(s_exp, *subobj);
            SetClass(s_ncbi);
            return *subobj;
        }}

    case eCategory_Unknown:
    default:
        break;
    }

    return *this;
}


CUser_object& CUser_object::SetExperiment(EExperiment category)
{
    Reset();
    SetClass(s_ncbi);
    switch (category) {
    case eExperiment_Sage:
        SetType().SetStr(s_sage);
        break;

    case eExperiment_Unknown:
    default:
        break;
    }

    return *this;
}


static const char* kDBLink                = "DBLink";
static const char* kStructuredComment     = "StructuredComment";
static const char* kOriginalId            = "OriginalID";
static const char* kOrigIdAltSpell        = "OrginalID";
static const char* kUnverified            = "Unverified";
static const char* kValidationSuppression = "ValidationSuppression";
static const char* kNcbiCleanup           = "NcbiCleanup";
static const char* kAutoDefOptions        = "AutodefOptions";

CUser_object::EObjectType CUser_object::GetObjectType() const
{
    if (!IsSetType() || !GetType().IsStr()) {
        return eObjectType_Unknown;
    }
    EObjectType rval = eObjectType_Unknown;

    string label = GetType().GetStr();
    if (NStr::Equal(label, kDBLink)) {
        rval = eObjectType_DBLink;
    } else if (NStr::Equal(label, kStructuredComment)) {
        rval = eObjectType_StructuredComment;
    } else if (NStr::Equal(label, kOriginalId)) {
        rval = eObjectType_OriginalId;
    } else if (NStr::Equal(label, kOrigIdAltSpell)) {
        rval = eObjectType_OriginalId;
    } else if (NStr::Equal(label, kUnverified)) {
        rval = eObjectType_Unverified;
    } else if (NStr::Equal(label, kValidationSuppression)) {
        rval = eObjectType_ValidationSuppression;
    } else if (NStr::Equal(label, kNcbiCleanup)) {
        rval = eObjectType_Cleanup;
    } else if (NStr::Equal(label, kAutoDefOptions)) {
        rval = eObjectType_AutodefOptions;
    }
    return rval;
}


void CUser_object::SetObjectType(EObjectType obj_type)
{
    switch (obj_type) {
        case eObjectType_DBLink:
            SetType().SetStr(kDBLink);
            break;
        case eObjectType_StructuredComment:
            SetType().SetStr(kStructuredComment);
            break;
        case eObjectType_OriginalId:
            SetType().SetStr(kOriginalId);
            break;
        case eObjectType_Unverified:
            SetType().SetStr(kUnverified);
            break;
        case eObjectType_ValidationSuppression:
            SetType().SetStr(kValidationSuppression);
            break;
        case eObjectType_Cleanup:
            SetType().SetStr(kNcbiCleanup);
            break;
        case eObjectType_AutodefOptions:
            SetType().SetStr(kAutoDefOptions);
            break;
        case eObjectType_Unknown:
            ResetType();
            break;
    }
}


bool CUser_object::x_IsUnverifiedType(const string& val, const CUser_field& field) const
{
    if (field.IsSetLabel() && field.GetLabel().IsStr()
        && NStr::Equal(field.GetLabel().GetStr(), "Type")
        && field.IsSetData()
        && field.GetData().IsStr()
        && NStr::Equal(field.GetData().GetStr(), val)) {
        return true;
    } else {
        return false;
    }
}


bool CUser_object::x_IsUnverifiedType(const string& val) const
{
    if (GetObjectType() != eObjectType_Unverified) {
        return false;
    }
    if (!IsSetData()) {
        return false;
    }
    bool found = false;

    ITERATE(CUser_object::TData, it, GetData()) {
        if (x_IsUnverifiedType(val, **it)) {
            found = true;
        }
    }
    return found;
}


void CUser_object::x_AddUnverifiedType(const string& val)
{
    SetObjectType(eObjectType_Unverified);
    if (x_IsUnverifiedType(val)) {
        // value already set, nothing to do
        return;
    }
    AddField("Type", val);
}


void CUser_object::x_RemoveUnverifiedType(const string& val)
{
    if (GetObjectType() != eObjectType_Unverified) {
        return;
    }
    if (!IsSetData()) {
        return;
    }
    CUser_object::TData::iterator it = SetData().begin();
    while (it != SetData().end()) {
        if (x_IsUnverifiedType(val, **it)) {
            it = SetData().erase(it);
        } else {
            it++;
        }
    }
    if (GetData().empty()) {
        ResetData();
    }
}


bool CUser_object::IsUnverifiedOrganism() const
{
    return x_IsUnverifiedType(kUnverifiedOrganism.Get());
}


void CUser_object::AddUnverifiedOrganism()
{
    x_AddUnverifiedType(kUnverifiedOrganism.Get());
}


void CUser_object::RemoveUnverifiedOrganism()
{
    x_RemoveUnverifiedType(kUnverifiedOrganism.Get());
}


bool CUser_object::IsUnverifiedFeature() const
{
    return x_IsUnverifiedType(kUnverifiedFeature.Get());
}


void CUser_object::AddUnverifiedFeature()
{
    x_AddUnverifiedType(kUnverifiedFeature.Get());
}


void CUser_object::RemoveUnverifiedFeature()
{
    x_RemoveUnverifiedType(kUnverifiedFeature.Get());
}


bool CUser_object::IsUnverifiedMisassembled() const
{
    return x_IsUnverifiedType(kUnverifiedMisassembled.Get());
}


void CUser_object::AddUnverifiedMisassembled()
{
    x_AddUnverifiedType(kUnverifiedMisassembled.Get());
}


void CUser_object::RemoveUnverifiedMisassembled()
{
    x_RemoveUnverifiedType(kUnverifiedMisassembled.Get());
}


void CUser_object::UpdateNcbiCleanup(int version)
{
    SetObjectType(eObjectType_Cleanup);
    CRef<CUser_field> method = SetFieldRef("method");
    method->SetValue("ExtendedSeqEntryCleanup");
    CRef<CUser_field> version_field = SetFieldRef("version");
    version_field->SetValue(version);

    // get current time
    CTime curr_time(CTime::eCurrent);
    CRef<CUser_field> month = SetFieldRef("month");
    month->SetData().SetInt(curr_time.Month());
    CRef<CUser_field> day = SetFieldRef("day");
    day->SetData().SetInt(curr_time.Day());
    CRef<CUser_field> year = SetFieldRef("year");
    year->SetData().SetInt(curr_time.Year());
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE
