# coding: UTF-8
#
# Xi Bot
#
# No rights reserved.
#
# Synopsis:
#   xi> 2d10 (two dice of ten)
#   [2d10] 13 = 7 + 6
#   xi> 5d
#   [5d6] 14 = 3 + 1 + 3 + 1 + 6
#   xi>100
#   [1d100] 26
#

class XiBot < Nadoka::NDK_Bot
  def bot_initialize
    @available_channel = @bot_config[:ch] || /.*/
  end

  def dice(count=1, max=6)
    count.times{ count += rand(max) }
    count
  end

  def on_privmsg prefix, ch, msg
    return unless @available_channel === ch
    return unless /\Axi\s*>\s*/ =~ msg
    case $~.post_match.downcase
    when /character/
      %w/STR DEX CON INT WIS CHA/.each do |name|
        values = (1..3).map{|i|rand(6)+1}
        sum = values.inject(0){|s, i|s += i}
        send_notice(ch, '%s: %2d = %s' % [name, sum, values.join(' + ')])
      end
    when /char/
      values = %w/STR DEX CON INT WIS CHA/.map do |name|
        '%s: %2d' % [name, (1..4).map{|i|rand(6)+1}.sort.last(3).inject(0){|s, i|s += i}]
      end
      send_notice(ch, "#{prefix.nick}: #{values.join(', ')}")
    when /san/
      int = dice(2, 6) + 6
      pow = dice(3, 6)
      san0 = pow * 5
      current = san0
      result = 'int:%d pow:%d san0:%d' % [int, pow, san0]

      case rand(10)
      when 9
        result <<= ' you saw Great Cthulhu.'
        losts = [dice(1, 10), dice(1, 100)]
      when 7, 8
        result <<= ' you saw a living dead.'
        losts = [1, dice(1, 10)]
      when 4, 5, 6
        result <<= ' you saw a Dimension-Shambler.'
        losts = [0, dice(1, 10)]
      when 2, 3, 4
        result <<= ' you woke up in the grave.'
        losts = [0, dice(1, 6)]
      else
        result <<= ' you find a dead body.'
        losts = [0, dice(1, 3)]
      end

      check = dice(1, 100)
      result << " check:#{check}"
      lost = losts[check > current ? 1 : 0]

      insane = false
      if lost > 0
        result << " you lost #{lost} SAN point."
        if lost >= current
          # eternal insanity
          result << ' you went mad. (eternal)'
          insane = true
        elsif lost * 5 > current
          # indefinite insanity
          r = %w/緊張症・痴呆症 記憶喪失 サンチョ・パンザ症、ドンキホーテ症 偏執症
          恐怖症、フェティッシュ 強迫観念、中毒、けいれん発作  誇大妄想 精神分裂症
          犯罪性精神異常 多重人格/[rand(10)]
          result << ' you went mad. (indefinite %s)' % NKF.nkf('-jW', r)
          insane = true
        elsif lost >= 5
          idearoll = dice(1, 100)
          result << " idearoll:#{idearoll}"
          if idearoll <= int * 5
            # temporary insanity
            result << ' you went mad. (temporary)'
            insane = true
          end
        end
      end
      result << ' you kept sanity.' unless insane
      #message = '%s: current: %d check: %d result: %s' % [prefix.nick, current, check, result]
      message = "#{prefix.nick}: #{result}"
      send_notice(ch, message)
    when /(?:(\d+)d)?(\d+)?(?:\*([1-9]))?/
      count = $1.to_i
      count = 1 unless (1..100).include? count
      max = $2.to_i
      max = 6 unless (1..1_000_000_000).include? max
      ($3 ? $3.to_i : 1).times do
        values = (1..count).map{|i|rand(max)+1}
        sum = values.inject(0){|s, i|s += i}
        if count == 1
          send_notice(ch, '%s: [%dd%d] %d' % [prefix.nick,count, max, sum])
        else
          send_notice(ch, '%s: [%dd%d] %d = %s' % [prefix.nick,count, max, sum, values.join(' + ')])
        end
      end
    end
  end
end
