(* ========================================================================= *)
(* A few simple examples of using the BDD library to prove tautologies.      *)
(* ========================================================================= *)

needs "Library/bdd.ml";;

(* ------------------------------------------------------------------------- *)
(* First a few basic tautologies with BDD_TAUT                               *)
(* ------------------------------------------------------------------------- *)

BDD_TAUT
 `((p <=> q) <=> r) <=> (p <=> (q <=> r))`;;

let syn323_1 =
 `~((v0 \/ v1) /\ (~v0 \/ v1) /\ (~v1 \/ v0) /\ (~v0 \/ ~v1))` in
BDD_TAUT syn323_1;;

let gra001_1 =
`~((~v1 \/ v0) /\
  (~v0 \/ v1) /\
  (~v4 \/ ~v2 \/ ~v0) /\
  (~v4 \/ v2 \/ v0) /\
  (~v2 \/ v4 \/ v0) /\
  (~v0 \/ v4 \/ v2) /\
  (~v3 \/ ~v2 \/ ~v1) /\
  (~v3 \/ v2 \/ v1) /\
  (~v2 \/ v3 \/ v1) /\
  (~v1 \/ v3 \/ v2) /\
  (~v3 \/ ~v4) /\
  (v3 \/ v4))` in
BDD_TAUT gra001_1;;

(* ------------------------------------------------------------------------- *)
(* The same formula considered ithout and with definitions.                  *)
(* ------------------------------------------------------------------------- *)

let rip02_be =
 `(car1 <=> (a1 /\ b1)) /\
  (cout <=> ((a2 \/ b2) /\ car1 \/ a2 /\ b2)) /\
  (som2 <=> ~(a2 <=> ~(b2 <=> car1))) /\
  (som1 <=> ~(a1 <=> b1)) /\
  (cout1 <=> (b1 /\ a1))
  ==> (som1 <=> ~(~a1 /\ ~b1 \/ a1 /\ b1)) /\
      (som2 <=>
       ~((~a2 /\ ~b2 \/ a2 /\ b2) /\ ~cout1 \/
         cout1 /\ ~(~a2 /\ ~b2 \/ a2 /\ b2))) /\
      (cout <=> (a2 /\ cout1 \/ b2 /\ cout1 \/ a2 /\ b2))`;;

BDD_TAUT rip02_be;;
BDD_DEFTAUT [] rip02_be;;

(* ------------------------------------------------------------------------- *)
(* With a specific variable order.                                           *)
(* ------------------------------------------------------------------------- *)

let add4_be  =
 `(n3 <=> a_0_) /\
  (n4 <=> a_2_) /\
  (n5 <=> a_4_) /\
  (n6 <=> a_5_) /\
  (n7 <=> a_6_) /\
  (n8 <=> a_8_) /\
  (n9 <=> a_3_) /\
  (n10 <=> a_7_) /\
  (n11 <=> a_9_) /\
  (n12 <=> a_11_) /\
  (n13 <=> a_1_) /\
  (n14 <=> a_10_) /\
  (n15 <=> anda) /\
  (n16 <=> exora) /\
  (n17 <=> b_3_) /\
  (n18 <=> b_4_) /\
  (n19 <=> b_6_) /\
  (n20 <=> b_1_) /\
  (n21 <=> b_7_) /\
  (n22 <=> b_9_) /\
  (n23 <=> b_2_) /\
  (n24 <=> b_5_) /\
  (n25 <=> b_8_) /\
  (n26 <=> b_10_) /\
  (n27 <=> b_11_) /\
  (n28 <=> b_0_) /\
  (n29 <=> andb) /\
  (n30 <=> exorb) /\
  (n31 <=> carryin) /\
  (n98 <=> ~n29) /\
  (n104 <=> ~n30) /\
  (n97 <=> ~n15) /\
  (n103 <=> ~n16) /\
  (n102 <=> ~n31) /\
  (n105 <=> ~n102) /\
  (n243 <=> ~n14 \/ ~n97) /\
  (n235 <=> ~n103) /\
  (n244 <=> ~n26 \/ ~n98) /\
  (n236 <=> ~n104) /\
  (n224 <=> ~n22 \/ ~n98) /\
  (n232 <=> ~n104) /\
  (n223 <=> ~n11 \/ ~n97) /\
  (n231 <=> ~n103) /\
  (n217 <=> ~n8 \/ ~n97) /\
  (n209 <=> ~n103) /\
  (n218 <=> ~n25 \/ ~n98) /\
  (n210 <=> ~n104) /\
  (n197 <=> ~n21 \/ ~n98) /\
  (n206 <=> ~n104) /\
  (n196 <=> ~n10 \/ ~n97) /\
  (n205 <=> ~n103) /\
  (n190 <=> ~n19 \/ ~n98) /\
  (n182 <=> ~n104) /\
  (n189 <=> ~n7 \/ ~n97) /\
  (n181 <=> ~n103) /\
  (n251 <=> ~n27 \/ ~n98) /\
  (n259 <=> ~n104) /\
  (n250 <=> ~n12 \/ ~n97) /\
  (n258 <=> ~n103) /\
  (n163 <=> ~n18 \/ ~n98) /\
  (n155 <=> ~n104) /\
  (n162 <=> ~n5 \/ ~n97) /\
  (n154 <=> ~n103) /\
  (n170 <=> ~n24 \/ ~n98) /\
  (n178 <=> ~n104) /\
  (n169 <=> ~n6 \/ ~n97) /\
  (n177 <=> ~n103) /\
  (n136 <=> ~n23 \/ ~n98) /\
  (n128 <=> ~n104) /\
  (n135 <=> ~n4 \/ ~n97) /\
  (n127 <=> ~n103) /\
  (n116 <=> ~n20 \/ ~n98) /\
  (n124 <=> ~n104) /\
  (n115 <=> ~n13 \/ ~n97) /\
  (n123 <=> ~n103) /\
  (n110 <=> ~n28 \/ ~n98) /\
  (n100 <=> ~n104) /\
  (n109 <=> ~n3 \/ ~n97) /\
  (n99 <=> ~n103) /\
  (n142 <=> ~n17 \/ ~n98) /\
  (n150 <=> ~n104) /\
  (n141 <=> ~n9 \/ ~n97) /\
  (n149 <=> ~n103) /\
  (n87 <=> ~n243) /\
  (n89 <=> ~n244) /\
  (n83 <=> ~n224) /\
  (n85 <=> ~n223) /\
  (n79 <=> ~n217) /\
  (n81 <=> ~n218) /\
  (n75 <=> ~n197) /\
  (n77 <=> ~n196) /\
  (n73 <=> ~n190) /\
  (n71 <=> ~n189) /\
  (n91 <=> ~n251) /\
  (n93 <=> ~n250) /\
  (n65 <=> ~n163) /\
  (n63 <=> ~n162) /\
  (n67 <=> ~n170) /\
  (n69 <=> ~n169) /\
  (n57 <=> ~n136) /\
  (n55 <=> ~n135) /\
  (n51 <=> ~n116) /\
  (n53 <=> ~n115) /\
  (n49 <=> ~n110) /\
  (n47 <=> ~n109) /\
  (n59 <=> ~n142) /\
  (n61 <=> ~n141) /\
  (n241 <=> n87 /\ n103 \/ ~n87 /\ ~n103) /\
  (n242 <=> n89 /\ n104 \/ ~n89 /\ ~n104) /\
  (n227 <=> n83 /\ n104 \/ ~n83 /\ ~n104) /\
  (n226 <=> n85 /\ n103 \/ ~n85 /\ ~n103) /\
  (n215 <=> n79 /\ n103 \/ ~n79 /\ ~n103) /\
  (n216 <=> n81 /\ n104 \/ ~n81 /\ ~n104) /\
  (n200 <=> n75 /\ n104 \/ ~n75 /\ ~n104) /\
  (n199 <=> n77 /\ n103 \/ ~n77 /\ ~n103) /\
  (n188 <=> n73 /\ n104 \/ ~n73 /\ ~n104) /\
  (n187 <=> n71 /\ n103 \/ ~n71 /\ ~n103) /\
  (n254 <=> n91 /\ n104 \/ ~n91 /\ ~n104) /\
  (n253 <=> n93 /\ n103 \/ ~n93 /\ ~n103) /\
  (n160 <=> n65 /\ n104 \/ ~n65 /\ ~n104) /\
  (n159 <=> n63 /\ n103 \/ ~n63 /\ ~n103) /\
  (n173 <=> n67 /\ n104 \/ ~n67 /\ ~n104) /\
  (n172 <=> n69 /\ n103 \/ ~n69 /\ ~n103) /\
  (n134 <=> n57 /\ n104 \/ ~n57 /\ ~n104) /\
  (n133 <=> n55 /\ n103 \/ ~n55 /\ ~n103) /\
  (n119 <=> n51 /\ n104 \/ ~n51 /\ ~n104) /\
  (n118 <=> n53 /\ n103 \/ ~n53 /\ ~n103) /\
  (n108 <=> n49 /\ n104 \/ ~n49 /\ ~n104) /\
  (n107 <=> n47 /\ n103 \/ ~n47 /\ ~n103) /\
  (n145 <=> n59 /\ n104 \/ ~n59 /\ ~n104) /\
  (n144 <=> n61 /\ n103 \/ ~n61 /\ ~n103) /\
  (n88 <=> ~n241) /\
  (n90 <=> ~n242) /\
  (n84 <=> ~n227) /\
  (n86 <=> ~n226) /\
  (n80 <=> ~n215) /\
  (n82 <=> ~n216) /\
  (n76 <=> ~n200) /\
  (n78 <=> ~n199) /\
  (n74 <=> ~n188) /\
  (n72 <=> ~n187) /\
  (n92 <=> ~n254) /\
  (n94 <=> ~n253) /\
  (n66 <=> ~n160) /\
  (n64 <=> ~n159) /\
  (n68 <=> ~n173) /\
  (n70 <=> ~n172) /\
  (n58 <=> ~n134) /\
  (n56 <=> ~n133) /\
  (n52 <=> ~n119) /\
  (n54 <=> ~n118) /\
  (n50 <=> ~n108) /\
  (n48 <=> ~n107) /\
  (n60 <=> ~n145) /\
  (n62 <=> ~n144) /\
  (n234 <=> ~n88) /\
  (n230 <=> ~n86) /\
  (n208 <=> ~n80) /\
  (n204 <=> ~n78) /\
  (n180 <=> ~n72) /\
  (n257 <=> ~n94) /\
  (n152 <=> ~n64) /\
  (n176 <=> ~n70) /\
  (n126 <=> ~n56) /\
  (n122 <=> ~n54) /\
  (n96 <=> ~n48) /\
  (n148 <=> ~n62) /\
  (n237 <=> n90 /\ n88 \/ ~n90 /\ ~n88) /\
  (n229 <=> n84 /\ n86 \/ ~n84 /\ ~n86) /\
  (n211 <=> n82 /\ n80 \/ ~n82 /\ ~n80) /\
  (n203 <=> n76 /\ n78 \/ ~n76 /\ ~n78) /\
  (n183 <=> n74 /\ n72 \/ ~n74 /\ ~n72) /\
  (n256 <=> n92 /\ n94 \/ ~n92 /\ ~n94) /\
  (n156 <=> n66 /\ n64 \/ ~n66 /\ ~n64) /\
  (n175 <=> n68 /\ n70 \/ ~n68 /\ ~n70) /\
  (n129 <=> n58 /\ n56 \/ ~n58 /\ ~n56) /\
  (n121 <=> n52 /\ n54 \/ ~n52 /\ ~n54) /\
  (n101 <=> n50 /\ n48 \/ ~n50 /\ ~n48) /\
  (n147 <=> n60 /\ n62 \/ ~n60 /\ ~n62) /\
  (n233 <=> ~n237) /\
  (n221 <=> ~n229) /\
  (n207 <=> ~n211) /\
  (n193 <=> ~n203) /\
  (n179 <=> ~n183) /\
  (n248 <=> ~n256) /\
  (n151 <=> ~n156) /\
  (n166 <=> ~n175) /\
  (n125 <=> ~n129) /\
  (n113 <=> ~n121) /\
  (n95 <=> ~n101) /\
  (n139 <=> ~n147) /\
  (n245 <=> ~n233) /\
  (n228 <=> ~n221) /\
  (n219 <=> ~n207) /\
  (n167 <=> ~n166 \/ ~n151 \/ ~n179 \/ ~n193) /\
  (n202 <=> ~n193) /\
  (n191 <=> ~n179) /\
  (n255 <=> ~n248) /\
  (n164 <=> ~n151) /\
  (n174 <=> ~n166) /\
  (n137 <=> ~n125) /\
  (n120 <=> ~n113) /\
  (n111 <=> ~n95) /\
  (n146 <=> ~n139) /\
  (n106 <=> n105 /\ ~n95 \/ ~n105 /\ n95) /\
  (n161 <=> ~n167) /\
  (n112 <=> ~n95 /\ ~n48 \/ ~n111 /\ ~n102) /\
  (n114 <=> ~n112) /\
  (n39 <=> ~n106) /\
  (n130 <=> ~n120 /\ ~n112 \/ ~n122 /\ ~n113) /\
  (n117 <=> n114 /\ n113 \/ ~n114 /\ ~n113) /\
  (n131 <=> ~n130) /\
  (n138 <=> ~n125 /\ ~n56 \/ ~n137 /\ ~n130) /\
  (n32 <=> ~n117) /\
  (n132 <=> n131 /\ ~n125 \/ ~n131 /\ n125) /\
  (n153 <=> ~n146 /\ ~n138 \/ ~n148 /\ ~n139) /\
  (n140 <=> ~n138) /\
  (n37 <=> ~n132) /\
  (n157 <=> ~n153) /\
  (n165 <=> ~n151 /\ ~n64 \/ ~n164 /\ ~n153) /\
  (n143 <=> n140 /\ n139 \/ ~n140 /\ ~n139) /\
  (n158 <=> n157 /\ ~n151 \/ ~n157 /\ n151) /\
  (n184 <=> ~n174 /\ ~n165 \/ ~n176 /\ ~n166) /\
  (n168 <=> ~n165) /\
  (n33 <=> ~n143) /\
  (n43 <=> ~n158) /\
  (n185 <=> ~n184) /\
  (n192 <=> ~n179 /\ ~n72 \/ ~n191 /\ ~n184) /\
  (n171 <=> n168 /\ n166 \/ ~n168 /\ ~n166) /\
  (n195 <=> ~n192) /\
  (n186 <=> n185 /\ ~n179 \/ ~n185 /\ n179) /\
  (n201 <=> ~n202 /\ ~n192 \/ ~n204 /\ ~n193) /\
  (n34 <=> ~n171) /\
  (n198 <=> n195 /\ n193 \/ ~n195 /\ ~n193) /\
  (n35 <=> ~n186) /\
  (n194 <=> ~n167 /\ ~n153 \/ ~n161 /\ ~n201) /\
  (n36 <=> ~n198) /\
  (n212 <=> ~n194) /\
  (n213 <=> ~n212) /\
  (n220 <=> ~n207 /\ ~n80 \/ ~n219 /\ ~n212) /\
  (n214 <=> n213 /\ ~n207 \/ ~n213 /\ n207) /\
  (n222 <=> ~n220) /\
  (n238 <=> ~n228 /\ ~n220 \/ ~n230 /\ ~n221) /\
  (n38 <=> ~n214) /\
  (n225 <=> n222 /\ n221 \/ ~n222 /\ ~n221) /\
  (n239 <=> ~n238) /\
  (n246 <=> ~n233 /\ ~n88 \/ ~n245 /\ ~n238) /\
  (n40 <=> ~n225) /\
  (n240 <=> n239 /\ ~n233 \/ ~n239 /\ n233) /\
  (n261 <=> ~n255 /\ ~n246 \/ ~n257 /\ ~n248) /\
  (n249 <=> ~n246) /\
  (n262 <=> n261 /\ n246 \/ ~n261 /\ ~n246) /\
  (n41 <=> ~n240) /\
  (n44 <=> ~n261) /\
  (n252 <=> n249 /\ n248 \/ ~n249 /\ ~n248) /\
  (n45 <=> ~n262) /\
  (n42 <=> ~n252) /\
  (n46 <=> ~n42) /\
  (o_4_ <=> n43) /\
  (o_11_ <=> n42) /\
  (o_10_ <=> n41) /\
  (o_9_ <=> n40) /\
  (o_0_ <=> n39) /\
  (o_8_ <=> n38) /\
  (o_2_ <=> n37) /\
  (o_7_ <=> n36) /\
  (o_6_ <=> n35) /\
  (o_5_ <=> n34) /\
  (o_3_ <=> n33) /\
  (o_1_ <=> n32) /\
  (aftbuf1 <=> ~anda) /\
  (aftbuf2 <=> ~andb) /\
  (aftbuf3 <=> ~exora) /\
  (aftbuf4 <=> ~exorb) /\
  (aftbuf5 <=> ~carryin) /\
  (n1_0_ <=> aftbuf1 /\ a_0_) /\
  (n1_1_ <=> aftbuf1 /\ a_1_) /\
  (n1_2_ <=> aftbuf1 /\ a_2_) /\
  (n1_3_ <=> aftbuf1 /\ a_3_) /\
  (n1_4_ <=> aftbuf1 /\ a_4_) /\
  (n1_5_ <=> aftbuf1 /\ a_5_) /\
  (n1_6_ <=> aftbuf1 /\ a_6_) /\
  (n1_7_ <=> aftbuf1 /\ a_7_) /\
  (n1_8_ <=> aftbuf1 /\ a_8_) /\
  (n1_9_ <=> aftbuf1 /\ a_9_) /\
  (n1_10_ <=> aftbuf1 /\ a_10_) /\
  (n1_11_ <=> aftbuf1 /\ a_11_) /\
  (n3_0_ <=> aftbuf2 /\ b_0_) /\
  (n3_1_ <=> aftbuf2 /\ b_1_) /\
  (n3_2_ <=> aftbuf2 /\ b_2_) /\
  (n3_3_ <=> aftbuf2 /\ b_3_) /\
  (n3_4_ <=> aftbuf2 /\ b_4_) /\
  (n3_5_ <=> aftbuf2 /\ b_5_) /\
  (n3_6_ <=> aftbuf2 /\ b_6_) /\
  (n3_7_ <=> aftbuf2 /\ b_7_) /\
  (n3_8_ <=> aftbuf2 /\ b_8_) /\
  (n3_9_ <=> aftbuf2 /\ b_9_) /\
  (n3_10_ <=> aftbuf2 /\ b_10_) /\
  (n3_11_ <=> aftbuf2 /\ b_11_) /\
  (n2_0_ <=> aftbuf3 /\ ~n1_0_ \/ ~aftbuf3 /\ n1_0_) /\
  (n2_1_ <=> aftbuf3 /\ ~n1_1_ \/ ~aftbuf3 /\ n1_1_) /\
  (n2_2_ <=> aftbuf3 /\ ~n1_2_ \/ ~aftbuf3 /\ n1_2_) /\
  (n2_3_ <=> aftbuf3 /\ ~n1_3_ \/ ~aftbuf3 /\ n1_3_) /\
  (n2_4_ <=> aftbuf3 /\ ~n1_4_ \/ ~aftbuf3 /\ n1_4_) /\
  (n2_5_ <=> aftbuf3 /\ ~n1_5_ \/ ~aftbuf3 /\ n1_5_) /\
  (n2_6_ <=> aftbuf3 /\ ~n1_6_ \/ ~aftbuf3 /\ n1_6_) /\
  (n2_7_ <=> aftbuf3 /\ ~n1_7_ \/ ~aftbuf3 /\ n1_7_) /\
  (n2_8_ <=> aftbuf3 /\ ~n1_8_ \/ ~aftbuf3 /\ n1_8_) /\
  (n2_9_ <=> aftbuf3 /\ ~n1_9_ \/ ~aftbuf3 /\ n1_9_) /\
  (n2_10_ <=> aftbuf3 /\ ~n1_10_ \/ ~aftbuf3 /\ n1_10_) /\
  (n2_11_ <=> aftbuf3 /\ ~n1_11_ \/ ~aftbuf3 /\ n1_11_) /\
  (n4_0_ <=> aftbuf4 /\ ~n3_0_ \/ ~aftbuf4 /\ n3_0_) /\
  (n4_1_ <=> aftbuf4 /\ ~n3_1_ \/ ~aftbuf4 /\ n3_1_) /\
  (n4_2_ <=> aftbuf4 /\ ~n3_2_ \/ ~aftbuf4 /\ n3_2_) /\
  (n4_3_ <=> aftbuf4 /\ ~n3_3_ \/ ~aftbuf4 /\ n3_3_) /\
  (n4_4_ <=> aftbuf4 /\ ~n3_4_ \/ ~aftbuf4 /\ n3_4_) /\
  (n4_5_ <=> aftbuf4 /\ ~n3_5_ \/ ~aftbuf4 /\ n3_5_) /\
  (n4_6_ <=> aftbuf4 /\ ~n3_6_ \/ ~aftbuf4 /\ n3_6_) /\
  (n4_7_ <=> aftbuf4 /\ ~n3_7_ \/ ~aftbuf4 /\ n3_7_) /\
  (n4_8_ <=> aftbuf4 /\ ~n3_8_ \/ ~aftbuf4 /\ n3_8_) /\
  (n4_9_ <=> aftbuf4 /\ ~n3_9_ \/ ~aftbuf4 /\ n3_9_) /\
  (n4_10_ <=> aftbuf4 /\ ~n3_10_ \/ ~aftbuf4 /\ n3_10_) /\
  (n4_11_ <=> aftbuf4 /\ ~n3_11_ \/ ~aftbuf4 /\ n3_11_) /\
  (cout1 <=> aftbuf5 /\ n4_0_ \/ aftbuf5 /\ n2_0_ \/ n4_0_ /\ n2_0_) /\
  (cout2 <=> cout1 /\ n4_1_ \/ cout1 /\ n2_1_ \/ n4_1_ /\ n2_1_) /\
  (cout3 <=> cout2 /\ n4_2_ \/ cout2 /\ n2_2_ \/ n4_2_ /\ n2_2_) /\
  (cout4 <=> cout3 /\ n4_3_ \/ cout3 /\ n2_3_ \/ n4_3_ /\ n2_3_) /\
  (cout5 <=> cout4 /\ n4_4_ \/ cout4 /\ n2_4_ \/ n4_4_ /\ n2_4_) /\
  (cout6 <=> cout5 /\ n4_5_ \/ cout5 /\ n2_5_ \/ n4_5_ /\ n2_5_) /\
  (cout7 <=> cout6 /\ n4_6_ \/ cout6 /\ n2_6_ \/ n4_6_ /\ n2_6_) /\
  (cout8 <=> cout7 /\ n4_7_ \/ cout7 /\ n2_7_ \/ n4_7_ /\ n2_7_) /\
  (cout9 <=> cout8 /\ n4_8_ \/ cout8 /\ n2_8_ \/ n4_8_ /\ n2_8_) /\
  (cout10 <=> cout9 /\ n4_9_ \/ cout9 /\ n2_9_ \/ n4_9_ /\ n2_9_) /\
  (cout11 <=> cout10 /\ n4_10_ \/ cout10 /\ n2_10_ \/ n4_10_ /\ n2_10_) /\
  (hulp0 <=> ~(n2_0_ <=> ~(n4_0_ <=> aftbuf5))) /\
  (hulp1 <=> ~(n2_1_ <=> ~(n4_1_ <=> cout1))) /\
  (hulp2 <=> ~(n2_2_ <=> ~(n4_2_ <=> cout2))) /\
  (hulp3 <=> ~(n2_3_ <=> ~(n4_3_ <=> cout3))) /\
  (hulp4 <=> ~(n2_4_ <=> ~(n4_4_ <=> cout4))) /\
  (hulp5 <=> ~(n2_5_ <=> ~(n4_5_ <=> cout5))) /\
  (hulp6 <=> ~(n2_6_ <=> ~(n4_6_ <=> cout6))) /\
  (hulp7 <=> ~(n2_7_ <=> ~(n4_7_ <=> cout7))) /\
  (hulp8 <=> ~(n2_8_ <=> ~(n4_8_ <=> cout8))) /\
  (hulp9 <=> ~(n2_9_ <=> ~(n4_9_ <=> cout9))) /\
  (hulp10 <=> ~(n2_10_ <=> ~(n4_10_ <=> cout10))) /\
  (hulp11 <=> ~(n2_11_ <=> ~(n4_11_ <=> cout11))) /\
  (hulp12 <=> cout11 /\ n4_11_ \/ cout11 /\ n2_11_ \/ n4_11_ /\ n2_11_)
  ==> (o_0_ <=> hulp0) /\
      (o_1_ <=> hulp1) /\
      (o_2_ <=> hulp2) /\
      (o_3_ <=> hulp3) /\
      (o_4_ <=> hulp4) /\
      (o_5_ <=> hulp5) /\
      (o_6_ <=> hulp6) /\
      (o_7_ <=> hulp7) /\
      (o_8_ <=> hulp8) /\
      (o_9_ <=> hulp9) /\
      (o_10_ <=> hulp10) /\
      (o_11_ <=> hulp11)`
and vars = map (C (curry mk_var) bool_ty)
          ["carryin";"anda";"andb";"exora";"exorb";
           "a_0_";"b_0_";"a_1_";"b_1_";"a_2_";
           "b_2_";"a_3_";"b_3_";"a_4_";"b_4_";
           "a_5_";"b_5_";"a_6_";"b_6_";"a_7_";
           "b_7_";"a_8_";"b_8_";"a_9_";"b_9_";
           "a_10_";"b_10_";"a_11_";"b_11_"] in
BDD_DEFTAUT vars add4_be;;
