/**********************************************************************
 *
 * Copyright (c) 2004 Olaf Willuhn
 * All rights reserved.
 * 
 * This software is copyrighted work licensed under the terms of the
 * Jameica License.  Please consult the file "LICENSE" for details. 
 *
 **********************************************************************/
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.Headline;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

/**
 * Detail-Ansicht eines Passports.
 */
public class Detail extends AbstractView
{
  private final static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

  /**
   * @see de.willuhn.jameica.gui.AbstractView#bind()
   */
  public void bind() throws Exception
  {

		final Controller control = new Controller(this);

		GUI.getView().setTitle(i18n.tr("Details der PIN/TAN-Konfiguration"));

    ColumnLayout layout = new ColumnLayout(getParent(),2);

    {
      Container group = new SimpleContainer(layout.getComposite());
      group.addHeadline(i18n.tr("Verbindungsdaten zur Bank"));
      group.addInput(control.getURL());
      group.addInput(control.getPort());
      group.addInput(control.getFilterType());
      group.addInput(control.getHBCIVersion());
    }
    
    {
      Container group = new SimpleContainer(layout.getComposite());
      group.addHeadline(i18n.tr("Benutzerdaten"));
      group.addInput(control.getUserId());
      group.addInput(control.getCustomerId());
      group.addInput(control.getBLZ());
    }
    
    {
      Container group = new SimpleContainer(getParent());

      group.addHeadline(i18n.tr("Erweiterte Einstellungen"));
      group.addCheckbox(control.getShowTan(),i18n.tr("TANs whrend der Eingabe anzeigen"));
      group.addInput(control.getBezeichnung());

      PtSecMech secMech = control.getConfig().getCurrentSecMech();
      if (secMech != null && secMech.useUSB())
      {
        group.addHeadline(i18n.tr("ChipTAN USB"));
        group.addInput(control.getChipTANUSB());
        group.addInput(control.getCardReaders());
      }
    }
    
    {
      PtSecMech secMech = control.getConfig().getStoredSecMech();
      ButtonArea buttons = new ButtonArea();
      String tanMedia = control.getConfig().getTanMedia();
      Button b = new Button(i18n.tr("TAN-Verfahren zurcksetzen"), new Action() {
        public void handleAction(Object context) throws ApplicationException
        {
          control.handleDeleteTanSettings();
        }
      },null,false,"edit-undo.png");
      b.setEnabled(secMech != null || (tanMedia != null && tanMedia.length() > 0));
      buttons.addButton(b);
      buttons.paint(getParent());
    }

    new Headline(getParent(),i18n.tr("Fest zugeordnete Konten"));
    control.getKontoAuswahl().paint(getParent());

    ButtonArea buttons = new ButtonArea();
    buttons.addButton(i18n.tr("BPD/UPD"),new Action()
    {
      public void handleAction(Object context) throws ApplicationException
      {
        control.handleDisplayProperties();
      }
    },null,false,"document-properties.png");
    buttons.addButton(i18n.tr("Konfiguration testen"),new Action()
    {
      public void handleAction(Object context) throws ApplicationException
      {
				control.handleTest();
      }
    },null,false,"dialog-information.png");
    buttons.addButton(i18n.tr("Speichern"),new Action()
    {
      public void handleAction(Object context) throws ApplicationException
      {
        control.handleStore();
      }
    },null,false,"document-save.png");
    buttons.paint(getParent());
  }
  
  /**
   * @see de.willuhn.jameica.gui.AbstractView#canBookmark()
   */
  public boolean canBookmark()
  {
    return false;
  }
}
