#!/bin/bash

# Copyright (C) 2001-2012 Michael Fuchs
trap cleanup 1 2 3 6

cleanup() {
  echo "Caught Signal ... cleaning up."
  tput cnorm
  exit 1
}

function fatal {
  echo "[FATAL] $1"
  exit 1
}

PROG=`type -p -- $0`

if [ $? -ne 0 ] ; then
    echo "Can't find installation directory!"
    exit 1
fi

# echo "Program: $PROG" 

PROG=`readlink -f "$PROG"`
# echo "Resolve symbolic links: $PROG"

BIN_DIR=`dirname "$PROG"`
# echo "bin directory: $BIN_DIR"

HEROLD_HOME=/usr/share/herold
# echo "herold home: $HEROLD_HOME"

HEROLD_JAR="/usr/share/java/herold.jar"
[ -f "$HEROLD_JAR" ] || fatal "Can't find jar archive '$HEROLD_JAR'!"

JAVA=`type -p -- java`
[ $? -eq 0 ] || fatal "Can't find java!"

lineWidth=`tput cols`
if [ $lineWidth -lt 42 ]; then
	lineWidth = 42;
fi

tput civis
"$JAVA" -Xmx1024m -Ddesktop.session=$DESKTOP_SESSION -Dconsole.lineWidth=$lineWidth -Dherold.home=$HEROLD_HOME -jar "$HEROLD_JAR" "$@"
tput cnorm
