/*
 * Copyright (C) 2015 Pengutronix, Uwe Kleine-König <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the
 * Free Software Foundation.
 */
#include <inttypes.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>

#include <dt/dt.h>

#include "dtblint.h"

#define IMX_NO_PAD_CTL	0x80000000	/* no pin config need */
#define IMX_PAD_SION	0x40000000	/* set SION */

#define IOMUXC_CONFIG_SION	(1 << 4)

struct padinfo {
	const char *padname;
	off_t swmux_regoffset;
	uint32_t swmux_reset_default;
	uint32_t swmux_writeable_mask;
	off_t swpad_regoffset;
	uint32_t swpad_reset_default;
	uint32_t swpad_writeable_mask;
};

struct socinfo {
	const struct padinfo *padinfo;
	size_t size_padinfo;
};

static const struct padinfo imx25_iomux_padinfo[] = {
	{
		.padname = "A10",
		.swmux_regoffset = 0x008,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = -1,
	}, {
		.padname = "A13",
		.swmux_regoffset = 0x00c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x22c,
		.swpad_reset_default = 0x80,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A14",
		.swmux_regoffset = 0x010,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x230,
		.swpad_reset_default = 0x80,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A15",
		.swmux_regoffset = 0x014,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x234,
		.swpad_reset_default = 0x80,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A16",
		.swmux_regoffset = 0x018,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "A17",
		.swmux_regoffset = 0x01c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x238,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A18",
		.swmux_regoffset = 0x020,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x23c,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A19",
		.swmux_regoffset = 0x024,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x240,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A20",
		.swmux_regoffset = 0x028,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x244,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A21",
		.swmux_regoffset = 0x02c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x248,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A22",
		.swmux_regoffset = 0x030,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "A23",
		.swmux_regoffset = 0x034,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x24c,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A24",
		.swmux_regoffset = 0x038,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x250,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "A25",
		.swmux_regoffset = 0x03c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x254,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "EB0",
		.swmux_regoffset = 0x040,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x258,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "EB1",
		.swmux_regoffset = 0x044,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x25c,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "OE",
		.swmux_regoffset = 0x048,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x260,
		.swpad_reset_default = 0x00,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "CS0",
		.swmux_regoffset = 0x04c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = -1,
	}, {
		.padname = "CS1",
		.swmux_regoffset = 0x050,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = -1,
	}, {
		.padname = "CS4",
		.swmux_regoffset = 0x054,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x264,
		.swpad_reset_default = 0x2001,
		.swpad_writeable_mask = 0x20b1,
	}, {
		.padname = "CS5",
		.swmux_regoffset = 0x058,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x268,
		.swpad_reset_default = 0x2001,
		.swpad_writeable_mask = 0x21b1,
	}, {
		.padname = "NF_CE0",
		.swmux_regoffset = 0x05c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x26c,
		.swpad_reset_default = 0x0001,
		.swpad_writeable_mask = 0x81,
	}, {
		.padname = "ECB",
		.swmux_regoffset = 0x060,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x270,
		.swpad_reset_default = 0x2e80,
		.swpad_writeable_mask = 0x2180,
	}, {
		.padname = "LBA",
		.swmux_regoffset = 0x064,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x274,
		.swpad_reset_default = 0x0000,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "BCLK",
		.swmux_regoffset = 0x068,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = -1,
	}, {
		.padname = "RW",
		.swmux_regoffset = 0x06c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x278,
		.swpad_reset_default = 0x0000,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "NFWE_B",
		.swmux_regoffset = 0x070,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "NFRE_B",
		.swmux_regoffset = 0x074,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "NFALE",
		.swmux_regoffset = 0x078,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "NFCLE",
		.swmux_regoffset = 0x07c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "NFWP_B",
		.swmux_regoffset = 0x080,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "NFRB",
		.swmux_regoffset = 0x084,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x27c,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x80,
	}, {
		.padname = "D15",
		.swmux_regoffset = 0x088,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x280,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "D14",
		.swmux_regoffset = 0x08c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x284,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "D13",
		.swmux_regoffset = 0x090,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x288,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "D12",
		.swmux_regoffset = 0x094,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x28c,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "D11",
		.swmux_regoffset = 0x098,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x290,
		/*
		 * specified as 0xa1 in IMX25RM; IMX25CEC says
		 * "100 kOhm Pull-Up" which would correspond to 0xe1.
		 */
		.swpad_reset_default = 0x0021,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "D10",
		.swmux_regoffset = 0x09c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x294,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "D9",
		.swmux_regoffset = 0x0a0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x298,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "D8",
		.swmux_regoffset = 0x0a4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x29c,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "D7",
		.swmux_regoffset = 0x0a8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2a0,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D6",
		.swmux_regoffset = 0x0ac,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2a4,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D5",
		.swmux_regoffset = 0x0b0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2a8,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D4",
		.swmux_regoffset = 0x0b4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2ac,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D3",
		.swmux_regoffset = 0x0b8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2b0,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D2",
		.swmux_regoffset = 0x0bc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2b4,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D1",
		.swmux_regoffset = 0x0c0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2b8,
		.swpad_reset_default = 0x0000,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "D0",
		.swmux_regoffset = 0x0c4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = 0x2bc,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x0040,
	}, {
		.padname = "LD0",
		.swmux_regoffset = 0x0c8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2c0,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "LD1",
		.swmux_regoffset = 0x0cc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2c4,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "LD2",
		.swmux_regoffset = 0x0d0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2c8,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD3",
		.swmux_regoffset = 0x0d4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2cc,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "LD4",
		.swmux_regoffset = 0x0d8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2d0,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD5",
		.swmux_regoffset = 0x0dc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2d4,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD6",
		.swmux_regoffset = 0x0e0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2d8,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD7",
		.swmux_regoffset = 0x0e4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2dc,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD8",
		.swmux_regoffset = 0x0e8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2e0,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD9",
		.swmux_regoffset = 0x0ec,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2e4,
		.swpad_reset_default = 0x0160,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "LD10",
		.swmux_regoffset = 0x0f0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2e8,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD11",
		.swmux_regoffset = 0x0f4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2ec,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "LD12",
		.swmux_regoffset = 0x0f8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2f0,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "LD13",
		.swmux_regoffset = 0x0fc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2f4,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "LD14",
		.swmux_regoffset = 0x100,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2f8,
		.swpad_reset_default = 0x0020,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "LD15",
		.swmux_regoffset = 0x104,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x2fc,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f8,
	}, {
		.padname = "HSYNC",
		.swmux_regoffset = 0x108,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x300,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "VSYNC",
		.swmux_regoffset = 0x10c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x304,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "LSCLK",
		.swmux_regoffset = 0x110,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x308,
		.swpad_reset_default = 0x0061,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "OE_ACD",
		.swmux_regoffset = 0x114,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x30c,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CONTRAST",
		.swmux_regoffset = 0x118,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x310,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "PWM",
		.swmux_regoffset = 0x11c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x314,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00f6,
	}, {
		.padname = "CSI_D2",
		.swmux_regoffset = 0x120,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x318,
		.swpad_reset_default = 0x00a1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSI_D3",
		.swmux_regoffset = 0x124,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x31c,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSI_D4",
		.swmux_regoffset = 0x128,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x320,
		.swpad_reset_default = 0x01a1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "CSI_D5",
		.swmux_regoffset = 0x12c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x324,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSI_D6",
		.swmux_regoffset = 0x130,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x328,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "CSI_D7",
		.swmux_regoffset = 0x134,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x32c,
		.swpad_reset_default = 0x01a0,
		.swpad_writeable_mask = 0x01f9,
	}, {
		.padname = "CSI_D8",
		.swmux_regoffset = 0x138,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x330,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "CSI_D9",
		.swmux_regoffset = 0x13c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x334,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "CSI_MCLK",
		.swmux_regoffset = 0x140,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x338,
		.swpad_reset_default = 0x0061,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSI_VSYNC",
		.swmux_regoffset = 0x144,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x33c,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSI_HSYNC",
		.swmux_regoffset = 0x148,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x340,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSI_PIXCLK",
		.swmux_regoffset = 0x14c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x344,
		.swpad_reset_default = 0x01a0,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "I2C1_CLK",
		.swmux_regoffset = 0x150,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x348,
		.swpad_reset_default = 0x00e8,
		.swpad_writeable_mask = 0x00be,
	}, {
		.padname = "I2C1_DAT",
		.swmux_regoffset = 0x154,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x34c,
		.swpad_reset_default = 0x00e8,
		.swpad_writeable_mask = 0x00be,
	}, {
		.padname = "CSPI1_MOSI",
		.swmux_regoffset = 0x158,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x350,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00b1,
	}, {
		.padname = "CSPI1_MISO",
		.swmux_regoffset = 0x15c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x354,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00b1,
	}, {
		.padname = "CSPI1_SS0",
		.swmux_regoffset = 0x160,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x358,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "CSPI1_SS1",
		.swmux_regoffset = 0x164,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x35c,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00b9,
	}, {
		.padname = "CSPI1_SCLK",
		.swmux_regoffset = 0x168,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x360,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00b1,
	}, {
		.padname = "CSPI1_RDY",
		.swmux_regoffset = 0x16c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x364,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00b1,
	}, {
		.padname = "UART1_RXD",
		.swmux_regoffset = 0x170,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x368,
		.swpad_reset_default = 0x00a0,
		.swpad_writeable_mask = 0x00b0,
	}, {
		.padname = "UART1_TXD",
		.swmux_regoffset = 0x174,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x36c,
		.swpad_reset_default = 0x0020,
		.swpad_writeable_mask = 0x00b0,
	}, {
		.padname = "UART1_RTS",
		.swmux_regoffset = 0x178,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x370,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "UART1_CTS",
		.swmux_regoffset = 0x17c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x374,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "UART2_RXD",
		.swmux_regoffset = 0x180,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x378,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00f0,
	}, {
		.padname = "UART2_TXD",
		.swmux_regoffset = 0x184,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x37c,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "UART2_RTS",
		.swmux_regoffset = 0x188,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x380,
		.swpad_reset_default = 0x00e1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "UART2_CTS",
		.swmux_regoffset = 0x18c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x384,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "SD1_CMD",
		.swmux_regoffset = 0x190,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x388,
		.swpad_reset_default = 0x00d1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "SD1_CLK",
		.swmux_regoffset = 0x194,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x38c,
		.swpad_reset_default = 0x00d1,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "SD1_DATA0",
		.swmux_regoffset = 0x198,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x390,
		.swpad_reset_default = 0x00d1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "SD1_DATA1",
		.swmux_regoffset = 0x19c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x394,
		.swpad_reset_default = 0x00d1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "SD1_DATA2",
		.swmux_regoffset = 0x1a0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x398,
		.swpad_reset_default = 0x00d1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "SD1_DATA3",
		.swmux_regoffset = 0x1a4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x39c,
		.swpad_reset_default = 0x00d1,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "KPP_ROW0",
		.swmux_regoffset = 0x1a8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a0,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "KPP_ROW1",
		.swmux_regoffset = 0x1ac,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a4,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "KPP_ROW2",
		.swmux_regoffset = 0x1b0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a8,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00f8,
	}, {
		.padname = "KPP_ROW3",
		.swmux_regoffset = 0x1b4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3ac,
		.swpad_reset_default = 0x00e0,
		.swpad_writeable_mask = 0x00f8,
	}, {
		.padname = "KPP_COL0",
		.swmux_regoffset = 0x1b8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3b0,
		.swpad_reset_default = 0x00a8,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "KPP_COL1",
		.swmux_regoffset = 0x1bc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3b4,
		.swpad_reset_default = 0x00a8,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "KPP_COL2",
		.swmux_regoffset = 0x1c0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3b8,
		.swpad_reset_default = 0x00a8,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "KPP_COL3",
		.swmux_regoffset = 0x1c4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3bc,
		.swpad_reset_default = 0x00a8,
		.swpad_writeable_mask = 0x00b8,
	}, {
		.padname = "FEC_MDC",
		.swmux_regoffset = 0x1c8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c0,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "FEC_MDIO",
		.swmux_regoffset = 0x1cc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c4,
		.swpad_reset_default = 0x01f0,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "FEC_TDATA0",
		.swmux_regoffset = 0x1d0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c8,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "FEC_TDATA1",
		.swmux_regoffset = 0x1d4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3cc,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f1,
	}, {
		.padname = "FEC_TX_EN",
		.swmux_regoffset = 0x1d8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d0,
		.swpad_reset_default = 0x0060,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "FEC_RDATA0",
		.swmux_regoffset = 0x1dc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d4,
		.swpad_reset_default = 0x00c1,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "FEC_RDATA1",
		.swmux_regoffset = 0x1e0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d8,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "FEC_RX_DV",
		.swmux_regoffset = 0x1e4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3dc,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00f9,
	}, {
		.padname = "FEC_TX_CLK",
		.swmux_regoffset = 0x1e8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e0,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x01f1,
	}, {
		.padname = "RTCK",
		.swmux_regoffset = 0x1ec,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e4,
		.swpad_reset_default = 0x0062,
		.swpad_writeable_mask = 0x00ff,
	}, {
		.padname = "TDO",
		.swpad_regoffset = 0x3e8,
		.swpad_reset_default = 0x0002,
		.swpad_writeable_mask = 0x0006,
	}, {
		.padname = "DE_B",
		.swmux_regoffset = 0x1f0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3ec,
		.swpad_reset_default = 0x00d0,
		.swpad_writeable_mask = 0x0006,
	}, {
		.padname = "GPIO_A",
		.swmux_regoffset = 0x1f4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f0,
		/* IMX25CE: no configuration after reset */
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00fe,
	}, {
		.padname = "GPIO_B",
		.swmux_regoffset = 0x1f8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f4,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00fe,
	}, {
		.padname = "GPIO_C",
		.swmux_regoffset = 0x1fc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f8,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00fe,
	}, {
		.padname = "GPIO_D",
		.swmux_regoffset = 0x200,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3fc,
		.swpad_reset_default = 0x0020,
		.swpad_writeable_mask = 0x00be,
	}, {
		.padname = "GPIO_E",
		.swmux_regoffset = 0x204,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x400,
		.swpad_reset_default = 0x00e8,
		.swpad_writeable_mask = 0x00be,
	}, {
		.padname = "GPIO_F",
		.swmux_regoffset = 0x208,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x404,
		.swpad_reset_default = 0x0020,
		.swpad_writeable_mask = 0x00b6,
	}, {
		.padname = "EXT_ARMCLK",
		.swmux_regoffset = 0x20c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "UPLL_BYPCLK",
		.swmux_regoffset = 0x210,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = -1,
	}, {
		.padname = "VSTBY_REQ",
		.swmux_regoffset = 0x214,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x408,
		.swpad_reset_default = 0x0000,
		.swpad_writeable_mask = 0x0086,
	}, {
		.padname = "VSTBY_ACK",
		.swmux_regoffset = 0x218,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x40c,
		.swpad_reset_default = 0x0080,
		.swpad_writeable_mask = 0x00b6,
	}, {
		.padname = "POWER_FAIL",
		.swmux_regoffset = 0x21c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x410,
		.swpad_reset_default = 0x00c0,
		.swpad_writeable_mask = 0x00b6,
	}, {
		.padname = "CLKO",
		.swmux_regoffset = 0x220,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x414,
		.swpad_reset_default = 0x0004,
		.swpad_writeable_mask = 0x0006,
	}, {
		.padname = "BOOT_MODE0",
		.swmux_regoffset = 0x224,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = -1,
	}, {
		.padname = "BOOT_MODE1",
		.swmux_regoffset = 0x228,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000007,
		.swpad_regoffset = -1,
	},
};

static const struct socinfo imx25_socinfo = {
	.padinfo = imx25_iomux_padinfo,
	.size_padinfo = ARRAY_SIZE(imx25_iomux_padinfo),
};

static const struct padinfo imx6dl_iomux_padinfo[] = {
	{
		.padname = "CSI0_DAT10",
		.swmux_regoffset = 0x04c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x360,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT11",
		.swmux_regoffset = 0x050,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x364,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT12",
		.swmux_regoffset = 0x054,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x368,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT13",
		.swmux_regoffset = 0x058,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x36c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT14",
		.swmux_regoffset = 0x05c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x370,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT15",
		.swmux_regoffset = 0x060,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x374,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT16",
		.swmux_regoffset = 0x064,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x378,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT17",
		.swmux_regoffset = 0x068,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x37c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT18",
		.swmux_regoffset = 0x06c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x380,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT19",
		.swmux_regoffset = 0x070,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x384,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT4",
		.swmux_regoffset = 0x074,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x388,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT5",
		.swmux_regoffset = 0x078,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x38c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT6",
		.swmux_regoffset = 0x07c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x390,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT7",
		.swmux_regoffset = 0x080,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x394,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT8",
		.swmux_regoffset = 0x084,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x398,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DAT9",
		.swmux_regoffset = 0x088,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x39c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DATA_EN",
		.swmux_regoffset = 0x08c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_DATA_EN",
		.swmux_regoffset = 0x08c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_MCLK",
		.swmux_regoffset = 0x090,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_PIXCLK",
		.swmux_regoffset = 0x094,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "CSI0_VSYNC",
		.swmux_regoffset = 0x098,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3ac,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DI0_DISP_CLK",
		.swmux_regoffset = 0x09c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x3b0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DI0_DISP_CLK",
		.swmux_regoffset = 0x09c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x3b0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DI0_PIN15",
		.swmux_regoffset = 0x0a0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x3b4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DI0_PIN2",
		.swmux_regoffset = 0x0a4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x3b8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DI0_PIN3",
		.swmux_regoffset = 0x0a8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x3bc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DI0_PIN4",
		.swmux_regoffset = 0x0ac,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x3c0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT0",
		.swmux_regoffset = 0x0b0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT1",
		.swmux_regoffset = 0x0b4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT10",
		.swmux_regoffset = 0x0b8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3cc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT11",
		.swmux_regoffset = 0x0bc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT12",
		.swmux_regoffset = 0x0c0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT13",
		.swmux_regoffset = 0x0c4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT14",
		.swmux_regoffset = 0x0c8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3dc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT15",
		.swmux_regoffset = 0x0cc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT16",
		.swmux_regoffset = 0x0d0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT17",
		.swmux_regoffset = 0x0d4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT18",
		.swmux_regoffset = 0x0d8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3ec,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT19",
		.swmux_regoffset = 0x0dc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT2",
		.swmux_regoffset = 0x0e0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT20",
		.swmux_regoffset = 0x0e4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT21",
		.swmux_regoffset = 0x0e8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3fc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT22",
		.swmux_regoffset = 0x0ec,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x400,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT23",
		.swmux_regoffset = 0x0f0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x404,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT3",
		.swmux_regoffset = 0x0f4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x408,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT4",
		.swmux_regoffset = 0x0f8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x40c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT5",
		.swmux_regoffset = 0x0fc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x410,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT6",
		.swmux_regoffset = 0x100,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x414,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT7",
		.swmux_regoffset = 0x104,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x418,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT8",
		.swmux_regoffset = 0x108,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x41c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "DISP0_DAT9",
		.swmux_regoffset = 0x10c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x420,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A16",
		.swmux_regoffset = 0x110,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4e0,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A17",
		.swmux_regoffset = 0x114,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4e4,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A18",
		.swmux_regoffset = 0x118,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4e8,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A19",
		.swmux_regoffset = 0x11c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4ec,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A20",
		.swmux_regoffset = 0x120,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4f0,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A21",
		.swmux_regoffset = 0x124,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4f4,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A22",
		.swmux_regoffset = 0x128,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4f8,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A23",
		.swmux_regoffset = 0x12c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x4fc,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A24",
		.swmux_regoffset = 0x130,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x500,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_A25",
		.swmux_regoffset = 0x134,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x504,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_BCLK",
		.swmux_regoffset = 0x138,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x508,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_CS0",
		.swmux_regoffset = 0x13c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x50c,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_CS1",
		.swmux_regoffset = 0x140,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x510,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D16",
		.swmux_regoffset = 0x144,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x514,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D17",
		.swmux_regoffset = 0x148,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x518,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D18",
		.swmux_regoffset = 0x14c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x51c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D19",
		.swmux_regoffset = 0x150,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x520,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D20",
		.swmux_regoffset = 0x154,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x524,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D21",
		.swmux_regoffset = 0x158,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x528,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D22",
		.swmux_regoffset = 0x15c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x52c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D23",
		.swmux_regoffset = 0x160,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x530,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D24",
		.swmux_regoffset = 0x164,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x534,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D25",
		.swmux_regoffset = 0x168,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x538,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D26",
		.swmux_regoffset = 0x16c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x53c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D27",
		.swmux_regoffset = 0x170,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x540,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D28",
		.swmux_regoffset = 0x174,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x544,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D29",
		.swmux_regoffset = 0x178,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x548,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D30",
		.swmux_regoffset = 0x17c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x54c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_D31",
		.swmux_regoffset = 0x180,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x550,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA0",
		.swmux_regoffset = 0x184,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x554,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA1",
		.swmux_regoffset = 0x188,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x558,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA10",
		.swmux_regoffset = 0x18c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x55c,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA11",
		.swmux_regoffset = 0x190,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x560,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA12",
		.swmux_regoffset = 0x194,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x564,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA13",
		.swmux_regoffset = 0x198,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x568,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA14",
		.swmux_regoffset = 0x19c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x56c,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA15",
		.swmux_regoffset = 0x1a0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x570,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA2",
		.swmux_regoffset = 0x1a4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x574,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA3",
		.swmux_regoffset = 0x1a8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x578,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA4",
		.swmux_regoffset = 0x1ac,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x57c,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA5",
		.swmux_regoffset = 0x1b0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x580,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA6",
		.swmux_regoffset = 0x1b4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x584,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA7",
		.swmux_regoffset = 0x1b8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x588,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA8",
		.swmux_regoffset = 0x1bc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x58c,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_DA9",
		.swmux_regoffset = 0x1c0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x590,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_EB0",
		.swmux_regoffset = 0x1c4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x594,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_EB1",
		.swmux_regoffset = 0x1c8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x598,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_EB2",
		.swmux_regoffset = 0x1cc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x59c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_EB3",
		.swmux_regoffset = 0x1d0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x5a0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_LBA",
		.swmux_regoffset = 0x1d4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x5a4,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_OE",
		.swmux_regoffset = 0x1d8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x5a8,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_RW",
		.swmux_regoffset = 0x1dc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x5ac,
		.swpad_reset_default = 0x0b0b1,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "EIM_WAIT",
		.swmux_regoffset = 0x1e0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5b0,
		.swpad_reset_default = 0x0b060,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_CRS_DV",
		.swmux_regoffset = 0x1e4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5b4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f839,
	}, {
		.padname = "ENET_MDC",
		.swmux_regoffset = 0x1e8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5b8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_MDIO",
		.swmux_regoffset = 0x1ec,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5bc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_REF_CLK",
		.swmux_regoffset = 0x1f0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5c0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_RX_ER",
		.swmux_regoffset = 0x1f4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5c4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_RXD0",
		.swmux_regoffset = 0x1f8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5c8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f839,
	}, {
		.padname = "ENET_RXD1",
		.swmux_regoffset = 0x1fc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5cc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_TX_EN",
		.swmux_regoffset = 0x200,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x5d0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_TXD0",
		.swmux_regoffset = 0x204,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5d4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "ENET_TXD1",
		.swmux_regoffset = 0x208,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x5d8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_0",
		.swmux_regoffset = 0x20c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5dc,
		.swpad_reset_default = 0x130b0,
		.swpad_writeable_mask = 0x1f839,
	}, {
		.padname = "GPIO_1",
		.swmux_regoffset = 0x210,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5e0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_16",
		.swmux_regoffset = 0x214,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5e4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_17",
		.swmux_regoffset = 0x218,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5e8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f839,
	}, {
		.padname = "GPIO_18",
		.swmux_regoffset = 0x21c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5ec,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_19",
		.swmux_regoffset = 0x220,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5f0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_2",
		.swmux_regoffset = 0x224,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5f4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_3",
		.swmux_regoffset = 0x228,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5f8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_4",
		.swmux_regoffset = 0x22c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5fc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_5",
		.swmux_regoffset = 0x230,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x600,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_6",
		.swmux_regoffset = 0x234,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x604,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_7",
		.swmux_regoffset = 0x238,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x608,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_8",
		.swmux_regoffset = 0x23c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x60c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "GPIO_9",
		.swmux_regoffset = 0x240,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x610,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_COL0",
		.swmux_regoffset = 0x244,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x62c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_COL1",
		.swmux_regoffset = 0x248,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x630,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_COL2",
		.swmux_regoffset = 0x24c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x634,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_COL3",
		.swmux_regoffset = 0x250,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x638,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_COL4",
		.swmux_regoffset = 0x254,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x63c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_ROW0",
		.swmux_regoffset = 0x258,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x640,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_ROW1",
		.swmux_regoffset = 0x25c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x644,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_ROW2",
		.swmux_regoffset = 0x260,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x648,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_ROW3",
		.swmux_regoffset = 0x264,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x64c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "KEY_ROW4",
		.swmux_regoffset = 0x268,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x650,
		.swpad_reset_default = 0x130b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_ALE",
		.swmux_regoffset = 0x26c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x654,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_CLE",
		.swmux_regoffset = 0x270,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x658,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_CS0",
		.swmux_regoffset = 0x274,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x65c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_CS1",
		.swmux_regoffset = 0x278,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x660,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_CS2",
		.swmux_regoffset = 0x27c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x664,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_CS3",
		.swmux_regoffset = 0x280,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x668,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D0",
		.swmux_regoffset = 0x284,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x66c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D1",
		.swmux_regoffset = 0x288,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x670,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D2",
		.swmux_regoffset = 0x28c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x674,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D3",
		.swmux_regoffset = 0x290,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x678,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D4",
		.swmux_regoffset = 0x294,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x67c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D5",
		.swmux_regoffset = 0x298,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x680,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D6",
		.swmux_regoffset = 0x29c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x684,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_D7",
		.swmux_regoffset = 0x2a0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x688,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_RB0",
		.swmux_regoffset = 0x2a4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x68c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "NANDF_WP_B",
		.swmux_regoffset = 0x2a8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x0000001f,
		.swpad_regoffset = 0x690,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "RGMII_RD0",
		.swmux_regoffset = 0x2ac,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x694,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_RD1",
		.swmux_regoffset = 0x2b0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x698,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_RD2",
		.swmux_regoffset = 0x2b4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x69c,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_RD3",
		.swmux_regoffset = 0x2b8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6a0,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_RX_CTL",
		.swmux_regoffset = 0x2bc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6a4,
		.swpad_reset_default = 0x13030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_RXC",
		.swmux_regoffset = 0x2c0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6a8,
		.swpad_reset_default = 0x13030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_TD0",
		.swmux_regoffset = 0x2c4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6ac,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_TD1",
		.swmux_regoffset = 0x2c8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6b0,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_TD2",
		.swmux_regoffset = 0x2cc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6b4,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_TD3",
		.swmux_regoffset = 0x2d0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6b8,
		.swpad_reset_default = 0x1b030,
		.swpad_writeable_mask = 0x3f038,
	}, {
		.padname = "RGMII_TX_CTL",
		.swmux_regoffset = 0x2d4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6bc,
		.swpad_reset_default = 0x13030,
		.swpad_writeable_mask = 0x1f038,
	}, {
		.padname = "RGMII_TXC",
		.swmux_regoffset = 0x2d8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6c0,
		.swpad_reset_default = 0x13030,
		.swpad_writeable_mask = 0x1f038,
	}, {
		.padname = "SD1_CLK",
		.swmux_regoffset = 0x2dc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6c4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD1_CMD",
		.swmux_regoffset = 0x2e0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6c8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD1_DAT0",
		.swmux_regoffset = 0x2e4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6cc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD1_DAT1",
		.swmux_regoffset = 0x2e8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6d0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD1_DAT2",
		.swmux_regoffset = 0x2ec,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6d4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD1_DAT3",
		.swmux_regoffset = 0x2f0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6d8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD2_CLK",
		.swmux_regoffset = 0x2f4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6dc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD2_CMD",
		.swmux_regoffset = 0x2f8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6e0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD2_DAT0",
		.swmux_regoffset = 0x2fc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6e4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD2_DAT1",
		.swmux_regoffset = 0x300,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6e8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD2_DAT2",
		.swmux_regoffset = 0x304,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6ec,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD2_DAT3",
		.swmux_regoffset = 0x308,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6f0,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_CLK",
		.swmux_regoffset = 0x30c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6f4,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_CMD",
		.swmux_regoffset = 0x310,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6f8,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT0",
		.swmux_regoffset = 0x314,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6fc,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT1",
		.swmux_regoffset = 0x318,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x700,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT2",
		.swmux_regoffset = 0x31c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x704,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT3",
		.swmux_regoffset = 0x320,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x708,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT4",
		.swmux_regoffset = 0x324,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x70c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT5",
		.swmux_regoffset = 0x328,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x710,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT6",
		.swmux_regoffset = 0x32c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x714,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_DAT7",
		.swmux_regoffset = 0x330,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x718,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD3_RST",
		.swmux_regoffset = 0x334,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x71c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_CLK",
		.swmux_regoffset = 0x338,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x720,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_CMD",
		.swmux_regoffset = 0x33c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x724,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT0",
		.swmux_regoffset = 0x340,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x728,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT1",
		.swmux_regoffset = 0x344,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x72c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT2",
		.swmux_regoffset = 0x348,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x730,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT3",
		.swmux_regoffset = 0x34c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x734,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT4",
		.swmux_regoffset = 0x350,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x738,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT5",
		.swmux_regoffset = 0x354,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x73c,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT6",
		.swmux_regoffset = 0x358,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x740,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	}, {
		.padname = "SD4_DAT7",
		.swmux_regoffset = 0x35c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x744,
		.swpad_reset_default = 0x1b0b0,
		.swpad_writeable_mask = 0x1f8f9,
	},
};

static const struct socinfo imx6dl_socinfo = {
	.padinfo = imx6dl_iomux_padinfo,
	.size_padinfo = ARRAY_SIZE(imx6dl_iomux_padinfo),
};

static const struct padinfo imx6q_iomux_padinfo[] = {
	{
		.padname = "SD2_DATA1",
		.swmux_regoffset = 0x04c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x360,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD2_DATA2",
		.swmux_regoffset = 0x050,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x364,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD2_DATA0",
		.swmux_regoffset = 0x054,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x368,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "RGMII_TXC",
		.swmux_regoffset = 0x058,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x36c,
		.swpad_reset_default = 0x00013030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_TD0",
		.swmux_regoffset = 0x05c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x370,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_TD1",
		.swmux_regoffset = 0x060,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x374,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_TD2",
		.swmux_regoffset = 0x064,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x378,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_TD3",
		.swmux_regoffset = 0x068,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x37c,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_RX_CTL",
		.swmux_regoffset = 0x06c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x380,
		.swpad_reset_default = 0x00013030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_RD0",
		.swmux_regoffset = 0x070,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x384,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_TX_CTL",
		.swmux_regoffset = 0x074,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x388,
		.swpad_reset_default = 0x00013030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_RD1",
		.swmux_regoffset = 0x078,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x38c,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_RD2",
		.swmux_regoffset = 0x07c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x390,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_RD3",
		.swmux_regoffset = 0x080,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x394,
		.swpad_reset_default = 0x0001b030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "RGMII_RXC",
		.swmux_regoffset = 0x084,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x398,
		.swpad_reset_default = 0x00013030,
		.swpad_writeable_mask = 0x0001f038,
	}, {
		.padname = "EIM_ADDR25",
		.swmux_regoffset = 0x088,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x39c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_EB2_B",
		.swmux_regoffset = 0x08c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA16",
		.swmux_regoffset = 0x090,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA17",
		.swmux_regoffset = 0x094,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3a8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA18",
		.swmux_regoffset = 0x098,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3ac,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA19",
		.swmux_regoffset = 0x09c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3b0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA20",
		.swmux_regoffset = 0x0a0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3b4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA21",
		.swmux_regoffset = 0x0a4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3b8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA22",
		.swmux_regoffset = 0x0a8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3bc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA23",
		.swmux_regoffset = 0x0ac,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_EB3_B",
		.swmux_regoffset = 0x0b0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA24",
		.swmux_regoffset = 0x0b4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3c8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA25",
		.swmux_regoffset = 0x0b8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3cc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA26",
		.swmux_regoffset = 0x0bc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA27",
		.swmux_regoffset = 0x0c0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA28",
		.swmux_regoffset = 0x0c4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3d8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA29",
		.swmux_regoffset = 0x0c8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3dc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA30",
		.swmux_regoffset = 0x0cc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_DATA31",
		.swmux_regoffset = 0x0d0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR24",
		.swmux_regoffset = 0x0d4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3e8,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR23",
		.swmux_regoffset = 0x0d8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3ec,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR22",
		.swmux_regoffset = 0x0dc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f0,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR21",
		.swmux_regoffset = 0x0e0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f4,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR20",
		.swmux_regoffset = 0x0e4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3f8,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR19",
		.swmux_regoffset = 0x0e8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x3fc,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR18",
		.swmux_regoffset = 0x0ec,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x400,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR17",
		.swmux_regoffset = 0x0f0,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x404,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_ADDR16",
		.swmux_regoffset = 0x0f4,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x408,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_CS0_B",
		.swmux_regoffset = 0x0f8,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x40c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_CS1_B",
		.swmux_regoffset = 0x0fc,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x410,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_OE_B",
		.swmux_regoffset = 0x100,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x414,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_RW",
		.swmux_regoffset = 0x104,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x418,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_LBA_B",
		.swmux_regoffset = 0x108,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x41c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_EB0_B",
		.swmux_regoffset = 0x10c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x420,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_EB1_B",
		.swmux_regoffset = 0x110,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x424,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD00",
		.swmux_regoffset = 0x114,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x428,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD01",
		.swmux_regoffset = 0x118,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x42c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD02",
		.swmux_regoffset = 0x11c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x430,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD03",
		.swmux_regoffset = 0x120,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x434,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD04",
		.swmux_regoffset = 0x124,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x438,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD05",
		.swmux_regoffset = 0x128,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x43c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD06",
		.swmux_regoffset = 0x12c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x440,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD07",
		.swmux_regoffset = 0x130,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x444,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD08",
		.swmux_regoffset = 0x134,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x448,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD09",
		.swmux_regoffset = 0x138,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x44c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD10",
		.swmux_regoffset = 0x13c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x450,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD11",
		.swmux_regoffset = 0x140,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x454,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD12",
		.swmux_regoffset = 0x144,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x458,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD13",
		.swmux_regoffset = 0x148,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x45c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD14",
		.swmux_regoffset = 0x14c,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x460,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_AD15",
		.swmux_regoffset = 0x150,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x464,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_WAIT_B",
		.swmux_regoffset = 0x154,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x468,
		.swpad_reset_default = 0x0000b060,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "EIM_BCLK",
		.swmux_regoffset = 0x158,
		.swmux_reset_default = 0x00000000,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x46c,
		.swpad_reset_default = 0x0000b0b1,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DI0_DISP_CLK",
		.swmux_regoffset = 0x15c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x470,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DI0_PIN15",
		.swmux_regoffset = 0x160,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x474,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DI0_PIN02",
		.swmux_regoffset = 0x164,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x478,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DI0_PIN03",
		.swmux_regoffset = 0x168,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x47c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DI0_PIN04",
		.swmux_regoffset = 0x16c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x480,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA00",
		.swmux_regoffset = 0x170,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x484,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA01",
		.swmux_regoffset = 0x174,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x488,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA02",
		.swmux_regoffset = 0x178,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x48c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA03",
		.swmux_regoffset = 0x17c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x490,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA04",
		.swmux_regoffset = 0x180,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x494,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA05",
		.swmux_regoffset = 0x184,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x498,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA06",
		.swmux_regoffset = 0x188,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x49c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA07",
		.swmux_regoffset = 0x18c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4a0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA08",
		.swmux_regoffset = 0x190,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4a4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA09",
		.swmux_regoffset = 0x194,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4a8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA10",
		.swmux_regoffset = 0x198,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4ac,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA11",
		.swmux_regoffset = 0x19c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4b0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA12",
		.swmux_regoffset = 0x1a0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4b4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA13",
		.swmux_regoffset = 0x1a4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4b8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA14",
		.swmux_regoffset = 0x1a8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4bc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA15",
		.swmux_regoffset = 0x1ac,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4c0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA16",
		.swmux_regoffset = 0x1b0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4c4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA17",
		.swmux_regoffset = 0x1b4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4c8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA18",
		.swmux_regoffset = 0x1b8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4cc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA19",
		.swmux_regoffset = 0x1bc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4d0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA20",
		.swmux_regoffset = 0x1c0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4d4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA21",
		.swmux_regoffset = 0x1c4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4d8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA22",
		.swmux_regoffset = 0x1c8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4dc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "DISP0_DATA23",
		.swmux_regoffset = 0x1cc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4e0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_MDIO",
		.swmux_regoffset = 0x1d0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4e4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_REF_CLK",
		.swmux_regoffset = 0x1d4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4e8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_RX_ER",
		.swmux_regoffset = 0x1d8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4ec,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_CRS_DV",
		.swmux_regoffset = 0x1dc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4f0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_RX_DATA1",
		.swmux_regoffset = 0x1e0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4f4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_RX_DATA0",
		.swmux_regoffset = 0x1e4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4f8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_TX_EN",
		.swmux_regoffset = 0x1e8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x4fc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_TX_DATA1",
		.swmux_regoffset = 0x1ec,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x500,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_TX_DATA0",
		.swmux_regoffset = 0x1f0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x504,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "ENET_MDC",
		.swmux_regoffset = 0x1f4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x508,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_COL0",
		.swmux_regoffset = 0x1f8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5c8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_ROW0",
		.swmux_regoffset = 0x1fc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5cc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_COL1",
		.swmux_regoffset = 0x200,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5d0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_ROW1",
		.swmux_regoffset = 0x204,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5d4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_COL2",
		.swmux_regoffset = 0x208,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5d8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_ROW2",
		.swmux_regoffset = 0x20c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5dc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_COL3",
		.swmux_regoffset = 0x210,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5e0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_ROW3",
		.swmux_regoffset = 0x214,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5e4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_COL4",
		.swmux_regoffset = 0x218,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5e8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "KEY_ROW4",
		.swmux_regoffset = 0x21c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5ec,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO00",
		.swmux_regoffset = 0x220,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5f0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO01",
		.swmux_regoffset = 0x224,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5f4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO09",
		.swmux_regoffset = 0x228,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5f8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO03",
		.swmux_regoffset = 0x22c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x5fc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO06",
		.swmux_regoffset = 0x230,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x600,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO02",
		.swmux_regoffset = 0x234,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x604,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO04",
		.swmux_regoffset = 0x238,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x608,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO05",
		.swmux_regoffset = 0x23c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x60c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO07",
		.swmux_regoffset = 0x240,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x610,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO08",
		.swmux_regoffset = 0x244,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x614,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO16",
		.swmux_regoffset = 0x248,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x618,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO17",
		.swmux_regoffset = 0x24c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x61c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO18",
		.swmux_regoffset = 0x250,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x620,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "GPIO19",
		.swmux_regoffset = 0x254,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x624,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_PIXCLK",
		.swmux_regoffset = 0x258,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x628,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_HSYNC",
		.swmux_regoffset = 0x25c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x62c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA_EN",
		.swmux_regoffset = 0x260,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x630,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_VSYNC",
		.swmux_regoffset = 0x264,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x634,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA04",
		.swmux_regoffset = 0x268,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x638,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA05",
		.swmux_regoffset = 0x26c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x63c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA06",
		.swmux_regoffset = 0x270,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x640,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA07",
		.swmux_regoffset = 0x274,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x644,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA08",
		.swmux_regoffset = 0x278,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x648,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA9",
		.swmux_regoffset = 0x27c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x64c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA10",
		.swmux_regoffset = 0x280,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x650,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA11",
		.swmux_regoffset = 0x284,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x654,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA12",
		.swmux_regoffset = 0x288,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x658,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA13",
		.swmux_regoffset = 0x28c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x65c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA14",
		.swmux_regoffset = 0x290,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x660,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA15",
		.swmux_regoffset = 0x294,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x664,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA16",
		.swmux_regoffset = 0x298,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x668,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA17",
		.swmux_regoffset = 0x29c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x66c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA18",
		.swmux_regoffset = 0x2a0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x670,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "CSI0_DATA19",
		.swmux_regoffset = 0x2a4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x674,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "JTAG_TMS",
		.swpad_regoffset = 0x678,
		.swpad_reset_default = 0x00007060,
		.swpad_writeable_mask = 0x0001d000,
		/* XXX: there are more JTAG pads here with swpad only */
	}, {
		.padname = "SD3_DATA7",
		.swmux_regoffset = 0x2a8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x690,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA6",
		.swmux_regoffset = 0x2ac,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x694,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA5",
		.swmux_regoffset = 0x2b0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x698,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA4",
		.swmux_regoffset = 0x2b4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x69c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_CMD",
		.swmux_regoffset = 0x2b8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6a0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_CLK",
		.swmux_regoffset = 0x2bc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6a4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA0",
		.swmux_regoffset = 0x2c0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6a8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA1",
		.swmux_regoffset = 0x2c4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6ac,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA2",
		.swmux_regoffset = 0x2c8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6b0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_DATA3",
		.swmux_regoffset = 0x2cc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6b4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD3_RESET",
		.swmux_regoffset = 0x2d0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6b8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_CLE",
		.swmux_regoffset = 0x2d4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6bc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_ALE",
		.swmux_regoffset = 0x2d8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6c0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_WP_B",
		.swmux_regoffset = 0x2dc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6c4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_READY_B",
		.swmux_regoffset = 0x2e0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6c8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_CS0_B",
		.swmux_regoffset = 0x2e4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6cc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_CS1_B",
		.swmux_regoffset = 0x2e8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6d0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_CS2_B",
		.swmux_regoffset = 0x2ec,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6d4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_CS3_B",
		.swmux_regoffset = 0x2f0,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6d8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_CMD",
		.swmux_regoffset = 0x2f4,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6dc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_CLK",
		.swmux_regoffset = 0x2f8,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6e0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA00",
		.swmux_regoffset = 0x2fc,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6e4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA01",
		.swmux_regoffset = 0x300,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6e8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA02",
		.swmux_regoffset = 0x304,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6ec,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA03",
		.swmux_regoffset = 0x308,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6f0,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA04",
		.swmux_regoffset = 0x30c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6f4,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA05",
		.swmux_regoffset = 0x310,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6f8,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA06",
		.swmux_regoffset = 0x314,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x6fc,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "NAND_DATA07",
		.swmux_regoffset = 0x318,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x700,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA0",
		.swmux_regoffset = 0x31c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x704,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA1",
		.swmux_regoffset = 0x320,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x708,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA2",
		.swmux_regoffset = 0x324,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x70c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA3",
		.swmux_regoffset = 0x328,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x710,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA4",
		.swmux_regoffset = 0x32c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x714,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA5",
		.swmux_regoffset = 0x330,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x718,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA6",
		.swmux_regoffset = 0x334,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x71c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD4_DATA7",
		.swmux_regoffset = 0x338,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x720,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD1_DATA1",
		.swmux_regoffset = 0x33c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x724,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD1_DATA0",
		.swmux_regoffset = 0x340,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x728,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD1_DATA3",
		.swmux_regoffset = 0x344,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x72c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD1_CMD",
		.swmux_regoffset = 0x348,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x730,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD1_DATA2",
		.swmux_regoffset = 0x34c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x734,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD1_CLK",
		.swmux_regoffset = 0x350,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x738,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD2_CLK",
		.swmux_regoffset = 0x354,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x73c,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD2_CMD",
		.swmux_regoffset = 0x358,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x740,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}, {
		.padname = "SD2_DATA3",
		.swmux_regoffset = 0x35c,
		.swmux_reset_default = 0x00000005,
		.swmux_writeable_mask = 0x00000017,
		.swpad_regoffset = 0x744,
		.swpad_reset_default = 0x0001b0b0,
		.swpad_writeable_mask = 0x0001f8f9,
	}
};

static const struct socinfo imx6q_socinfo = {
	.padinfo = imx6q_iomux_padinfo,
	.size_padinfo = ARRAY_SIZE(imx6q_iomux_padinfo),
};

static const struct padinfo *find_padinfo(off_t swmux_regoffset,
					  const struct socinfo *socinfo)
{
	size_t i;
	for (i = 0; i < socinfo->size_padinfo; ++i) {
		if (socinfo->padinfo[i].swmux_regoffset == swmux_regoffset)
			return &socinfo->padinfo[i];
	}

	return NULL;
}

static int parse_function(struct device_node *funcnode,
			  const struct socinfo *socinfo)
{
	const __be32 *list;
	int size, i;

	list = of_get_property(funcnode, "fsl,pins", &size);
	if (!list) {
		fprintf(stderr, "no fsl,pins property in node %s\n", funcnode->full_name);
		return -EINVAL;
	}

	if (!size || size % 24) {
		fprintf(stderr, "fsl,pins invalid in node %s\n", funcnode->full_name);
		return -EINVAL;
	}

	for (i = 0; i < size / 24; ++i) {
		uint32_t mux_reg = be32_to_cpu(*list++);
		off_t conf_reg;
		uint32_t mux_mode;
		uint32_t input_reg;
		uint32_t input_val;
		uint32_t config;
		const struct padinfo *padinfo;

		conf_reg = be32_to_cpu(*list++);
		if (!conf_reg)
			conf_reg = -1;

		input_reg = be32_to_cpu(*list++);
		(void)input_reg;
		mux_mode = be32_to_cpu(*list++);
		input_val = be32_to_cpu(*list++);
		(void)input_val;
		config = be32_to_cpu(*list++);
		if (config & IMX_PAD_SION)
			mux_mode |= IOMUXC_CONFIG_SION;
		config = config & ~IMX_PAD_SION;

		/* sanity checks */
		padinfo = find_padinfo(mux_reg, socinfo);
		if (!padinfo) {
			fprintf(stderr, "unknown pad (muxreg: %lx)\n",
				(unsigned long)mux_reg);
			continue;
		}

		if (conf_reg != padinfo->swpad_regoffset)
			printf("E: wrong offset for SW_PAD register (%s)\n",
			       padinfo->padname);

		if (conf_reg == -1) {
			if (config != 0x80000000)
				printf("E: config value without config register (%s)\n",
				       padinfo->padname);
		} else {
			if (config == 0x80000000) {
				printf("S: explicitly use 0x%08x as config value for %s\n",
				       padinfo->swpad_reset_default,
				       padinfo->padname);
			} else if ((config ^ padinfo->swpad_reset_default) & ~padinfo->swpad_writeable_mask) {
				printf("E: config value specified for reserved bit differ from reset value (%s, %" PRIx32 ")\n",
				       padinfo->padname, (config ^ padinfo->swpad_reset_default) & ~padinfo->swpad_writeable_mask);
			}
		}
	}
	return 0;
}

struct iomux_id_t {
	const char *compatible;
	const struct socinfo *socinfo;
};

static const struct iomux_id_t iomux_id[] = {
	{
		.compatible = "fsl,imx25-iomuxc",
		.socinfo = &imx25_socinfo,
	}, {
		.compatible = "fsl,imx6dl-iomuxc",
		.socinfo = &imx6dl_socinfo,
	}, {
		.compatible = "fsl,imx6q-iomuxc",
		.socinfo = &imx6q_socinfo,
	}
};

void dtblint_imx_pinmux(void)
{
	struct device_node *np;
	size_t i;

	for (i = 0; i < ARRAY_SIZE(iomux_id); ++i) {
		for_each_compatible_node(np, NULL, iomux_id[i].compatible) {
			struct device_node *npc;

			pr_debug("Found iomuxc %s\n", np->full_name);

			for_each_child_of_node(np, npc) {
				if (of_property_read_bool(npc, "fsl,pins")) {
					pr_debug("Found function node %s\n", npc->full_name);
					parse_function(npc, iomux_id[i].socinfo);
				} else {
					struct device_node *npcc;

					for_each_child_of_node(npc, npcc)
						parse_function(npcc,
							       iomux_id[i].socinfo);
				}
			}
		}
	}
}
