DCUT(1)
=======
:doctype: manpage


NAME
----
dcut - Debian archive command file upload tool

SYNOPSIS
--------
*dcut* [-h] [-d] [-c 'FILE'] [-m 'MAINTAINER'] [-k 'KEYID'] [-O 'FILENAME']
			[-P] [-s] [-U 'FILENAME'] [-i 'FILENAME'] [-v]
            ['HOST'] SUBCOMMAND ...

*dcut* ['OPTIONS'] ['HOST'] SUBCOMMAND ['SUB-COMMAND OPTIONS']


DESCRIPTION
-----------

*dcut* can create and/or upload command files understood by the debian archive
kit ("dak") software. It provides an extensible interface so that third party
authors can easily integrate more sub-commands. Hence, your running instance of
*dcut* may understand more commands than these documented here. Refer to the
respective documentations for these commands.

Similar to *dput*, a 'HOST' can be specified as a target site for the command
file. Likewise, the same default host selection criteria apply. It also parses
the same configuration files described there. 

It should be noted that this does not support the same interface as the old
dput binary. Please be sure to double-check scripts that depend on old-style
dput's interface.

OPTIONS
-------

*-c, --config*=FILE::
	Configuration file to parse.

*-d, --debug*::
	Enable debug messages. Repeat twice to increase the verbosity level.

*-f, --force*::
    Bypass all sanity checks and upload the commands file as is. Use with caution.

*-m, --maintainer*=MAINTAINER::
	Use 'MAINTAINER' for the uploader field and GnuPG key
	selection. Provide it as a full identity, that is in
	"+J Uploader <yourid@example.com>+" format. This has no effect when
	the *upload* command is used.

*-k, --keyid*=KEYID::
	Use 'KEYID' as a key for signing. Default is to use DEBEMAIL and
	DEBFULLNAME, or whatever identity was provided with *--maintainer*.
	This has no effect when the *upload* command is used.

*-O, --output*=FILENAME::
	Write the resulting commands file to 'FILENAME' instead of uploading it.
    This option should not be used with the *upload* command.  The selected
    'FILENAME' won't be overwritten if it exists already. This is very helpful
    for testing that things work correctly.

*-P, --passive*::
	Force FTP passive mode when uploading the package through FTP.
	This option is deprecated - use profiles instead.

*-s, --simulate*::
	Simulate the upload only. This runs all pre-upload checks, initializes
	the upload handler but does not actually store any file.

*-i, --input*=FILENAME::
	Ignored silently for compatibility with old-style dput command lines.

*-v, --version*::
	Print version information and exit

*HOST*::
	Target host to upload a package. It has the same behavior and semantics as
	*dput(1)*'s 'HOST' argument. It also uses the same profiles from it.

SUB-COMMANDS
------------

Sub-commands are actually implementing commands understood by be archive
software. They can take individual arguments which must appear after specifying
the actual desired sub-command.

cancel
~~~~~~

Cancel an upload entirely. The upload is referred to as a changes file name
existing *remote* in the incoming or deferred queues.

OPTIONS
^^^^^^^

Takes one argument

*-f*, *--file*='FILENAME'::
	The changes file name which refers to the upload to be cancelled.

rm
~~

Remove a lost or wrongly uploaded file from the incoming directory. The
argument is interpreted as a path fragment by the archive software. Therefore,
to delete a filename from a deferred queue, refer to it by using the full path

For example, to delete a broken upload in the DELAYED queue, use the command

  dcut rm -f DELAYED/X-day/foobar.deb

Alternatively, the '--searchdirs' argument instructs the archive software to
search for a file name in all directory. Hence, this command is equivalent to
the command before:

  dcut rm --searchdirs -f foobar.deb


OPTIONS
^^^^^^^

Takes at least one argument

*-f*, *--file*='FILENAME'::
	The file name to be removed. This argument can be repeated, and also knows
	about the shell wildcards *, ?, and []. However, please keep your local
	shell replacements in mind when supplying shell meta characters. You may
	need to escape them or provide them within quotes.

*--searchdirs*::
	Search in all directories for the given file. Only supported for files in
	the DELAYED queue.


dm
~~

Manage Debian Maintainer (DM) upload permissions. Debian Developers can grant
or revoke them package upload permissions using this command. Takes the Debian
Maintainer and the action to perform as argument.

Note, dcut will not perform any validation for conflicting arguments within
*--allow* and *--deny* below. This handling is left to the archive software,
which is currently processing *--allow* before *--deny* as an implementation
detail.

OPTIONS
^^^^^^^

*--uid*::

Any searchable, unique identity to identify an existing Debian Maintainer. This
can be a (full) name an e-mail address or a GnuPG fingerprint of any existing
Debian Maintainer. Note, the identity provided must be known in the DM keyring
installed on your local system. The keyring is used to validate the supplied
argument and makes sure the identity hint supplied matches *exactly* one DM. If
the user you want to change ACLs on is not known to the local DM keyring, you can
provide the *full* GPG user ID as argument, and pass --force, to cause dcut to
bypass any argument checking/translation. Please note, this will generate a
commands file which will be uploaded literally as is. Use with caution.

*--allow*=PACKAGE

*--allow* PACKAGE LIST::

Source package(s) where permissions to upload should be granted. Give
a space-separated list of packages to apply permissions to more than
one package at once. If multiple '--allow' options are given, the last
one takes precedence.

*--deny*=PACKAGE

*--deny* PACKAGE LIST::

Source package(s) where permissions to upload should be denied. Give a
space-separated list of packages to apply permissions to more than one
package at once. If multiple '--deny' options are given, the last
one takes precedence.

reschedule
~~~~~~~~~~

Reschedule an upload. This command can move a deferred upload to any other
deferred queue.

OPTIONS
^^^^^^^

Takes two arguments

*-f*, *--file*='FILENAME'::

file name to be rescheduled

*-d*, *--days*='DAYS'::


Reschedule the upload to DAYS days. Takes a numeric argument from 0 to 15
corresponding to the respective delayed queues. Note, 0-day is not the same
as uploading to incoming straight.


upload
~~~~~~

This is a pseudo-command (that is, it is handled within dcut and not forwarded
to the archive kit) which uploads a locally existing commands file as is.

However, no checks are performed for this file. Use with caution.

OPTIONS
^^^^^^^

Takes one argument

*-f*, *--file*='FILENAME'::
	A local file name which is uploaded as is to the archive software.


EXIT STATUS
-----------
*0*::
    Success

*1*::
    A runtime check returned an error

*2*::
    An internal error was detected, for example while loading configuration
    files

*3*::
	An upload error was detected, for example a permission or authentication
	problem while uploading files


BUGS
----

Report bugs to <http://bugs.debian.org/cgi-bin/pkgreport.cgi?pkg=dput-ng>


EXAMPLES
--------

  $ dcut dm --uid "Paul Tagliamonte" --allow glibc

  $ dcut dm --uid 0DEFACED --allow linux --deny kfreebsd9

  $ dcut dm --uid paul@example.com --allow eglibc linux

  $ dcut rm --searchdirs -f udj-desktop-client_0.5.1-2_amd64.deb

  $ dcut ftp-master rm -f 'linux*.deb'


AUTHOR
------
dput-ng was originally written by `Arno Töll <arno(a)debian.org>` and `Paul
Richard I by the Grace of God of the United Kingdom of Debian and Ubuntu and
of his other realms and territories King Head of the Fluxbox Window Manager
Defender of the Faith Tagliamonte <paultag(a)debian.org>`.


RESOURCES
---------

*dput(5)*, *dput.cf(5)*, *dcut(1)*, *gpg(1)*, *dirt(1)*

COPYING
-------
Copyright (C) 2012 dput-ng authors. Free use of this software is
granted under the terms of the GNU General Public License (GPL) Version 2 or
later.

