.\" dpkg manual page - deb822(5)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb822 5 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
deb \- Debian\-RFC822\-Steuerdatenformat
.
.SH BESCHREIBUNG
Die in einem gemeinsamen Format dargestellten Daten des
Paketverwaltungssystems, gespeichert in \fISteuerdateien\fP. Steuerdateien
werden für Quellpakete, Binärpakete und die \fB.changes\fP\-Dateien, die die
Installation von hochgeladenen Dateien steuern, verwandt (die internen
Datenbanken von \fBdpkg\fP sind in einem ähnlichen Format).
.
.SH SYNTAX
Eine Steuerdatei besteht aus einem oder mehreren Absätzen mit Feldern. Die
Absätze werden durch Leerzeilen getrennt. Auswertprogramme können Zeilen,
die nur aus U+0020 \fBLeerzeichen\fP und U+0009 \fBTabulatoren\fP als
Absatztrennern bestehen, akzeptieren, allerdings sollten Steuerdateien nur
Leerzeilen verwenden. Einige Steuerdateien erlauben nur einen Absatz, andere
erlauben mehrere. In letzterem Fall bezieht sich jeder Absatz normalerweise
auf ein anderes Paket. (Beispielsweise bezieht sich der erste Absatz in
Quellpaketen auf das Quellpaket und spätere Absätze beziehen sich auf die
Binärpakete, die aus dieser Quelle erstellt werden.) Die Reihenfolge der
Absätze in Steuerdateien ist relevant.

Jeder Absatz besteht aus einer Reihe von Datenfeldern. Jedes Feld besteht
aus dem Feldnamen, gefolgt von einem Doppelpunkt (U+003A ‚\fB:\fP’) und den
Daten/Werten, die dem Feld zugeordnet sind. Der Feldname besteht aus
US\-ASCII\-Zeichen, außer den Steuerzeichen, dem Leerzeichen und dem
Doppelpunkt (d.h. Zeichen in den Bereichen U+0021 ‚\fB!\fP’ bis U+0039 ‚\fB9\fP’
und U+003B ‚\fB;\fP’ bis U+007E ‚\fB~\fP’ einschließlich). Feldnamen dürfen nicht
mit dem Kommentarzeichen (U+0023 ‚\fB#\fP’) oder dem Gedankenstrich (U+002D
‚\fB\-\fP’) beginnen.

Das Feld endet am Zeilenende oder am Ende der letzten Fortsetzungszeile
(siehe unten). Horizontaler Leerraum (U+0020 \fBLEERZEICHEN\fP und U+0009
\fBTABULATOR\fP) können sofort nach oder vor dem Wert vorkommen und werden dort
ignoriert; als Konvention wird ein einzelnes Leerzeichen nach dem
Doppelpunkt gesetzt. Ein Feld könnte beispielsweise sein:
.RS
.nf
Package: dpkg
.fi
.RE
Der Feldname lautet \fBPackage\fP und der Feldwert \fBdpkg\fP.

Leere Feldwerte sind nur in Quellpaket\-Steuerdateien (\fIdebian/control\fP)
erlaubt. Solche Felder werden ignoriert.

Ein Absatz darf nicht mehr als ein Vorkommen eines bestimmten Feldnamens
enthalten.

Es gibt drei Arten von Feldern:

.RS 0
.TP 
\fBsimple\fP
Ein Feld, einschließlich des Wertes, muss eine einzelne Zeile sein. Falten
(Umbrechen) des Feldes ist nicht erlaubt. Dies ist der Standardtyp, falls
die Definition des Feldes nicht einen anderen Typ spezifiziert.
.TP 
\fBfolded\fP
Der Wert des gefalteten Feldes ist eine logische Zeile, die sich über
mehrere Zeilen erstrecken kann. Die Zeilen nach der ersten werden
Fortsetzungszeilen genannt und müssen mit einem U+0020 \fBLEERZEICHEN\fP oder
U+0009 \fBTABULATOR\fP beginnen. Leerraum, darunter Zeilenumbrüche, ist für die
Feldwerte gefalteter Zeilen nicht signifikant.

Diese Faltmethode ist ähnlich RFC5322 und erlaubt Steuerdateien, die nur
einen Absatz und keine mehrzeiligen Absätze, die von für RFC5322
geschriebenen Auswertprogrammen eingelesen werden müssen, enthalten.
.TP 
\fBmultiline\fP
Der Wert eines mehrzeiligen Feldes darf mehrere Fortsetzungszeilen
enthalten. Die erstes des Wertes, der Teil der auf der gleichen Zeile wie
der Feldname ist, hat oft eine spezielle Bedeutung oder könnte leer sein
müssen. Weitere Zeilen werden hinzugefügt und folgen der gleichen Syntax wie
die Fortsetzungszeilen von anderen gefalteten Feldern. Leerraum, inklusive
Zeilenumbrüchen, ist im Wert von mehrzeiligen Feldern signifikant.
.RE

Leerraum darf nicht innerhalb von Namen (von Paketen, Architekturen, Dateien
oder sonstigem) oder Versionsnummern oder zwischen den Zeichen einer
Mehrzeichenversionsbeziehung auftauchen.

Die Existenz und der Zweck eines Feldes und die Syntax seines Wertes können
zwischen den Arten der Steuerdateien variieren.

Die Groß\-/Kleinschreibung ist bei Feldnamen nicht relevant, aber
normalerweise wird die Großschreibung eines Feldes in der unten gezeigten
gemischten Weise vorgenommen. Bei den Feldwerten ist die
Groß\-/Kleinschreibung relevant, außer die Beschreibung sagt etwas anderes.

Absatztrenner (leere Zeilen) und Zeilen, die nur aus U+0020 \fBLEERZEICHEN\fP
und U+0009 \fBTABULAOREN\fP bestehen sind in Feldwerten oder zwischen Feldern
nicht erlaubt. Leere Zeilen und Feldwerte werden normalerweise maskiert,
indem sie durch ein U+0020 \fBLEERZEICHEN\fP gefolgt von einem Satzpunkt
(U+002E ‚\fB.\fP’) dargestellt werden.

Zeilen, die mit U+0023 ‚\fB#\fP’ ohne ein vorangestellten Leerraum beginnen,
sind Kommentarzeilen, die nur in Quellpaketsteuerdateien (\fIdebian/control\fP)
und in \fBdeb\-origin\fP(5)\-Dateien erlaubt sind. Diese Kommentarzeilen werden
ignoriert, selbst zwischen zwei Fortsetzungszeilen. Sie beenden keine
logischen Zeilen.

Alle Steuerdateien müssen in UTF\-8 kodiert sein.
.
.\" .SH EXAMPLE
.\" .RS
.\" .nf
.\" .fi
.\" .RE
.
.SH "SIEHE AUCH"
\fBRFC822\fP, \fBRFC5322\fP.
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2018 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
