.\" dpkg manual page - deb(5)
.\"
.\" Copyright © 1995 Raul Miller
.\" Copyright © 1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2014 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
deb \- Debian binary package format
.SH SYNOPSIS
.IB filename .deb
.SH DESCRIPTION
The
.B .deb
format is the Debian binary package file format. It is understood
since dpkg 0.93.76, and is generated by default since dpkg 1.2.0 and
1.1.1elf (i386/ELF builds).
.PP
The format described here is used since Debian 0.93; details of the
old format are described in
.BR deb\-old (5).
.SH FORMAT
The file is an
.B ar
archive with a magic value of
.BR !<arch> .
Only the common \fBar\fP archive format is supported, with no long file
name extensions, but with file names containing an optional trailing
slash, which limits their length to 15 characters (from the 16 allowed).
File sizes are limited to 10 ASCII decimal digits, allowing for up to
approximately 9536.74 MiB member files.
.PP
The \fBtar\fP archives currently allowed are, the old-style (v7) format,
the pre-POSIX ustar format, a subset of the GNU format (only the new
style long pathnames and long linknames, supported since dpkg 1.4.1.17),
and the POSIX ustar format (long names supported since dpkg 1.15.0).
Unrecognized tar typeflags are considered an error.
Each tar entry size inside a tar archive is limited to 11 ASCII octal
digits, allowing for up to 8 GiB tar entries.
.PP
The first member is named
.B debian\-binary
and contains a series of lines, separated by newlines. Currently only
one line is present, the format version number,
.BR 2.0
at the time this manual page was written.
Programs which read new-format archives should be prepared for the
minor number to be increased and new lines to be present, and should
ignore these if this is the case.
.PP
If the major number has changed, an incompatible change has been made
and the program should stop. If it has not, then the program should
be able to safely continue, unless it encounters an unexpected member
in the archive (except at the end), as described below.
.PP
The second required member is named
.BR control.tar .
It is a tar archive containing the package control information, either
not compressed (supported since dpkg 1.17.6), or compressed with
gzip (with \fB.gz\fP extension) or
xz (with \fB.xz\fP extension, supported since 1.17.6),
as a series of plain files, of which the file
.B control
is mandatory and contains the core control information, the
.BR conffiles ", " triggers ", " shlibs
and
.B symbols
files contain optional control information, and the
.BR preinst ", " postinst ", " prerm
and
.B postrm
files are optional maintainer scripts.
The control tarball may optionally contain an entry for
.RB ‘ . ’,
the current directory.
.PP
The third, last required member is named
.BR data.tar .
It contains the filesystem as a tar archive, either
not compressed (supported since dpkg 1.10.24), or compressed with
gzip (with \fB.gz\fP extension),
xz (with \fB.xz\fP extension, supported since dpkg 1.15.6),
bzip2 (with \fB.bz2\fP extension, supported since dpkg 1.10.24) or
lzma (with \fB.lzma\fP extension, supported since dpkg 1.13.25).
.PP
These members must occur in this exact order. Current implementations
should ignore any additional members after
.BR data.tar .
Further members may be defined in the future, and (if possible) will be
placed after these three. Any additional members that may need to be
inserted after
.B debian\-binary
and before
.B control.tar
or
.B data.tar
and which should be safely ignored by older programs, will have names
starting with an underscore,
.RB ‘ _ ’.
.PP
Those new members which won't be able to be safely ignored will be
inserted before
.B data.tar
with names starting with something other than underscores, or will
(more likely) cause the major version number to be increased.
.SH MEDIA TYPE
.SS Current
application/vnd.debian.binary-package
.SS Deprecated
application/x-debian-package
.br
application/x-deb
.SH SEE ALSO
.BR deb\-old (5),
.BR dpkg\-deb (1),
.BR deb\-control (5),
.BR deb\-conffiles (5)
.BR deb\-triggers (5),
.BR deb\-shlibs (5),
.BR deb\-symbols (5),
.BR deb\-preinst (5),
.BR deb\-postinst (5),
.BR deb\-prerm (5),
.BR deb\-postrm (5).
