.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dpkg\-gensymbols \- erstelle Symboldateien (Abhängigkeitsinformationen für
Laufzeitbibliotheken)
.
.SH ÜBERSICHT
\fBdpkg\-gensymbols\fP [\fIOption\fP …]
.
.SH BESCHREIBUNG
\fBdpkg\-gensymbols\fP durchsucht einen temporären Baubaum (standardmäßig
debian/tmp), sucht nach Bibliotheken und erstellt eine Datei \fIsymbols\fP, die
diese beschreibt. Diese Datei wird, falls sie nicht leer ist, in das
Unterverzeichnis DEBIAN des Baubaums installiert, so dass sie schlussendlich
in der Steuerinformation des Pakets auftaucht.
.P
Beim Erstellen dieser Dateien verwendet es als Eingabe einige vom Betreuer
bereitgestellte Symboldateien. Es sucht nach den folgenden Dateien (und
verwendet die erste, die gefunden wird):
.IP • 4
debian/\fIPaket\fP.symbols.\fIArchitektur\fP
.IP • 4
debian/symbols.\fIArchitektur\fP
.IP • 4
debian/\fIPaket\fP.symbols
.IP • 4
debian/symbols
.P
Der Hauptzweck dieser Dateien besteht darin, die minimale Version
bereitzustellen, die mit jedem von der Bibliothek bereitgestellten Symbol
verknüpft ist. Normalerweise entspricht dies der ersten Version des Pakets,
die dieses Symbol bereitgestellt hat, kann aber vom Betreuer erhöht werden,
falls die ABI des Symbols ohne Brechen der Rückwärtskompatibilität erweitert
wurde. Es liegt in der Verwantwortung des Betreuers, diese Dateien aktuell
zu halten, aber \fBdpkg\-gensymbols\fP hilft dabei.
.P
Wenn die erstellten Symboldateien sich von denen, die der Betreuer
bereitgestellt hat, unterscheiden, wird \fBdpkg\-gensymbols\fP ein Diff zwischen
den zwei Versionen anzeigen. Falls die Unterschiede desweiteren zu
gravierend sind, wird es sogar fehlschlagen (Sie können einstellen, wie
große Unterschiede Sie tolerieren können, sehen Sie hierzu die Option
\fB\-c\fP).
.SH "SYMBOLDATEIEN PFLEGEN"
Die Symboldateien sind nur wirklich nützlich, falls sie die Entwicklung
eines Paketes über mehrere Veröffentlichungen hinweg wiedergeben. Daher muss
der Betreuer sie immer aktualisieren, wenn eine neues Symbol hinzugefügt
wird, so dass die zugeordnete minimale Version der Realität entspricht. Die
in den Bauprotokollen enthaltenen Diffs können als Startpunkt benutzt
werden, aber zusätzlich hat der Betreuer sicherzustellen, dass sich das
Verhalten dieser Symbole nicht derart geändert hat, dass irgendetwas, was
diese Symbole verwendet und gegen die neue Version gelinkt ist, daran
hindern würde, mit der alten Version zu funktionieren. Meistens kann der
Diff direkt auf die Datei debian/\fIPaket\fP.symbols angewandt
werden. Allerdings werden normalerweise weitere Anpassungen notwendig: es
wird beispielsweise empfohlen, die Debian\-Revision von der minimalen Version
zu entfernen, so dass Backports mit einer niedrigeren Versionsnummer aber
der gleichen Version der Originalautoren immer noch die erstellten
Abhängigkeiten erfüllen. Falls die Debian\-Revision nicht entfernt werden
kann, da das Symbol wirklich von der Debian\-spezifischen Änderung
hinzugefügt wurde, dann sollte der Version ‚\fB~\fP’ angehängt werden.
.P
Bevor irgendein Patch auf die Symboldatei angewendet wird, sollte der
Betreuer zweimal prüfen, dass der Patch vernünftig ist. Öffentliche Symbole
sollten nicht verschwinden, daher sollte der Patch idealerweise nur neue
Zeilen hinzufügen.
.P
Beachten Sie, dass Sie in Symboldateien Kommentare einfügen können: jede
Zeile, die mit ‚#’ als ersten Zeichen beginnt, ist ein Kommentar, falls sie
nicht mit ‚#include’ beginnt (siehe Abschnitt \fBIncludes
verwenden\fP). Zeilen, die mit ‚#MISSING:’ anfangen, sind besondere
Kommentare, die verschwundene Symbole dokumentieren.
.P
Vergessen Sie nicht, zu überprüfen, ob alte Versionen aktualisiert werden
müssen. Es gibt für \fBdpkg\-gensymbols\fP keine Möglichkeit, hierzu eine
Warnung auszugeben. Wird der Diff blind akzeptiert oder wird angenommen,
dass nichts geändert werden muss, wenn es keinen Diff gibt, ohne auf
Änderungen zu prüfen, kann dies dazu führen, dass lockere Abhängigkeiten
erzeugt werden, laut deren mit älteren Versionen gearbeitet werden kann,
obwohl dies nicht möglich ist. Dies wird zu schwer zu findenden Fehlern bei
(teilweisen) Upgrades führen.
.SS "Verwendung der #PACKAGE#\-Ersetzung"
.P
In einigen seltenen Fällen unterscheidet sich der Name der Bibliothek auf
verschiedenen Architekturen. Um zu vermeiden, dass der Paketname in der
Symboldatei fest kodiert wird, können Sie die Markierung \fI#PACKAGE#\fP
verwenden. Während der Installation der Symboldatei wird sie durch den
echten Paketnamen ersetzt. Anders als die Markierung \fI#MINVER#\fP wird
\fI#PACKAGE#\fP nie in der Symboldatei innerhalb eines Binärpakets auftauchen.
.SS "Verwendung von Symbolkennzeichnungen"
.P
Symbolkennzeichnungen sind nützlich, um Symbole zu markieren, die in
irgendeiner Weise besonders sind. Jedes Symbol kann eine beliebige Anzahl
zugeordneter Kennzeichnungen besitzen. Während alle Kennzeichnungen
ausgewertet und gespeichert werden, werden nur einige von \fBdpkg\-gensymbols\fP
verstanden und lösen eine Spezialbehandlung der Symbole aus. Lesen Sie den
Unterabschnit \fBStandardsymbolkennzeichnungen\fP für eine Referenz dieser
Kennzeichnungen.
.P
Kennzeichnungsspezifikationen kommen direkt vor dem Symbolnamen (dazwischen
sind keine Leerraumzeichen erlaubt). Sie beginnen immer mit einer öffnenden
Klammer \fB(\fP, enden mit einer schließenden Klammer \fB)\fP und müssen
mindestens eine Kennzeichnung enthalten. Mehrere Kennzeichnungen werden
durch das Zeichen \fB|\fP getrennt. Jede Kennzeichnungen kann optional einen
Wert enthalten, der von der Kennzeichnung durch das Zeichen \fB=\fP getrennt
wird. Kennzeichennamen und \-werte können beliebige Zeichenketten sein, sie
dürfen allerdings keine der der besonderen Zeichen \fB)\fP \fB|\fP \fB=\fP
enthalten. Symbolnamen, die einer Kennzeichnungsspezifikation folgen, können
optional mit den Zeichen \fB'\fP oder \fB"\fP zitiert werden, um Leerraumzeichen
darin zu erlauben. Falls keine Kennzeichnungen für das Symbol spezifiziert
sind, werden Zitatzeichen als Teil des Symbolnamens behandelt, der bis zum
ersten Leerzeichen geht.
.P
 (Kennz1=bin markiert|Name mit Leerraum)"zitiertes gekennz Symbol"@Base 1.0
 (optional)gekennzeichnet_unzitiertes_Symbol@Base 1.0 1
 ungekennzeichnetes_Symbol@Base 1.0
.P
Das erste Symbol im Beispiel heißt \fIzitiertes gekennz Symbol\fP und hat zwei
Kennzeichnungen: \fIKennz1\fP mit dem Wert \fIbin markiert\fP und \fIName mit
Leerraum\fP ohne Wert. Das zweite Symbol heißt
\fIgekennzeichnet_unzitiertes_Symbol\fP und ist nur mit dem Kennzeichen namens
\fIoptional\fP gekennzeichnet. Das letzte Symbol ist ein Beispiel eines
normalen, nicht gekennzeichneten Symbols.
.P
Da Symbolkennzeichnungen eine Erweiterung des Formats \fBdeb\-symbols(5)\fP
sind, können sie nur Teil der in Quellpaketen verwandten Symboldateien sein
(diese Dateien sollten dann als Vorlagen zum Bau der Symboldateien, die in
Binärpakete eingebettet werden, gesehen werden). Wenn \fBdpkg\-gensymbols\fP
ohne die Option \fB\-t\fP aufgerufen wird, wird es alle Symbole ausgeben, die
zum Format \fBdeb\-symbols\fP(5) kompatibel sind: Es verarbeitet die Symbole
entsprechend der Anforderungen ihrer Standardkennzeichnungen und entfernt
alle Kennzeichnungen aus der Ausgabe. Im Gegensatz dazu werden alle Symbole
und ihre Kennzeichnungen (sowohl die Standardkennzeichnungen als auch die
unbekannten) im Vorlagenmodus (\fB\-t\fP) in der Ausgabe beibehalten und in
ihrer Originalform wie sie geladen wurden auch geschrieben.
.SS Standard\-Symbolkennzeichnungen
.TP 
\fBoptional\fP
Ein als »optional« gekennzeichnetes Symbol kann jederzeit von der Bibliothek
verschwinden und wird nie zum Fehlschlag von \fBdpkg\-gensymbols\fP
führen. Verschwundene optionale Symbole werden kontinuierlich als MISSING
(Fehlend) in dem Diff in jeder neuen Paketversion auftauchen. Dieses
Verhalten dient als Erinnerung für den Betreuer, dass so ein Symbol aus der
Symboldatei entfernt oder wieder der Bibliothek hinzugefügt werden
muss. Wenn das optionale Symbol, dass bisher als MISSING bezeichnet gewesen
war, plötzlich in der nächsten Version wieder auftaucht, wird es wieder auf
den Status „existing“ (existierend) gebracht, wobei die minimale Version
unverändert bleibt.

Diese Markierung ist für private Symbole nützlich, deren Verschwinden keinen
ABI\-Bruch auslöst. Beispielsweise fallen die meisten
C++\-Template\-Instanziierungen in diese Kategorie. Wie jede andere Markierung
kann auch diese einen beliebigen Wert haben: sie könnte angeben, warum
dieses Symbol als optional betrachtet wird.
.TP 
\fBarch=\fP\fIArchitekturliste\fP
.TQ
\fBarch\-bits=\fP\fIArchitektur\-Bits\fP
.TQ
\fBarch\-endian=\fP\fIArchitektur\-Endianness\fP
Diese Markierungen erlauben es, den Satz an Architekturen einzugrenzen, auf
denen das Symbol existieren sollte. Die Markierungen \fBarch\-bits\fP und
\fBarch\-endian\fP werden seit Dpkg 1.18.0 unterstützt. Wenn die Symbolliste mit
den in der Bibliothek entdeckten Symbolen aktualisiert wird, werden alle
architekturspezifischen Symbole, die nicht auf die aktuelle Host\-Architektur
passen, so behandelt, als ob sie nicht existierten. Falls ein
architekturspezifisches Symbol, das auf die aktuelle Host\-Architektur passt,
in der Bibliothek nicht existiert, werden die normalen Regeln für fehlende
Symbole angewandt und \fBdpkg\-gensymbols\fP könnte dadurch fehlschlagen. Auf
der anderen Seite, falls das architekturspezifische Symbol gefunden wurde,
wenn es nicht existieren sollte (da die aktuelle Host\-Architektur nicht in
der Markierung aufgeführt ist oder nicht auf die Endianess und Bits passt),
wird sie architekturneutral gemacht (d.h. die Architektur\-,
Architektur\-Bits\- und Architektur\-Endianessmarkierungen werden entfernt und
das Symbol wird im Diff aufgrund dieser Änderung auftauchen), aber es wird
nicht als neu betrachtet.

Beim Betrieb im standardmäßigen nicht\-Vorlagen\-Modus werden unter den
architekturspezifischen Symbolen nur die in die Symboldatei geschrieben, die
auf die aktuelle Host\-Architektur passen. Auf der anderen Seite werden beim
Betrieb im Vorlagenmodus alle architekturspezifischen Symbole (darunter auch
die von fremden Architekturen) immer in die Symboldatei geschrieben.

Das Format der \fIArchitekturliste\fP ist das gleiche wie das des Feldes
\fBBuild\-Depends\fP in \fIdebian/control\fP (außer den einschließenden eckigen
Klammern []). Beispielsweise wird das erste Symbol aus der folgenden Liste
nur auf den Architekturen Alpha, Any\-amd64 und Ia64 betrachtet, das zweite
nur Linux\-Architekturen, während das dritte überall außer auf Armel
betrachtet wird.

 (arch=alpha any\-amd64 ia64)64bit_specific_symbol@Base 1.0
 (arch=linux\-any)linux_specific_symbol@Base 1.0
 (arch=!armel)symbol_armel_does_not_have@Base 1.0

\fIarchitecture\-bits\fP ist entweder \fB32\fP oder \fB64\fP.

 (arch\-bits=32)32bit_specific_symbol@Base 1.0
 (arch\-bits=64)64bit_specific_symbol@Base 1.0

\fIarchitecture\-endianness\fP ist entweder \fBlittle\fP oder \fBbig\fP.

 (arch\-endian=little)little_endian_specific_symbol@Base 1.0
 (arch\-endian=big)big_endian_specific_symbol@Base 1.0

Mehrere Einschränkungen können aneinandergehängt werden.

 (arch\-bits=32|arch\-endian=little)32bit_le_symbol@Base 1.0
.TP 
\fBignore\-blacklist\fP
dpkg\-gensymbols verfügt über eine interne Ausschußliste (»blacklist«) von
Symbolen, die nicht in Symboldateien auftauchen sollten, da sie
normalerweise nur Seiteneffekte von Implementierungsdetails in der
Werkzeugkette darstellen. Falls Sie aus irgendeinem Grund wollen, dass diese
Symbole in der Symboldatei aufgenommen werden, sollten Sie das Symbol mit
\fBignore\-blacklist\fP kennzeichnen. Dies kann für einige grundlegende
Bibliotheken der Werkzeugkette wie libgcc notwendig sein.
.TP 
\fBc++\fP
Gibt \fIc++\fP\-Symbolmuster an. Lesen Sie den Unterabschnitt \fBVerwendung von
Symbolmuster\fP unten.
.TP 
\fBsymver\fP
Gibt \fIsymver\fP (Symbolversion)\-Symbolmuster an. Lesen Sie den Unterabschnitt
\fBVerwendung von Symbolmuster\fP unten.
.TP 
\fBregex\fP
Gibt \fIregex\fP\-Symbolmuster an. Lesen Sie den Unterabschnitt \fBVerwendung von
Symbolmuster\fP unten.
.SS "Verwendung von Symbolmustern"
.P
Anders als die Standardsymbolspezifikation kann ein Muster mehrere reale
Symbole aus der Bibliothek abdecken. \fBdpkg\-gensymbols\fP wird versuchen,
jedes Muster auf jedes reale Symbol, für das \fIkein\fP spezifisches
Symbolgegenstück in der Symboldatei definiert ist, zu passen. Wann immer das
erste passende Muster gefunden wurde, werden alle Kennzeichnungen und
Eigenschaften als Basisspezifikation des Symbols verwandt. Falls keines der
Muster passt, wird das Symbol als neu betrachtet.

Ein Muster wird als verloren betrachtet, falls es auf kein Symbol in der
Bibliothek passt. Standardmäßig wird dies ein Versagen von
\fBdpkg\-gensymbols\fP in der Stufe \fB\-c1\fP oder höher auslösen. Falls der
Fehlschlag allerdings unerwünscht ist, kann das Muster mit der Kennzeichnung
\fIoptional\fP markiert werden. Falls das Muster dann auf nichts passt wird es
im Diff nur als MISSING (fehlend) auftauchen. Desweiteren kann das Muster
wie jedes Symbol auf die spezielle Architektur mit der Kennzeichnung \fIarch\fP
beschränkt werden. Bitte lesen Sie den Unterabschnitt \fBStandard
Symbolkennzeichnungen\fP oben für weitere Informationen.

Muster sind eine Erweiterung des Formats \fBdeb\-symbols\fP(5); sie sind daher
nur in Symboldatei\-Vorlagen gültig. Die Musterspezifikationssyntax
unterscheidet sich nicht von der eines spezifischen Symbols. Allerdings
dient der Symbolnamenteil der Spezifikation als Ausdruck, der gegen
\fIName@Version\fP eines realen Symbols gepasst wird. Um zwischen den
verschiedenen Mustertypen zu unterscheiden, wird es typischerweise mit einer
speziellen Kennzeichnung gekennzeichnet.

Derzeit unterstützt \fBdpkg\-gensymbols\fP drei grundlegene Mustertypen:
.TP  3
\fBc++\fP
Dieses Muster wird durch die Kennzeichnung \fIc++\fP verzeichnet. Es passt nur
auf die entworrenen (»demangled«) Symbolnamen (wie sie vom Hilfswerkzeug
\fBc++filt\fP(1) ausgegeben werden). Dieses Muster ist sehr hilfreich um auf
Symbole zu passen, bei dem die verworrenen (»mangled«) Namen sich auf
verschiedenen Architekturen unterscheiden während die entworrenen die
gleichen bleiben. Eine Gruppe solcher Symbole ist \fInon\-virtual thunks\fP, die
einen architekturspezifischen Versatz in ihren verworrenen Namen eingebettet
haben. Eine häufige Instanz dieses Falles ist ein virtueller Destruktur, der
unter rautenförmiger Vererbung ein nicht\-virtuelles Thunk\-Symbol
benötigt. Selbst wenn beispielsweise _ZThn8_N3NSB6ClassDD1Ev@Base auf 32
Bit\-Architekturen _ZThn16_N3NSB6ClassDD1Ev@Base auf 64 Bit\-Architekturen
ist, kann es mit einem einzigen \fIc++\fP\-Muster gepasst werden:

libdummy.so.1 libdummy1 #MINVER#
 […]
 (c++)"non\-virtual thunk to NSB::ClassD::~ClassD()@Base" 1.0
 […]

Der entworrene Name oben kann durch Ausführung folgenden Befehls erhalten
werden:

 $ echo '_ZThn8_N3NSB6ClassDD1Ev@Base' | c++filt

Bitte beachten Sie, dass per Definition zwar der verworrene Name in der
Bibliothek eindeutig ist, die aber nicht notwendigerweise für die
entworrenen Namen zutrifft. Ein Satz von unterschiedlichen realen Symbolen
können den gleichen entworrenen Namen haben. Beispielsweise ist das der Fall
bei nicht\-virtuellen Thunk\-Symbolen in komplexen Vererbungskonfigurationen
oder bei den meisten Konstruktoren und Destruktoren (da g++ typischerweise
zwei reale Symbole für sie generiert). Da diese Kollisionen aber auf dem
ABI\-Niveau passieren, sollten sie nicht die Qualität der Symboldatei
reduzieren.
.TP 
\fBsymver\fP
Dieses Muster wird durch die Kennzeichnung \fIsymver\fP verzeichnet. Gut
betreute Bibliotheken verfügen über versionierte Symbole, wobei jede Version
zu der Version der Originalautoren passt, in der dieses Symbol hinzugefügt
wurde. Falls das der Fall ist, können SIe ein \fIsymver\fP\-Muster verwenden, um
auf jedes zu einer spezifizierten Version zugeordnete Symbol zu
passen. Beispiel:

libc.so.6 libc6 #MINVER#
 (symver)GLIBC_2.0 2.0
 […]
 (symver)GLIBC_2.7 2.7
 access@GLIBC_2.0 2.2

Alle Version GLIBC_2.0 und GLIBC_2.7 zugeordneten Symbole werden zu einer
minimalen Version 2.0 bzw. 2.7 führen, wobei das Symbol access@GLIBC_2.0 die
Ausnahme darstellt. Es wird zu einer minimalen Abhängigkeit auf libc6
Version 2.2 führen, obwohl es im Geltungsbereich des Musters
»(symver)GLIBC_2.0« passt, da spezielle Symbole vor Mustern Vorrang haben.

Bitte beachten Sie, dass Platzhaltermuster im alten Format (angezeigt durch
»*@version« im Symbolnamenfeld) zwar noch unterstützt werden, sie aber durch
die Syntax im neuen Format »(symver|optional)version« abgelöst
wurden. Beispielsweise sollte »*@GLIBC_2.0 2.0« als
»(symver|optional)GLIBC_2.0 2.0« geschrieben werden, falls das gleiche
Verhalten benötigt wird.
.TP 
\fBregex\fP
Muster mit regulären Ausdrücken werden durch die Kennzeichnung \fIregex\fP
verzeichnet. Sie passen auf den regulären Ausdruck von Perl, der im
Symbolnamenfeld angegeben ist. Ein regulärer Ausdruck wird wie er ist
gepasst. Denken Sie daher daran, ihn mit dem Zeichen \fI^\fP zu beginnen, da er
ansonsten auf jeden Teil der Zeichenkette des realen Symbols \fIname@version\fP
passt. Beispiel:

libdummy.so.1 libdummy1 #MINVER#
 (regex)"^mystack_.*@Base$" 1.0
 (regex|optional)"private" 1.0

Symbole wie »mystack_new@Base«, »mystack_push@Base«, »mystack_pop@Base«
usw. werden vom ersten Muster gepasst, während dies z.B. für
»ng_mystack_new@Base« nicht der Fall ist. Das zweite Muster wird auf alle
Symbole, die die Zeichenkette »private« in ihren Namen enthalten, passen und
die gepassten Symbole erben die Kennzeichnung \fIoptional\fP vom Muster.
.P
Die oben aufgeführten grundlegenden Muster können \- wo es Sinn ergibt \-
kombiniert werden. In diesem Fall werden sie in der Reihenfolge verarbeitet,
in der die Kennzeichnungen angegeben sind. Im Beispiel

 (c++|regex)"^NSA::ClassA::Private::privmethod\ed\e(int\e)@Base" 1.0
 (regex|c++)N3NSA6ClassA7Private11privmethod\edEi@Base 1.0

werden die Symbole »_ZN3NSA6ClassA7Private11privmethod1Ei@Base« und
»_ZN3NSA6ClassA7Private11privmethod2Ei@Base« gepasst. Beim Passen der ersten
Musters wird das rohe Symbol erst als C++\-Symbol entworren, dann wird der
entworrende Name gegen den regulären Ausdruck gepasst. Auf der anderen Seite
wird beim Passen des zweiten Musters der reguläre Ausdruck gegen den rohen
Symbolnamen gepasst, dann wird das Symbol überprüft, ob es ein C++\-Symbol
ist, indem das Entwirren versucht wird. Ein Fehlschlag eines einfachen
Musters wird zum Fehlschlag des gesamten Musters führen. Daher wird
beispielsweise »__N3NSA6ClassA7Private11privmethod\edEi@Base« keines der
Muster passen, da es kein gültiges C++\-Symbol ist.

Im Allgemeinen werden die Muster in zwei Kategorien eingeteilt: Aliase
(grundlegende \fIc++\fP\- und \fIsymver\fP\-Muster) und generische Muster (\fIregex\fP
und alle Kombinationen grundlegender Muster). Passen von grundlegenden
alias\-basierenden Mustern ist schnell (O(1)), während generische Muster O(N)
(wobei N die Anzahl der generischen Muster ist) für jedes Symbol ist. Daher
wird empfohlen, generische Muster nicht zu viel zu verwenden.

Wenn mehrere Muster auf das gleiche Symbol passen, werden Aliase (zuerst
\fIc++\fP, dann \fIsymver\fP) gegenüber den generischen Mustern
bevorzugt. Generische Muster werden in der Reihenfolge, in der sie in der
Symboldateivorlage gefunden werden, gepasst, bis zum ersten Erfolg. Beachten
Sie aber, dass das manuelle Anordnen der Vorlagendateieinträge nicht
empfohlen wird, da \fBdpkg\-gensymbols\fP Diffs basierend auf der
alphanumerischen Reihenfolge ihrer Namen erstellt.
.SS "Includes verwenden"
.P
Wenn der Satz der exportierten Symbolen sich zwischen Architekturen
unterscheidet, kann es ineffizient werden, eine einzige Symboldatei zu
verwenden. In diesen Fällen kann sich eine Include\-Direktive in einer Reihe
von Arten als nützlich erweisen:
.IP • 4
Sie können den gemeinsamen Teil in eine externe Datei auslagern und diese
Datei dann in Ihre \fIPaket\fP.symbols.\fIArch\fP\-Datei mit einer
include\-Direktive wie folgt einbinden:

#include "\fIPakete\fP.symbols.common"
.IP •
Die Include\-Direktive kann auch wie jedes Symbol gekennzeichnet werden:

(Kennzeichen|…|KennzeichenN)#include "einzubindende\-Datei"

Als Ergebnis werden alle Symbole aus \fIeinzubindende\-Datei\fP standardmäßig
als mit \fIKennzeichen\fP … \fIKennzeichenN\fP gekennzeichnet betrachtet. Sie
können diese Funktionalität benutzen, um eine gemeinsame Datei
\fIPaket\fP.symbols zu erstellen, die architekturspezifische Symboldateien
einbindet:

  common_symbol1@Base 1.0
 (arch=amd64 ia64 alpha)#include "Paket.symbols.64bit"
 (arch=!amd64 !ia64 !alpha)#include "Paket.symbols.32bit"
  common_symbol2@Base 1.0
.P
Die Symboldateien werden Zeile für Zeile gelesen und include\-Direktiven
werden bearbeitet, sobald sie erkannt werden. Das bedeutet, dass der Inhalt
der Include\-Datei jeden Inhalt überschreiben kann, der vor der
Include\-Direktive aufgetaucht ist und Inhalt nach der Direktive alles aus
der Include\-Datei überschreiben kann. Jedes Symbol (oder sogar weitere
#include\-Direktiven) in der Include\-Datei kann zusätzliche Kennzeichnungen
spezifizieren oder Werte der vererbtgen Kennzeichnungen in ihrer
Kennzeichnungsspezifikation überschreiben. Allerdings gibt es keine
Möglichkeit für ein Symbol, die ererbten Kennzeichnungen zu überschreiben.
.P
Eine eingebundene Datei kann die Kopfzeile wiederholen, die den SONAME der
Bibliothek enthält. In diesem Fall überschreibt sie jede vorher gelesene
Kopfzeile. Allerdings ist es im Allgemeinen am Besten, die Wiederholung von
Kopfzeilen zu vermeiden. Ein Weg dies zu erreichen, ist wie folgt:
.PP
#include "libirgendwas1.symbols.common"
 arch_spezifisches_Symbol@Base 1.0
.SS "Gute Bibliotheksverwaltung"
.P
Eine gut verwaltete Bibliothek hat die folgenden Eigenschaften:
.IP • 4
seine API ist stabil (öffentliche Symbole entfallen nie, nur neue
öffentliche Symbole werden hinzugefügt) und inkompatible Änderungen erfolgen
nur, wenn sich der SONAME ändert,
.IP • 4
idealerweise verwendet sie Symbolversionierung, um ABI\-Stabilität trotz
interner Änderungen und API\-Erweiterungen zu erreichen,
.IP • 4
sie exportiert nie private Symbole (als Hilfslösung können diese als
optional gekennzeichnet werden).
.P
Bei der Verwaltung der Symboldatei kann das Auftauchen und Verschwinden von
Symbolen leicht bemerkt werden. Es ist aber schwieriger, inkompatbile API\-
und ABI\-Änderungen zu bemerken. Daher sollte der Betreuer intensiv die
Changelog\-Einträge durchschauen und nach Fällen suchen, in denen die Regeln
der guten Bibliotheksverwaltung gebrochen wurden. Falls mögliche Probleme
entdeckt wurden, sollten der Originalautor informiert werden, da eine
Korrektur vom Originalautor immer besser als eine Debian\-spezifische
Hilfslösung ist.
.SH OPTIONEN
.TP 
\fB\-P\fP\fIPaketbauverzeichnis\fP
Suche nach \fIPaketbauverzeichnis\fP statt nach debian/tmp.
.TP 
\fB\-p\fP\fIPaket\fP
Definiert den Paketnamen. Benötigt, falls mehr als ein binäres Paket in
debian/control aufgeführt ist (oder falls es keine Datei debian/control
gibt).
.TP 
\fB\-v\fP\fIVersion\fP
Definiert die Paketversion. Standardmäßig wird eie Version aus
debian/changelog ausgelesen. Benötigt, falls der Aufruf außerhalb des
Quellpaketbaums erfolgt.
.TP 
\fB\-e\fP\fIBibliotheksdatei\fP
Nur die explizit aufgeführten Bibliotheken untersuchen statt alle
öffentlichen Bibliotheken zu finden. Sie können Shell\-Muster, die zur
Expansion von Pfadnamen verwandt werden (siehe die Handbuchseite
\fBFile::Glob\fP(3perl) für weitere Details) in \fIBibliotheksdatei\fP verwenden,
um mehrere Bibliotheken mit einem einzelnen Argument zu passen (andernfalls
benötigen Sie mehrere \fB\-e\fP).
.TP 
\fB\-I\fP\fIDateiname\fP
Verwende \fIDateiname\fP als Referenzdatei, um die Symboldatei zu erstellen,
die dann im Paket selbst integriert wird.
.TP 
\fB\-O\fP[\fIDateiname\fP]
Die erstellte Symbols\-Datei auf die Standardausgabe oder nach \fIDateiname\fP,
falls angegeben, ausgeben statt in \fBdebian/tmp/DEBIAN/symbols\fP (oder
\fIPaket\-Bauverzeichnis\fP\fB/DEBIAN/symbols\fP falls \fB\-P\fP verwandt wurde). Falls
\fIDateiname\fP bereits existiert, wird deren Inhalt als Grundlage für die
erstellte Symboldatei verwandt. Sie können diese Funktionalität benutzen, um
eine Symboldatei zu aktualisieren, so dass sie zu einer neueren Version der
Originalautoren Ihrer Bibliothek passt.
.TP 
\fB\-t\fP
Schreibe die Symboldatei im Vorlagenmodus statt im zu \fBdeb\-symbols\fP(5)
kompatiblen Format. Der Hauptunterschied besteht darin, dass im
Vorlagenmodus die Symbolnamen und Kennzeichnungen in ihrer Originalform
geschrieben werden, im Gegensatz zu den verarbeiteten Symbolnamen mit
entfernen Kennzeichnungen im Kompatibilitätsmodus. Desweiteren könnten
einige Symbole beim Schreiben einer Standard \fBdeb\-symbols\fP(5)\-Datei
entfernt werden (gemäß der Verarbeitungsregeln für Kennzeichen), während in
der Symboldateivorlage immer alle Symbole geschrieben werden.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Definiert die Prüfungen, die beim Vergleich der erstellten Symboldatei mit
der Vorlagendatei als Startpunkt erfolgen sollen. Standardstufe ist
1. Zunehmende Stufen führen mehr Prüfungen durch und enthalten alle
Prüfungen der niedrigeren Stufen. Stufe 0 schlägt nie fehl. Stufe 1 schlägt
fehl, wenn einige Symbole verschwunden sind. Stufe 2 schlägt fehlt, falls
einige neue Symbole eingeführt wurden. Stufe 3 schlägt fehl, falls einige
Bibliotheken verschwunden sind. Stufe 4 schlägt fehl, falls einige
Bibliotheken hinzugekommen sind.

Dieser Wert kann von der Umgebungsvariablen \fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
außer Kraft gesetzt werden.
.TP 
\fB\-q\fP
Ruhig verhalten und nie einen Diff zwischen der erstellten Symboldatei und
der als Startpunkt verwandten Vorlagendatei erstellen oder keine Warnungen
bezüglich neuer/verlorender Bibliotheken oder neuer/verlorender Symbole
ausgeben. Diese Option deaktiviert nur die informative Ausgabe aber nicht
die Prüfungen selbst (sehen Sie hierzu die Option \fB\-c\fP).
.TP 
\fB\-a\fP\fIArchitektur\fP
Nehme \fIArch\fP als Host\-Architektur beim Verarbeiten der Symboldateien
an. Verwenden Sie diese Option, um Symboldateien oder Diffs für beliebige
Architekturen zu erstellen, vorausgesetzt, die Binärprogramme sind bereits
verfügbar.
.TP 
\fB\-d\fP
Debug\-Modus aktivieren. Eine Vielzahl von Nachrichten wird angezeigt, um zu
erklären, was \fBdpkg\-gensymbols\fP durchführt.
.TP 
\fB\-V\fP
Ausführlichen Modus aktivieren. Die erstellte Symboldatei enthält veraltete
Symbole als Kommentare. Im Vorlagenmodus werden Mustersymbole desweiteren
von Kommentaren gefolgt, die die echten Symbole aufführen, die auf dieses
Muster passen.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeige den Bedienungshinweis und beende.
.TP 
\fB\-\-version\fP
Gebe die Version aus und beende sich.
.
.SH UMGEBUNG
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Setzt die Befehlsüberprüfungsstufe außer Kraft, selbst wenn das
Befehlszeilenargument \fB\-c\fP übergeben wurde (beachten Sie, dass dies der
üblichen Konvention widerspricht, demnach Befehlszeilenargumente Vorrang
über Umgebungsvariablen haben).
.SH "SIEHE AUCH"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2017 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
