#!/bin/sh

unset ZONE KTAG ALGO DTYPE DIGEST

TTL=172800

export IFS="="
xml2 | while read -r KEY VAL; do
    case "$KEY" in
	"/TrustAnchor/Zone") ZONE="$VAL";;
	"/TrustAnchor/KeyDigest/KeyTag") KTAG="$VAL";;
	"/TrustAnchor/KeyDigest/Algorithm") ALGO="$VAL";;
	"/TrustAnchor/KeyDigest/DigestType") DTYPE="$VAL";;
	"/TrustAnchor/KeyDigest/Digest")
	    DIGEST="$(echo "$VAL" | tr "[:upper:]" "[:lower:]")"
	    if [ -z "$ZONE" ] || [ -z "$KTAG" ] || [ -z "$ALGO" ] || [ -z "$DTYPE" ]; then
		echo "Missing some KeyDigest parameter"
		exit 1
	    fi
	    printf "%s\t%s\tIN\tDS\t%s %s %s %s\n" "$ZONE" "$TTL" "$KTAG" "$ALGO" "$DTYPE" "$DIGEST"
	    unset KTAG ALGO DTYPE DIGEST
	    ;;
    esac
done
exit 0
