try:  # pragma: no cover
    from django.urls import re_path
except ImportError:
    from django.conf.urls import url as re_path

from rest_framework_simplejwt import views

urlpatterns = [
    re_path(r"^jwt/create/?", views.TokenObtainPairView.as_view(), name="jwt-create"),
    re_path(r"^jwt/refresh/?", views.TokenRefreshView.as_view(), name="jwt-refresh"),
    re_path(r"^jwt/verify/?", views.TokenVerifyView.as_view(), name="jwt-verify"),
]
