/*
* gravity.h
* DIN Is Noise is copyright (c) 2006-2022 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __GRAVITY
#define __GRAVITY

#include "widget.h"
#include "arrow_button.h"
#include "checkbutton.h"
#include "spinner2.h"
#include "point.h"
#include "mouse_slider.h"
#include "multi_curve.h"
#include "mod_params.h"
#include "curve_editor.h"
#include "ui_list.h"

struct drone;

struct gravlis : rellis {
  void released ();
};

struct gravity_t : widget, click_listener, mouse_slider_listener {

  gravlis guil;
  gravlis* pguil;

  arrow_button fold;
  label lbl;
  button zero, reset;
  arrow_button left, right, up, down;
  checkbutton mouse, dron, dronsize, keepsize;
  button changesize;

  button toscrcent, tocenter, todrone;
  MAKE_CLICK_LISTENER(toscrcenl, scrcenl)
  MAKE_CLICK_LISTENER(tocenl, cenl)
  MAKE_CLICK_LISTENER(todrol, drol)

  MAKE_STATE_LISTENER (mousel, ml)

  int modyes;
  int restormod;
  double modparin;
  struct modulatet {
    checkbutton yes;
    MAKE_STATE_LISTENER(yesl, yl)
    spinner2<float> depth, bpm;
    MAKE_FIELD_LISTENER (depthl, dl)
    MAKE_FIELD_LISTENER (bpml, bl)
    multi_curve crv;
    button edit;
    curve_editor ed;
    MAKE_CLICK_LISTENER (editl, el)
    CURVE_LISTENER(curvel)
    curvel cl;
    mod_params params;
    modulatet () : crv ("gravmod.crv"), ed ("gravmod.ed"), params (&crv) {
      t = ui_clk ();
      LISTEN(yes,&yl)
      LISTEN(edit, &el)
      ed.add (&crv, &cl);
    }
    double t;
    float eval ();
  } mod;
  void modulate ();

  int lmb_clicked;
  int hitt;
  enum {NEXT_TO_NOTHING = -1, NOTHING, BASE, TIP};
  int hit (const point<float>& p, float mx, float my);

  int handlesize;

  point<float> base;
  point<float> tip;
  point<float> base2tip, base2tip_ms;
  point<float> p_base2tip;
  point<float> bottomleft, topright;
  point<int> textpos;

  double btux, btuy;

  float strength;
  float gx, gy;

  drone* tracked_drone;
  void track (float vx, float vy);
  int maos;
  int dronn;
  int dronsz;

  double mag0, mag;
	int keep_size;
  void updmag (double m);


  gravity_t ();
  void load (std::ifstream& file);
  void save (std::ofstream& file);
  int handle_input ();
  int handle_input2 ();

  void set (point<float>& p, float mx, float my, int calc_mag = 1);
  void move (float tox, float toy);
  void calcbase2tip ();
  void calcvisual ();
  void calc (int calc_mag = 1);
  void calcui ();
  void initui ();
  void preset (int id);
  void doreset (int keep_size = 0);
	int stop_editing ();

  int gl_base [8];
  float gl_arrow[12];

  void draw ();
  void drawrrow ();

  void clicked (button& b);
  void moused (int dir, double scl);
  void after_slide ();

  int unfolded ();

  int ldwx, ldwy; // last tracked drone pos on din window

};

#endif



