# Copyright © 2018 Rafael Laboissière <rafael@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

1;
function out = sysout (cmd)
    [~, out] = system (cmd);
    out = deblank (out);
endfunction

if (exist ("./PKG_ADD") == 2)
    movefile ("PKG_ADD", "PKG_ADD.bak");
endif

package = sysout ("grep ^Source: debian/control | cut -f2 -d\\ ");
debpkg = [pwd(), "/debian/", package];
mpath = [debpkg, "/usr/share/octave/packages"];
arch = sysout ("dpkg-architecture -qDEB_HOST_MULTIARCH");
bpath = [debpkg, "/usr/lib/", arch, "/octave/packages"];
pkg ("prefix", mpath, bpath);

pkg ("local_list", fullfile (pwd (), "local-list"));
pkg ("global_list", fullfile (pwd (), "global-list"));

save_header_format_string ("# Generated by Octave during Debian package build");

if (exist ("PKG_ADD.bak") == 2)
    movefile ("PKG_ADD.bak", "PKG_ADD");
endif

pkg -verbose -nodeps install .

system (sprintf ("rmdir --ignore-fail-on-non-empty -p %s %s",
                 mpath, bpath));

### Remove unnecessary documentation files
pkgdir = "debian/*/usr/share/octave/packages/*";
system (sprintf ("rm -rf %s/doc", pkgdir));
system (sprintf ("rm -f %s/packinfo/COPYING", pkgdir));

### Fix permission of installed *.oct and *.mex files, as per FHS 3.0
### sections 4.6 and 4.7 (see Bug#954149)
system (sprintf ("chmod -x debian/*/usr/lib/*/octave/packages/*/*/*.oct"));
system (sprintf ("chmod -x debian/*/usr/lib/*/octave/packages/*/*/*.mex"));
