#!/usr/bin/env python3

import configparser
import json
import sys

def metadata_ini_to_json(filename):
    ini_parser = configparser.ConfigParser()
    ini_parser.read(filename)
    desktop_items = ini_parser['Desktop Entry']
    obj = {}
    obj['KPlugin'] = {}
    authors = [{}]
    for key in desktop_items:
        val = desktop_items[key]
        if key == 'name':
            obj['KPlugin']['Name'] = val
        elif key == 'name[fr]':
            obj['KPlugin']['Name[fr]'] = val
        elif key == 'x-kde-plugininfo-author':
            authors[0]['Name'] = val
        elif key == 'x-kde-plugininfo-email':
            authors[0]['Email'] = val
        elif key == 'x-kde-plugininfo-license':
            obj['KPlugin']['License'] = val
        elif key == 'x-kde-plugininfo-name':
            obj['KPlugin']['Id'] = val
        else:
            raise ValueError('Unexpected key', key)
    if len(authors[0]) >= 1:
        obj['KPlugin']['Authors'] = authors
    print(json.dumps(obj, indent=4))

if __name__ == '__main__':
    metadata_ini_to_json(sys.argv[1])
