/*
============================================================================
DELLY: Structural variant discovery by integrated PE mapping and SR analysis
============================================================================
Copyright (C) 2012-2018 Tobias Rausch

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
============================================================================
Contact: Tobias Rausch (rausch@embl.de)
============================================================================
*/

#ifndef VERSION_H
#define VERSION_H

namespace torali
{


  std::string dellyVersionNumber = "0.7.9";

  inline 
    void printTitle(std::string const& title) 
    {
      std::cout << "**********************************************************************" << std::endl;
      std::cout << "Program: Delly" << std::endl;
      std::cout << "This is free software, and you are welcome to redistribute it under" << std::endl;
      std::cout << "certain conditions (GPL); for license details use '-l'." << std::endl;
      std::cout << "This program comes with ABSOLUTELY NO WARRANTY; for details use '-w'." << std::endl;
      std::cout <<  std::endl;
      std::cout <<  title << " (Version: " << dellyVersionNumber << ")" << std::endl;
      std::cout << "Contact: Tobias Rausch (rausch@embl.de)" << std::endl;
      std::cout << "**********************************************************************" << std::endl;
      std::cout << std::endl;
    }

  inline
    void displayWarranty()
    {
      std::cout << "THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY" << std::endl;
      std::cout << "APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT" << std::endl;
      std::cout << "HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM ''AS IS'' WITHOUT" << std::endl;
      std::cout << "WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT" << std::endl;
      std::cout << "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR" << std::endl;
      std::cout << "A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND" << std::endl;
      std::cout << "PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE" << std::endl;
      std::cout << "DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR" << std::endl;
      std::cout << "OR CORRECTION." << std::endl;
      std::cout << std::endl;
      std::cout << "IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING" << std::endl;
      std::cout << "WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR" << std::endl;
      std::cout << "CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES," << std::endl;
      std::cout << "INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES" << std::endl;
      std::cout << "ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT" << std::endl;
      std::cout << "NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR" << std::endl;
      std::cout << "LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM" << std::endl;
      std::cout << "TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER" << std::endl;
      std::cout << "PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES." << std::endl;
    }
    
  inline
    void gplV3() {
    std::cout << "                    GNU GENERAL PUBLIC LICENSE" << std::endl;
    std::cout << "                       Version 3, 29 June 2007" << std::endl;
    std::cout << std::endl;
    std::cout << " Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>" << std::endl;
    std::cout << " Everyone is permitted to copy and distribute verbatim copies" << std::endl;
    std::cout << " of this license document, but changing it is not allowed." << std::endl;
    std::cout << std::endl;
    std::cout << "                            Preamble" << std::endl;
    std::cout << std::endl;
    std::cout << "  The GNU General Public License is a free, copyleft license for" << std::endl;
    std::cout << "software and other kinds of works." << std::endl;
    std::cout << std::endl;
    std::cout << "  The licenses for most software and other practical works are designed" << std::endl;
    std::cout << "to take away your freedom to share and change the works.  By contrast," << std::endl;
    std::cout << "the GNU General Public License is intended to guarantee your freedom to" << std::endl;
    std::cout << "share and change all versions of a program--to make sure it remains free" << std::endl;
    std::cout << "software for all its users.  We, the Free Software Foundation, use the" << std::endl;
    std::cout << "GNU General Public License for most of our software; it applies also to" << std::endl;
    std::cout << "any other work released this way by its authors.  You can apply it to" << std::endl;
    std::cout << "your programs, too." << std::endl;
    std::cout << std::endl;
    std::cout << "  When we speak of free software, we are referring to freedom, not" << std::endl;
    std::cout << "price.  Our General Public Licenses are designed to make sure that you" << std::endl;
    std::cout << "have the freedom to distribute copies of free software (and charge for" << std::endl;
    std::cout << "them if you wish), that you receive source code or can get it if you" << std::endl;
    std::cout << "want it, that you can change the software or use pieces of it in new" << std::endl;
    std::cout << "free programs, and that you know you can do these things." << std::endl;
    std::cout << std::endl;
    std::cout << "  To protect your rights, we need to prevent others from denying you" << std::endl;
    std::cout << "these rights or asking you to surrender the rights.  Therefore, you have" << std::endl;
    std::cout << "certain responsibilities if you distribute copies of the software, or if" << std::endl;
    std::cout << "you modify it: responsibilities to respect the freedom of others." << std::endl;
    std::cout << std::endl;
    std::cout << "  For example, if you distribute copies of such a program, whether" << std::endl;
    std::cout << "gratis or for a fee, you must pass on to the recipients the same" << std::endl;
    std::cout << "freedoms that you received.  You must make sure that they, too, receive" << std::endl;
    std::cout << "or can get the source code.  And you must show them these terms so they" << std::endl;
    std::cout << "know their rights." << std::endl;
    std::cout << std::endl;
    std::cout << "  Developers that use the GNU GPL protect your rights with two steps:" << std::endl;
    std::cout << "(1) assert copyright on the software, and (2) offer you this License" << std::endl;
    std::cout << "giving you legal permission to copy, distribute and/or modify it." << std::endl;
    std::cout << std::endl;
    std::cout << "  For the developers' and authors' protection, the GPL clearly explains" << std::endl;
    std::cout << "that there is no warranty for this free software.  For both users' and" << std::endl;
    std::cout << "authors' sake, the GPL requires that modified versions be marked as" << std::endl;
    std::cout << "changed, so that their problems will not be attributed erroneously to" << std::endl;
    std::cout << "authors of previous versions." << std::endl;
    std::cout << std::endl;
    std::cout << "  Some devices are designed to deny users access to install or run" << std::endl;
    std::cout << "modified versions of the software inside them, although the manufacturer" << std::endl;
    std::cout << "can do so.  This is fundamentally incompatible with the aim of" << std::endl;
    std::cout << "protecting users' freedom to change the software.  The systematic" << std::endl;
    std::cout << "pattern of such abuse occurs in the area of products for individuals to" << std::endl;
    std::cout << "use, which is precisely where it is most unacceptable.  Therefore, we" << std::endl;
    std::cout << "have designed this version of the GPL to prohibit the practice for those" << std::endl;
    std::cout << "products.  If such problems arise substantially in other domains, we" << std::endl;
    std::cout << "stand ready to extend this provision to those domains in future versions" << std::endl;
    std::cout << "of the GPL, as needed to protect the freedom of users." << std::endl;
    std::cout << std::endl;
    std::cout << "  Finally, every program is threatened constantly by software patents." << std::endl;
    std::cout << "States should not allow patents to restrict development and use of" << std::endl;
    std::cout << "software on general-purpose computers, but in those that do, we wish to" << std::endl;
    std::cout << "avoid the special danger that patents applied to a free program could" << std::endl;
    std::cout << "make it effectively proprietary.  To prevent this, the GPL assures that" << std::endl;
    std::cout << "patents cannot be used to render the program non-free." << std::endl;
    std::cout << std::endl;
    std::cout << "  The precise terms and conditions for copying, distribution and" << std::endl;
    std::cout << "modification follow." << std::endl;
    std::cout << std::endl;
    std::cout << "                       TERMS AND CONDITIONS" << std::endl;
    std::cout << std::endl;
    std::cout << "  0. Definitions." << std::endl;
    std::cout << std::endl;
    std::cout << "  \"This License\" refers to version 3 of the GNU General Public License." << std::endl;
    std::cout << std::endl;
    std::cout << "  \"Copyright\" also means copyright-like laws that apply to other kinds of" << std::endl;
    std::cout << "works, such as semiconductor masks." << std::endl;
    std::cout << std::endl;
    std::cout << "  \"The Program\" refers to any copyrightable work licensed under this" << std::endl;
    std::cout << "License.  Each licensee is addressed as \"you\".  \"Licensees\" and" << std::endl;
    std::cout << "\"recipients\" may be individuals or organizations." << std::endl;
    std::cout << std::endl;
    std::cout << "  To \"modify\" a work means to copy from or adapt all or part of the work" << std::endl;
    std::cout << "in a fashion requiring copyright permission, other than the making of an" << std::endl;
    std::cout << "exact copy.  The resulting work is called a \"modified version\" of the" << std::endl;
    std::cout << "earlier work or a work \"based on\" the earlier work." << std::endl;
    std::cout << std::endl;
    std::cout << "  A \"covered work\" means either the unmodified Program or a work based" << std::endl;
    std::cout << "on the Program." << std::endl;
    std::cout << std::endl;
    std::cout << "  To \"propagate\" a work means to do anything with it that, without" << std::endl;
    std::cout << "permission, would make you directly or secondarily liable for" << std::endl;
    std::cout << "infringement under applicable copyright law, except executing it on a" << std::endl;
    std::cout << "computer or modifying a private copy.  Propagation includes copying," << std::endl;
    std::cout << "distribution (with or without modification), making available to the" << std::endl;
    std::cout << "public, and in some countries other activities as well." << std::endl;
    std::cout << std::endl;
    std::cout << "  To \"convey\" a work means any kind of propagation that enables other" << std::endl;
    std::cout << "parties to make or receive copies.  Mere interaction with a user through" << std::endl;
    std::cout << "a computer network, with no transfer of a copy, is not conveying." << std::endl;
    std::cout << std::endl;
    std::cout << "  An interactive user interface displays \"Appropriate Legal Notices\"" << std::endl;
    std::cout << "to the extent that it includes a convenient and prominently visible" << std::endl;
    std::cout << "feature that (1) displays an appropriate copyright notice, and (2)" << std::endl;
    std::cout << "tells the user that there is no warranty for the work (except to the" << std::endl;
    std::cout << "extent that warranties are provided), that licensees may convey the" << std::endl;
    std::cout << "work under this License, and how to view a copy of this License.  If" << std::endl;
    std::cout << "the interface presents a list of user commands or options, such as a" << std::endl;
    std::cout << "menu, a prominent item in the list meets this criterion." << std::endl;
    std::cout << std::endl;
    std::cout << "  1. Source Code." << std::endl;
    std::cout << std::endl;
    std::cout << "  The \"source code\" for a work means the preferred form of the work" << std::endl;
    std::cout << "for making modifications to it.  \"Object code\" means any non-source" << std::endl;
    std::cout << "form of a work." << std::endl;
    std::cout << std::endl;
    std::cout << "  A \"Standard Interface\" means an interface that either is an official" << std::endl;
    std::cout << "standard defined by a recognized standards body, or, in the case of" << std::endl;
    std::cout << "interfaces specified for a particular programming language, one that" << std::endl;
    std::cout << "is widely used among developers working in that language." << std::endl;
    std::cout << std::endl;
    std::cout << "  The \"System Libraries\" of an executable work include anything, other" << std::endl;
    std::cout << "than the work as a whole, that (a) is included in the normal form of" << std::endl;
    std::cout << "packaging a Major Component, but which is not part of that Major" << std::endl;
    std::cout << "Component, and (b) serves only to enable use of the work with that" << std::endl;
    std::cout << "Major Component, or to implement a Standard Interface for which an" << std::endl;
    std::cout << "implementation is available to the public in source code form.  A" << std::endl;
    std::cout << "\"Major Component\", in this context, means a major essential component" << std::endl;
    std::cout << "(kernel, window system, and so on) of the specific operating system" << std::endl;
    std::cout << "(if any) on which the executable work runs, or a compiler used to" << std::endl;
    std::cout << "produce the work, or an object code interpreter used to run it." << std::endl;
    std::cout << std::endl;
    std::cout << "  The \"Corresponding Source\" for a work in object code form means all" << std::endl;
    std::cout << "the source code needed to generate, install, and (for an executable" << std::endl;
    std::cout << "work) run the object code and to modify the work, including scripts to" << std::endl;
    std::cout << "control those activities.  However, it does not include the work's" << std::endl;
    std::cout << "System Libraries, or general-purpose tools or generally available free" << std::endl;
    std::cout << "programs which are used unmodified in performing those activities but" << std::endl;
    std::cout << "which are not part of the work.  For example, Corresponding Source" << std::endl;
    std::cout << "includes interface definition files associated with source files for" << std::endl;
    std::cout << "the work, and the source code for shared libraries and dynamically" << std::endl;
    std::cout << "linked subprograms that the work is specifically designed to require," << std::endl;
    std::cout << "such as by intimate data communication or control flow between those" << std::endl;
    std::cout << "subprograms and other parts of the work." << std::endl;
    std::cout << std::endl;
    std::cout << "  The Corresponding Source need not include anything that users" << std::endl;
    std::cout << "can regenerate automatically from other parts of the Corresponding" << std::endl;
    std::cout << "Source." << std::endl;
    std::cout << std::endl;
    std::cout << "  The Corresponding Source for a work in source code form is that" << std::endl;
    std::cout << "same work." << std::endl;
    std::cout << std::endl;
    std::cout << "  2. Basic Permissions." << std::endl;
    std::cout << std::endl;
    std::cout << "  All rights granted under this License are granted for the term of" << std::endl;
    std::cout << "copyright on the Program, and are irrevocable provided the stated" << std::endl;
    std::cout << "conditions are met.  This License explicitly affirms your unlimited" << std::endl;
    std::cout << "permission to run the unmodified Program.  The output from running a" << std::endl;
    std::cout << "covered work is covered by this License only if the output, given its" << std::endl;
    std::cout << "content, constitutes a covered work.  This License acknowledges your" << std::endl;
    std::cout << "rights of fair use or other equivalent, as provided by copyright law." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may make, run and propagate covered works that you do not" << std::endl;
    std::cout << "convey, without conditions so long as your license otherwise remains" << std::endl;
    std::cout << "in force.  You may convey covered works to others for the sole purpose" << std::endl;
    std::cout << "of having them make modifications exclusively for you, or provide you" << std::endl;
    std::cout << "with facilities for running those works, provided that you comply with" << std::endl;
    std::cout << "the terms of this License in conveying all material for which you do" << std::endl;
    std::cout << "not control copyright.  Those thus making or running the covered works" << std::endl;
    std::cout << "for you must do so exclusively on your behalf, under your direction" << std::endl;
    std::cout << "and control, on terms that prohibit them from making any copies of" << std::endl;
    std::cout << "your copyrighted material outside their relationship with you." << std::endl;
    std::cout << std::endl;
    std::cout << "  Conveying under any other circumstances is permitted solely under" << std::endl;
    std::cout << "the conditions stated below.  Sublicensing is not allowed; section 10" << std::endl;
    std::cout << "makes it unnecessary." << std::endl;
    std::cout << std::endl;
    std::cout << "  3. Protecting Users' Legal Rights From Anti-Circumvention Law." << std::endl;
    std::cout << std::endl;
    std::cout << "  No covered work shall be deemed part of an effective technological" << std::endl;
    std::cout << "measure under any applicable law fulfilling obligations under article" << std::endl;
    std::cout << "11 of the WIPO copyright treaty adopted on 20 December 1996, or" << std::endl;
    std::cout << "similar laws prohibiting or restricting circumvention of such" << std::endl;
    std::cout << "measures." << std::endl;
    std::cout << std::endl;
    std::cout << "  When you convey a covered work, you waive any legal power to forbid" << std::endl;
    std::cout << "circumvention of technological measures to the extent such circumvention" << std::endl;
    std::cout << "is effected by exercising rights under this License with respect to" << std::endl;
    std::cout << "the covered work, and you disclaim any intention to limit operation or" << std::endl;
    std::cout << "modification of the work as a means of enforcing, against the work's" << std::endl;
    std::cout << "users, your or third parties' legal rights to forbid circumvention of" << std::endl;
    std::cout << "technological measures." << std::endl;
    std::cout << std::endl;
    std::cout << "  4. Conveying Verbatim Copies." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may convey verbatim copies of the Program's source code as you" << std::endl;
    std::cout << "receive it, in any medium, provided that you conspicuously and" << std::endl;
    std::cout << "appropriately publish on each copy an appropriate copyright notice;" << std::endl;
    std::cout << "keep intact all notices stating that this License and any" << std::endl;
    std::cout << "non-permissive terms added in accord with section 7 apply to the code;" << std::endl;
    std::cout << "keep intact all notices of the absence of any warranty; and give all" << std::endl;
    std::cout << "recipients a copy of this License along with the Program." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may charge any price or no price for each copy that you convey," << std::endl;
    std::cout << "and you may offer support or warranty protection for a fee." << std::endl;
    std::cout << std::endl;
    std::cout << "  5. Conveying Modified Source Versions." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may convey a work based on the Program, or the modifications to" << std::endl;
    std::cout << "produce it from the Program, in the form of source code under the" << std::endl;
    std::cout << "terms of section 4, provided that you also meet all of these conditions:" << std::endl;
    std::cout << std::endl;
    std::cout << "    a) The work must carry prominent notices stating that you modified" << std::endl;
    std::cout << "    it, and giving a relevant date." << std::endl;
    std::cout << std::endl;
    std::cout << "    b) The work must carry prominent notices stating that it is" << std::endl;
    std::cout << "    released under this License and any conditions added under section" << std::endl;
    std::cout << "    7.  This requirement modifies the requirement in section 4 to" << std::endl;
    std::cout << "    \"keep intact all notices\"." << std::endl;
    std::cout << std::endl;
    std::cout << "    c) You must license the entire work, as a whole, under this" << std::endl;
    std::cout << "    License to anyone who comes into possession of a copy.  This" << std::endl;
    std::cout << "    License will therefore apply, along with any applicable section 7" << std::endl;
    std::cout << "    additional terms, to the whole of the work, and all its parts," << std::endl;
    std::cout << "    regardless of how they are packaged.  This License gives no" << std::endl;
    std::cout << "    permission to license the work in any other way, but it does not" << std::endl;
    std::cout << "    invalidate such permission if you have separately received it." << std::endl;
    std::cout << std::endl;
    std::cout << "    d) If the work has interactive user interfaces, each must display" << std::endl;
    std::cout << "    Appropriate Legal Notices; however, if the Program has interactive" << std::endl;
    std::cout << "    interfaces that do not display Appropriate Legal Notices, your" << std::endl;
    std::cout << "    work need not make them do so." << std::endl;
    std::cout << std::endl;
    std::cout << "  A compilation of a covered work with other separate and independent" << std::endl;
    std::cout << "works, which are not by their nature extensions of the covered work," << std::endl;
    std::cout << "and which are not combined with it such as to form a larger program," << std::endl;
    std::cout << "in or on a volume of a storage or distribution medium, is called an" << std::endl;
    std::cout << "\"aggregate\" if the compilation and its resulting copyright are not" << std::endl;
    std::cout << "used to limit the access or legal rights of the compilation's users" << std::endl;
    std::cout << "beyond what the individual works permit.  Inclusion of a covered work" << std::endl;
    std::cout << "in an aggregate does not cause this License to apply to the other" << std::endl;
    std::cout << "parts of the aggregate." << std::endl;
    std::cout << std::endl;
    std::cout << "  6. Conveying Non-Source Forms." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may convey a covered work in object code form under the terms" << std::endl;
    std::cout << "of sections 4 and 5, provided that you also convey the" << std::endl;
    std::cout << "machine-readable Corresponding Source under the terms of this License," << std::endl;
    std::cout << "in one of these ways:" << std::endl;
    std::cout << std::endl;
    std::cout << "    a) Convey the object code in, or embodied in, a physical product" << std::endl;
    std::cout << "    (including a physical distribution medium), accompanied by the" << std::endl;
    std::cout << "    Corresponding Source fixed on a durable physical medium" << std::endl;
    std::cout << "    customarily used for software interchange." << std::endl;
    std::cout << std::endl;
    std::cout << "    b) Convey the object code in, or embodied in, a physical product" << std::endl;
    std::cout << "    (including a physical distribution medium), accompanied by a" << std::endl;
    std::cout << "    written offer, valid for at least three years and valid for as" << std::endl;
    std::cout << "    long as you offer spare parts or customer support for that product" << std::endl;
    std::cout << "    model, to give anyone who possesses the object code either (1) a" << std::endl;
    std::cout << "    copy of the Corresponding Source for all the software in the" << std::endl;
    std::cout << "    product that is covered by this License, on a durable physical" << std::endl;
    std::cout << "    medium customarily used for software interchange, for a price no" << std::endl;
    std::cout << "    more than your reasonable cost of physically performing this" << std::endl;
    std::cout << "    conveying of source, or (2) access to copy the" << std::endl;
    std::cout << "    Corresponding Source from a network server at no charge." << std::endl;
    std::cout << std::endl;
    std::cout << "    c) Convey individual copies of the object code with a copy of the" << std::endl;
    std::cout << "    written offer to provide the Corresponding Source.  This" << std::endl;
    std::cout << "    alternative is allowed only occasionally and noncommercially, and" << std::endl;
    std::cout << "    only if you received the object code with such an offer, in accord" << std::endl;
    std::cout << "    with subsection 6b." << std::endl;
    std::cout << std::endl;
    std::cout << "    d) Convey the object code by offering access from a designated" << std::endl;
    std::cout << "    place (gratis or for a charge), and offer equivalent access to the" << std::endl;
    std::cout << "    Corresponding Source in the same way through the same place at no" << std::endl;
    std::cout << "    further charge.  You need not require recipients to copy the" << std::endl;
    std::cout << "    Corresponding Source along with the object code.  If the place to" << std::endl;
    std::cout << "    copy the object code is a network server, the Corresponding Source" << std::endl;
    std::cout << "    may be on a different server (operated by you or a third party)" << std::endl;
    std::cout << "    that supports equivalent copying facilities, provided you maintain" << std::endl;
    std::cout << "    clear directions next to the object code saying where to find the" << std::endl;
    std::cout << "    Corresponding Source.  Regardless of what server hosts the" << std::endl;
    std::cout << "    Corresponding Source, you remain obligated to ensure that it is" << std::endl;
    std::cout << "    available for as long as needed to satisfy these requirements." << std::endl;
    std::cout << std::endl;
    std::cout << "    e) Convey the object code using peer-to-peer transmission, provided" << std::endl;
    std::cout << "    you inform other peers where the object code and Corresponding" << std::endl;
    std::cout << "    Source of the work are being offered to the general public at no" << std::endl;
    std::cout << "    charge under subsection 6d." << std::endl;
    std::cout << std::endl;
    std::cout << "  A separable portion of the object code, whose source code is excluded" << std::endl;
    std::cout << "from the Corresponding Source as a System Library, need not be" << std::endl;
    std::cout << "included in conveying the object code work." << std::endl;
    std::cout << std::endl;
    std::cout << "  A \"User Product\" is either (1) a \"consumer product\", which means any" << std::endl;
    std::cout << "tangible personal property which is normally used for personal, family," << std::endl;
    std::cout << "or household purposes, or (2) anything designed or sold for incorporation" << std::endl;
    std::cout << "into a dwelling.  In determining whether a product is a consumer product," << std::endl;
    std::cout << "doubtful cases shall be resolved in favor of coverage.  For a particular" << std::endl;
    std::cout << "product received by a particular user, \"normally used\" refers to a" << std::endl;
    std::cout << "typical or common use of that class of product, regardless of the status" << std::endl;
    std::cout << "of the particular user or of the way in which the particular user" << std::endl;
    std::cout << "actually uses, or expects or is expected to use, the product.  A product" << std::endl;
    std::cout << "is a consumer product regardless of whether the product has substantial" << std::endl;
    std::cout << "commercial, industrial or non-consumer uses, unless such uses represent" << std::endl;
    std::cout << "the only significant mode of use of the product." << std::endl;
    std::cout << std::endl;
    std::cout << "  \"Installation Information\" for a User Product means any methods," << std::endl;
    std::cout << "procedures, authorization keys, or other information required to install" << std::endl;
    std::cout << "and execute modified versions of a covered work in that User Product from" << std::endl;
    std::cout << "a modified version of its Corresponding Source.  The information must" << std::endl;
    std::cout << "suffice to ensure that the continued functioning of the modified object" << std::endl;
    std::cout << "code is in no case prevented or interfered with solely because" << std::endl;
    std::cout << "modification has been made." << std::endl;
    std::cout << std::endl;
    std::cout << "  If you convey an object code work under this section in, or with, or" << std::endl;
    std::cout << "specifically for use in, a User Product, and the conveying occurs as" << std::endl;
    std::cout << "part of a transaction in which the right of possession and use of the" << std::endl;
    std::cout << "User Product is transferred to the recipient in perpetuity or for a" << std::endl;
    std::cout << "fixed term (regardless of how the transaction is characterized), the" << std::endl;
    std::cout << "Corresponding Source conveyed under this section must be accompanied" << std::endl;
    std::cout << "by the Installation Information.  But this requirement does not apply" << std::endl;
    std::cout << "if neither you nor any third party retains the ability to install" << std::endl;
    std::cout << "modified object code on the User Product (for example, the work has" << std::endl;
    std::cout << "been installed in ROM)." << std::endl;
    std::cout << std::endl;
    std::cout << "  The requirement to provide Installation Information does not include a" << std::endl;
    std::cout << "requirement to continue to provide support service, warranty, or updates" << std::endl;
    std::cout << "for a work that has been modified or installed by the recipient, or for" << std::endl;
    std::cout << "the User Product in which it has been modified or installed.  Access to a" << std::endl;
    std::cout << "network may be denied when the modification itself materially and" << std::endl;
    std::cout << "adversely affects the operation of the network or violates the rules and" << std::endl;
    std::cout << "protocols for communication across the network." << std::endl;
    std::cout << std::endl;
    std::cout << "  Corresponding Source conveyed, and Installation Information provided," << std::endl;
    std::cout << "in accord with this section must be in a format that is publicly" << std::endl;
    std::cout << "documented (and with an implementation available to the public in" << std::endl;
    std::cout << "source code form), and must require no special password or key for" << std::endl;
    std::cout << "unpacking, reading or copying." << std::endl;
    std::cout << std::endl;
    std::cout << "  7. Additional Terms." << std::endl;
    std::cout << std::endl;
    std::cout << "  \"Additional permissions\" are terms that supplement the terms of this" << std::endl;
    std::cout << "License by making exceptions from one or more of its conditions." << std::endl;
    std::cout << "Additional permissions that are applicable to the entire Program shall" << std::endl;
    std::cout << "be treated as though they were included in this License, to the extent" << std::endl;
    std::cout << "that they are valid under applicable law.  If additional permissions" << std::endl;
    std::cout << "apply only to part of the Program, that part may be used separately" << std::endl;
    std::cout << "under those permissions, but the entire Program remains governed by" << std::endl;
    std::cout << "this License without regard to the additional permissions." << std::endl;
    std::cout << std::endl;
    std::cout << "  When you convey a copy of a covered work, you may at your option" << std::endl;
    std::cout << "remove any additional permissions from that copy, or from any part of" << std::endl;
    std::cout << "it.  (Additional permissions may be written to require their own" << std::endl;
    std::cout << "removal in certain cases when you modify the work.)  You may place" << std::endl;
    std::cout << "additional permissions on material, added by you to a covered work," << std::endl;
    std::cout << "for which you have or can give appropriate copyright permission." << std::endl;
    std::cout << std::endl;
    std::cout << "  Notwithstanding any other provision of this License, for material you" << std::endl;
    std::cout << "add to a covered work, you may (if authorized by the copyright holders of" << std::endl;
    std::cout << "that material) supplement the terms of this License with terms:" << std::endl;
    std::cout << std::endl;
    std::cout << "    a) Disclaiming warranty or limiting liability differently from the" << std::endl;
    std::cout << "    terms of sections 15 and 16 of this License; or" << std::endl;
    std::cout << std::endl;
    std::cout << "    b) Requiring preservation of specified reasonable legal notices or" << std::endl;
    std::cout << "    author attributions in that material or in the Appropriate Legal" << std::endl;
    std::cout << "    Notices displayed by works containing it; or" << std::endl;
    std::cout << std::endl;
    std::cout << "    c) Prohibiting misrepresentation of the origin of that material, or" << std::endl;
    std::cout << "    requiring that modified versions of such material be marked in" << std::endl;
    std::cout << "    reasonable ways as different from the original version; or" << std::endl;
    std::cout << std::endl;
    std::cout << "    d) Limiting the use for publicity purposes of names of licensors or" << std::endl;
    std::cout << "    authors of the material; or" << std::endl;
    std::cout << std::endl;
    std::cout << "    e) Declining to grant rights under trademark law for use of some" << std::endl;
    std::cout << "    trade names, trademarks, or service marks; or" << std::endl;
    std::cout << std::endl;
    std::cout << "    f) Requiring indemnification of licensors and authors of that" << std::endl;
    std::cout << "    material by anyone who conveys the material (or modified versions of" << std::endl;
    std::cout << "    it) with contractual assumptions of liability to the recipient, for" << std::endl;
    std::cout << "    any liability that these contractual assumptions directly impose on" << std::endl;
    std::cout << "    those licensors and authors." << std::endl;
    std::cout << std::endl;
    std::cout << "  All other non-permissive additional terms are considered \"further" << std::endl;
    std::cout << "restrictions\" within the meaning of section 10.  If the Program as you" << std::endl;
    std::cout << "received it, or any part of it, contains a notice stating that it is" << std::endl;
    std::cout << "governed by this License along with a term that is a further" << std::endl;
    std::cout << "restriction, you may remove that term.  If a license document contains" << std::endl;
    std::cout << "a further restriction but permits relicensing or conveying under this" << std::endl;
    std::cout << "License, you may add to a covered work material governed by the terms" << std::endl;
    std::cout << "of that license document, provided that the further restriction does" << std::endl;
    std::cout << "not survive such relicensing or conveying." << std::endl;
    std::cout << std::endl;
    std::cout << "  If you add terms to a covered work in accord with this section, you" << std::endl;
    std::cout << "must place, in the relevant source files, a statement of the" << std::endl;
    std::cout << "additional terms that apply to those files, or a notice indicating" << std::endl;
    std::cout << "where to find the applicable terms." << std::endl;
    std::cout << std::endl;
    std::cout << "  Additional terms, permissive or non-permissive, may be stated in the" << std::endl;
    std::cout << "form of a separately written license, or stated as exceptions;" << std::endl;
    std::cout << "the above requirements apply either way." << std::endl;
    std::cout << std::endl;
    std::cout << "  8. Termination." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may not propagate or modify a covered work except as expressly" << std::endl;
    std::cout << "provided under this License.  Any attempt otherwise to propagate or" << std::endl;
    std::cout << "modify it is void, and will automatically terminate your rights under" << std::endl;
    std::cout << "this License (including any patent licenses granted under the third" << std::endl;
    std::cout << "paragraph of section 11)." << std::endl;
    std::cout << std::endl;
    std::cout << "  However, if you cease all violation of this License, then your" << std::endl;
    std::cout << "license from a particular copyright holder is reinstated (a)" << std::endl;
    std::cout << "provisionally, unless and until the copyright holder explicitly and" << std::endl;
    std::cout << "finally terminates your license, and (b) permanently, if the copyright" << std::endl;
    std::cout << "holder fails to notify you of the violation by some reasonable means" << std::endl;
    std::cout << "prior to 60 days after the cessation." << std::endl;
    std::cout << std::endl;
    std::cout << "  Moreover, your license from a particular copyright holder is" << std::endl;
    std::cout << "reinstated permanently if the copyright holder notifies you of the" << std::endl;
    std::cout << "violation by some reasonable means, this is the first time you have" << std::endl;
    std::cout << "received notice of violation of this License (for any work) from that" << std::endl;
    std::cout << "copyright holder, and you cure the violation prior to 30 days after" << std::endl;
    std::cout << "your receipt of the notice." << std::endl;
    std::cout << std::endl;
    std::cout << "  Termination of your rights under this section does not terminate the" << std::endl;
    std::cout << "licenses of parties who have received copies or rights from you under" << std::endl;
    std::cout << "this License.  If your rights have been terminated and not permanently" << std::endl;
    std::cout << "reinstated, you do not qualify to receive new licenses for the same" << std::endl;
    std::cout << "material under section 10." << std::endl;
    std::cout << std::endl;
    std::cout << "  9. Acceptance Not Required for Having Copies." << std::endl;
    std::cout << std::endl;
    std::cout << "  You are not required to accept this License in order to receive or" << std::endl;
    std::cout << "run a copy of the Program.  Ancillary propagation of a covered work" << std::endl;
    std::cout << "occurring solely as a consequence of using peer-to-peer transmission" << std::endl;
    std::cout << "to receive a copy likewise does not require acceptance.  However," << std::endl;
    std::cout << "nothing other than this License grants you permission to propagate or" << std::endl;
    std::cout << "modify any covered work.  These actions infringe copyright if you do" << std::endl;
    std::cout << "not accept this License.  Therefore, by modifying or propagating a" << std::endl;
    std::cout << "covered work, you indicate your acceptance of this License to do so." << std::endl;
    std::cout << std::endl;
    std::cout << "  10. Automatic Licensing of Downstream Recipients." << std::endl;
    std::cout << std::endl;
    std::cout << "  Each time you convey a covered work, the recipient automatically" << std::endl;
    std::cout << "receives a license from the original licensors, to run, modify and" << std::endl;
    std::cout << "propagate that work, subject to this License.  You are not responsible" << std::endl;
    std::cout << "for enforcing compliance by third parties with this License." << std::endl;
    std::cout << std::endl;
    std::cout << "  An \"entity transaction\" is a transaction transferring control of an" << std::endl;
    std::cout << "organization, or substantially all assets of one, or subdividing an" << std::endl;
    std::cout << "organization, or merging organizations.  If propagation of a covered" << std::endl;
    std::cout << "work results from an entity transaction, each party to that" << std::endl;
    std::cout << "transaction who receives a copy of the work also receives whatever" << std::endl;
    std::cout << "licenses to the work the party's predecessor in interest had or could" << std::endl;
    std::cout << "give under the previous paragraph, plus a right to possession of the" << std::endl;
    std::cout << "Corresponding Source of the work from the predecessor in interest, if" << std::endl;
    std::cout << "the predecessor has it or can get it with reasonable efforts." << std::endl;
    std::cout << std::endl;
    std::cout << "  You may not impose any further restrictions on the exercise of the" << std::endl;
    std::cout << "rights granted or affirmed under this License.  For example, you may" << std::endl;
    std::cout << "not impose a license fee, royalty, or other charge for exercise of" << std::endl;
    std::cout << "rights granted under this License, and you may not initiate litigation" << std::endl;
    std::cout << "(including a cross-claim or counterclaim in a lawsuit) alleging that" << std::endl;
    std::cout << "any patent claim is infringed by making, using, selling, offering for" << std::endl;
    std::cout << "sale, or importing the Program or any portion of it." << std::endl;
    std::cout << std::endl;
    std::cout << "  11. Patents." << std::endl;
    std::cout << std::endl;
    std::cout << "  A \"contributor\" is a copyright holder who authorizes use under this" << std::endl;
    std::cout << "License of the Program or a work on which the Program is based.  The" << std::endl;
    std::cout << "work thus licensed is called the contributor's \"contributor version\"." << std::endl;
    std::cout << std::endl;
    std::cout << "  A contributor's \"essential patent claims\" are all patent claims" << std::endl;
    std::cout << "owned or controlled by the contributor, whether already acquired or" << std::endl;
    std::cout << "hereafter acquired, that would be infringed by some manner, permitted" << std::endl;
    std::cout << "by this License, of making, using, or selling its contributor version," << std::endl;
    std::cout << "but do not include claims that would be infringed only as a" << std::endl;
    std::cout << "consequence of further modification of the contributor version.  For" << std::endl;
    std::cout << "purposes of this definition, \"control\" includes the right to grant" << std::endl;
    std::cout << "patent sublicenses in a manner consistent with the requirements of" << std::endl;
    std::cout << "this License." << std::endl;
    std::cout << std::endl;
    std::cout << "  Each contributor grants you a non-exclusive, worldwide, royalty-free" << std::endl;
    std::cout << "patent license under the contributor's essential patent claims, to" << std::endl;
    std::cout << "make, use, sell, offer for sale, import and otherwise run, modify and" << std::endl;
    std::cout << "propagate the contents of its contributor version." << std::endl;
    std::cout << std::endl;
    std::cout << "  In the following three paragraphs, a \"patent license\" is any express" << std::endl;
    std::cout << "agreement or commitment, however denominated, not to enforce a patent" << std::endl;
    std::cout << "(such as an express permission to practice a patent or covenant not to" << std::endl;
    std::cout << "sue for patent infringement).  To \"grant\" such a patent license to a" << std::endl;
    std::cout << "party means to make such an agreement or commitment not to enforce a" << std::endl;
    std::cout << "patent against the party." << std::endl;
    std::cout << std::endl;
    std::cout << "  If you convey a covered work, knowingly relying on a patent license," << std::endl;
    std::cout << "and the Corresponding Source of the work is not available for anyone" << std::endl;
    std::cout << "to copy, free of charge and under the terms of this License, through a" << std::endl;
    std::cout << "publicly available network server or other readily accessible means," << std::endl;
    std::cout << "then you must either (1) cause the Corresponding Source to be so" << std::endl;
    std::cout << "available, or (2) arrange to deprive yourself of the benefit of the" << std::endl;
    std::cout << "patent license for this particular work, or (3) arrange, in a manner" << std::endl;
    std::cout << "consistent with the requirements of this License, to extend the patent" << std::endl;
    std::cout << "license to downstream recipients.  \"Knowingly relying\" means you have" << std::endl;
    std::cout << "actual knowledge that, but for the patent license, your conveying the" << std::endl;
    std::cout << "covered work in a country, or your recipient's use of the covered work" << std::endl;
    std::cout << "in a country, would infringe one or more identifiable patents in that" << std::endl;
    std::cout << "country that you have reason to believe are valid." << std::endl;
    std::cout << std::endl;
    std::cout << "  If, pursuant to or in connection with a single transaction or" << std::endl;
    std::cout << "arrangement, you convey, or propagate by procuring conveyance of, a" << std::endl;
    std::cout << "covered work, and grant a patent license to some of the parties" << std::endl;
    std::cout << "receiving the covered work authorizing them to use, propagate, modify" << std::endl;
    std::cout << "or convey a specific copy of the covered work, then the patent license" << std::endl;
    std::cout << "you grant is automatically extended to all recipients of the covered" << std::endl;
    std::cout << "work and works based on it." << std::endl;
    std::cout << std::endl;
    std::cout << "  A patent license is \"discriminatory\" if it does not include within" << std::endl;
    std::cout << "the scope of its coverage, prohibits the exercise of, or is" << std::endl;
    std::cout << "conditioned on the non-exercise of one or more of the rights that are" << std::endl;
    std::cout << "specifically granted under this License.  You may not convey a covered" << std::endl;
    std::cout << "work if you are a party to an arrangement with a third party that is" << std::endl;
    std::cout << "in the business of distributing software, under which you make payment" << std::endl;
    std::cout << "to the third party based on the extent of your activity of conveying" << std::endl;
    std::cout << "the work, and under which the third party grants, to any of the" << std::endl;
    std::cout << "parties who would receive the covered work from you, a discriminatory" << std::endl;
    std::cout << "patent license (a) in connection with copies of the covered work" << std::endl;
    std::cout << "conveyed by you (or copies made from those copies), or (b) primarily" << std::endl;
    std::cout << "for and in connection with specific products or compilations that" << std::endl;
    std::cout << "contain the covered work, unless you entered into that arrangement," << std::endl;
    std::cout << "or that patent license was granted, prior to 28 March 2007." << std::endl;
    std::cout << std::endl;
    std::cout << "  Nothing in this License shall be construed as excluding or limiting" << std::endl;
    std::cout << "any implied license or other defenses to infringement that may" << std::endl;
    std::cout << "otherwise be available to you under applicable patent law." << std::endl;
    std::cout << std::endl;
    std::cout << "  12. No Surrender of Others' Freedom." << std::endl;
    std::cout << std::endl;
    std::cout << "  If conditions are imposed on you (whether by court order, agreement or" << std::endl;
    std::cout << "otherwise) that contradict the conditions of this License, they do not" << std::endl;
    std::cout << "excuse you from the conditions of this License.  If you cannot convey a" << std::endl;
    std::cout << "covered work so as to satisfy simultaneously your obligations under this" << std::endl;
    std::cout << "License and any other pertinent obligations, then as a consequence you may" << std::endl;
    std::cout << "not convey it at all.  For example, if you agree to terms that obligate you" << std::endl;
    std::cout << "to collect a royalty for further conveying from those to whom you convey" << std::endl;
    std::cout << "the Program, the only way you could satisfy both those terms and this" << std::endl;
    std::cout << "License would be to refrain entirely from conveying the Program." << std::endl;
    std::cout << std::endl;
    std::cout << "  13. Use with the GNU Affero General Public License." << std::endl;
    std::cout << std::endl;
    std::cout << "  Notwithstanding any other provision of this License, you have" << std::endl;
    std::cout << "permission to link or combine any covered work with a work licensed" << std::endl;
    std::cout << "under version 3 of the GNU Affero General Public License into a single" << std::endl;
    std::cout << "combined work, and to convey the resulting work.  The terms of this" << std::endl;
    std::cout << "License will continue to apply to the part which is the covered work," << std::endl;
    std::cout << "but the special requirements of the GNU Affero General Public License," << std::endl;
    std::cout << "section 13, concerning interaction through a network will apply to the" << std::endl;
    std::cout << "combination as such." << std::endl;
    std::cout << std::endl;
    std::cout << "  14. Revised Versions of this License." << std::endl;
    std::cout << std::endl;
    std::cout << "  The Free Software Foundation may publish revised and/or new versions of" << std::endl;
    std::cout << "the GNU General Public License from time to time.  Such new versions will" << std::endl;
    std::cout << "be similar in spirit to the present version, but may differ in detail to" << std::endl;
    std::cout << "address new problems or concerns." << std::endl;
    std::cout << std::endl;
    std::cout << "  Each version is given a distinguishing version number.  If the" << std::endl;
    std::cout << "Program specifies that a certain numbered version of the GNU General" << std::endl;
    std::cout << "Public License \"or any later version\" applies to it, you have the" << std::endl;
    std::cout << "option of following the terms and conditions either of that numbered" << std::endl;
    std::cout << "version or of any later version published by the Free Software" << std::endl;
    std::cout << "Foundation.  If the Program does not specify a version number of the" << std::endl;
    std::cout << "GNU General Public License, you may choose any version ever published" << std::endl;
    std::cout << "by the Free Software Foundation." << std::endl;
    std::cout << std::endl;
    std::cout << "  If the Program specifies that a proxy can decide which future" << std::endl;
    std::cout << "versions of the GNU General Public License can be used, that proxy's" << std::endl;
    std::cout << "public statement of acceptance of a version permanently authorizes you" << std::endl;
    std::cout << "to choose that version for the Program." << std::endl;
    std::cout << std::endl;
    std::cout << "  Later license versions may give you additional or different" << std::endl;
    std::cout << "permissions.  However, no additional obligations are imposed on any" << std::endl;
    std::cout << "author or copyright holder as a result of your choosing to follow a" << std::endl;
    std::cout << "later version." << std::endl;
    std::cout << std::endl;
    std::cout << "  15. Disclaimer of Warranty." << std::endl;
    std::cout << std::endl;
    std::cout << "  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY" << std::endl;
    std::cout << "APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT" << std::endl;
    std::cout << "HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY" << std::endl;
    std::cout << "OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO," << std::endl;
    std::cout << "THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR" << std::endl;
    std::cout << "PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM" << std::endl;
    std::cout << "IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF" << std::endl;
    std::cout << "ALL NECESSARY SERVICING, REPAIR OR CORRECTION." << std::endl;
    std::cout << std::endl;
    std::cout << "  16. Limitation of Liability." << std::endl;
    std::cout << std::endl;
    std::cout << "  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING" << std::endl;
    std::cout << "WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS" << std::endl;
    std::cout << "THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY" << std::endl;
    std::cout << "GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE" << std::endl;
    std::cout << "USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF" << std::endl;
    std::cout << "DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD" << std::endl;
    std::cout << "PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS)," << std::endl;
    std::cout << "EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF" << std::endl;
    std::cout << "SUCH DAMAGES." << std::endl;
    std::cout << std::endl;
    std::cout << "  17. Interpretation of Sections 15 and 16." << std::endl;
    std::cout << std::endl;
    std::cout << "  If the disclaimer of warranty and limitation of liability provided" << std::endl;
    std::cout << "above cannot be given local legal effect according to their terms," << std::endl;
    std::cout << "reviewing courts shall apply local law that most closely approximates" << std::endl;
    std::cout << "an absolute waiver of all civil liability in connection with the" << std::endl;
    std::cout << "Program, unless a warranty or assumption of liability accompanies a" << std::endl;
    std::cout << "copy of the Program in return for a fee." << std::endl;
    std::cout << std::endl;
    std::cout << "                     END OF TERMS AND CONDITIONS" << std::endl;
  }

}

#endif
