# Copyright 2023 The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.
"""Django pages URL's for Debusine."""
from django.urls import include, path

from debusine.web.views.task_status import TaskStatusView

# Scoped URLs
urlpatterns = [
    # TODO: move to unscoped
    path(
        "accounts/",
        include("debusine.web.urls.accounts", namespace="accounts"),
    ),
    # TODO: move to unscoped, or filter by scope?
    path(
        "work-request/",
        include("debusine.web.urls.work_requests", namespace="work-requests"),
    ),
    # TODO: move to unscoped
    path(
        "workers/",
        include("debusine.web.urls.workers", namespace="workers"),
    ),
    path(
        "artifact/",
        include(
            "debusine.web.urls.artifacts",
            namespace="artifacts",
        ),
    ),
    # TODO: move to unscoped
    path(
        "user/",
        include(
            "debusine.web.urls.user",
            namespace="user",
        ),
    ),
    # TODO: move to unscoped, or filter by scope?
    path(
        "task-status/",
        TaskStatusView.as_view(),
        name="task-status",
    ),
    path(
        "",
        include("debusine.web.urls.workspaces", namespace="workspaces"),
    ),
]
