# Generated by Django 3.2.19 on 2024-05-22 10:05

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0059_collection_workspace_namespace'),
    ]

    operations = [
        migrations.CreateModel(
            name='WorkspaceChain',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'order',
                    models.IntegerField(
                        help_text='Lookup order of this element in the chain'
                    ),
                ),
                (
                    'child',
                    models.ForeignKey(
                        help_text='Workspace that falls back on `parent` for lookups',
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='chain_parents',
                        to='db.workspace',
                    ),
                ),
                (
                    'parent',
                    models.ForeignKey(
                        help_text='Workspace to be looked up if lookup in `child` fails',
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='chain_children',
                        to='db.workspace',
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='workspace',
            name='inherits',
            field=models.ManyToManyField(
                related_name='inherited_by',
                through='db.WorkspaceChain',
                to='db.Workspace',
            ),
        ),
        migrations.AddConstraint(
            model_name='workspacechain',
            constraint=models.UniqueConstraint(
                fields=('child', 'parent'),
                name='db_workspacechain_unique_child_parent',
            ),
        ),
        migrations.AddConstraint(
            model_name='workspacechain',
            constraint=models.UniqueConstraint(
                fields=('child', 'order'),
                name='db_workspacechain_unique_child_order',
            ),
        ),
    ]
