# Generated by Django 3.2.19 on 2024-03-17 18:30

import django.contrib.postgres.constraints
import django.contrib.postgres.operations
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions


class Migration(migrations.Migration):

    dependencies = [('db', '0025_token_hash_final')]

    operations = [
        django.contrib.postgres.operations.BtreeGistExtension(),
        migrations.CreateModel(
            name='CollectionItemMatchConstraint',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('collection_item_id', models.BigIntegerField()),
                ('constraint_name', models.CharField(max_length=255)),
                ('key', models.TextField()),
                ('value', models.TextField()),
                (
                    'collection',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='item_match_constraints',
                        to='db.collection',
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name='collectionitemmatchconstraint',
            index=models.Index(
                fields=['collection_item_id'],
                name='db_cimc_collection_item_idx',
            ),
        ),
        migrations.AddConstraint(
            model_name='collectionitemmatchconstraint',
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=(
                    (django.db.models.expressions.F('collection'), '='),
                    (django.db.models.expressions.F('constraint_name'), '='),
                    (django.db.models.expressions.F('key'), '='),
                    (django.db.models.expressions.F('value'), '<>'),
                ),
                name='db_collectionitemmatchconstraint_match_value',
            ),
        ),
    ]
