# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Test tables."""

from django.test import RequestFactory

from debusine.db.models import WorkRequest
from debusine.test.django import TestCase
from debusine.web.views.tables import WorkRequestTable


class WorkRequestTableTests(TestCase):
    """Tests for :py:class:`WorkRequestTable`."""

    def test_defaults(self) -> None:
        """Test default arguments for custom Pagination object."""
        request = RequestFactory().get("/")
        table = WorkRequestTable(request, WorkRequest.objects.all())
        self.assertEqual(table.default_column, "-created_at")
        self.assertEqual(
            list(table.columns.keys()),
            ["id", "created_at", "task_type", "task_name", "status", "result"],
        )
