# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Common code for debusine-client tests."""

import io

from rich.console import Console


class TestConsole(Console):
    """Rich console set up to direct simple output to a buffer."""

    def __init__(self) -> None:
        """Initialize to send all output to self.output."""
        self.output = io.StringIO()
        super().__init__(
            force_terminal=False, file=self.output, width=4096, height=4096
        )

    def reset_output(self) -> None:
        """Empty self.output."""
        self.output.truncate(0)
        self.output.seek(0)
