Format: complete
Css: README.css
Title: Debian Policy
Author: Manoj Srivastava and Russ Allbery
Email: debian-policy@packages.debian.org
Link Home: https://wiki.debian.org/Teams/Policy
Link Up: https://www.debian.org/

# Debian Policy

## Infrastructure

+ Website:: <https://www.debian.org/doc/devel-manuals#policy>
+ Mailing list:: <debian-policy@lists.debian.org> lists
+ Source Code::
  * git clone https://salsa.debian.org/dbnpolicy/policy
  * Browser: <https://salsa.debian.org/dbnpolicy/policy>
+ Unix group:: dbnpolicy
+ Salsa Group:: <https://salsa.debian.org/dbnpolicy> (exists
  to manage the repository but not otherwise used)

### Interacting with the team

+ Email contact:: <debian-policy@lists.debian.org>
+ Request tracker:: <https://bugs.debian.org/src:debian-policy>

Debian Policy uses a formal procedure and a set of user tags to manage
the life cycle of change proposals. For definitions of those tags and
proposal states and information about what the next step is for each
phase, see [Policy changes process](./Process.md).

Given that most changes need to be discussed according to this
process, we have merge requests on salsa turned off.  Please submit a
bug to the BTS, either with patches attached, or a reference to a
git branch that is publically fetchable.

Once the wording for a change has been finalized, please send a patch
against the current Git master branch to the bug report, if you're not
familiar with Git, the following commands are the basic process:


    git clone https://salsa.debian.org/dbnpolicy/policy
    git checkout -b <local-branch-name>

    # edit files, but don't make changes to upgrading-checklist or debian/changelog
    git add <files>
    git commit
    # repeat as necessary

    # update your branch against the current master
    git checkout master
    git pull

    git checkout master
    git merge --no-commit <local-branch-name>
    git reset --hard HEAD;
    git checkout <local-branch-name>;

    # If there are changes in master that make the branch not apply cleanly,
    # there should have been en error during the merge step above. If there
    # was an error, merge the master branch into the local branch, fix the
    # conflicts, and commit the new version of the local branch.
    git merge master
    # Edit files to remove conflict
    git commit -s

    # Checkout the local branch, to create the patch to send to the policy
    git checkout <local-branch-name>
    dir=$(mktemp -d)
    git format-patch -o $dir -s master
    # check out the patches created in $dir
    git send-email --from "you <your@email>"             \
                   --to debian-policy@lists.debian.org   \
                   $dir/

<local-branch-name> is some convenient name designating your local
changes. You may want to use some common prefix like local-. You can
use git format-patch and git send-email if you want, but usually it's
overkill.

## Usual Roles

The Debian Policy team are official project delegates (see the DPL
delegation). All of the Policy team members do basically the same
work: shepherd proposals, propose wording, and merge changes when
consensus has been reached. The current delegates are:

+ Russ Allbery (rra)
+ Sean Whitton (spwhitton)

## Task description

The Debian Policy team is responsible for maintaining and coordinating
updates to the Debian Policy Manual and all the other policy documents
released as part of the "debian-policy" package.

The Debian Policy Editors:

+ Guide the work on the Debian Policy Manual and related documents as a
  collaborative process where developers review and second or object to
  proposals, usually on the debian-policy mailing list.
+ Count seconds and weight objections to proposals, to determine whether
  they have reached sufficient consensus to be included, and accept
  consensual proposals.
+ Reject or refer to the Technical Committee proposals that fail to
  reach consensus.
+ Commit changes to the version control system repository used to
  maintain the Debian Policy Manual and related documents.
+ Maintain the "debian-policy" package. As package maintainers, they
  have the last word on package content, releases, bug reports, etc.

Everything else can be done by anyone, or any DD (depending on the
outcome of the discussion about seconding). We explicitly want any
Debian DD to review and second or object to proposals. The more
participation, the better. Many other people are active on the Policy
mailing list without being project delegates.

In addition to the main technical manual, the team currently also maintains:

+ [Machine-readable debian/copyright format](https://www.debian.org/doc/packaging-manuals/copyright-format/1.0/)
+ [Debian Menu sub-policy](https://www.debian.org/doc/packaging-manuals/menu-policy/)
+ [Debian Perl Policy](https://www.debian.org/doc/packaging-manuals/perl-policy/)
+ [Debconf Specification](https://www.debian.org/doc/packaging-manuals/debconf_specification.html)
+ [Authoritative list of virtual package names](https://www.debian.org/doc/packaging-manuals/virtual-package-names-list.txt)

These documents are maintained using the Policy changes process (see
final appendix to policy), and the current state of all change
proposals is tracked using the
[debian-policy BTS](https://bugs.debian.org/src:debian-policy).

## Get involved

The best way to help is to review the
[current open bugs](https://bugs.debian.org/src:debian-policy), pick a
bug that no one is currently shepherding (ask on
[debian-policy@lists.debian.org](mailto:debian-policy@lists.debian.org)
if you're not sure if a particular bug is being shepherded), and help
it through the change process.  In addition to the main bug view, you
can also
[view bugs organised by complexity](https://bugs.debian.org/cgi-bin/pkgreport.cgi?dist=unstable;ordering=by-complexity;package=debian-policy)
-- a bug of simple complexity is thought to be an uncontroversial
change that probably just needs someone to write a patch.

Shepherding a bug involves guiding the discussion, seeking additional
input (particularly from experts in the area being discussed),
possibly raising the issue on other mailing lists, proposing or
getting other people to propose specific wording changes, and writing
diffs against the current Policy document. All of the steps of the
Policy changes process can be done by people other than Policy team
members except the final acceptance steps and almost every change can
be worked on independently, so there's a lot of opportunity for people
to help.

There are also some other, larger projects:

+ Policy contains several appendices which are really documentation of
  how parts of the dpkg system works rather than technical
  Policy. Those appendices should be removed from the Policy document
  and maintained elsewhere, probably as part of dpkg, and any Policy
  statements in them moved into the main document. This project will
  require reviewing the current contents of the appendices and feeding
  the useful bits that aren't currently documented back to the dpkg
  team as documentation patches.
+ Policy has grown organically over the years and suffers from
  organizational issues because of it. There has been quite a bit of
  discussion of a new format that would allow for this, probably as
  part of switching to DocBook, but as yet such a reorganization and
  reworking has not been started.

If you want to work on any of these projects, please mail
[debian-policy@lists.debian.org](mailto:debian-policy@lists.debian.org)
for more information. We'll be happy to help you get started.

### Translations

We have recently begun accepting translations for the Policy Manual.
Please follow the procedures of the localisation team for the language
into which you wish to translate.

When you have a translation for us to merge, it should be committed to
this repository:

    https://salsa.debian.org/dbnpolicy/policy-l10n-merge-requests-here

DDs can push to this repo's master branch; non-DDs should create merge
requests.

## Maintenance procedures

### Repository layout

The Git repository used for Debian Policy has the following branches:

+ master:: the current accepted changes that will be in the next release
+ bug<number>-<user>:: changes addressing bug <number>,
  shepherded by <user>
+ rra:: old history of Russ's arch repository, now frozen
+ srivasta:: old history of Manoj's arch repository

### Managing a bug

The process used by Policy team members to manage a bug, once there is
proposed wording, is:

+ Create a bug<number>-<user> branch for the bug, where
  <number> is the bug number in the BTS and <user>is a
  designator of the Policy team member who is shepherding the bug.
+ Commit wording changes in that branch until consensus is
  achieved. Do not modify debian/changelog or upgrading-checklist.xml
  during this phase. Use the BTS to track who proposed the wording and
  who seconded it.
+ git pull master to make sure you have the latest version.
+ Once the change has been approved by enough people, git merge the
  branch into master immediately after making the final commit adding
  the changelog entry to minimize conflicts.
+ add the debian/changelog and upgrading-checklist.xml changes, and
  commit to master.
+ Push master out so other people may merge in their own bug branches
  without conflicts.
+ Tag the bug as pending and remove other process tags.
+ Delete the now-merged branch.

The Git commands used for this workflow are:

    git checkout -b bug12345-rra master
    # edit files
    # git add files
    git commit
    git push origin bug12345-rra
    # iterate until good
    # update your local master branch
    git checkout master
    git pull

    git checkout master
    git merge --no-commit bug12345-rra
    git reset --hard HEAD;

    # If there are changes in master that make the branch not apply cleanly,
    # there should have been en error during the merge step above. If there
    # was an error, merge the master branch into the local branch, fix the
    # conflicts, and commit the new version of the local branch.
    git checkout bug12345-rra
    git merge master
    # Edit files to remove conflict
    git commit -s

    git checkout master
    git merge bug12345-rra
    # edit debian/changelog and upgrading-checklist.xml
    git add debian/changelog upgrading-checklist.xml
    git commit
    git push origin master
    git branch -d bug12345-rra
    git push origin :bug12345-rra

For the debian/changelog entry, use the following format:

    * <document>: <brief change description>
      Wording: <author of wording>
      Seconded: <seconder>
      Seconded: <seconder>
      Closes: <bug numbers>

For example:

    * Policy: better document version ranking and empty Debian revisions
      Wording: Russ Allbery <rra@debian.org>
      Seconded: Raphaël Hertzog <hertzog@debian.org>
      Seconded: Manoj Srivastava <srivasta@debian.org>
      Seconded: Guillem Jover <guillem@debian.org>
      Closes: #186700, #458910

### Updating branches

After commits to master have been pushed, either by you or by another
Policy team member, you will generally want to update your working bug
branches. The equivalent of the following commands should do that:

    for i in `git show-ref --heads | awk '{print $2}'`; do
        j=$(basename $i)
        if [ "$j" != "master" ]; then
            git checkout $j && git merge master
        fi
    done
    git push --all origin

assuming that you haven't packed the refs in your repository.

### Making a release

For a final Policy release,

1. Pull any translation updates from `https://salsa.debian.org/dbnpolicy/policy-l10n-merge-requests-here`
2. `dch -r` to finalise changelog
3. Update release date in the upgrading checklist
4. Bump Standards-Version in d/control
5. Commit these changes:

    `git commit debian/changelog debian/control policy/upgrading-checklist.rst -m"finalise 3.9.8.0"`

6. Make sure the package builds and installs: `dgit sbuild` or
   equivalent
7. Tag and upload: either
  - `git tag -s 3.9.8.0` followed by `dput`; or
  - `dgit push-source`
8. Push to salsa:
  - `git push --tags origin`
9. Announce on debian-devel-announce, including upgrading checklist
   section for new release
10. Also consider a more informally-worded posting on a blog that is
   syndicated to planet.debian.org.
11. Some time later, verify publication to
    https://www.debian.org/doc/debian-policy/ .
  +  This is generated by executing the following cron scripts:
      -  `/srv/www.debian.org/cron/parts/1ftpfiles` (download the deb package)
      -  `/srv/www.debian.org/cron/parts/7doc` (unpack and move pages)
  +  It's build log is available at
      -  https://www-master.debian.org/build-logs/webwml/often.log
  +  These cron scripts can be found at
      -  https://salsa.debian.org/webmaster-team/cron

### Setting release goals

Policy has a large bug backlog, and each bug against Policy tends to
take considerable time and discussion to resolve. I've found it
useful, when trying to find a place to start, to pick a manageable set
of bugs and set as a target resolving them completely before the next
Policy release. Resolving a bug means one of the following:

+ Proposing new language to address the bug that's seconded and approved by
  the readers of the Policy list following the [Policy changes process](./Progress.md)
  (or that's accepted by one of the Policy delegates if the change isn't
  normative; i.e., doesn't change the technical meaning of the document).
+ Determining that the bug is not relevant to Policy and closing it.
+ Determining that either there is no consensus that the bug indicates
  a problem, that the solutions that we can currently come up with are
  good solutions, or that Debian is ready for the change. These bugs
  are tagged wontfix and then closed after a while. A lot of Policy
  bugs fall into this category; just because it would be useful to
  have a policy in some area doesn't mean that we're ready to make
  one, and keeping the bugs open against Policy makes it difficult to
  tell what requires work. If the problem is worth writing a policy
  for, it will come up again later when hopefully the project
  consensus is more mature.

Anyone can pick bugs and work resolve them. The final determination to
accept a wording change or reject a bug will be made by a Policy
delegate, but if a patch is already written and seconded, or if a
summary of why a bug is not ready to be acted on is already written,
the work is much easier for the Policy delegate.

One of the best ways to help out is to pick one or two bugs (checking
on the Policy list first), say that you'll make resolving them a goal
for the next release, and guide the discussion until the bugs can
reach one of the resolution states above.
