// Limit the disk cache, and disable it by default, to avoid users
// filling up their home directory with cache files.
pref("browser.cache.disk.enable", false);
pref("browser.cache.offline.enable", false);

pref("browser.cache.disk.capacity", 5120);
// This need to point to a user specific file, can't use a common file for all users
//pref("browser.cache.disk.parent_directory", "/var/tmp");

// Only cache to memory instead
pref("browser.cache.memory.enable", true);
pref("browser.cache.memory.max_entry_size", -1);

// Printer Settings
pref("print.postscript.print_size", "A4");
pref("print.postscript.print_command", "kprinter");
pref("print.print_command", "kprinter");

// Enable spell checking in both single-line and multi-line fields
pref("layout.spellcheckDefault", 2);

// Mailto settings
pref("network.protocol-handler.app.mailto", "icedove");

// Disable malware detection to avoid heavy I/O during login.
// Should be disabled when BTS #? is fixed.
// http://www.debianhelp.org/node/14453
// https://bugs.launchpad.net/firefox/+bug/215728
// https://bugs.edge.launchpad.net/ubuntu/+source/firefox-3.0/+bug/229745
pref("browser.safebrowsing.malware.enabled", false);
pref("browser.safebrowsing.enabled", false);

// Disable location-bar suggestion feature that is sludgy on
// thin-clients.
pref("browser.urlbar.maxRichResults", 0);

// Tell Firefox to not look for upgrades.  Use apt to upgrade.
pref("app.update.enabled", false);

// But it is allowed to look for new extentions.
pref("extensions.update.enabled", true);

// Use LANG environment variable to choose locale.
pref("intl.locale.matchOS", true);

// Disable default browser checking.
pref("browser.shell.checkDefaultBrowser", false);
