%undefine __cmake_in_source_build
%undefine __cmake3_in_source_build

Name:         davix
Version:      0.8.8
Release:      1%{?dist}
Summary:      Toolkit for HTTP-based file management
License:      LGPLv2+
URL:          https://dmc-docs.web.cern.ch/dmc-docs/davix.html
#Source0:     https://github.com/cern-fts/davix/releases/download/R_0_8_6/davix-0.8.6.tar.gz
Source0:      %{name}-%{version}.tar.gz

BuildRequires:      gcc-c++
BuildRequires:      python3
BuildRequires:      cmake
# main lib dependencies
%if 0%{?fedora} || 0%{?rhel} >= 9
# use bundled curl version on EPEL 8
BuildRequires:      curl-devel
%endif
BuildRequires:      libxml2-devel
BuildRequires:      openssl-devel
BuildRequires:      zlib-devel
# davix-copy dependencies
BuildRequires:      gsoap-devel
BuildRequires:      libuuid-devel
# unit tests
BuildRequires:      gtest-devel
# documentation
BuildRequires:      doxygen
BuildRequires:      python3-sphinx
BuildRequires:      python3-sphinx_rtd_theme

Requires:     %{name}-libs%{?_isa} = %{version}-%{release}

%description
Davix is a toolkit designed for file operations
with HTTP based protocols (WebDav, Amazon S3, ...).
Davix provides an API and a set of command line tools.

%package libs
Summary:      Runtime libraries for %{name}
%if ! ( 0%{?fedora} || 0%{?rhel} >= 9)
Provides:     bundled(libcurl) = 7.69.0
%endif

%description libs
Libraries for %{name}. Davix is a toolkit designed for file operations
with HTTP based protocols (WebDav, Amazon S3, ...).

%package devel
Summary:       Development files for %{name}
Requires:      %{name}-libs%{?_isa} = %{version}-%{release}

%description devel
Development files for %{name}. Davix is a toolkit designed for file operations
with HTTP based protocols (WebDav, Amazon S3, ...).

%package tests
Summary:      Test suite for %{name}
Requires:     %{name}-libs%{?_isa} = %{version}-%{release}

%description tests
Test suite for %{name}. Davix is a toolkit designed for file operations
with HTTP based protocols (WebDav, Amazon S3, ...).

%package doc
Summary:      Documentation for %{name}
BuildArch:    noarch

%description doc
Documentation and examples for %{name}. Davix is a toolkit designed
for file operations with HTTP based protocols (WebDav, Amazon S3, ...).

%clean
%cmake3_build --target clean

%prep
%setup -q

# Remove bundled stuff
%if 0%{?fedora} || 0%{?rhel} >= 9
# remove bundled curl version outside EPEL 8
rm -rf deps/curl
%endif
rm -rf test/pywebdav
rm -rf doc/sphinx/_themes/sphinx_rtd_theme

%build
%cmake3 \
%if 0%{?fedora} || 0%{?rhel} >= 9
  -DEMBEDDED_LIBCURL=FALSE \
%endif
  -DDOC_INSTALL_DIR=%{_pkgdocdir} \
  -DENABLE_THIRD_PARTY_COPY=TRUE \
  -DENABLE_HTML_DOCS=TRUE
%cmake3_build
%cmake3_build --target doc
( cd %{_vpath_builddir}/doc ; \
  sphinx-build -q -b html ../../doc/sphinx build/html ; \
  rm -f build/html/.buildinfo ; \
  rm -rf build/html/.doctrees )

%install
%cmake3_install
rm %{buildroot}%{_pkgdocdir}/LICENSE

%ldconfig_scriptlets libs

%files
%{_bindir}/davix-cp
%{_bindir}/davix-get
%{_bindir}/davix-http
%{_bindir}/davix-ls
%{_bindir}/davix-mkdir
%{_bindir}/davix-mv
%{_bindir}/davix-put
%{_bindir}/davix-rm
%doc %{_mandir}/man1/davix-get.1*
%doc %{_mandir}/man1/davix-http.1*
%doc %{_mandir}/man1/davix-ls.1*
%doc %{_mandir}/man1/davix-mkdir.1*
%doc %{_mandir}/man1/davix-mv.1*
%doc %{_mandir}/man1/davix-put.1*
%doc %{_mandir}/man1/davix-rm.1*

%files libs
%{_libdir}/libdavix.so.*
%{_libdir}/libdavix_copy.so.*
%doc %{_pkgdocdir}/RELEASE-NOTES.md
%license LICENSE

%files devel
%{_includedir}/davix
%{_libdir}/libdavix.so
%{_libdir}/libdavix_copy.so
%{_libdir}/pkgconfig/davix.pc
%{_libdir}/pkgconfig/davix_copy.pc
%doc %{_mandir}/man3/libdavix.3*

%files tests
%{_bindir}/davix-unit-tests
%{_bindir}/davix-tester

%files doc
%doc %{_pkgdocdir}/html
%license LICENSE

%changelog
* Tue Jan 21 2025 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.8-1
 - davix 0.8.8 release, see RELEASE-NOTES.md for changes

* Mon Jun 24 2024 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.7-1
 - davix 0.8.7 release, see RELEASE-NOTES.md for changes

* Tue Apr 02 2024 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.6-1
 - davix 0.8.6 release, see RELEASE-NOTES.md for changes

* Fri Oct 20 2023 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.5-1
 - davix 0.8.5 release, see RELEASE-NOTES.md for changes

* Thu Feb 02 2023 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.4-1
 - davix 0.8.4 release, see RELEASE-NOTES.md for changes

* Tue Sep 13 2022 Joao Lopes <batistal at cern.ch> - 0.8.3-1
 - davix 0.8.3 release, see RELEASE-NOTES.md for changes

* Fri Jun 10 2022 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.2-1
 - davix 0.8.2 release, see RELEASE-NOTES.md for changes

* Wed Mar 30 2022 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.1-1
- davix 0.8.1 release, see RELEASE-NOTES.md for changes

* Fri Sep 17 2021 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.0-1
- davix 0.8.0 release, see RELEASE-NOTES.md for changes

* Wed Apr 29 2020 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.6-1
- davix 0.7.6 release, see RELEASE-NOTES.md for changes

* Wed Aug 28 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.5-1
- davix 0.7.5 release, see RELEASE-NOTES.md for changes

* Thu Jul 04 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.4-1
- davix 0.7.4 release, see RELEASE-NOTES.md for changes

* Wed May 08 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.3-1
- davix 0.7.3 release, see RELEASE-NOTES.md for changes

* Fri Feb 15 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.2-1
- davix 0.7.2 release, see RELEASE-NOTES.md for changes

* Wed Oct 24 2018 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.1-1
- davix 0.7.1 release, see RELEASE-NOTES.md for changes

* Mon Oct 22 2018 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.0-1
- davix 0.7.0 release, see RELEASE-NOTES.md for changes

* Tue Sep 25 2018 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.9-1
- davix 0.6.9 release, see RELEASE-NOTES.md for changes

* Fri Dec 01 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.8-1
- davix 0.6.8 release, see RELEASE-NOTES for changes

* Tue Nov 07 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.7-1
- davix 0.6.7 release, see RELEASE-NOTES for changes

* Wed May 17 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.7-1
- davix 0.6.7 release, see RELEASE-NOTES for changes

* Thu May 11 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.6-1
- davix 0.6.6 release, see RELEASE-NOTES for changes

* Tue Feb 07 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.5-1
- davix 0.6.5 release, see RELEASE-NOTES for changes

* Thu Aug 18 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.4-1
- davix 0.6.4 release, see RELEASE-NOTES for changes

* Thu Apr 07 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.3-1
- davix 0.6.3 release, see RELEASE-NOTES for changes

* Tue Apr 05 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.2-1
- davix 0.6.2 release, see RELEASE-NOTES for changes

* Mon Apr 04 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.1-1
- davix 0.6.1 release, see RELEASE-NOTES for changes

* Thu Nov 05 2015 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.0-1
- davix 0.6.0 release, see RELEASE-NOTES for changes

* Fri Dec 05 2014 Adrien Devresse <adevress at cern.ch> - 0.4.0-1
- davix 0.4.0 release, see RELEASE-NOTES for changes

* Tue Aug 12 2014 Adrien Devresse <adevress at cern.ch> - 0.3.6-1
- davix 0.3.6 release, see RELEASE-NOTES for changes

* Tue Jul 22 2014 Adrien Devresse <adevress at cern.ch> - 0.3.4-1
- Update to release 0.3.4

* Wed Jun 04 2014 Adrien Devresse <adevress at cern.ch> - 0.3.1-1
- davix 0.3.1 release, see RELEASE-NOTES for changes

* Tue Jun 03 2014 Adrien Devresse <adevress at cern.ch> - 0.3.0-1
- davix 0.3.0 release, see RELEASE-NOTES for changes

* Tue Jan 28 2014 Adrien Devresse <adevress at cern.ch> - 0.2.10-1
- davix 0.2.10 release, see RELEASE-NOTES for details

* Mon Oct 28 2013 Adrien Devresse <adevress at cern.ch> - 0.2.7-3
- New update of davix, see RELEASE-NOTES for details

* Tue Sep 03 2013 Adrien Devresse <adevress at cern.ch> - 0.2.6-1
- Release 0.2.6 of davix, see RELEASE-NOTES for details

* Wed Jun 05 2013 Adrien Devresse <adevress at cern.ch> - 0.2.2-2
- Initial EPEL release
