info = {
    "name": "uk",
    "date_order": "DMY",
    "january": [
        "січ",
        "січень",
        "січня"
    ],
    "february": [
        "лют",
        "лютий",
        "лютого"
    ],
    "march": [
        "бер",
        "берез",
        "березень",
        "березня"
    ],
    "april": [
        "кві",
        "квіт",
        "квітень",
        "квітня"
    ],
    "may": [
        "тра",
        "трав",
        "травень",
        "травня"
    ],
    "june": [
        "чер",
        "черв",
        "червень",
        "червня"
    ],
    "july": [
        "лип",
        "липень",
        "липня"
    ],
    "august": [
        "сер",
        "серп",
        "серпень",
        "серпня"
    ],
    "september": [
        "вер",
        "верес",
        "вересень",
        "вересня"
    ],
    "october": [
        "жов",
        "жовт",
        "жовтень",
        "жовтня"
    ],
    "november": [
        "лис",
        "лист",
        "листоп",
        "листопад",
        "листопада"
    ],
    "december": [
        "гру",
        "груд",
        "грудень",
        "грудня"
    ],
    "monday": [
        "пн",
        "пон",
        "понед",
        "понеділок",
        "пн",
        "пон",
        "понед",
        "понеділок"
    ],
    "tuesday": [
        "вт",
        "вів",
        "вівторок",
        "вт",
        "вів",
        "вівтор",
        "вівторок"
    ],
    "wednesday": [
        "ср",
        "сер",
        "середа",
        "ср",
        "сер",
        "серед",
        "середа",
        "середу"
    ],
    "thursday": [
        "чт",
        "чет",
        "четвер",
        "чт",
        "чет",
        "четвер"
    ],
    "friday": [
        "пт",
        "пят",
        "п'ятниця"
    ],
    "saturday": [
        "сб",
        "суб",
        "субота",
        "сб",
        "суб",
        "субот",
        "субота",
        "суботу"
    ],
    "sunday": [
        "нд",
        "нед",
        "неділя",
        "нд",
        "нед",
        "неділ",
        "неділя",
        "неділю"
    ],
    "am": [
        "дп",
        "до полудня"
    ],
    "pm": [
        "пп",
        "після полудня",
        "пополудні",
        "пополудні"
    ],
    "year": [
        "р",
        "рік",
        "року",
        "років",
        "роками",
        "роках",
        "роки",
        "рокові",
        "роком",
        "році",
        "р",
        "рік",
        "роки",
        "років",
        "року",
        "роком",
        "році"
    ],
    "month": [
        "міс",
        "місяць",
        "місяця",
        "місяців",
        "місяцями",
        "місяцях",
        "місяці",
        "місяцеві",
        "місяцю",
        "місяцем",
        "м",
        "міс",
        "місяць",
        "місяці",
        "місяців",
        "місяця",
        "місяцю",
        "місяцям",
        "місяцем"
    ],
    "week": [
        "тиж",
        "тижня",
        "тижневі",
        "тижню",
        "тижнем",
        "тижню",
        "тиждень",
        "т",
        "тиждень",
        "тижня",
        "тижні",
        "тижнів",
        "тижнем"
    ],
    "day": [
        "д",
        "дня",
        "дневі",
        "дню",
        "днем",
        "день",
        "д",
        "дн",
        "день",
        "дня",
        "дні",
        "днів",
        "доба",
        "доби",
        "діб"
    ],
    "hour": [
        "год",
        "година",
        "годині",
        "годиною",
        "годино",
        "г",
        "год",
        "годин",
        "година",
        "години",
        "годин",
        "годину",
        "г"
    ],
    "minute": [
        "хв",
        "хвилина",
        "хвилині",
        "хвилиною",
        "хвилино",
        "хв",
        "хвилини",
        "хвилин",
        "хвилину"
    ],
    "second": [
        "с",
        "секунда",
        "секунді",
        "секундою",
        "секундо",
        "с",
        "секунда",
        "секунди",
        "секунд",
        "секунду",
        "сек"
    ],
    "relative-type": {
        "0 day ago": [
            "сьогодні"
        ],
        "0 hour ago": [
            "цієї години"
        ],
        "0 minute ago": [
            "цієї хвилини"
        ],
        "0 month ago": [
            "цього місяця"
        ],
        "0 second ago": [
            "зараз"
        ],
        "0 week ago": [
            "цього тижня"
        ],
        "0 year ago": [
            "цього року"
        ],
        "1 day ago": [
            "учора",
            "вчора"
        ],
        "1 month ago": [
            "минулого місяця"
        ],
        "1 week ago": [
            "минулого тижня"
        ],
        "1 year ago": [
            "торік"
        ],
        "in 1 day": [
            "завтра"
        ],
        "in 1 month": [
            "наступного місяця"
        ],
        "in 1 week": [
            "наступного тижня"
        ],
        "in 1 year": [
            "наступного року"
        ],
        "2 day ago": [
            "позавчора"
        ],
        "in 2 day": [
            "післязавтра"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) д тому",
            "(\\d+) день тому",
            "(\\d+) дн тому",
            "(\\d+) дня тому"
        ],
        "\\1 hour ago": [
            "(\\d+) год тому",
            "(\\d+) години тому",
            "(\\d+) година тому",
            "(\\d+) годину тому"
        ],
        "\\1 minute ago": [
            "(\\d+) хв тому",
            "(\\d+) хвилина тому",
            "(\\d+) хвилини тому",
            "(\\d+) хвилину тому"
        ],
        "\\1 month ago": [
            "(\\d+) міс тому",
            "(\\d+) місяць тому",
            "(\\d+) місяця тому"
        ],
        "\\1 second ago": [
            "(\\d+) с тому",
            "(\\d+) секунда тому",
            "(\\d+) секунди тому",
            "(\\d+) секунду тому"
        ],
        "\\1 week ago": [
            "(\\d+) тиж тому",
            "(\\d+) тиждень тому",
            "(\\d+) тижня тому"
        ],
        "\\1 year ago": [
            "(\\d+) р тому",
            "(\\d+) року тому",
            "(\\d+) рік тому"
        ],
        "in \\1 day": [
            "за (\\d+) д",
            "через (\\d+) день",
            "через (\\d+) дн",
            "через (\\d+) дня"
        ],
        "in \\1 hour": [
            "за (\\d+) год",
            "через (\\d+) год",
            "через (\\d+) години",
            "через (\\d+) годину"
        ],
        "in \\1 minute": [
            "за (\\d+) хв",
            "через (\\d+) хв",
            "через (\\d+) хвилини",
            "через (\\d+) хвилину"
        ],
        "in \\1 month": [
            "за (\\d+) міс",
            "через (\\d+) міс",
            "через (\\d+) місяць",
            "через (\\d+) місяця"
        ],
        "in \\1 second": [
            "за (\\d+) с",
            "через (\\d+) с",
            "через (\\d+) секунди",
            "через (\\d+) секунду"
        ],
        "in \\1 week": [
            "за (\\d+) тиж",
            "через (\\d+) тиж",
            "через (\\d+) тиждень",
            "через (\\d+) тижня"
        ],
        "in \\1 year": [
            "за (\\d+) р",
            "через (\\d+) р",
            "через (\\d+) року",
            "через (\\d+) рік"
        ]
    },
    "locale_specific": {},
    "skip": [
        "приблизно",
        "близько",
        "о",
        "об",
        "і",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "тому",
        "назад"
    ],
    "in": [
        "протягом",
        "через",
        "за"
    ],
    "simplifications": [
        {
            "од(на|ну|ні|ної|нієї|ин|ній)": "1"
        },
        {
            "дв(а|і|оє|ох)": "2"
        },
        {
            "пар[ауі]": "2"
        },
        {
            "три": "3"
        },
        {
            "чотири": "4"
        },
        {
            "п'ять": "5"
        },
        {
            "шість": "6"
        },
        {
            "сім": "7"
        },
        {
            "вісім": "8"
        },
        {
            "дев'ять": "9"
        },
        {
            "десять": "10"
        },
        {
            "одинадцять": "11"
        },
        {
            "дванадцять": "12"
        },
        {
            "п'ятнадцять": "15"
        },
        {
            "двадцять": "20"
        },
        {
            "тридцять": "30"
        },
        {
            "сорок": "40"
        },
        {
            "п'ятдесят": "50"
        },
        {
            "півгодини": "30 хвилин"
        },
        {
            "пів години": "30 хвилин"
        },
        {
            "півроку": "6 місяців"
        },
        {
            "пів року": "6 місяців"
        },
        {
            "півтори години": "90 хвилин"
        },
        {
            "півтора року": "18 місяців"
        },
        {
            "^година": "1 година"
        },
        {
            "^годину": "1 годину"
        },
        {
            "^хвилину": "1 хвилину"
        },
        {
            "^секунду": "1 секунду"
        },
        {
            "кілька секунд": "44 секунди"
        },
        {
            "кілька хвилин": "2 хвилини"
        },
        {
            "опів на": "30 хвилин"
        },
        {
            "за чверть": "15 хвилин"
        }
    ]
}
