info = {
    "name": "hr",
    "date_order": "DMY",
    "january": [
        "sij",
        "siječanj",
        "siječnja",
        "siječnju",
        "siječnjem"
    ],
    "february": [
        "velj",
        "veljača",
        "veljače",
        "veljači",
        "veljačom"
    ],
    "march": [
        "ožu",
        "ožujak",
        "ožujka",
        "ožujku",
        "ožujkom"
    ],
    "april": [
        "tra",
        "travanj",
        "travnja",
        "travnju",
        "travnjem"
    ],
    "may": [
        "svi",
        "svibanj",
        "svibnja",
        "svibnju",
        "svibnjem"
    ],
    "june": [
        "lip",
        "lipanj",
        "lipnja",
        "lipnju",
        "lipnjem"
    ],
    "july": [
        "srp",
        "srpanj",
        "srpnja",
        "srpnju",
        "srpnjem"
    ],
    "august": [
        "kol",
        "kolovoz",
        "kolovoza",
        "kolovozu",
        "kolovozom"
    ],
    "september": [
        "ruj",
        "rujan",
        "rujna",
        "rujnu",
        "rujnom"
    ],
    "october": [
        "lis",
        "listopad",
        "listopada",
        "listopadu",
        "listopadom"
    ],
    "november": [
        "stu",
        "studeni",
        "studenoga",
        "studenom",
        "studenomu",
        "studenome",
        "studenog",
        "studenim"
    ],
    "december": [
        "pro",
        "prosinac",
        "prosinca",
        "prosincu",
        "prosincem"
    ],
    "monday": [
        "pon",
        "ponedjeljak"
    ],
    "tuesday": [
        "uto",
        "utorak"
    ],
    "wednesday": [
        "sri",
        "srijeda"
    ],
    "thursday": [
        "čet",
        "četvrtak"
    ],
    "friday": [
        "pet",
        "petak"
    ],
    "saturday": [
        "sub",
        "subota"
    ],
    "sunday": [
        "ned",
        "nedjelja"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "g",
        "godina"
    ],
    "month": [
        "m",
        "mj",
        "mjesec"
    ],
    "week": [
        "tj",
        "tjedan"
    ],
    "day": [
        "d",
        "dan"
    ],
    "hour": [
        "h",
        "sat"
    ],
    "minute": [
        "min",
        "minuta"
    ],
    "second": [
        "s",
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "danas"
        ],
        "0 hour ago": [
            "ovaj sat"
        ],
        "0 minute ago": [
            "ova minuta"
        ],
        "0 month ago": [
            "ovaj mj",
            "ovaj mjesec"
        ],
        "0 second ago": [
            "sad"
        ],
        "0 week ago": [
            "ovaj tj",
            "ovaj tjedan"
        ],
        "0 year ago": [
            "ove g",
            "ove god",
            "ove godine"
        ],
        "1 day ago": [
            "jučer",
            "jučer"
        ],
        "1 month ago": [
            "prošli mj",
            "prošli mjesec",
            "prošlog mjeseca",
            "prošlom mjesecu"
        ],
        "1 week ago": [
            "prošli tj",
            "prošli tjedan",
            "prošlog tjedna",
            "prošlom tjednu"
        ],
        "1 year ago": [
            "prošle g",
            "prošle god",
            "prošle godine",
            "prošla godina",
            "prošloj godini",
            "lani"
        ],
        "in 1 day": [
            "sutra",
            "sutra"
        ],
        "in 1 month": [
            "sljedeći mj",
            "sljedeći mjesec",
            "sljedećeg mjeseca",
            "sljedećem mjesecu",
            "idući mj",
            "idućeg mj",
            "idućem mj",
            "idući mjesec",
            "idućeg mjeseca",
            "idućem mjesecu"
        ],
        "in 1 week": [
            "sljedeći tj",
            "sljedeći tjedan",
            "sljedećeg tjedna",
            "sljedećem tjednu",
            "idući tj",
            "idućeg tj",
            "idućem tj",
            "idući tjedan",
            "idućeg tjedna",
            "idućem tjednu"
        ],
        "in 1 year": [
            "sljedeće g",
            "sljedeće god",
            "sljedeće godine",
            "sljedeća g",
            "sljedeća god",
            "sljedeća godina",
            "sljedećoj godini",
            "iduća g",
            "iduće g",
            "idućoj g",
            "iduća god",
            "iduće god",
            "idućoj god",
            "iduća godina",
            "iduće godine",
            "idućoj godini",
            "dogodine",
            "nagodinu"
        ],
        "in 2 day": [
            "prekosutra"
        ],
        "2 year ago": [
            "preklani"
        ],
        "2 day ago": [
            "prekjučer"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "prije (\\d+) d",
            "prije (\\d+) dan",
            "prije (\\d+) dana"
        ],
        "\\1 hour ago": [
            "prije (\\d+) h",
            "prije (\\d+) sat",
            "prije (\\d+) sati",
            "prije (\\d+) sata"
        ],
        "\\1 minute ago": [
            "prije (\\d+) min",
            "prije (\\d+) minuta",
            "prije (\\d+) minutu",
            "prije (\\d+) minute"
        ],
        "\\1 month ago": [
            "prije (\\d+) mj",
            "prije (\\d+) mjesec",
            "prije (\\d+) mjeseci",
            "prije (\\d+) mjeseca"
        ],
        "\\1 second ago": [
            "prije (\\d+) s",
            "prije (\\d+) sekundi",
            "prije (\\d+) sekundu",
            "prije (\\d+) sekunde",
            "prije (\\d+) sekundu"
        ],
        "\\1 week ago": [
            "prije (\\d+) tj",
            "prije (\\d+) tjedan",
            "prije (\\d+) tjedana",
            "prije (\\d+) tjedna"
        ],
        "\\1 year ago": [
            "prije (\\d+) g",
            "prije (\\d+) godina",
            "prije (\\d+) godinu",
            "prije (\\d+) godine"
        ],
        "in \\1 day": [
            "za (\\d+) d",
            "za (\\d+) dan",
            "za (\\d+) dana"
        ],
        "in \\1 hour": [
            "za (\\d+) h",
            "za (\\d+) sat",
            "za (\\d+) sati",
            "za (\\d+) sata"
        ],
        "in \\1 minute": [
            "za (\\d+) min",
            "za (\\d+) minuta",
            "za (\\d+) minutu",
            "za (\\d+) minute"
        ],
        "in \\1 month": [
            "za (\\d+) mj",
            "za (\\d+) mjesec",
            "za (\\d+) mjeseci",
            "za (\\d+) mjeseca"
        ],
        "in \\1 second": [
            "za (\\d+) s",
            "za (\\d+) sekundi",
            "za (\\d+) sekundu",
            "za (\\d+) sekunde",
            "za (\\d+) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+) tj",
            "za (\\d+) tjedan",
            "za (\\d+) tjedana",
            "za (\\d+) tjedna"
        ],
        "in \\1 year": [
            "za (\\d+) g",
            "za (\\d+) godina",
            "za (\\d+) godinu",
            "za (\\d+) godine"
        ]
    },
    "locale_specific": {
        "hr-BA": {
            "name": "hr-BA"
        }
    },
    "in": [
        "u"
    ],
    "simplifications": [
        {
            "podne": "12:00"
        },
        {
            "ponoć": "00:00"
        }
    ],
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
