#!/bin/bash
# THIS FILE IS PART OF THE CYLC SUITE ENGINE.
# Copyright (C) 2008-2018 NIWA
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------
# Test for completion of custom outputs in dummy and sim modes.
# And no duplication dummy outputs (GitHub #2064)
. "$(dirname "$0")/test_header"

set_test_number 6

install_suite "${TEST_NAME_BASE}" "${TEST_NAME_BASE}"

run_ok "${TEST_NAME_BASE}-validate" \
    cylc validate --debug ${SUITE_NAME}

suite_run_fail "${TEST_NAME_BASE}-run-live" \
    cylc run --reference-test --debug --no-detach ${SUITE_NAME}

suite_run_ok "${TEST_NAME_BASE}-run-dummy" \
    cylc run -m 'dummy' --reference-test --debug --no-detach ${SUITE_NAME}

suite_run_ok "${TEST_NAME_BASE}-run-simulation" \
    cylc run -m 'simulation' --reference-test --debug --no-detach ${SUITE_NAME}

LOG=$(cylc log -m p $SUITE_NAME)
count_ok '> meet' ${LOG} 1
count_ok '> greet' ${LOG} 1

purge_suite "${SUITE_NAME}"
