#!/bin/bash

set -e
set -u

if [ $# -ne 2 ]; then
    echo >&2 "Usage: $0 FIELD UPSTREAM_VERSION"
    exit 1
fi

field=$1
version=$2

# Turn 'debian upstream version' in 'original upstream version'
version=$( sed -E 's/\+(dfsg|ds)[0-9]+$//' <<< $version )
version=$( sed 's/~/-/g' <<< $version )

commit=
year=

case "$version" in
    (1.8.6) year=2020; commit=2fa535b ;;
    (*)
        echo >&2 "Unknown version '$version'"
        echo >&2 "Please add it to debian/$(basename $0)"
        exit 1
        ;;
esac

case "$field" in
    (commit) echo "$commit" ;;
    (year)   echo "$year"   ;;
    (*)
        echo >&2 "Invalid field '$field'"
        exit 1
        ;;
esac
