#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Data/CODNumbers.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2017-11-10 12:53:37 +0200 (Fri, 10 Nov 2017) $ 
#$Revision: 5765 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.2/tests/shtests/have_equiv_bibliographies_010.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Data::CODNumbers::have_equiv_bibliographies
#* subroutine. Tests the way the subroutine behaves when two entries with
#* almost identical bibliographies are compared. In this case, the only
#* difference is that the _journal_volume field in one of the entries has
#* several zeros prefixed to its value. Since _journal_volume field values
#* are compared as numbers the entries are treated as having equivalent
#* bibliographies.
#**

use strict;
use warnings;

use COD::CIF::Data::CODNumbers;

my $entry_1 = {
    'bibliography' => {
        '_journal_name_full'    => 'Journal of Applied Crystallography',
        '_journal_year'         => 2016,
        '_journal_volume'       => '0049',
        '_journal_issue'        => 1,
        '_journal_page_first'   => 'a292',
        '_journal_page_last'    => 'a301',
    }
};

my $entry_2 = {
    'bibliography' => {
        '_journal_name_full'    => 'Journal of Applied Crystallography',
        '_journal_year'         => 2016,
        '_journal_volume'       => 49,
        '_journal_issue'        => 1,
        '_journal_page_first'   => 'a292',
        '_journal_page_last'    => 'a301',
    }
};

my $equivalent = COD::CIF::Data::CODNumbers::have_equiv_bibliographies(
    $entry_1,
    $entry_2
);

if ( $equivalent ) {
    print "Bibliographies were treated as equivalent.\n";
} else {
    print "Bibliographies were treated as not equivalent.\n";
}

END_SCRIPT
