var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { OverlayTrigger } from '../../OverlayTrigger/index';
import { Tooltip } from '../../Tooltip/index';

var randomId = function randomId() {
  return Date.now();
};

var TooltipFunction = function TooltipFunction(value) {
  if (value.tooltipFunction) {
    return value.tooltipFunction(value.value, value.title);
  }

  return React.createElement(
    Tooltip,
    { id: value.tooltipId || randomId() },
    value.title + ': ' + value.value + '%'
  );
};

var BulletChartValue = function BulletChartValue(_ref) {
  var className = _ref.className,
      value = _ref.value,
      prevValue = _ref.prevValue,
      dot = _ref.dot,
      vertical = _ref.vertical,
      props = _objectWithoutProperties(_ref, ['className', 'value', 'prevValue', 'dot', 'vertical']);

  var showValue = Math.min(Math.max(value.value + prevValue, 0), 120);

  var valueClasses = classNames({
    'bullet-chart-pf-value-dot': dot,
    'bullet-chart-pf-value-bar': !dot
  }, className);

  var valueComponent = void 0;
  if (dot) {
    valueComponent = React.createElement('div', _extends({
      className: valueClasses,
      style: {
        left: vertical ? undefined : showValue + '%',
        bottom: vertical ? showValue + '%' : undefined,
        backgroundColor: value.color,
        zIndex: 100 + showValue
      }
    }, props));
  } else {
    valueComponent = React.createElement('div', _extends({
      className: valueClasses,
      style: {
        left: vertical ? undefined : prevValue + '%',
        width: vertical ? undefined : showValue - prevValue + '%',
        bottom: vertical ? prevValue + '%' : undefined,
        height: vertical ? showValue - prevValue + '%' : undefined,
        backgroundColor: value.color,
        zIndex: 400 - showValue
      }
    }, props));
  }
  return React.createElement(
    OverlayTrigger,
    {
      key: value.title,
      overlay: TooltipFunction(value),
      placement: vertical ? 'right' : 'top',
      trigger: ['hover', 'focus'],
      rootClose: false
    },
    valueComponent
  );
};

BulletChartValue.propTypes = {
  /** Additional css classes */
  className: PropTypes.string,
  /** Value */
  value: PropTypes.shape({
    value: PropTypes.number.isRequired,
    title: PropTypes.string,
    color: PropTypes.string,
    tooltipFunction: PropTypes.func,
    tooltipId: PropTypes.string
  }).isRequired,
  /** Previous value (for stacked charts), default 0 */
  prevValue: PropTypes.number,
  /** Display a dot rather than a bar, default false */
  dot: PropTypes.bool,
  /** Vertical chart, default false */
  vertical: PropTypes.bool
};

BulletChartValue.defaultProps = {
  className: '',
  prevValue: 0,
  dot: false,
  vertical: false
};

export default BulletChartValue;