var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

var BulletChartThreshold = function BulletChartThreshold(_ref) {
  var className = _ref.className,
      threshold = _ref.threshold,
      vertical = _ref.vertical,
      props = _objectWithoutProperties(_ref, ['className', 'threshold', 'vertical']);

  if (threshold > 0 && threshold <= 100) {
    var thresholdClasses = classNames('bullet-chart-pf-threshold-indicator', className);
    return React.createElement('div', _extends({
      className: thresholdClasses,
      style: {
        left: vertical ? undefined : threshold + '%',
        bottom: vertical ? threshold + '%' : undefined
      }
    }, props));
  }

  return null;
};

BulletChartThreshold.propTypes = {
  /** Additional css classes */
  className: PropTypes.string,
  /** Threshold value */
  threshold: PropTypes.number.isRequired,
  /** Vertical chart, default false */
  vertical: PropTypes.bool
};

BulletChartThreshold.defaultProps = {
  className: '',
  vertical: false
};

export default BulletChartThreshold;